#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define HW_ENABLE 1
#define DOG_PY 0

#define COLORS 8

#include "im_utils.h"
#include "keypoints.h"
#include "sift.h"
#include "sift_utils.h"
#include "vga_ball.h"
#include "vga_ball_utils.h"

int main() {
  vga_ball_arg_t vla;
  vga_ball_value_t cur_val = {0, 0};
  static const char filename[] = "/dev/vga_ball";

  static const vga_ball_color_t colors[] = {
    { 0xc0, 0x00, 0x00 }, 
    { 0xa0, 0x00, 0x00 },
    { 0x90, 0x00, 0x00 }, 
    { 0x88, 0x00, 0x00 }, 
    { 0x84, 0x00, 0x00 }, 

    { 0xc0, 0xa0, 0x00 }, 
    { 0xa0, 0xa0, 0x00 }, 
    { 0x90, 0xa0, 0x00 }, 
    { 0x88, 0xa0, 0x00 }, 
    { 0x84, 0xa0, 0x00 }, 

    { 0xc0, 0x90, 0x00 }, 
    { 0xa0, 0x90, 0x00 }, 
    { 0x90, 0x90, 0x00 }, 
    { 0x88, 0x90, 0x00 }, 
    { 0x84, 0x90, 0x00 }, 

    { 0xc0, 0x88, 0x00 }, 
    { 0xa0, 0x88, 0x00 }, 
    { 0x90, 0x88, 0x00 }, 
    { 0x88, 0x88, 0x00 }, 
    { 0x84, 0x88, 0x00 } 

  };

  printf("VGA ball Userspace program started\n");

#if HW_ENABLE
  extern int vga_ball_fd;
  if ((vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;

    printf("initial state: ");
    // clear_bram(&cur_val);
    // print_background_color();
    // set_background_color(
    //    &colors[4]); // is this necessary? or just leftover from lab3
  }
#endif

  // const char *img_name = "eiffel-tower-gray-8-bit.bin";
  // const char *img_name = "eiffel-tower-gray-updated.bin";
  // const char *img_name = "statue_of_liberty2.bin";
  //const char *img_name = "eiffel-tower-gray-updated.bin";
  // const char *img_name = "statue_of_liberty2.bin";
  //const char *img_name = "greek.bin";
  // const char *img_name = "alma_mater.bin";
  // const char *img_name = "roundabout.bin";
  const char *img_name = "colosseum.bin";
  // const char *img_name = "highway.bin";
  char array[IMAGE_SIZE] = {0};
  char read_array[IMAGE_SIZE] = {0};

  read_image_data(img_name, array, IMAGE_SIZE); 
  printf("Read image data from file\n");
  //for (size_t i = NUM_IOCTL_READS - 20; i < NUM_IOCTL_READS *
  // BUFFER_IMAGE_SIZE; i++) { printf("array[%d] = %d\n", (int)i, array[i]);
  // }
#if HW_ENABLE
  cur_val.addr = 0;
  for (size_t i = 0; i < IMAGE_SIZE; i++) {
    
    cur_val.val = array[i];
    if (cur_val.val == 0)
      cur_val.val = 1;
    cur_val.addr++;
    set_value(&cur_val);
  }
#endif

  Img *blurred_ims[20] = {0};
  double sigmas[NUM_BLURS];
  get_sigmas(sigmas, SIGMA_ROOT);
  

int heights[NUM_OCTAVES] = {IMAGE_HEIGHT, IMAGE_HEIGHT / 2, IMAGE_HEIGHT / 4, IMAGE_HEIGHT / 8};
int widths[NUM_OCTAVES] = {IMAGE_WIDTH, IMAGE_WIDTH / 2, IMAGE_WIDTH / 4, IMAGE_WIDTH / 8};
// conv_out_height = img_height - kernel_size + 18'd1;
#if DOG_PY
int blur_im_heights[NUM_OCTAVES * NUM_BLURS] = {heights[0], heights[0], heights[0], heights[0], heights[0], heights[1], heights[1], heights[1], heights[1], heights[1], heights[2], heights[2], heights[2], heights[2], heights[2], heights[3], heights[3], heights[3], heights[3], heights[3], };
int blur_im_widths[NUM_OCTAVES * NUM_BLURS] = {widths[0], widths[0], widths[0], widths[0], widths[0], widths[1], widths[1], widths[1], widths[1], widths[1], widths[2], widths[2], widths[2], widths[2], widths[2], widths[3], widths[3], widths[3], widths[3], widths[3], };
#else
int blur_im_heights[NUM_OCTAVES * NUM_BLURS] = {heights[0]-8, heights[0]-10, heights[0]-14, heights[0]-18, heights[0]-24,
 				            heights[1]-8 + check_bit(IMAGE_HEIGHT, 0), heights[1]-10 + check_bit(IMAGE_HEIGHT, 0), heights[1]-14 + check_bit(IMAGE_HEIGHT, 0), heights[1]-18 + check_bit(IMAGE_HEIGHT, 0), heights[1]-24 + check_bit(IMAGE_HEIGHT, 0),
					    heights[2]-8 + check_bit(IMAGE_HEIGHT, 1), heights[2]-10 + check_bit(IMAGE_HEIGHT, 1), heights[2]-14 + check_bit(IMAGE_HEIGHT, 1), heights[2]-18 + check_bit(IMAGE_HEIGHT, 1), heights[2]-24 + check_bit(IMAGE_HEIGHT, 1),
				            heights[3]-8 + check_bit(IMAGE_HEIGHT, 2), heights[3]-10 + check_bit(IMAGE_HEIGHT, 2), heights[3]-14 + check_bit(IMAGE_HEIGHT, 2), heights[3]-18 + check_bit(IMAGE_HEIGHT, 2), heights[3]-24 + check_bit(IMAGE_HEIGHT, 2)  
					   };

int blur_im_widths[NUM_OCTAVES * NUM_BLURS] = {widths[0]-8, widths[0]-10, widths[0]-14, widths[0]-18, widths[0]-24, 
				 	   widths[1]-8 + check_bit(IMAGE_WIDTH, 0), widths[1]-10 + check_bit(IMAGE_WIDTH, 0), widths[1]-14 + check_bit(IMAGE_WIDTH, 0), widths[1]-18 + check_bit(IMAGE_WIDTH, 0), widths[1]-24 + check_bit(IMAGE_WIDTH, 0), 
					   widths[2]-8 + check_bit(IMAGE_WIDTH, 1), widths[2]-10 + check_bit(IMAGE_WIDTH, 1), widths[2]-14 + check_bit(IMAGE_WIDTH, 1), widths[2]-18 + check_bit(IMAGE_WIDTH, 1), widths[2]-24 + check_bit(IMAGE_WIDTH, 1), 
					   widths[3]-8 + check_bit(IMAGE_WIDTH, 2), widths[3]-10 + check_bit(IMAGE_WIDTH, 2), widths[3]-14 + check_bit(IMAGE_WIDTH, 2), widths[3]-18 + check_bit(IMAGE_WIDTH, 2), widths[3]-24 + check_bit(IMAGE_WIDTH, 2)
					  };

#endif

int dog_heights[NUM_OCTAVES] = {blur_im_heights[4], blur_im_heights[9], blur_im_heights[14], blur_im_heights[19]};
int dog_widths[NUM_OCTAVES] = {blur_im_widths[4], blur_im_widths[9], blur_im_widths[14], blur_im_widths[19]};

for (int i=0; i<4; i++) {
	printf("GET BIT(%d, %d) = %d\n", IMAGE_WIDTH, i, check_bit(IMAGE_WIDTH, i));
	printf("GET BIT(%d, %d) = %d\n", IMAGE_HEIGHT, i, check_bit(IMAGE_HEIGHT, i));
}
for (int i=0; i<20; i++) {
	printf("h, w: %d, %d\n", blur_im_heights[i], blur_im_widths[i]);
}

  //   int widths[NUM_OCTAVES] = {10, 5, 2, 1};
  for (int octave_num = 0; octave_num < NUM_OCTAVES; octave_num++) {
    for (int blur_idx = 0; blur_idx < NUM_BLURS; blur_idx++) {
      int idx = octave_num * NUM_BLURS + blur_idx;

      Img *blurred_im = (Img *)malloc(sizeof(Img));
      blurred_im->height = blur_im_heights[idx];
      blurred_im->width = blur_im_widths[idx];

      int size = blurred_im->height * blurred_im->width;
      blurred_im->array = (unsigned char *)malloc(size * sizeof(char));
      //   printf("blurred_im_array#%d: %lx\n", idx,
      //  (unsigned long)blurred_im->array);
#if DOG_PY
#elif HW_ENABLE
      blurred_im->array[0] = set_background_color(&colors[idx]); 
      printf("Running conv on octave %d and blur_idx %d...\n", octave_num, blur_idx);
      // usleep(3000000);
      //usleep(5000000 >> (octave_num));
      for (int i = 1; i < size; i++){
    	read_value(blurred_im->array, i);
      }
#else
      for (int i = 0; i < size; i++) {
        blurred_im->array[i] = (char)(i + blur_idx);
      }
#endif

      blurred_im->blur_idx = blur_idx;
      blurred_im->octave = octave_num;
      blurred_im->sigma = sigmas[blur_idx];
      blurred_ims[idx] = blurred_im;
      char file_path[100] = {0};
      sprintf(file_path, "blurred_outputs/octave%d_blur_idx%d.txt", octave_num, blur_idx);
      write_image_to_txt_file(blurred_im->array, file_path, size);
    }
  }

  DoG *diffs[16] = {0};
  for (int octave_num = 0; octave_num < NUM_OCTAVES; octave_num++) {
    for (int blur_idx = 0; blur_idx < NUM_BLURS - 1; blur_idx++) {
      int dog_idx = octave_num * (NUM_BLURS - 1) + blur_idx;
      int blur_ims_idx = octave_num * (NUM_BLURS) + blur_idx;
      DoG *diff = malloc(sizeof(DoG));
      diff->img1 = blurred_ims[blur_ims_idx];
      diff->img2 = blurred_ims[blur_ims_idx + 1];
      diff->octave = octave_num;
      // int size = diff->img2->height * diff->img2->width; // img2s size because img2 is smaller, and DoG must go by smaller im
      int size = dog_widths[octave_num] * dog_heights[octave_num];
      diff->array = (double *)malloc(size * sizeof(double));
      diff->width = dog_widths[octave_num];
      diff->height = dog_heights[octave_num];
#if DOG_PY
      read_DoG_py(diff->img1, diff->img2, diff);
#else
      compute_DoG(diff->img1, diff->img2, diff);
#endif
      if (size > 5010) {
	      for (int i = 5000; i < 5010; i++) {
		printf("octave #%d, DoG #%d, array[%d]: %f\n", octave_num, blur_idx, i,
		       diff->array[i]);
	      }
      }

      diffs[dog_idx] = diff;
      char file_path[100] = {0};
      sprintf(file_path, "DoG_outputs/DoG_octave%d_blur_idx%d.txt", octave_num, blur_idx);
      write_float_image_to_txt_file(diff->array, file_path, size);

#if HW_ENABLE
#else
      // To add a random extrema to see if the kp code later on works
      if (blur_idx % 2 == 0) {
        diff->array[1100] = .234;
        for (int i = 1098; i < 1104; i++)
          printf("octave #%d, DoG #%d, array[%d]: %f\n", octave_num, blur_idx,
                 i, diff->array[i]);
      }
#endif
    }
  }

  Keypoints keypoints;
  keypoints._max_capacity = MAX_KEYPOINTS;
  keypoints.count = 0;
  keypoints.kp_list = (Kp **)malloc(MAX_KEYPOINTS * sizeof(Kp **));
  get_candidate_keypoints(diffs, &keypoints);

  localize_keypoints(&keypoints, diffs);

  char file_path[100] = {0};
  sprintf(file_path, "keypoint_outputs/keypoints_eifel.txt");
  write_kps_to_txt_file(&keypoints, file_path);

  for (int octave_num = 0; octave_num < NUM_OCTAVES; octave_num++) {
  	mark_keypoints_on_imag(array, &keypoints, octave_num);
  }

#if 1
  cur_val.addr = 0;
  for (size_t i = 0; i < IMAGE_SIZE; i++) {
    cur_val.val = array[i];
    cur_val.addr++;
    set_value(&cur_val);
  }
#endif


 //read_image_data(img_name2, array, IMAGE_SIZE); 
  //printf("Read image data from file\n");
  // for (size_t i = NUM_IOCTL_READS - 20; i < NUM_IOCTL_READS *
  // BUFFER_IMAGE_SIZE; i++) { printf("array[%d] = %d\n", (int)i, array[i]);
  // }
#if 0
  cur_val.addr = 0;
  for (size_t i = 0; i < IMAGE_SIZE; i++) {
    cur_val.val = array[i];
    cur_val.addr++;
    set_value(&cur_val);
  }
#endif


  printf("VGA BALL Userspace program terminating\n");
  return 0;
}
