#include "im_utils.h"
#include "sift.h"
#include "sift_utils.h"
#include "vga_ball.h"

#ifndef _KEYPOINTS
#define _KEYPOINTS

/*
For statue of liberty -- use thresh 0.06
For eifel tower -- use thresh 0.07
For roundabout -- use thresh 0.05
For highway -- use thresh 0.07
For colosseum -- use thresh 0.08
*/

#define CONTRAST_THRESHOLD 0.08    // (orig 0.03)
#define PRINCIPLE_CURVATURE_THRESHOLD 12.1 // (r+1)^2 / r, with r=10

#define MAX_KEYPOINTS 10000

typedef struct Kp_precise {
  double x;
  double y;
  double real_x;
  double real_y;
  double DoG_idx;
} Kp_precise;

typedef struct Kp {
  unsigned short x;
  unsigned short y;
  DoG *DoG;
  int DoG_idx;
  int is_valid;

  // used for keypoint localization
  double *jacobian; // should point to 3 * 8 bytes (dx, dy, ds)
  double *hessian; // should point to 4 * 8 bytes (only care about dxx, dxy, dxy, dyy, actual mat is 3x3)
  double *offset; // should point to 3 * 8 bytes (offset_row, offset_col, offset_sigma)
  Kp_precise *kp_precise;
} Kp;

typedef struct Keypoints {
  Kp **kp_list;
  unsigned short count;
  int _max_capacity;
} Keypoints;

void get_candidate_keypoints(DoG **DoGs, Keypoints *keypoints);
void get_candidate_keypoints_for_octave(DoG **DoGs, Keypoints *keypoints, int octave_num);
void localize_keypoints(Keypoints *keypoints, DoG **diffs);
void localize_kp(Kp *kp, DoG **diffs);
double compute_kp_contrast(Kp *kp, DoG **diffs);
void print_keypoints_stats(Keypoints *keypoints);
void write_kps_to_txt_file(Keypoints *keypoints, const char *file_path);

#endif
