#include "vga_ball.h"
#include "keypoints.h"
#include <stdio.h>
#include <stdlib.h>

int vga_ball_fd;

void read_image_data(const char* filename, char* image_data, int img_size) {
    FILE* file = fopen(filename, "rb");
    if (file == NULL) {
        perror("Error opening file");
        exit(EXIT_FAILURE);
    }

    size_t elements_read = fread(image_data, sizeof(char), img_size, file);
    if (elements_read != img_size) {
        perror("Error reading file");
        fclose(file);
        exit(EXIT_FAILURE);
    }

    fclose(file);
}

void write_image_to_txt_file(const char image[], const char *file_path, int img_size) {
    FILE *file = fopen(file_path, "wb");
    if (!file) {
        perror("Error opening file for writing");
        return;
    }

    for (int i = 0; i < img_size; i++) {
      fprintf(file, "%d ", (unsigned char) image[i]);
      fprintf(file, "\n");
    }
    printf("Wrote image to file %s!\n", file_path);

    fclose(file);
}

void write_float_image_to_txt_file(const double image[], const char *file_path, int img_size) {
    FILE *file = fopen(file_path, "wb");
    if (!file) {
        perror("Error opening file for writing");
        return;
    }

    for (int i = 0; i < img_size; i++) {
      fprintf(file, "%f ", image[i]);
      fprintf(file, "\n");
    }
    printf("Wrote image to file %s!\n", file_path);

    fclose(file);
}

