/*
 * Userspace program that communicates with the vga_ball device driver
 * through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdint.h>

int vga_ball_fd;

/* Read and print the background color */
void print_background_color() {
  vga_ball_arg_t vla;
  
  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
      return;
  }
  printf("%02x %02x %02x\n",
	 vla.background.red, vla.background.green, vla.background.blue);
}

/* Set the background color */
void set_background_color(const vga_ball_color_t *c)
{
  vga_ball_arg_t vla;
  vla.background = *c;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
      return;
  }
}

/* Set the value */
void set_value(vga_ball_value_t *v)
{
  vga_ball_arg_t vla;
  vla.value = *v;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_VALUE, &vla)) {
      perror("ioctl(VGA_BALL_WRITE_VALUE) failed");
      return;
  }
}

/* Clear BRAM memory */
void clear_bram(vga_ball_value_t *v)
{
  vga_ball_arg_t vla;
  vla.value = *v;
  if (ioctl(vga_ball_fd, VGA_BALL_MEM_CLEAR, &vla)) {
      perror("ioctl(VGA_BALL_MEM_CLEAR) failed");
      return;
  }
}

/* Read and print the value from hardware */
void read_value(char* image_data, int start_index) {
  vga_ball_arg_t vla;
  
  //vla.value.addr = address;
  if (ioctl(vga_ball_fd, VGA_BALL_READ_VALUE, &vla)) {
      perror("ioctl(VGA_BALL_READ_VALUE) failed");
      return;
  }
  //usleep(200000);
  //printf("value at address %u is %u\n",address, vla.value.val);
  for (int i = 0; i < BUFFER_IMAGE_SIZE; i++) {
     //printf("%d \n",vla.image[0]);
     image_data[start_index] = vla.image[i];
  }
}


void read_image_data(const char* filename, char* image_data, int img_size) {
    FILE* file = fopen(filename, "rb");
    if (file == NULL) {
        perror("Error opening file");
        exit(EXIT_FAILURE);
    }

    size_t elements_read = fread(image_data, sizeof(char), img_size, file);
    if (elements_read != img_size) {
        perror("Error reading file");
        fclose(file);
        exit(EXIT_FAILURE);
    }

    fclose(file);
}

void write_image_to_txt_file(const char image[], const char *file_path, int img_size) {
    FILE *file = fopen(file_path, "wb");
    if (!file) {
        perror("Error opening file for writing");
        return;
    }

    for (int i = 0; i < img_size; i++) {
      fprintf(file, "%d ", (unsigned char) image[i]);
      fprintf(file, "\n");
    }

    fclose(file);
}

int main()
{
  vga_ball_arg_t vla;
  vga_ball_value_t cur_val = {0,0};
  int x_dir = 1, y_dir = 1;
  int i = 0;
  static const char filename[] = "/dev/vga_ball";

  //{R, G, B}:
  // R -> XXXX_XXXX -> bit 1 (MSB) to start conv,
  //	               bit 2 = kernel 9x9
  //	               bit 3 = kernel 11x11
  //	               bit 4 = kernel 15x15
  //	               bit 5 = kernel 19x19
  //	               bit 6 = kernel 25x25

  // G -> XXXX_XXXX -> bit 1 (MSB) ignored (for now),
  //	               bit 2 = octave divide by 1 
  //	               bit 3 = octave divide by 2 1010_0000
  //	               bit 4 = octave divide by 4
  //	               bit 5 = octave divide by 8

  // B -> Not yet used
  static const vga_ball_color_t colors[] = {
    { 0xc0, 0x00, 0x00 }, 
    { 0xa0, 0x00, 0x00 },
    { 0x90, 0x00, 0x00 }, 
    { 0x88, 0x00, 0x00 }, 
    { 0x84, 0x00, 0x00 }, 

    { 0xc0, 0xa0, 0x00 }, 
    { 0xa0, 0xa0, 0x00 }, 
    { 0x90, 0xa0, 0x00 }, 
    { 0x88, 0xa0, 0x00 }, 
    { 0x84, 0xa0, 0x00 }, 

    { 0xc0, 0x90, 0x00 }, 
    { 0xa0, 0x90, 0x00 }, 
    { 0x90, 0x90, 0x00 }, 
    { 0x88, 0x90, 0x00 }, 
    { 0x84, 0x90, 0x00 }, 

    { 0xc0, 0x88, 0x00 }, 
    { 0xa0, 0x88, 0x00 }, 
    { 0x90, 0x88, 0x00 }, 
    { 0x88, 0x88, 0x00 }, 
    { 0x84, 0x88, 0x00 } 

  };

# define COLORS 8


  printf("VGA ball Userspace program started\n");

  if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  //printf("initial state: ");

  //print_background_color();
  //set_background_color(&colors[4]);

  //const char *img_name = "eiffel-tower-gray-updated-resized.bin";
  const char *img_name = "eiffel-tower-gray-updated.bin";
  char array[IMAGE_SIZE] = {0};
  char read_array[IMAGE_SIZE];

  read_image_data(img_name, array, IMAGE_SIZE);
  /*for (size_t i = NUM_IOCTL_READS-20; i < NUM_IOCTL_READS*BUFFER_IMAGE_SIZE; i++) {
    printf("array[%d] = %d\n",i, array[i]);
  }*/
  /*for (size_t i = NUM_IOCTL_READS-20; i < NUM_IOCTL_READS*BUFFER_IMAGE_SIZE; i++) {
    printf("array[%d] = %d\n",i, array[i]);
  }*/


  
  //printf("first 3x3 convolution value: ");
  int conv_result = 0;
  int row_offset = 0;
  int col_offset = 0;
  char kernel[] = {1,2,3,4,5,6,7,8,9}; 
  int intPart = 0;
  int indexStart = 525*5+513;

  /*array[IMAGE_SIZE-10] = consistent use of tabs and spaces in indentation
[ps3320@micro34 project]$ python3 display_im.py
['9', '6', '9', '7', '9', '8', '9', '9', '1', '0'] 496349
[ps3320@micro34 project]$ python3 display_im.py
['96 \n', '97 \n', '98 \n', '99 \n', '100 \n', '101 \n', '102 \n', '102 \n', '103 \n', '105 \n'] 1762;
  array[IMAGE_SIZE-9] = 1;  
  array[IMAGE_SIZE-8] = 2;
  array[IMAGE_SIZE-7] = 3;
  array[IMAGE_SIZE-6] = 4;
  array[IMAGE_SIZE-5] = 5;
  array[IMAGE_SIZE-4] = 2;
  array[IMAGE_SIZE-3] = 1;
  array[IMAGE_SIZE-2] = 2;
  array[0] = 2;
  array[1] = 3;
  array[2] = 1;
  array[3] = 1;
  array[4] = 0;
  array[5] = 1;
  array[6] = 1;
  array[7] = 1;
  array[8] = 1;
  array[9] = 1;
  array[10] = 1;
  array[11] = 1;

  array[525] = 2;
  array[526] = 3;
  array[527] = 1;
  array[528] = 1;
  array[529] = 0;
  array[530] = 1;
  array[531] = 1;
  array[532] = 1;
  array[533] = 1;
  array[534] = 1;
  array[535] = 1;
  array[536] = 1;*/

  /*array[1050] = 1;
  array[1051] = 3;
  array[1052] = 1;
  array[1053] = 1;
  array[1054] = 0;
  array[1055] = 1;
  array[1056] = 1;
  array[1057] = 1;
  array[1058] = 1;
  array[1059] = 1;
  array[1060] = 1;
  array[1061] = 1;*/


  /*array[525] = 2;
  array[526] = 3;
  array[750] = 8;
  array[525+525] = 2;
  array[525+526] = 3;
  array[525+750] = 8;*/


  /*array[indexStart] = 2;
  array[indexStart+1] = 3;
  array[indexStart+2] = 1;
  array[indexStart+3] = 1;
  array[indexStart+4] = 0;
  array[indexStart+5] = 1;
  array[indexStart+6] = 1;
  array[indexStart+7] = 1;
  array[indexStart+8] = 1;
  array[indexStart+9] = 1;
  array[indexStart+10] = 1;
  array[indexStart+11] = 1;

  array[525+indexStabackground_rrt] = 2;
  array[525+indexStart+1] = 3;
  array[525+indexStart+2] = 1;
  array[525+indexStart+3] = 1;
  array[525+indexStart+4] = 0;
  array[525+indexStart+5] = 1;
  array[525+indexStart+6] = 1;
  array[525+indexStart+7] = 1;
  array[525+indexStart+8] = 1;
  array[525+indexStart+9] = 1;
  array[525+indexStart+10] = 1;
  array[525+indexStart+11] = 1;

  array[1050+indexStart] = 2;
  array[1050+indexStart+1] = 3;
  array[1050+indexStart+2] = 1;
  array[1050+indexStart+3] = 1;
  array[1050+indexStart+4] = 0;
  array[1050+indexStart+5] = 1;
  array[1050+indexStart+6] = 1;
  array[1050+indexStart+7] = 1;
  array[1050+indexStart+8] = 1;
  array[1050+indexStart+9] = 1;
  array[1050+indexStart+10] = 1;
  array[1050+indexStart+11] = 1;*/


  char c = 1;
  if (array != NULL) {
    cur_val.addr = 0;
    for (size_t i = 0; i < IMAGE_SIZE; i++) {
      cur_val.val = array[i];
      cur_val.addr++;
      set_value(&cur_val);
    }
  }

  /*printf("array[0] = %d\n",array[0]);
  printf("array[1] = %d\n",array[1]);
  printf("array[2] = %d\n",array[2]);
  printf("array[3] = %d\n",array[3]);
  printf("array[4] = %d\n",array[4]);
  printf("array[5] = %d\n",array[5]);
  printf("array[6] = %d\n",array[6]);
  printf("array[7] = %d\n",array[7]);
  printf("array[8] = %d\n",array[8]);*/

  //usleep(5000000);
  //for (size_t i = 0; i < 1; i++) {
    set_background_color(&colors[5]);
    usleep(5000000);
  //}
  //set_background_color(&colors[7]);
  /*set_background_color(&colors[1]);
  usleep(10000000);
  set_background_color(&colors[2]);
  usleep(10000000);
  set_background_color(&colors[3]);
  usleep(10000000);
  set_background_color(&colors[4]);*/
  //usleep(10000000);
  //clear_bram(&cur_val);

  /*array[0] = 2;
  array[1] = 3;
  array[2] = 1;
  array[3] = 1;
  array[4] = 0;
  array[5] = 1;
  array[6] = 1;
  array[7] = 1;
  array[8] = 1;
  array[9] = 1;
  array[10] = 1;
  array[11] = 1;

  array[525] = 2;
  array[526] = 3;
  array[527] = 1;
  array[528] = 1;
  array[529] = 0;
  array[530] = 1;
  array[531] = 1;
  array[532] = 1;
  array[533] = 1;
  array[534] = 1;
  array[535] = 1;
  array[536] = 1;

  array[1050] = 1;
  array[1051] = 3;
  array[1052] = 1;
  array[1053] = 1;
  array[1054] = 0;
  array[1055] = 1;
  array[1056] = 1;
  array[1057] = 1;
  array[1058] = 1;
  array[1059] = 1;
  array[1060] = 1;
  array[1061] = 1;*/

  /*if (array != NULL) {
    cur_val.addr = 0;
    for (size_t i = 0; i < IMAGE_SIZE; i++) {
      cur_val.val = array[i];
      cur_val.addr++;
      set_value(&cur_val);
    }
  }*/
  //set_background_color(&colors[0]);

  /*for (size_t i = 0; i < NUM_IOCTL_READS; i++) {
    read_value(read_array, i*BUFFER_IMAGE_SIZE);
  }
  printf("printing read image\n");
  for (size_t i = NUM_IOCTL_READS-20; i < NUM_IOCTL_READS; i++) {
    printf("%d \n",read_array[i]);
  }*/

  for (int i = 0; i < 255*167; i++){
    read_value(read_array, i);
    //if (read_array[i] != 0)
      // printf("Conv output %d -> %d \n",i,read_array[i]);
  }
  const char *file_path = "conv_image_data.txt";  // Replace with your file path
  write_image_to_txt_file(read_array, file_path, 255*167);

  //for (int i = IMAGE_SIZE-10; i < indexStart+10; i++)
    //printf("Conv output %d -> %d \n",i,read_array[i]);


  printf("VGA BALL Userspace program terminating\n");
  return 0;
}
