#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>

typedef struct {
	unsigned char red, green, blue;
} vga_ball_color_t;
  
//creation of tetormino location datatype
typedef struct {
	unsigned int hor, vert;
} tetromino_location_t;

//creation of tetromino choice datatype
typedef struct {
	unsigned char tetro;
} tetromino_choice_t;

//creation of tetromino orientation datatype
typedef struct {
	unsigned char ori;
} tetromino_ori_t;

typedef struct {
	unsigned int contents, num;
} tetromino_row_t;

/*typedef struct {
	unsigned char a, b, c, d;
	//unsigned int number;
} tetromino_row_t;
*/

typedef struct {
  vga_ball_color_t background;
  tetromino_location_t tetro_loco;
  tetromino_ori_t ori; 
  tetromino_choice_t choice;
  tetromino_choice_t next;
  tetromino_row_t row;
} vga_ball_arg_t;


#define VGA_BALL_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_BALL_WRITE_BACKGROUND _IOW(VGA_BALL_MAGIC, 1, vga_ball_arg_t *)
#define VGA_BALL_READ_BACKGROUND  _IOR(VGA_BALL_MAGIC, 2, vga_ball_arg_t *)
#define TETROMINO_WRITE_LOCATION   _IOW(VGA_BALL_MAGIC, 3, vga_ball_arg_t *)
#define TETROMINO_WRITE_ORIENTATION _IOW(VGA_BALL_MAGIC, 4, vga_ball_arg_t *)
#define TETROMINO_WRITE_CHOICE _IOW(VGA_BALL_MAGIC, 5, vga_ball_arg_t *)
#define TETROMINO_WRITE_ROW _IOW(VGA_BALL_MAGIC, 6, vga_ball_arg_t *)
#define TETROMINO_WRITE_NEXT _IOW(VGA_BALL_MAGIC, 7, vga_ball_arg_t *)


#endif
