#define ROWS     (20)
#define COLS     (10)

// define the available movements of the tetromino
typedef enum {
    tetromino_moveopt_LEFT,
    tetromino_moveopt_RIGHT,
    tetromino_moveopt_DOWN
} _debug_tetromino_moveopt;

// define the available rotation options of the tetromino
typedef enum {
    tetromino_rotopt_CLOCKWISE,
    tetromino_rotopt_COUNTERCLOCKWISE,
} _debug_tetromino_rotopt;

// define the type of the current tetromino
typedef enum {
    tetromino_type_I,
    tetromino_type_O,
    tetromino_type_T,
    tetromino_type_S,
    tetromino_type_Z,
    tetromino_type_J,
    tetromino_type_L
} _debug_tetromino_type;

// tetromino orientations
typedef enum {
    tetromino_orientation_0,
    tetromino_orientation_1,
    tetromino_orientation_2,
    tetromino_orientation_3
} _debug_tetromino_orientation;

// convert tetromino type to a color
const char _debug_type_to_color[7] = {
    'W', 'W', 'W', 'B', 'R', 'B', 'R'
};

// tetromino  block offset [type-7][orientation-4][col offset, row offset]
const int _debug_tetromino_block_offset[7][4][2] = {
    // tetromino_type_I
    {
        // tetromino_orientation_0 (X+2)
        {
            2, 0
        },

        // tetromino_orientation_1 (Y+1)
        {
            0, 1
        },

        // tetromino_orientation_2 (X+2)
        {
            2, 0
        },

        // tetromino_orientation_3 (Y+1)
        {
            0, 1
        },
    },

    // tetromino_type_O
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_1 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_3 (X+1, Y+1)
        {
            1, 1
        },
    },

    // tetromino_type_T
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_1 (X+1)
        {
            1, 0
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_3 (X+1)
        {
            1, 0
        },
    },

    // tetromino_type_S
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_1 (X+1)
        {
            1, 0
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_3 (X+1)
        {
            1, 0
        }
    },

    // tetromino_type_Z
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_1 (X+1)
        {
            1, 0
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_3 (X+1)
        {
            1, 0
        }
    },

    // tetromino_type_J
    {
        // tetromino_orientation_0 (X+1)
        {
            1, 0
        },

        // tetromino_orientation_1 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_2 (X+1)
        {
            1, 0
        },

        // tetromino_orientation_3 (X+1, Y+1)
        {
            1, 1
        }
    },

    // tetromino_type_L
    {
        // tetromino_orientation_0 (X+1)
        {
            1, 0
        },

        // tetromino_orientation_1 (X+1, Y+1)
        {
            1, 1
        },

        // tetromino_orientation_2 (X+1)
        {
            1, 0
        },

        // tetromino_orientation_3 (X+1, Y+1)
        {
            1, 1
        }
    }
};

// define available tetriminos as a 4d array [type-7][orientation-4][rows-4][cols-4]
const char _debug_tetromino_matrix[7][4][4][4] = {
    // tetromino_type_I
    {
        // tetromino_orientation_0 (X+2)
        {
            {' ', ' ', 'W', ' '},
            {' ', ' ', 'W', ' '},
            {' ', ' ', 'W', ' '},
            {' ', ' ', 'W', ' '}
        },

        // tetromino_orientation_1 (Y+1)
        {
            {' ', ' ', ' ', ' '},
            {'W', 'W', 'W', 'W'},
            {' ', ' ', ' ', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_2 (X+2)
        {
            {' ', ' ', 'W', ' '},
            {' ', ' ', 'W', ' '},
            {' ', ' ', 'W', ' '},
            {' ', ' ', 'W', ' '}
        },

        // tetromino_orientation_3 (Y+1)
        {
            {' ', ' ', ' ', ' '},
            {'W', 'W', 'W', 'W'},
            {' ', ' ', ' ', ' '},
            {' ', ' ', ' ', ' '}
        },
    },

    // tetromino_type_O
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'W', 'W', ' '},
            {' ', 'W', 'W', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_1 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'W', 'W', ' '},
            {' ', 'W', 'W', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'W', 'W', ' '},
            {' ', 'W', 'W', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_3 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'W', 'W', ' '},
            {' ', 'W', 'W', ' '},
            {' ', ' ', ' ', ' '}
        },
    },

    // tetromino_type_T
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'W', 'W', 'W'},
            {' ', ' ', 'W', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_1 (X+1)
        {
            {' ', ' ', 'W', ' '},
            {' ', 'W', 'W', ' '},
            {' ', ' ', 'W', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', ' ', 'W', ' '},
            {' ', 'W', 'W', 'W'},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_3 (X+1)
        {
            {' ', 'W', ' ', ' '},
            {' ', 'W', 'W', ' '},
            {' ', 'W', ' ', ' '},
            {' ', ' ', ' ', ' '}
        },
    },

    // tetromino_type_S
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', ' ', 'B', 'B'},
            {' ', 'B', 'B', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_1 (X+1)
        {
            {' ', 'B', ' ', ' '},
            {' ', 'B', 'B', ' '},
            {' ', ' ', 'B', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', ' ', 'B', 'B'},
            {' ', 'B', 'B', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_3 (X+1)
        {
            {' ', 'B', ' ', ' '},
            {' ', 'B', 'B', ' '},
            {' ', ' ', 'B', ' '},
            {' ', ' ', ' ', ' '}
        }
    },

    // tetromino_type_Z
    {
        // tetromino_orientation_0 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'R', 'R', ' '},
            {' ', ' ', 'R', 'R'},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_1 (X+1)
        {
            {' ', ' ', 'R', ' '},
            {' ', 'R', 'R', ' '},
            {' ', 'R', ' ', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_2 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'R', 'R', ' '},
            {' ', ' ', 'R', 'R'},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_3 (X+1)
        {
            {' ', ' ', 'R', ' '},
            {' ', 'R', 'R', ' '},
            {' ', 'R', ' ', ' '},
            {' ', ' ', ' ', ' '}
        }
    },
    
    // tetromino_type_J
    {
        // tetromino_orientation_0 (X+1)
        {
            {' ', ' ', 'B', ' '},
            {' ', ' ', 'B', ' '},
            {' ', 'B', 'B', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_1 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'B', ' ', ' '},
            {' ', 'B', 'B', 'B'},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_2 (X+1)
        {
            {' ', 'B', 'B', ' '},
            {' ', 'B', ' ', ' '},
            {' ', 'B', ' ', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_3 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'B', 'B', 'B'},
            {' ', ' ', ' ', 'B'},
            {' ', ' ', ' ', ' '}
        }
    },

    // tetromino_type_L
    {
        // tetromino_orientation_0 (X+1)
        {
            {' ', 'R', ' ', ' '},
            {' ', 'R', ' ', ' '},
            {' ', 'R', 'R', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_1 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'R', 'R', 'R'},
            {' ', 'R', ' ', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_2 (X+1)
        {
            {' ', 'R', 'R', ' '},
            {' ', ' ', 'R', ' '},
            {' ', ' ', 'R', ' '},
            {' ', ' ', ' ', ' '}
        },

        // tetromino_orientation_3 (X+1, Y+1)
        {
            {' ', ' ', ' ', ' '},
            {' ', 'R', ' ', ' '},
            {' ', 'R', 'R', 'R'},
            {' ', ' ', ' ', ' '}
        }
    }

};

char _debug_currentboard[ROWS][COLS] = {
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '},
    {' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '}
};

// struct containing the internal data needed for the current tetromino
typedef struct {
	_debug_tetromino_type tetromino_type;
    _debug_tetromino_orientation tetromino_orientation;
	int pos_x;
	int pos_y;
    int offset_x;
    int offset_y;
} _debug_currenttetromino;