module block_sync#(
	parameter INIT_F = ""
)(
	input logic clk,
	input logic [8:0] address,
	output logic [7:0] data_out
);

	logic [7:0] mem [512:0];

	initial begin
		if (INIT_F) != 0) begin
			$readmemh(INIT_F, mem);
		end
	end

	always_ff @(posedge clk) begin
		data_out <= mem[address];
	end
endmodule
