#ifndef _WACOM_HID_DRIVER_H
#define _WACOM_HID_DRIVER_H

#include <hidapi.h>
#include <wchar.h>
#include <string.h>
#include <stdlib.h>

void print_device(struct hid_device_info *cur_dev);
void print_hid_report_descriptor_from_device(hid_device *device);
void print_hid_report_descriptor_from_path(const char *path);
void print_devices(struct hid_device_info *cur_dev);
void print_devices_with_descriptor(struct hid_device_info *cur_dev);
int wacom_hid_init();
struct hid_device_info *wacom_hid_enumerate(unsigned short vendor_id, unsigned short product_id);
void wacom_hid_free_enumeration(struct hid_device_info *devs);
struct hid_device *wacom_hid_open(unsigned short vendor_id, unsigned short product_id, const wchar_t *serial_number);
int wacom_hid_get_manufacturer_string (hid_device *dev, wchar_t *string, size_t maxlen);
int wacom_hid_get_product_string(hid_device *dev, wchar_t *string, size_t maxlen);
int wacom_hid_get_serial_number_string(hid_device *dev, wchar_t *string, size_t maxlen);
struct hid_device_info *wacom_hid_get_device_info(hid_device *dev);
int wacom_hid_get_indexed_string(hid_device *dev, int string_index, wchar_t *string, size_t maxlen);
int wacom_hid_set_nonblocking(hid_device *dev, int nonblock);
int wacom_hid_read(hid_device *dev, unsigned char *data, size_t length);
int wacom_hid_send_feature_report(hid_device *dev, const unsigned char *data, size_t length);
int hid_get_feature_report(hid_device *dev, unsigned char *data, size_t length);

#endif