// Wacom Driver Files
//#include <hidapi.h>
#include "wacom_hid_driver.h"

// Fallback/example
#ifndef HID_API_MAKE_VERSION
#define HID_API_MAKE_VERSION(mj, mn, p) (((mj) << 24) | ((mn) << 8) | (p))
#endif
#ifndef HID_API_VERSION
#define HID_API_VERSION HID_API_MAKE_VERSION(HID_API_VERSION_MAJOR, HID_API_VERSION_MINOR, HID_API_VERSION_PATCH)
#endif

// Sample using platform-specific headers

#if defined(USING_HIDAPI_LIBUSB) && HID_API_VERSION >= HID_API_MAKE_VERSION(0, 12, 0)
#include <hidapi_libusb.h>
#endif


void print_device(struct hid_device_info *cur_dev) {
	printf("Device Found\n  type: %04hx %04hx\n  path: %s\n  serial_number: %ls", cur_dev->vendor_id, cur_dev->product_id, cur_dev->path, cur_dev->serial_number);
	printf("\n");
	printf("  Manufacturer: %ls\n", cur_dev->manufacturer_string);
	printf("  Product:      %ls\n", cur_dev->product_string);
	printf("  Release:      %hx\n", cur_dev->release_number);
	printf("  Interface:    %d\n",  cur_dev->interface_number);
	printf("  Usage (page): 0x%hx (0x%hx)\n", cur_dev->usage, cur_dev->usage_page);
	printf("  Bus type: %d\n", cur_dev->bus_type);
	printf("\n");
}

void print_hid_report_descriptor_from_device(hid_device *device) {
	unsigned char descriptor[HID_API_MAX_REPORT_DESCRIPTOR_SIZE];
	int res = 0;

	printf("  Report Descriptor: ");
	res = hid_get_report_descriptor(device, descriptor, sizeof(descriptor));
	if (res < 0) {
		printf("error getting: %ls", hid_error(device));
	}
	else {
		printf("(%d bytes)", res);
	}
	for (int i = 0; i < res; i++) {
		if (i % 10 == 0) {
			printf("\n");
		}
		printf("0x%02x, ", descriptor[i]);
	}
	printf("\n");
}

void print_hid_report_descriptor_from_path(const char *path) {
	hid_device *device = hid_open_path(path);
	if (device) {
		print_hid_report_descriptor_from_device(device);
		hid_close(device);
	}
	else {
		printf("  Report Descriptor: Unable to open device by path\n");
	}
}

void print_devices(struct hid_device_info *cur_dev) {
	for (; cur_dev; cur_dev = cur_dev->next) {
		print_device(cur_dev);
	}
}

void print_devices_with_descriptor(struct hid_device_info *cur_dev) {
	for (; cur_dev; cur_dev = cur_dev->next) {
		print_device(cur_dev);
		print_hid_report_descriptor_from_path(cur_dev->path);
	}
}

int wacom_hid_init() {
    return hid_init();
}

struct hid_device_info *wacom_hid_enumerate(unsigned short vendor_id, unsigned short product_id) {
    return hid_enumerate(vendor_id, product_id);
}

void wacom_hid_free_enumeration(struct hid_device_info *devs) {
    hid_free_enumeration(devs);
}

struct hid_device *wacom_hid_open(unsigned short vendor_id, unsigned short product_id, const wchar_t *serial_number) {
    return hid_open(vendor_id, product_id, serial_number);
}

int wacom_hid_get_manufacturer_string (hid_device *dev, wchar_t *string, size_t maxlen) {
    return hid_get_manufacturer_string(dev, string, maxlen);
}

int wacom_hid_get_product_string(hid_device *dev, wchar_t *string, size_t maxlen) {
    return hid_get_product_string(dev, string, maxlen);
}

int wacom_hid_get_serial_number_string(hid_device *dev, wchar_t *string, size_t maxlen) {
    return hid_get_serial_number_string(dev, string, maxlen);
}

struct hid_device_info *wacom_hid_get_device_info(hid_device *dev) {
    return hid_get_device_info(dev);
}

int wacom_hid_get_indexed_string(hid_device *dev, int string_index, wchar_t *string, size_t maxlen) {
    hid_get_indexed_string(dev, string_index, string, maxlen);
}

int wacom_hid_set_nonblocking(hid_device *dev, int nonblock) {
    return hid_set_nonblocking(dev, nonblock);
}

int wacom_hid_read(hid_device *dev, unsigned char *data, size_t length) {
    return hid_read(dev, data, length);
}

int wacom_hid_send_feature_report(hid_device *dev, const unsigned char *data, size_t length) {
    return hid_send_feature_report(dev, data, length);
}

int wacom_hid_get_feature_report(hid_device *dev, unsigned char *data, size_t length) {
    return hid_get_feature_report(dev, data, length);
}

int wacom_hid_exit(void) {
    return hid_exit();
}



