module vga_ball(
		input logic        clk,
	        input logic 	   reset,
		input logic [31:0]  writedata,
		input logic 	   write,
		input logic 	   read,
		input 		   chipselect,
		output logic [31:0] readdata,
		input logic [2:0]  address,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n);

   logic [10:0]	   hcount,x;
   logic [9:0]     vcount,y;

   logic [7:0] 	   background_r, background_g, background_b;
   logic [17:0] index;
   logic [18:0] i = 0;
   logic [18:0] addr_b_del;
   logic [18:0] addr_b_del2;

   logic [18:0] addr_a_del;
   logic [18:0] addr_a_del2;
   logic [2:0] pixel_out;
   logic [2:0] color;

  // Sketchmaster (2163), Box(630*8), CSEE4840(336)
   logic [9674:0][18:0] temp_addr;
   logic [18:0] temp_count;

   logic [2:0] heading_color;
   logic [2:0] draw_color;
   logic [2:0] draw_color_state;
   logic flag;
   logic clear_screen;
   logic clear_done;
   logic read_flag;
   logic read_done;
   
   logic [31:0] addr_track;
   logic [31:0] clear_addr;
   logic [31:0] read_addr;

   logic [31:0] ball_h;
   logic [31:0] ball_v;
   logic [31:0] clear_h;
   logic [31:0] clear_v;
   logic [31:0] read_h;
   logic [31:0] read_v;

	localparam [2:0] // 3 states are required for Moore
		color1 = 3'h0,
		color2 = 3'h1, 
		color3 = 3'h2,
		color4 = 3'h3,
		color5 = 3'h4,
		color6 = 3'h5, 
		color7 = 3'h6,
		color8 = 3'h7;

   vga_counters counters(.clk50(clk), .*);


// VGA Output signals

	logic [18:0] addr_a,addr_b;
	logic wea, web;
	logic [2:0] pixel;
// Paste the values here in the order MSB:LSB
// BOX 8, BOX 7, BOX 6, BOX 5, BOX 4, BOX 3, BOX 2, BOX 1, SKETCHMASTER, CSEE 4840
 assign temp_addr = {19'd305517, 19'd305518, 19'd305519, 19'd305520, 19'd305521, 19'd305522, 19'd305523, 19'd305524, 19'd305525, 19'd305526, 19'd305527, 19'd305528, 19'd305529, 19'd305530, 19'd305531, 19'd305532, 19'd305533, 19'd305534, 19'd305535, 19'd305536, 19'd305537, 19'd305538, 19'd305539, 19'd305540, 19'd305541, 19'd305542, 19'd305543, 19'd305544, 19'd305545, 19'd305546, 19'd305547, 19'd305548, 19'd305549, 19'd305550, 19'd305551, 19'd305552, 19'd305553, 19'd305554, 19'd305555, 19'd305556, 19'd305557, 19'd305558, 19'd305559, 19'd305560, 19'd305561, 19'd305562, 19'd305563, 19'd305564, 19'd305565, 19'd305566, 19'd305567, 19'd305568, 19'd305569, 19'd305570, 19'd305571, 19'd305572, 19'd305573, 19'd305574, 19'd305575, 19'd305576, 19'd305577, 19'd305578, 19'd305579, 19'd305580, 19'd305581, 19'd305582, 19'd305583, 19'd305584, 19'd305585, 19'd305586, 19'd305587, 19'd305588, 19'd305589, 19'd305590, 19'd305591, 19'd305592, 19'd305593, 19'd305594, 19'd305595, 19'd305596, 19'd305597, 19'd305598, 19'd305599, 19'd305600, 19'd305601, 19'd305602, 19'd305603, 19'd305604, 19'd305605, 19'd305606, 19'd305607, 19'd305608, 19'd305609, 19'd305610, 19'd305611, 19'd305612, 19'd305613, 19'd305614, 19'd305615, 19'd305616, 19'd305617, 19'd305618, 19'd305619, 19'd305620, 19'd305621, 19'd305622, 19'd305623, 19'd305624, 19'd305625, 19'd305626, 19'd305627, 19'd305628, 19'd305629, 19'd305630, 19'd305631, 19'd305632, 19'd305633, 19'd305634, 19'd305635, 19'd305636, 19'd305637, 19'd305638, 19'd305639, 19'd305640, 19'd305641, 19'd305642, 19'd305643, 19'd305644, 19'd305645, 19'd305646, 19'd305647, 19'd305648, 19'd305649, 19'd305650, 19'd305651, 19'd305652, 19'd305653, 19'd305654, 19'd305655, 19'd305656, 19'd305657, 19'd305658, 19'd305659, 19'd305660, 19'd305661, 19'd305662, 19'd305663, 19'd305664, 19'd305665, 19'd305666, 19'd305667, 19'd305668, 19'd305669, 19'd305670, 19'd305671, 19'd305672, 19'd305673, 19'd305674, 19'd305675, 19'd305676, 19'd305677, 19'd305678, 19'd305679, 19'd305680, 19'd305681, 19'd305682, 19'd305683, 19'd305684, 19'd305685, 19'd305686, 19'd305687, 19'd305688, 19'd305689, 19'd305690, 19'd305691, 19'd305692, 19'd305693, 19'd305694, 19'd305695, 19'd305696, 19'd305697, 19'd305698, 19'd305699, 19'd305700, 19'd305701, 19'd305702, 19'd305703, 19'd305704, 19'd305705, 19'd305706, 19'd305707, 19'd305708, 19'd305709, 19'd305710, 19'd305711, 19'd305712, 19'd305713, 19'd305714, 19'd305715, 19'd305716, 19'd305717, 19'd305718, 19'd305719, 19'd305720, 19'd305721, 19'd305722, 19'd305723, 19'd305724, 19'd305725, 19'd305726, 19'd305727, 19'd305728, 19'd305729, 19'd305730, 19'd305731, 19'd305732, 19'd305733, 19'd305734, 19'd305735, 19'd305736, 19'd305737, 19'd305738, 19'd305739, 19'd305740, 19'd305741, 19'd305742, 19'd305743, 19'd305744, 19'd305745, 19'd305746, 19'd305747, 19'd305748, 19'd305749, 19'd305750, 19'd305751, 19'd305752, 19'd305753, 19'd305754, 19'd305755, 19'd305756, 19'd305757, 19'd305758, 19'd305759, 19'd305760, 19'd305761, 19'd305762, 19'd305763, 19'd305764, 19'd305765, 19'd305766, 19'd305767, 19'd305768, 19'd305769, 19'd305770, 19'd305771, 19'd305772, 19'd305773, 19'd305774, 19'd305775, 19'd305776, 19'd305777, 19'd305778, 19'd305779, 19'd305780, 19'd305781, 19'd305782, 19'd305783, 19'd305784, 19'd305785, 19'd305786, 19'd305787, 19'd305788, 19'd305789, 19'd305790, 19'd305791, 19'd305792, 19'd305793, 19'd305794, 19'd305795, 19'd305796, 19'd305797, 19'd305798, 19'd305799, 19'd305800, 19'd305801, 19'd305802, 19'd305803, 19'd305804, 19'd305805, 19'd305806, 19'd305807, 19'd305808, 19'd305809, 19'd305810, 19'd305811, 19'd305812, 19'd305813, 19'd305814, 19'd305815, 19'd305816, 19'd305817, 19'd305818, 19'd305819, 19'd305820, 19'd305821, 19'd305822, 19'd305823, 19'd305824, 19'd305825, 19'd305826, 19'd305827, 19'd305828, 19'd305829, 19'd305830, 19'd305831, 19'd305832, 19'd305833, 19'd305834, 19'd305835, 19'd305836, 19'd305837, 19'd305838, 19'd305839, 19'd305840, 19'd305841, 19'd305842, 19'd305843, 19'd305844, 19'd305845, 19'd305846, 19'd305847, 19'd305848, 19'd305849, 19'd305850, 19'd305851, 19'd305852, 19'd305853, 19'd305854, 19'd305855, 19'd305856, 19'd305857, 19'd305858, 19'd305859, 19'd305860, 19'd305861, 19'd305862, 19'd305863, 19'd305864, 19'd305865, 19'd305866, 19'd305867, 19'd305868, 19'd305869, 19'd305870, 19'd305871, 19'd305872, 19'd305873, 19'd305874, 19'd305875, 19'd305876, 19'd305877, 19'd305878, 19'd305879, 19'd305880, 19'd305881, 19'd305882, 19'd305883, 19'd305884, 19'd305885, 19'd305886, 19'd305887, 19'd305888, 19'd305889, 19'd305890, 19'd305891, 19'd305892, 19'd305893, 19'd305894, 19'd305895, 19'd305896, 19'd305897, 19'd305898, 19'd305899, 19'd305900, 19'd305901, 19'd305902, 19'd305903, 19'd305904, 19'd305905, 19'd305906, 19'd305907, 19'd305908, 19'd305909, 19'd305910, 19'd305911, 19'd305912, 19'd305913, 19'd305914, 19'd305915, 19'd305916, 19'd305917, 19'd305918, 19'd305919, 19'd305920, 19'd305921, 19'd305922, 19'd305923, 19'd305924, 19'd305925, 19'd305926, 19'd305927, 19'd305928, 19'd305929, 19'd305930, 19'd305931, 19'd305932, 19'd305933, 19'd305934, 19'd305935, 19'd305936, 19'd305937, 19'd305938, 19'd305939, 19'd305940, 19'd305941, 19'd305942, 19'd305943, 19'd305944, 19'd305945, 19'd305946, 19'd305947, 19'd305948, 19'd305949, 19'd305950, 19'd305951, 19'd305952, 19'd305953, 19'd305954, 19'd305955, 19'd305956, 19'd305957, 19'd305958, 19'd305959, 19'd305960, 19'd305961, 19'd305962, 19'd305963, 19'd305964, 19'd305965, 19'd305966, 19'd305967, 19'd305968, 19'd305969, 19'd305970, 19'd305971, 19'd305972, 19'd305973, 19'd305974, 19'd305975, 19'd305976, 19'd305977, 19'd305978, 19'd305979, 19'd305980, 19'd305981, 19'd305982, 19'd305983, 19'd305984, 19'd305985, 19'd305986, 19'd305987, 19'd305988, 19'd305989, 19'd305990, 19'd305991, 19'd305992, 19'd305993, 19'd305994, 19'd305995, 19'd305996, 19'd305997, 19'd305998, 19'd305999, 19'd306000, 19'd306001, 19'd306002, 19'd306003, 19'd306004, 19'd306005, 19'd306006, 19'd306007, 19'd306008, 19'd306009, 19'd306010, 19'd306011, 19'd306012, 19'd306013, 19'd306014, 19'd306015, 19'd306016, 19'd306017, 19'd306018, 19'd306019, 19'd306020, 19'd306021, 19'd306022, 19'd306023, 19'd306024, 19'd306025, 19'd306026, 19'd306027, 19'd306028, 19'd306029, 19'd306030, 19'd306031, 19'd306032, 19'd306033, 19'd306034, 19'd306035, 19'd306036, 19'd306037, 19'd306038, 19'd306039, 19'd306040, 19'd306041, 19'd306042, 19'd306043, 19'd306044, 19'd306045, 19'd306046, 19'd306047, 19'd306048, 19'd306049, 19'd306050, 19'd306051, 19'd306052, 19'd306053, 19'd306054, 19'd306055, 19'd306056, 19'd306057, 19'd306058, 19'd306059, 19'd306060, 19'd306061, 19'd306062, 19'd306063, 19'd306064, 19'd306065, 19'd306066, 19'd306067, 19'd306068, 19'd306069, 19'd306070, 19'd306071, 19'd306072, 19'd306073, 19'd306074, 19'd306075, 19'd306076, 19'd306077, 19'd306078, 19'd306079, 19'd306080, 19'd48640, 19'd49279, 19'd49918, 19'd50557, 19'd51196, 19'd51835, 19'd52474, 19'd53113, 19'd53752, 19'd54391, 19'd55030, 19'd55669, 19'd56308, 19'd56947, 19'd57586, 19'd58225, 19'd58864, 19'd59503, 19'd60142, 19'd60781, 19'd61420, 19'd62059, 19'd62698, 19'd63337, 19'd63976, 19'd64615, 19'd65254, 19'd65893, 19'd66532, 19'd67171, 19'd67810, 19'd68449, 19'd69088, 19'd69727, 19'd70366, 19'd71005, 19'd71644, 19'd72283, 19'd72922, 19'd73561, 19'd74200, 19'd74839, 19'd75478, 19'd76117, 19'd76756, 19'd77395, 19'd78034, 19'd78673, 19'd79312, 19'd79951, 19'd80590, 19'd81229, 19'd81868, 19'd82507, 19'd83146, 19'd83785, 19'd84424, 19'd85063, 19'd85702, 19'd86341, 19'd86980, 19'd87619, 19'd88258, 19'd88897, 19'd89536, 19'd90175, 19'd90814, 19'd91453, 19'd92092, 19'd92731, 19'd93370, 19'd94009, 19'd94648, 19'd95287, 19'd95926, 19'd96565, 19'd97204, 19'd97843, 19'd98482, 19'd99121, 19'd99760, 19'd100399, 19'd101038, 19'd101677, 19'd102316, 19'd102955, 19'd103594, 19'd104233, 19'd104872, 19'd105511, 19'd106150, 19'd106789, 19'd107428, 19'd108067, 19'd108706, 19'd109345, 19'd109984, 19'd110623, 19'd111262, 19'd111901, 19'd112540, 19'd113179, 19'd113818, 19'd114457, 19'd115096, 19'd115735, 19'd116374, 19'd117013, 19'd117652, 19'd118291, 19'd118930, 19'd119569, 19'd120208, 19'd120847, 19'd121486, 19'd122125, 19'd122764, 19'd123403, 19'd124042, 19'd124681, 19'd125320, 19'd125959, 19'd126598, 19'd127237, 19'd127876, 19'd128515, 19'd129154, 19'd129793, 19'd130432, 19'd131071, 19'd131710, 19'd132349, 19'd132988, 19'd133627, 19'd134266, 19'd134905, 19'd135544, 19'd136183, 19'd136822, 19'd137461, 19'd138100, 19'd138739, 19'd139378, 19'd140017, 19'd140656, 19'd141295, 19'd141934, 19'd142573, 19'd143212, 19'd143851, 19'd144490, 19'd145129, 19'd145768, 19'd146407, 19'd147046, 19'd147685, 19'd148324, 19'd148963, 19'd149602, 19'd150241, 19'd150880, 19'd151519, 19'd152158, 19'd152797, 19'd153436, 19'd154075, 19'd154714, 19'd155353, 19'd155992, 19'd156631, 19'd157270, 19'd157909, 19'd158548, 19'd159187, 19'd159826, 19'd160465, 19'd161104, 19'd161743, 19'd162382, 19'd163021, 19'd163660, 19'd164299, 19'd164938, 19'd165577, 19'd166216, 19'd166855, 19'd167494, 19'd168133, 19'd168772, 19'd169411, 19'd170050, 19'd170689, 19'd171328, 19'd171967, 19'd172606, 19'd173245, 19'd173884, 19'd174523, 19'd175162, 19'd175801, 19'd176440, 19'd177079, 19'd177718, 19'd178357, 19'd178996, 19'd179635, 19'd180274, 19'd180913, 19'd181552, 19'd182191, 19'd182830, 19'd183469, 19'd184108, 19'd184747, 19'd185386, 19'd186025, 19'd186664, 19'd187303, 19'd187942, 19'd188581, 19'd189220, 19'd189859, 19'd190498, 19'd191137, 19'd191776, 19'd192415, 19'd193054, 19'd193693, 19'd194332, 19'd194971, 19'd195610, 19'd196249, 19'd196888, 19'd197527, 19'd198166, 19'd198805, 19'd199444, 19'd200083, 19'd200722, 19'd201361, 19'd202000, 19'd202639, 19'd203278, 19'd203917, 19'd204556, 19'd205195, 19'd205834, 19'd206473, 19'd207112, 19'd207751, 19'd208390, 19'd209029, 19'd209668, 19'd210307, 19'd210946, 19'd211585, 19'd212224, 19'd212863, 19'd213502, 19'd214141, 19'd214780, 19'd215419, 19'd216058, 19'd216697, 19'd217336, 19'd217975, 19'd218614, 19'd219253, 19'd219892, 19'd220531, 19'd221170, 19'd221809, 19'd222448, 19'd223087, 19'd223726, 19'd224365, 19'd225004, 19'd225643, 19'd226282, 19'd226921, 19'd227560, 19'd228199, 19'd228838, 19'd229477, 19'd230116, 19'd230755, 19'd231394, 19'd232033, 19'd232672, 19'd233311, 19'd233950, 19'd234589, 19'd235228, 19'd235867, 19'd236506, 19'd237145, 19'd237784, 19'd238423, 19'd239062, 19'd239701, 19'd240340, 19'd240979, 19'd241618, 19'd242257, 19'd242896, 19'd243535, 19'd244174, 19'd244813, 19'd245452, 19'd246091, 19'd246730, 19'd247369, 19'd248008, 19'd248647, 19'd249286, 19'd249925, 19'd250564, 19'd251203, 19'd251842, 19'd252481, 19'd253120, 19'd253759, 19'd254398, 19'd255037, 19'd255676, 19'd256315, 19'd256954, 19'd257593, 19'd258232, 19'd258871, 19'd259510, 19'd260149, 19'd260788, 19'd261427, 19'd262066, 19'd262705, 19'd263344, 19'd263983, 19'd264622, 19'd265261, 19'd265900, 19'd266539, 19'd267178, 19'd267817, 19'd268456, 19'd269095, 19'd269734, 19'd270373, 19'd271012, 19'd271651, 19'd272290, 19'd272929, 19'd273568, 19'd274207, 19'd274846, 19'd275485, 19'd276124, 19'd276763, 19'd277402, 19'd278041, 19'd278680, 19'd279319, 19'd279958, 19'd280597, 19'd281236, 19'd281875, 19'd282514, 19'd283153, 19'd283792, 19'd284431, 19'd285070, 19'd285709, 19'd286348, 19'd286987, 19'd287626, 19'd288265, 19'd288904, 19'd289543, 19'd290182, 19'd290821, 19'd291460, 19'd292099, 19'd292738, 19'd293377, 19'd294016, 19'd294655, 19'd295294, 19'd295933, 19'd296572, 19'd297211, 19'd297850, 19'd298489, 19'd299128, 19'd299767, 19'd300406, 19'd301045, 19'd301684, 19'd302323, 19'd302962, 19'd303601, 19'd304240, 19'd304879, 19'd305518, 19'd48000, 19'd48001, 19'd48002, 19'd48003, 19'd48004, 19'd48005, 19'd48006, 19'd48007, 19'd48008, 19'd48009, 19'd48010, 19'd48011, 19'd48012, 19'd48013, 19'd48014, 19'd48015, 19'd48016, 19'd48017, 19'd48018, 19'd48019, 19'd48020, 19'd48021, 19'd48022, 19'd48023, 19'd48024, 19'd48025, 19'd48026, 19'd48027, 19'd48028, 19'd48029, 19'd48030, 19'd48031, 19'd48032, 19'd48033, 19'd48034, 19'd48035, 19'd48036, 19'd48037, 19'd48038, 19'd48039, 19'd48040, 19'd48041, 19'd48042, 19'd48043, 19'd48044, 19'd48045, 19'd48046, 19'd48047, 19'd48048, 19'd48049, 19'd48050, 19'd48051, 19'd48052, 19'd48053, 19'd48054, 19'd48055, 19'd48056, 19'd48057, 19'd48058, 19'd48059, 19'd48060, 19'd48061, 19'd48062, 19'd48063, 19'd48064, 19'd48065, 19'd48066, 19'd48067, 19'd48068, 19'd48069, 19'd48070, 19'd48071, 19'd48072, 19'd48073, 19'd48074, 19'd48075, 19'd48076, 19'd48077, 19'd48078, 19'd48079, 19'd48080, 19'd48081, 19'd48082, 19'd48083, 19'd48084, 19'd48085, 19'd48086, 19'd48087, 19'd48088, 19'd48089, 19'd48090, 19'd48091, 19'd48092, 19'd48093, 19'd48094, 19'd48095, 19'd48096, 19'd48097, 19'd48098, 19'd48099, 19'd48100, 19'd48101, 19'd48102, 19'd48103, 19'd48104, 19'd48105, 19'd48106, 19'd48107, 19'd48108, 19'd48109, 19'd48110, 19'd48111, 19'd48112, 19'd48113, 19'd48114, 19'd48115, 19'd48116, 19'd48117, 19'd48118, 19'd48119, 19'd48120, 19'd48121, 19'd48122, 19'd48123, 19'd48124, 19'd48125, 19'd48126, 19'd48127, 19'd48128, 19'd48129, 19'd48130, 19'd48131, 19'd48132, 19'd48133, 19'd48134, 19'd48135, 19'd48136, 19'd48137, 19'd48138, 19'd48139, 19'd48140, 19'd48141, 19'd48142, 19'd48143, 19'd48144, 19'd48145, 19'd48146, 19'd48147, 19'd48148, 19'd48149, 19'd48150, 19'd48151, 19'd48152, 19'd48153, 19'd48154, 19'd48155, 19'd48156, 19'd48157, 19'd48158, 19'd48159, 19'd48160, 19'd48161, 19'd48162, 19'd48163, 19'd48164, 19'd48165, 19'd48166, 19'd48167, 19'd48168, 19'd48169, 19'd48170, 19'd48171, 19'd48172, 19'd48173, 19'd48174, 19'd48175, 19'd48176, 19'd48177, 19'd48178, 19'd48179, 19'd48180, 19'd48181, 19'd48182, 19'd48183, 19'd48184, 19'd48185, 19'd48186, 19'd48187, 19'd48188, 19'd48189, 19'd48190, 19'd48191, 19'd48192, 19'd48193, 19'd48194, 19'd48195, 19'd48196, 19'd48197, 19'd48198, 19'd48199, 19'd48200, 19'd48201, 19'd48202, 19'd48203, 19'd48204, 19'd48205, 19'd48206, 19'd48207, 19'd48208, 19'd48209, 19'd48210, 19'd48211, 19'd48212, 19'd48213, 19'd48214, 19'd48215, 19'd48216, 19'd48217, 19'd48218, 19'd48219, 19'd48220, 19'd48221, 19'd48222, 19'd48223, 19'd48224, 19'd48225, 19'd48226, 19'd48227, 19'd48228, 19'd48229, 19'd48230, 19'd48231, 19'd48232, 19'd48233, 19'd48234, 19'd48235, 19'd48236, 19'd48237, 19'd48238, 19'd48239, 19'd48240, 19'd48241, 19'd48242, 19'd48243, 19'd48244, 19'd48245, 19'd48246, 19'd48247, 19'd48248, 19'd48249, 19'd48250, 19'd48251, 19'd48252, 19'd48253, 19'd48254, 19'd48255, 19'd48256, 19'd48257, 19'd48258, 19'd48259, 19'd48260, 19'd48261, 19'd48262, 19'd48263, 19'd48264, 19'd48265, 19'd48266, 19'd48267, 19'd48268, 19'd48269, 19'd48270, 19'd48271, 19'd48272, 19'd48273, 19'd48274, 19'd48275, 19'd48276, 19'd48277, 19'd48278, 19'd48279, 19'd48280, 19'd48281, 19'd48282, 19'd48283, 19'd48284, 19'd48285, 19'd48286, 19'd48287, 19'd48288, 19'd48289, 19'd48290, 19'd48291, 19'd48292, 19'd48293, 19'd48294, 19'd48295, 19'd48296, 19'd48297, 19'd48298, 19'd48299, 19'd48300, 19'd48301, 19'd48302, 19'd48303, 19'd48304, 19'd48305, 19'd48306, 19'd48307, 19'd48308, 19'd48309, 19'd48310, 19'd48311, 19'd48312, 19'd48313, 19'd48314, 19'd48315, 19'd48316, 19'd48317, 19'd48318, 19'd48319, 19'd48320, 19'd48321, 19'd48322, 19'd48323, 19'd48324, 19'd48325, 19'd48326, 19'd48327, 19'd48328, 19'd48329, 19'd48330, 19'd48331, 19'd48332, 19'd48333, 19'd48334, 19'd48335, 19'd48336, 19'd48337, 19'd48338, 19'd48339, 19'd48340, 19'd48341, 19'd48342, 19'd48343, 19'd48344, 19'd48345, 19'd48346, 19'd48347, 19'd48348, 19'd48349, 19'd48350, 19'd48351, 19'd48352, 19'd48353, 19'd48354, 19'd48355, 19'd48356, 19'd48357, 19'd48358, 19'd48359, 19'd48360, 19'd48361, 19'd48362, 19'd48363, 19'd48364, 19'd48365, 19'd48366, 19'd48367, 19'd48368, 19'd48369, 19'd48370, 19'd48371, 19'd48372, 19'd48373, 19'd48374, 19'd48375, 19'd48376, 19'd48377, 19'd48378, 19'd48379, 19'd48380, 19'd48381, 19'd48382, 19'd48383, 19'd48384, 19'd48385, 19'd48386, 19'd48387, 19'd48388, 19'd48389, 19'd48390, 19'd48391, 19'd48392, 19'd48393, 19'd48394, 19'd48395, 19'd48396, 19'd48397, 19'd48398, 19'd48399, 19'd48400, 19'd48401, 19'd48402, 19'd48403, 19'd48404, 19'd48405, 19'd48406, 19'd48407, 19'd48408, 19'd48409, 19'd48410, 19'd48411, 19'd48412, 19'd48413, 19'd48414, 19'd48415, 19'd48416, 19'd48417, 19'd48418, 19'd48419, 19'd48420, 19'd48421, 19'd48422, 19'd48423, 19'd48424, 19'd48425, 19'd48426, 19'd48427, 19'd48428, 19'd48429, 19'd48430, 19'd48431, 19'd48432, 19'd48433, 19'd48434, 19'd48435, 19'd48436, 19'd48437, 19'd48438, 19'd48439, 19'd48440, 19'd48441, 19'd48442, 19'd48443, 19'd48444, 19'd48445, 19'd48446, 19'd48447, 19'd48448, 19'd48449, 19'd48450, 19'd48451, 19'd48452, 19'd48453, 19'd48454, 19'd48455, 19'd48456, 19'd48457, 19'd48458, 19'd48459, 19'd48460, 19'd48461, 19'd48462, 19'd48463, 19'd48464, 19'd48465, 19'd48466, 19'd48467, 19'd48468, 19'd48469, 19'd48470, 19'd48471, 19'd48472, 19'd48473, 19'd48474, 19'd48475, 19'd48476, 19'd48477, 19'd48478, 19'd48479, 19'd48480, 19'd48481, 19'd48482, 19'd48483, 19'd48484, 19'd48485, 19'd48486, 19'd48487, 19'd48488, 19'd48489, 19'd48490, 19'd48491, 19'd48492, 19'd48493, 19'd48494, 19'd48495, 19'd48496, 19'd48497, 19'd48498, 19'd48499, 19'd48500, 19'd48501, 19'd48502, 19'd48503, 19'd48504, 19'd48505, 19'd48506, 19'd48507, 19'd48508, 19'd48509, 19'd48510, 19'd48511, 19'd48512, 19'd48513, 19'd48514, 19'd48515, 19'd48516, 19'd48517, 19'd48518, 19'd48519, 19'd48520, 19'd48521, 19'd48522, 19'd48523, 19'd48524, 19'd48525, 19'd48526, 19'd48527, 19'd48528, 19'd48529, 19'd48530, 19'd48531, 19'd48532, 19'd48533, 19'd48534, 19'd48535, 19'd48536, 19'd48537, 19'd48538, 19'd48539, 19'd48540, 19'd48541, 19'd48542, 19'd48543, 19'd48544, 19'd48545, 19'd48546, 19'd48547, 19'd48548, 19'd48549, 19'd48550, 19'd48551, 19'd48552, 19'd48553, 19'd48554, 19'd48555, 19'd48556, 19'd48557, 19'd48558, 19'd48559, 19'd48560, 19'd48561, 19'd48562, 19'd48563,19'd48564, 19'd49203, 19'd49842, 19'd50481, 19'd51120, 19'd51759, 19'd52398, 19'd53037, 19'd53676, 19'd54315, 19'd54954, 19'd55593, 19'd56232, 19'd56871, 19'd57510, 19'd58149, 19'd58788, 19'd59427, 19'd60066, 19'd60705, 19'd61344, 19'd61983, 19'd62622, 19'd63261, 19'd63900, 19'd64539, 19'd65178, 19'd65817, 19'd66456, 19'd67095, 19'd67734, 19'd68373, 19'd69012, 19'd69651, 19'd70290, 19'd70929, 19'd71568, 19'd72207, 19'd72846, 19'd73485, 19'd74124, 19'd74763, 19'd75402, 19'd76041, 19'd76680, 19'd77319, 19'd77958, 19'd78597, 19'd79236, 19'd79875, 19'd80514, 19'd81153, 19'd81792, 19'd82431, 19'd83070, 19'd83709, 19'd84348, 19'd84987, 19'd85626, 19'd86265, 19'd86904, 19'd87543, 19'd88182, 19'd88821, 19'd89460, 19'd90099, 19'd90738, 19'd91377, 19'd92016, 19'd92655, 19'd93294, 19'd93933, 19'd94572, 19'd95211, 19'd95850, 19'd96489, 19'd97128, 19'd97767, 19'd98406, 19'd99045, 19'd99684, 19'd100323, 19'd100962, 19'd101601, 19'd102240, 19'd102879, 19'd103518, 19'd104157, 19'd104796, 19'd105435, 19'd106074, 19'd106713, 19'd107352, 19'd107991, 19'd108630, 19'd109269, 19'd109908, 19'd110547, 19'd111186, 19'd111825, 19'd112464, 19'd113103, 19'd113742, 19'd114381, 19'd115020, 19'd115659, 19'd116298, 19'd116937, 19'd117576, 19'd118215, 19'd118854, 19'd119493, 19'd120132, 19'd120771, 19'd121410, 19'd122049, 19'd122688, 19'd123327, 19'd123966, 19'd124605, 19'd125244, 19'd125883, 19'd126522, 19'd127161, 19'd127800, 19'd128439, 19'd129078, 19'd129717, 19'd130356, 19'd130995, 19'd131634, 19'd132273, 19'd132912, 19'd133551, 19'd134190, 19'd134829, 19'd135468, 19'd136107, 19'd136746, 19'd137385, 19'd138024, 19'd138663, 19'd139302, 19'd139941, 19'd140580, 19'd141219, 19'd141858, 19'd142497, 19'd143136, 19'd143775, 19'd144414, 19'd145053, 19'd145692, 19'd146331, 19'd146970, 19'd147609, 19'd148248, 19'd148887, 19'd149526, 19'd150165, 19'd150804, 19'd151443, 19'd152082, 19'd152721, 19'd153360, 19'd153999, 19'd154638, 19'd155277, 19'd155916, 19'd156555, 19'd157194, 19'd157833, 19'd158472, 19'd159111, 19'd159750, 19'd160389, 19'd161028, 19'd161667, 19'd162306, 19'd162945, 19'd163584, 19'd164223, 19'd164862, 19'd165501, 19'd166140, 19'd166779, 19'd167418, 19'd168057, 19'd168696, 19'd169335, 19'd169974, 19'd170613, 19'd171252, 19'd171891, 19'd172530, 19'd173169, 19'd173808, 19'd174447, 19'd175086, 19'd175725, 19'd176364, 19'd177003, 19'd177642, 19'd178281, 19'd178920, 19'd179559, 19'd180198, 19'd180837, 19'd181476, 19'd182115, 19'd182754, 19'd183393, 19'd184032, 19'd184671, 19'd185310, 19'd185949, 19'd186588, 19'd187227, 19'd187866, 19'd188505, 19'd189144, 19'd189783, 19'd190422, 19'd191061, 19'd191700, 19'd192339, 19'd192978, 19'd193617, 19'd194256, 19'd194895, 19'd195534, 19'd196173, 19'd196812, 19'd197451, 19'd198090, 19'd198729, 19'd199368, 19'd200007, 19'd200646, 19'd201285, 19'd201924, 19'd202563, 19'd203202, 19'd203841, 19'd204480, 19'd205119, 19'd205758, 19'd206397, 19'd207036, 19'd207675, 19'd208314, 19'd208953, 19'd209592, 19'd210231, 19'd210870, 19'd211509, 19'd212148, 19'd212787, 19'd213426, 19'd214065, 19'd214704, 19'd215343, 19'd215982, 19'd216621, 19'd217260, 19'd217899, 19'd218538, 19'd219177, 19'd219816, 19'd220455, 19'd221094, 19'd221733, 19'd222372, 19'd223011, 19'd223650, 19'd224289, 19'd224928, 19'd225567, 19'd226206, 19'd226845, 19'd227484, 19'd228123, 19'd228762, 19'd229401, 19'd230040, 19'd230679, 19'd231318, 19'd231957, 19'd232596, 19'd233235, 19'd233874, 19'd234513, 19'd235152, 19'd235791, 19'd236430, 19'd237069, 19'd237708, 19'd238347, 19'd238986, 19'd239625, 19'd240264, 19'd240903, 19'd241542, 19'd242181, 19'd242820, 19'd243459, 19'd244098, 19'd244737, 19'd245376, 19'd246015, 19'd246654, 19'd247293, 19'd247932, 19'd248571, 19'd249210, 19'd249849, 19'd250488, 19'd251127, 19'd251766, 19'd252405, 19'd253044, 19'd253683, 19'd254322, 19'd254961, 19'd255600, 19'd256239, 19'd256878, 19'd257517, 19'd258156, 19'd258795, 19'd259434, 19'd260073, 19'd260712, 19'd261351, 19'd261990, 19'd262629, 19'd263268, 19'd263907, 19'd264546, 19'd265185, 19'd265824, 19'd266463, 19'd267102, 19'd267741, 19'd268380, 19'd269019, 19'd269658, 19'd270297, 19'd270936, 19'd271575, 19'd272214, 19'd272853, 19'd273492, 19'd274131, 19'd274770, 19'd275409, 19'd276048, 19'd276687, 19'd277326, 19'd277965, 19'd278604, 19'd279243, 19'd279882, 19'd280521, 19'd281160, 19'd281799, 19'd282438, 19'd283077, 19'd283716, 19'd284355, 19'd284994, 19'd285633, 19'd286272, 19'd286911, 19'd287550, 19'd288189, 19'd288828, 19'd289467, 19'd290106, 19'd290745, 19'd291384, 19'd292023, 19'd292662, 19'd293301, 19'd293940, 19'd294579, 19'd295218, 19'd295857, 19'd296496, 19'd297135, 19'd297774, 19'd298413, 19'd299052, 19'd299691, 19'd300330, 19'd300969, 19'd301608, 19'd302247, 19'd302886, 19'd303525, 19'd304164, 19'd304803, 19'd305442, 19'd10826, 19'd10827, 19'd10828, 19'd10829, 19'd10830, 19'd10831, 19'd10833, 19'd10840, 19'd10841, 19'd10842, 19'd10843, 19'd10844, 19'd10845, 19'd10847, 19'd10848, 19'd10849, 19'd10850, 19'd10851, 19'd10852, 19'd10854, 19'd10855, 19'd10856, 19'd10857, 19'd10858, 19'd10859, 19'd11465, 19'd11466, 19'd11467, 19'd11468, 19'd11469, 19'd11470, 19'd11472, 19'd11479, 19'd11480, 19'd11481, 19'd11482, 19'd11483, 19'd11484, 19'd11486, 19'd11487, 19'd11488, 19'd11489, 19'd11490, 19'd11491, 19'd11493, 19'd11494, 19'd11495, 19'd11496, 19'd11497, 19'd11498, 19'd12104, 19'd12111, 19'd12118, 19'd12125, 19'd12130, 19'd12132, 19'd12137, 19'd12743, 19'd12750, 19'd12757, 19'd12764, 19'd12769, 19'd12771, 19'd12776, 19'd13382, 19'd13389, 19'd13396, 19'd13403, 19'd13408, 19'd13410, 19'd13415, 19'd14021, 19'd14028, 19'd14035, 19'd14042, 19'd14047, 19'd14049, 19'd14054, 19'd14660, 19'd14667, 19'd14674, 19'd14681, 19'd14686, 19'd14688, 19'd14693, 19'd15299, 19'd15306, 19'd15313, 19'd15314, 19'd15315, 19'd15316, 19'd15317, 19'd15318, 19'd15320, 19'd15321, 19'd15322, 19'd15323, 19'd15324, 19'd15325, 19'd15327, 19'd15328, 19'd15329, 19'd15330, 19'd15331, 19'd15332, 19'd15938, 19'd15945, 19'd15952, 19'd15953, 19'd15954, 19'd15955, 19'd15956, 19'd15957, 19'd15959, 19'd15960, 19'd15961, 19'd15962, 19'd15963, 19'd15964, 19'd15966, 19'd15967, 19'd15968, 19'd15969, 19'd15970, 19'd15971, 19'd16577, 19'd16584, 19'd16591, 19'd16598, 19'd16603, 19'd16605, 19'd16606, 19'd17216, 19'd17223, 19'd17230, 19'd17237, 19'd17242, 19'd17244, 19'd17245, 19'd17246, 19'd17855, 19'd17862, 19'd17869, 19'd17876, 19'd17881, 19'd17883, 19'd17885, 19'd17886, 19'd18494, 19'd18501, 19'd18508, 19'd18515, 19'd18520, 19'd18522, 19'd18525, 19'd18526, 19'd19133, 19'd19134, 19'd19135, 19'd19136, 19'd19137, 19'd19138, 19'd19140, 19'd19141, 19'd19142, 19'd19143, 19'd19144, 19'd19145, 19'd19147, 19'd19148, 19'd19149, 19'd19150, 19'd19151, 19'd19152, 19'd19154, 19'd19159, 19'd19161, 19'd19165, 19'd19166, 19'd19772, 19'd19773, 19'd19774, 19'd19775, 19'd19776, 19'd19777, 19'd19779, 19'd19780, 19'd19781, 19'd19782, 19'd19783, 19'd19784, 19'd19786, 19'd19787, 19'd19788, 19'd19789, 19'd19790, 19'd19791, 19'd19793, 19'd19798, 19'd19800, 19'd19805, 19'd276714, 19'd276715, 19'd276716, 19'd276717, 19'd276718, 19'd276719, 19'd276721, 19'd276722, 19'd276723, 19'd276724, 19'd276725, 19'd276726, 19'd276728, 19'd276729, 19'd276730, 19'd276731, 19'd276732, 19'd276733, 19'd276735, 19'd276736, 19'd276737, 19'd276738, 19'd276739, 19'd276740, 19'd276742, 19'd276743, 19'd276744, 19'd276745, 19'd276746, 19'd276747, 19'd277353, 19'd277354, 19'd277355, 19'd277356, 19'd277357, 19'd277358, 19'd277360, 19'd277361, 19'd277362, 19'd277363, 19'd277364, 19'd277365, 19'd277367, 19'd277368, 19'd277369, 19'd277370, 19'd277371, 19'd277372, 19'd277374, 19'd277375, 19'd277376, 19'd277377, 19'd277378, 19'd277379, 19'd277381, 19'd277382, 19'd277383, 19'd277384, 19'd277385, 19'd277386, 19'd277992, 19'd277999, 19'd278004, 19'd278006, 19'd278011, 19'd278013, 19'd278020, 19'd278631, 19'd278638, 19'd278643, 19'd278645, 19'd278650, 19'd278652, 19'd278659, 19'd279270, 19'd279277, 19'd279282, 19'd279284, 19'd279289, 19'd279291, 19'd279298, 19'd279909, 19'd279916, 19'd279921, 19'd279923, 19'd279928, 19'd279930, 19'd279937, 19'd280548, 19'd280555, 19'd280560, 19'd280562, 19'd280567, 19'd280569, 19'd280576, 19'd281187, 19'd281188, 19'd281189, 19'd281190, 19'd281191, 19'd281192, 19'd281194, 19'd281195, 19'd281196, 19'd281197, 19'd281198, 19'd281199, 19'd281201, 19'd281202, 19'd281203, 19'd281204, 19'd281205, 19'd281206, 19'd281208, 19'd281209, 19'd281210, 19'd281211, 19'd281212, 19'd281213, 19'd281215, 19'd281216, 19'd281217, 19'd281218, 19'd281219, 19'd281220, 19'd281826, 19'd281827, 19'd281828, 19'd281829, 19'd281830, 19'd281831, 19'd281833, 19'd281834, 19'd281835, 19'd281836, 19'd281837, 19'd281838, 19'd281840, 19'd281841, 19'd281842, 19'd281843, 19'd281844, 19'd281845, 19'd281847, 19'd281848, 19'd281849, 19'd281850, 19'd281851, 19'd281852, 19'd281854, 19'd281855, 19'd281856, 19'd281857, 19'd281858, 19'd281859, 19'd282465, 19'd282472, 19'd282473, 19'd282479, 19'd282484, 19'd282491, 19'd282493, 19'd283104, 19'd283111, 19'd283113, 19'd283118, 19'd283123, 19'd283130, 19'd283132, 19'd283743, 19'd283750, 19'd283752, 19'd283753, 19'd283757, 19'd283762, 19'd283769, 19'd283771, 19'd284382, 19'd284389, 19'd284392, 19'd284393, 19'd284396, 19'd284401, 19'd284408, 19'd284410, 19'd285021, 19'd285022, 19'd285023, 19'd285024, 19'd285025, 19'd285026, 19'd285028, 19'd285032, 19'd285033, 19'd285035, 19'd285040, 19'd285042, 19'd285043, 19'd285044, 19'd285045, 19'd285046, 19'd285047, 19'd285049, 19'd285050, 19'd285051, 19'd285052, 19'd285053, 19'd285054, 19'd285660, 19'd285661, 19'd285662, 19'd285663, 19'd285664, 19'd285665, 19'd285667, 19'd285672, 19'd285674, 19'd285679, 19'd285681, 19'd285682, 19'd285683, 19'd285684, 19'd285685, 19'd285686, 19'd285688, 19'd285689, 19'd285690, 19'd285691, 19'd285692, 19'd285693, 19'd286938, 19'd286939, 19'd286940, 19'd286941, 19'd286942, 19'd286943, 19'd286944, 19'd286945, 19'd286946, 19'd286947, 19'd286948, 19'd286949, 19'd286950, 19'd286951, 19'd286952, 19'd286953, 19'd286954, 19'd286955, 19'd286956, 19'd286957, 19'd286958, 19'd286959, 19'd286960, 19'd286961, 19'd286962, 19'd286963, 19'd286964, 19'd286965, 19'd286966, 19'd286967, 19'd286968, 19'd286969, 19'd286970, 19'd286971, 19'd242849, 19'd242850, 19'd242851, 19'd242852, 19'd242853, 19'd242854, 19'd242855, 19'd242856, 19'd242857, 19'd242858, 19'd242859, 19'd242860, 19'd242861, 19'd242862, 19'd242863, 19'd242864, 19'd242865, 19'd242866, 19'd242867, 19'd242868, 19'd242869, 19'd242870, 19'd242871, 19'd242872, 19'd242873, 19'd242874, 19'd242875, 19'd242876, 19'd242877, 19'd242878, 19'd243488, 19'd243489, 19'd243490, 19'd243491, 19'd243492, 19'd243493, 19'd243494, 19'd243495, 19'd243496, 19'd243497, 19'd243498, 19'd243499, 19'd243500, 19'd243501, 19'd243502, 19'd243503, 19'd243504, 19'd243505, 19'd243506, 19'd243507, 19'd243508, 19'd243509, 19'd243510, 19'd243511, 19'd243512, 19'd243513, 19'd243514, 19'd243515, 19'd243516, 19'd243517, 19'd244127, 19'd244128, 19'd244129, 19'd244130, 19'd244131, 19'd244132, 19'd244133, 19'd244134, 19'd244135, 19'd244136, 19'd244137, 19'd244138, 19'd244139, 19'd244140, 19'd244141, 19'd244142, 19'd244143, 19'd244144, 19'd244145, 19'd244146, 19'd244147, 19'd244148, 19'd244149, 19'd244150, 19'd244151, 19'd244152, 19'd244153, 19'd244154, 19'd244155, 19'd244156, 19'd244766, 19'd244767, 19'd244768, 19'd244769, 19'd244770, 19'd244771, 19'd244772, 19'd244773, 19'd244774, 19'd244775, 19'd244776, 19'd244777, 19'd244778, 19'd244779, 19'd244780, 19'd244781, 19'd244782, 19'd244783, 19'd244784, 19'd244785, 19'd244786, 19'd244787, 19'd244788, 19'd244789, 19'd244790, 19'd244791, 19'd244792, 19'd244793, 19'd244794, 19'd244795, 19'd245405, 19'd245406, 19'd245407, 19'd245408, 19'd245409, 19'd245410, 19'd245411, 19'd245412, 19'd245413, 19'd245414, 19'd245415, 19'd245416, 19'd245417, 19'd245418, 19'd245419, 19'd245420, 19'd245421, 19'd245422, 19'd245423, 19'd245424, 19'd245425, 19'd245426, 19'd245427, 19'd245428, 19'd245429, 19'd245430, 19'd245431, 19'd245432, 19'd245433, 19'd245434, 19'd246044, 19'd246045, 19'd246046, 19'd246047, 19'd246048, 19'd246049, 19'd246050, 19'd246051, 19'd246052, 19'd246053, 19'd246054, 19'd246055, 19'd246056, 19'd246057, 19'd246058, 19'd246059, 19'd246060, 19'd246061, 19'd246062, 19'd246063, 19'd246064, 19'd246065, 19'd246066, 19'd246067, 19'd246068, 19'd246069, 19'd246070, 19'd246071, 19'd246072, 19'd246073, 19'd246683, 19'd246684, 19'd246685, 19'd246686, 19'd246687, 19'd246688, 19'd246689, 19'd246690, 19'd246691, 19'd246692, 19'd246693, 19'd246694, 19'd246695, 19'd246696, 19'd246697, 19'd246698, 19'd246699, 19'd246700, 19'd246701, 19'd246702, 19'd246703, 19'd246704, 19'd246705, 19'd246706, 19'd246707, 19'd246708, 19'd246709, 19'd246710, 19'd246711, 19'd246712, 19'd247322, 19'd247323, 19'd247324, 19'd247325, 19'd247326, 19'd247327, 19'd247328, 19'd247329, 19'd247330, 19'd247331, 19'd247332, 19'd247333, 19'd247334, 19'd247335, 19'd247336, 19'd247337, 19'd247338, 19'd247339, 19'd247340, 19'd247341, 19'd247342, 19'd247343, 19'd247344, 19'd247345, 19'd247346, 19'd247347, 19'd247348, 19'd247349, 19'd247350, 19'd247351, 19'd247961, 19'd247962, 19'd247963, 19'd247964, 19'd247965, 19'd247966, 19'd247967, 19'd247968, 19'd247969, 19'd247970, 19'd247971, 19'd247972, 19'd247973, 19'd247974, 19'd247975, 19'd247976, 19'd247977, 19'd247978, 19'd247979, 19'd247980, 19'd247981, 19'd247982, 19'd247983, 19'd247984, 19'd247985, 19'd247986, 19'd247987, 19'd247988, 19'd247989, 19'd247990, 19'd248600, 19'd248601, 19'd248602, 19'd248603, 19'd248604, 19'd248605, 19'd248606, 19'd248607, 19'd248608, 19'd248609, 19'd248610, 19'd248611, 19'd248612, 19'd248613, 19'd248614, 19'd248615, 19'd248616, 19'd248617, 19'd248618, 19'd248619, 19'd248620, 19'd248621, 19'd248622, 19'd248623, 19'd248624, 19'd248625, 19'd248626, 19'd248627, 19'd248628, 19'd248629, 19'd249239, 19'd249240, 19'd249241, 19'd249242, 19'd249243, 19'd249244, 19'd249245, 19'd249246, 19'd249247, 19'd249248, 19'd249249, 19'd249250, 19'd249251, 19'd249252, 19'd249253, 19'd249254, 19'd249255, 19'd249256, 19'd249257, 19'd249258, 19'd249259, 19'd249260, 19'd249261, 19'd249262, 19'd249263, 19'd249264, 19'd249265, 19'd249266, 19'd249267, 19'd249268, 19'd249878, 19'd249879, 19'd249880, 19'd249881, 19'd249882, 19'd249883, 19'd249884, 19'd249885, 19'd249886, 19'd249887, 19'd249888, 19'd249889, 19'd249890, 19'd249891, 19'd249892, 19'd249893, 19'd249894, 19'd249895, 19'd249896, 19'd249897, 19'd249898, 19'd249899, 19'd249900, 19'd249901, 19'd249902, 19'd249903, 19'd249904, 19'd249905, 19'd249906, 19'd249907, 19'd250517, 19'd250518, 19'd250519, 19'd250520, 19'd250521, 19'd250522, 19'd250523, 19'd250524, 19'd250525, 19'd250526, 19'd250527, 19'd250528, 19'd250529, 19'd250530, 19'd250531, 19'd250532, 19'd250533, 19'd250534, 19'd250535, 19'd250536, 19'd250537, 19'd250538, 19'd250539, 19'd250540, 19'd250541, 19'd250542, 19'd250543, 19'd250544, 19'd250545, 19'd250546, 19'd251156, 19'd251157, 19'd251158, 19'd251159, 19'd251160, 19'd251161, 19'd251162, 19'd251163, 19'd251164, 19'd251165, 19'd251166, 19'd251167, 19'd251168, 19'd251169, 19'd251170, 19'd251171, 19'd251172, 19'd251173, 19'd251174, 19'd251175, 19'd251176, 19'd251177, 19'd251178, 19'd251179, 19'd251180, 19'd251181, 19'd251182, 19'd251183, 19'd251184, 19'd251185, 19'd251795, 19'd251796, 19'd251797, 19'd251798, 19'd251799, 19'd251800, 19'd251801, 19'd251802, 19'd251803, 19'd251804, 19'd251805, 19'd251806, 19'd251807, 19'd251808, 19'd251809, 19'd251810, 19'd251811, 19'd251812, 19'd251813, 19'd251814, 19'd251815, 19'd251816, 19'd251817, 19'd251818, 19'd251819, 19'd251820, 19'd251821, 19'd251822, 19'd251823, 19'd251824, 19'd252434, 19'd252435, 19'd252436, 19'd252437, 19'd252438, 19'd252439, 19'd252440, 19'd252441, 19'd252442, 19'd252443, 19'd252444, 19'd252445, 19'd252446, 19'd252447, 19'd252448, 19'd252449, 19'd252450, 19'd252451, 19'd252452, 19'd252453, 19'd252454, 19'd252455, 19'd252456, 19'd252457, 19'd252458, 19'd252459, 19'd252460, 19'd252461, 19'd252462, 19'd252463, 19'd253073, 19'd253074, 19'd253075, 19'd253076, 19'd253077, 19'd253078, 19'd253079, 19'd253080, 19'd253081, 19'd253082, 19'd253083, 19'd253084, 19'd253085, 19'd253086, 19'd253087, 19'd253088, 19'd253089, 19'd253090, 19'd253091, 19'd253092, 19'd253093, 19'd253094, 19'd253095, 19'd253096, 19'd253097, 19'd253098, 19'd253099, 19'd253100, 19'd253101, 19'd253102, 19'd253712, 19'd253713, 19'd253714, 19'd253715, 19'd253716, 19'd253717, 19'd253718, 19'd253719, 19'd253720, 19'd253721, 19'd253722, 19'd253723, 19'd253724, 19'd253725, 19'd253726, 19'd253727, 19'd253728, 19'd253729, 19'd253730, 19'd253731, 19'd253732, 19'd253733, 19'd253734, 19'd253735, 19'd253736, 19'd253737, 19'd253738, 19'd253739, 19'd253740, 19'd253741, 19'd254351, 19'd254352, 19'd254353, 19'd254354, 19'd254355, 19'd254356, 19'd254357, 19'd254358, 19'd254359, 19'd254360, 19'd254361, 19'd254362, 19'd254363, 19'd254364, 19'd254365, 19'd254366, 19'd254367, 19'd254368, 19'd254369, 19'd254370, 19'd254371, 19'd254372, 19'd254373, 19'd254374, 19'd254375, 19'd254376, 19'd254377, 19'd254378, 19'd254379, 19'd254380, 19'd254990, 19'd254991, 19'd254992, 19'd254993, 19'd254994, 19'd254995, 19'd254996, 19'd254997, 19'd254998, 19'd254999, 19'd255000, 19'd255001, 19'd255002, 19'd255003, 19'd255004, 19'd255005, 19'd255006, 19'd255007, 19'd255008, 19'd255009, 19'd255010, 19'd255011, 19'd255012, 19'd255013, 19'd255014, 19'd255015, 19'd255016, 19'd255017, 19'd255018, 19'd255019, 19'd255629, 19'd255630, 19'd255631, 19'd255632, 19'd255633, 19'd255634, 19'd255635, 19'd255636, 19'd255637, 19'd255638, 19'd255639, 19'd255640, 19'd255641, 19'd255642, 19'd255643, 19'd255644, 19'd255645, 19'd255646, 19'd255647, 19'd255648, 19'd255649, 19'd255650, 19'd255651, 19'd255652, 19'd255653, 19'd255654, 19'd255655, 19'd255656, 19'd255657, 19'd255658, 19'd210899, 19'd210900, 19'd210901, 19'd210902, 19'd210903, 19'd210904, 19'd210905, 19'd210906, 19'd210907, 19'd210908, 19'd210909, 19'd210910, 19'd210911, 19'd210912, 19'd210913, 19'd210914, 19'd210915, 19'd210916, 19'd210917, 19'd210918, 19'd210919, 19'd210920, 19'd210921, 19'd210922, 19'd210923, 19'd210924, 19'd210925, 19'd210926, 19'd210927, 19'd210928, 19'd211538, 19'd211539, 19'd211540, 19'd211541, 19'd211542, 19'd211543, 19'd211544, 19'd211545, 19'd211546, 19'd211547, 19'd211548, 19'd211549, 19'd211550, 19'd211551, 19'd211552, 19'd211553, 19'd211554, 19'd211555, 19'd211556, 19'd211557, 19'd211558, 19'd211559, 19'd211560, 19'd211561, 19'd211562, 19'd211563, 19'd211564, 19'd211565, 19'd211566, 19'd211567, 19'd212177, 19'd212178, 19'd212179, 19'd212180, 19'd212181, 19'd212182, 19'd212183, 19'd212184, 19'd212185, 19'd212186, 19'd212187, 19'd212188, 19'd212189, 19'd212190, 19'd212191, 19'd212192, 19'd212193, 19'd212194, 19'd212195, 19'd212196, 19'd212197, 19'd212198, 19'd212199, 19'd212200, 19'd212201, 19'd212202, 19'd212203, 19'd212204, 19'd212205, 19'd212206, 19'd212816, 19'd212817, 19'd212818, 19'd212819, 19'd212820, 19'd212821, 19'd212822, 19'd212823, 19'd212824, 19'd212825, 19'd212826, 19'd212827, 19'd212828, 19'd212829, 19'd212830, 19'd212831, 19'd212832, 19'd212833, 19'd212834, 19'd212835, 19'd212836, 19'd212837, 19'd212838, 19'd212839, 19'd212840, 19'd212841, 19'd212842, 19'd212843, 19'd212844, 19'd212845, 19'd213455, 19'd213456, 19'd213457, 19'd213458, 19'd213459, 19'd213460, 19'd213461, 19'd213462, 19'd213463, 19'd213464, 19'd213465, 19'd213466, 19'd213467, 19'd213468, 19'd213469, 19'd213470, 19'd213471, 19'd213472, 19'd213473, 19'd213474, 19'd213475, 19'd213476, 19'd213477, 19'd213478, 19'd213479, 19'd213480, 19'd213481, 19'd213482, 19'd213483, 19'd213484, 19'd214094, 19'd214095, 19'd214096, 19'd214097, 19'd214098, 19'd214099, 19'd214100, 19'd214101, 19'd214102, 19'd214103, 19'd214104, 19'd214105, 19'd214106, 19'd214107, 19'd214108, 19'd214109, 19'd214110, 19'd214111, 19'd214112, 19'd214113, 19'd214114, 19'd214115, 19'd214116, 19'd214117, 19'd214118, 19'd214119, 19'd214120, 19'd214121, 19'd214122, 19'd214123, 19'd214733, 19'd214734, 19'd214735, 19'd214736, 19'd214737, 19'd214738, 19'd214739, 19'd214740, 19'd214741, 19'd214742, 19'd214743, 19'd214744, 19'd214745, 19'd214746, 19'd214747, 19'd214748, 19'd214749, 19'd214750, 19'd214751, 19'd214752, 19'd214753, 19'd214754, 19'd214755, 19'd214756, 19'd214757, 19'd214758, 19'd214759, 19'd214760, 19'd214761, 19'd214762, 19'd215372, 19'd215373, 19'd215374, 19'd215375, 19'd215376, 19'd215377, 19'd215378, 19'd215379, 19'd215380, 19'd215381, 19'd215382, 19'd215383, 19'd215384, 19'd215385, 19'd215386, 19'd215387, 19'd215388, 19'd215389, 19'd215390, 19'd215391, 19'd215392, 19'd215393, 19'd215394, 19'd215395, 19'd215396, 19'd215397, 19'd215398, 19'd215399, 19'd215400, 19'd215401, 19'd216011, 19'd216012, 19'd216013, 19'd216014, 19'd216015, 19'd216016, 19'd216017, 19'd216018, 19'd216019, 19'd216020, 19'd216021, 19'd216022, 19'd216023, 19'd216024, 19'd216025, 19'd216026, 19'd216027, 19'd216028, 19'd216029, 19'd216030, 19'd216031, 19'd216032, 19'd216033, 19'd216034, 19'd216035, 19'd216036, 19'd216037, 19'd216038, 19'd216039, 19'd216040, 19'd216650, 19'd216651, 19'd216652, 19'd216653, 19'd216654, 19'd216655, 19'd216656, 19'd216657, 19'd216658, 19'd216659, 19'd216660, 19'd216661, 19'd216662, 19'd216663, 19'd216664, 19'd216665, 19'd216666, 19'd216667, 19'd216668, 19'd216669, 19'd216670, 19'd216671, 19'd216672, 19'd216673, 19'd216674, 19'd216675, 19'd216676, 19'd216677, 19'd216678, 19'd216679, 19'd217289, 19'd217290, 19'd217291, 19'd217292, 19'd217293, 19'd217294, 19'd217295, 19'd217296, 19'd217297, 19'd217298, 19'd217299, 19'd217300, 19'd217301, 19'd217302, 19'd217303, 19'd217304, 19'd217305, 19'd217306, 19'd217307, 19'd217308, 19'd217309, 19'd217310, 19'd217311, 19'd217312, 19'd217313, 19'd217314, 19'd217315, 19'd217316, 19'd217317, 19'd217318, 19'd217928, 19'd217929, 19'd217930, 19'd217931, 19'd217932, 19'd217933, 19'd217934, 19'd217935, 19'd217936, 19'd217937, 19'd217938, 19'd217939, 19'd217940, 19'd217941, 19'd217942, 19'd217943, 19'd217944, 19'd217945, 19'd217946, 19'd217947, 19'd217948, 19'd217949, 19'd217950, 19'd217951, 19'd217952, 19'd217953, 19'd217954, 19'd217955, 19'd217956, 19'd217957, 19'd218567, 19'd218568, 19'd218569, 19'd218570, 19'd218571, 19'd218572, 19'd218573, 19'd218574, 19'd218575, 19'd218576, 19'd218577, 19'd218578, 19'd218579, 19'd218580, 19'd218581, 19'd218582, 19'd218583, 19'd218584, 19'd218585, 19'd218586, 19'd218587, 19'd218588, 19'd218589, 19'd218590, 19'd218591, 19'd218592, 19'd218593, 19'd218594, 19'd218595, 19'd218596, 19'd219206, 19'd219207, 19'd219208, 19'd219209, 19'd219210, 19'd219211, 19'd219212, 19'd219213, 19'd219214, 19'd219215, 19'd219216, 19'd219217, 19'd219218, 19'd219219, 19'd219220, 19'd219221, 19'd219222, 19'd219223, 19'd219224, 19'd219225, 19'd219226, 19'd219227, 19'd219228, 19'd219229, 19'd219230, 19'd219231, 19'd219232, 19'd219233, 19'd219234, 19'd219235, 19'd219845, 19'd219846, 19'd219847, 19'd219848, 19'd219849, 19'd219850, 19'd219851, 19'd219852, 19'd219853, 19'd219854, 19'd219855, 19'd219856, 19'd219857, 19'd219858, 19'd219859, 19'd219860, 19'd219861, 19'd219862, 19'd219863, 19'd219864, 19'd219865, 19'd219866, 19'd219867, 19'd219868, 19'd219869, 19'd219870, 19'd219871, 19'd219872, 19'd219873, 19'd219874, 19'd220484, 19'd220485, 19'd220486, 19'd220487, 19'd220488, 19'd220489, 19'd220490, 19'd220491, 19'd220492, 19'd220493, 19'd220494, 19'd220495, 19'd220496, 19'd220497, 19'd220498, 19'd220499, 19'd220500, 19'd220501, 19'd220502, 19'd220503, 19'd220504, 19'd220505, 19'd220506, 19'd220507, 19'd220508, 19'd220509, 19'd220510, 19'd220511, 19'd220512, 19'd220513, 19'd221123, 19'd221124, 19'd221125, 19'd221126, 19'd221127, 19'd221128, 19'd221129, 19'd221130, 19'd221131, 19'd221132, 19'd221133, 19'd221134, 19'd221135, 19'd221136, 19'd221137, 19'd221138, 19'd221139, 19'd221140, 19'd221141, 19'd221142, 19'd221143, 19'd221144, 19'd221145, 19'd221146, 19'd221147, 19'd221148, 19'd221149, 19'd221150, 19'd221151, 19'd221152, 19'd221762, 19'd221763, 19'd221764, 19'd221765, 19'd221766, 19'd221767, 19'd221768, 19'd221769, 19'd221770, 19'd221771, 19'd221772, 19'd221773, 19'd221774, 19'd221775, 19'd221776, 19'd221777, 19'd221778, 19'd221779, 19'd221780, 19'd221781, 19'd221782, 19'd221783, 19'd221784, 19'd221785, 19'd221786, 19'd221787, 19'd221788, 19'd221789, 19'd221790, 19'd221791, 19'd222401, 19'd222402, 19'd222403, 19'd222404, 19'd222405, 19'd222406, 19'd222407, 19'd222408, 19'd222409, 19'd222410, 19'd222411, 19'd222412, 19'd222413, 19'd222414, 19'd222415, 19'd222416, 19'd222417, 19'd222418, 19'd222419, 19'd222420, 19'd222421, 19'd222422, 19'd222423, 19'd222424, 19'd222425, 19'd222426, 19'd222427, 19'd222428, 19'd222429, 19'd222430, 19'd223040, 19'd223041, 19'd223042, 19'd223043, 19'd223044, 19'd223045, 19'd223046, 19'd223047, 19'd223048, 19'd223049, 19'd223050, 19'd223051, 19'd223052, 19'd223053, 19'd223054, 19'd223055, 19'd223056, 19'd223057, 19'd223058, 19'd223059, 19'd223060, 19'd223061, 19'd223062, 19'd223063, 19'd223064, 19'd223065, 19'd223066, 19'd223067, 19'd223068, 19'd223069, 19'd223679, 19'd223680, 19'd223681, 19'd223682, 19'd223683, 19'd223684, 19'd223685, 19'd223686, 19'd223687, 19'd223688, 19'd223689, 19'd223690, 19'd223691, 19'd223692, 19'd223693, 19'd223694, 19'd223695, 19'd223696, 19'd223697, 19'd223698, 19'd223699, 19'd223700, 19'd223701, 19'd223702, 19'd223703, 19'd223704, 19'd223705, 19'd223706, 19'd223707, 19'd223708, 19'd178949, 19'd178950, 19'd178951, 19'd178952, 19'd178953, 19'd178954, 19'd178955, 19'd178956, 19'd178957, 19'd178958, 19'd178959, 19'd178960, 19'd178961, 19'd178962, 19'd178963, 19'd178964, 19'd178965, 19'd178966, 19'd178967, 19'd178968, 19'd178969, 19'd178970, 19'd178971, 19'd178972, 19'd178973, 19'd178974, 19'd178975, 19'd178976, 19'd178977, 19'd178978, 19'd179588, 19'd179589, 19'd179590, 19'd179591, 19'd179592, 19'd179593, 19'd179594, 19'd179595, 19'd179596, 19'd179597, 19'd179598, 19'd179599, 19'd179600, 19'd179601, 19'd179602, 19'd179603, 19'd179604, 19'd179605, 19'd179606, 19'd179607, 19'd179608, 19'd179609, 19'd179610, 19'd179611, 19'd179612, 19'd179613, 19'd179614, 19'd179615, 19'd179616, 19'd179617, 19'd180227, 19'd180228, 19'd180229, 19'd180230, 19'd180231, 19'd180232, 19'd180233, 19'd180234, 19'd180235, 19'd180236, 19'd180237, 19'd180238, 19'd180239, 19'd180240, 19'd180241, 19'd180242, 19'd180243, 19'd180244, 19'd180245, 19'd180246, 19'd180247, 19'd180248, 19'd180249, 19'd180250, 19'd180251, 19'd180252, 19'd180253, 19'd180254, 19'd180255, 19'd180256, 19'd180866, 19'd180867, 19'd180868, 19'd180869, 19'd180870, 19'd180871, 19'd180872, 19'd180873, 19'd180874, 19'd180875, 19'd180876, 19'd180877, 19'd180878, 19'd180879, 19'd180880, 19'd180881, 19'd180882, 19'd180883, 19'd180884, 19'd180885, 19'd180886, 19'd180887, 19'd180888, 19'd180889, 19'd180890, 19'd180891, 19'd180892, 19'd180893, 19'd180894, 19'd180895, 19'd181505, 19'd181506, 19'd181507, 19'd181508, 19'd181509, 19'd181510, 19'd181511, 19'd181512, 19'd181513, 19'd181514, 19'd181515, 19'd181516, 19'd181517, 19'd181518, 19'd181519, 19'd181520, 19'd181521, 19'd181522, 19'd181523, 19'd181524, 19'd181525, 19'd181526, 19'd181527, 19'd181528, 19'd181529, 19'd181530, 19'd181531, 19'd181532, 19'd181533, 19'd181534, 19'd182144, 19'd182145, 19'd182146, 19'd182147, 19'd182148, 19'd182149, 19'd182150, 19'd182151, 19'd182152, 19'd182153, 19'd182154, 19'd182155, 19'd182156, 19'd182157, 19'd182158, 19'd182159, 19'd182160, 19'd182161, 19'd182162, 19'd182163, 19'd182164, 19'd182165, 19'd182166, 19'd182167, 19'd182168, 19'd182169, 19'd182170, 19'd182171, 19'd182172, 19'd182173, 19'd182783, 19'd182784, 19'd182785, 19'd182786, 19'd182787, 19'd182788, 19'd182789, 19'd182790, 19'd182791, 19'd182792, 19'd182793, 19'd182794, 19'd182795, 19'd182796, 19'd182797, 19'd182798, 19'd182799, 19'd182800, 19'd182801, 19'd182802, 19'd182803, 19'd182804, 19'd182805, 19'd182806, 19'd182807, 19'd182808, 19'd182809, 19'd182810, 19'd182811, 19'd182812, 19'd183422, 19'd183423, 19'd183424, 19'd183425, 19'd183426, 19'd183427, 19'd183428, 19'd183429, 19'd183430, 19'd183431, 19'd183432, 19'd183433, 19'd183434, 19'd183435, 19'd183436, 19'd183437, 19'd183438, 19'd183439, 19'd183440, 19'd183441, 19'd183442, 19'd183443, 19'd183444, 19'd183445, 19'd183446, 19'd183447, 19'd183448, 19'd183449, 19'd183450, 19'd183451, 19'd184061, 19'd184062, 19'd184063, 19'd184064, 19'd184065, 19'd184066, 19'd184067, 19'd184068, 19'd184069, 19'd184070, 19'd184071, 19'd184072, 19'd184073, 19'd184074, 19'd184075, 19'd184076, 19'd184077, 19'd184078, 19'd184079, 19'd184080, 19'd184081, 19'd184082, 19'd184083, 19'd184084, 19'd184085, 19'd184086, 19'd184087, 19'd184088, 19'd184089, 19'd184090, 19'd184700, 19'd184701, 19'd184702, 19'd184703, 19'd184704, 19'd184705, 19'd184706, 19'd184707, 19'd184708, 19'd184709, 19'd184710, 19'd184711, 19'd184712, 19'd184713, 19'd184714, 19'd184715, 19'd184716, 19'd184717, 19'd184718, 19'd184719, 19'd184720, 19'd184721, 19'd184722, 19'd184723, 19'd184724, 19'd184725, 19'd184726, 19'd184727, 19'd184728, 19'd184729, 19'd185339, 19'd185340, 19'd185341, 19'd185342, 19'd185343, 19'd185344, 19'd185345, 19'd185346, 19'd185347, 19'd185348, 19'd185349, 19'd185350, 19'd185351, 19'd185352, 19'd185353, 19'd185354, 19'd185355, 19'd185356, 19'd185357, 19'd185358, 19'd185359, 19'd185360, 19'd185361, 19'd185362, 19'd185363, 19'd185364, 19'd185365, 19'd185366, 19'd185367, 19'd185368, 19'd185978, 19'd185979, 19'd185980, 19'd185981, 19'd185982, 19'd185983, 19'd185984, 19'd185985, 19'd185986, 19'd185987, 19'd185988, 19'd185989, 19'd185990, 19'd185991, 19'd185992, 19'd185993, 19'd185994, 19'd185995, 19'd185996, 19'd185997, 19'd185998, 19'd185999, 19'd186000, 19'd186001, 19'd186002, 19'd186003, 19'd186004, 19'd186005, 19'd186006, 19'd186007, 19'd186617, 19'd186618, 19'd186619, 19'd186620, 19'd186621, 19'd186622, 19'd186623, 19'd186624, 19'd186625, 19'd186626, 19'd186627, 19'd186628, 19'd186629, 19'd186630, 19'd186631, 19'd186632, 19'd186633, 19'd186634, 19'd186635, 19'd186636, 19'd186637, 19'd186638, 19'd186639, 19'd186640, 19'd186641, 19'd186642, 19'd186643, 19'd186644, 19'd186645, 19'd186646, 19'd187256, 19'd187257, 19'd187258, 19'd187259, 19'd187260, 19'd187261, 19'd187262, 19'd187263, 19'd187264, 19'd187265, 19'd187266, 19'd187267, 19'd187268, 19'd187269, 19'd187270, 19'd187271, 19'd187272, 19'd187273, 19'd187274, 19'd187275, 19'd187276, 19'd187277, 19'd187278, 19'd187279, 19'd187280, 19'd187281, 19'd187282, 19'd187283, 19'd187284, 19'd187285, 19'd187895, 19'd187896, 19'd187897, 19'd187898, 19'd187899, 19'd187900, 19'd187901, 19'd187902, 19'd187903, 19'd187904, 19'd187905, 19'd187906, 19'd187907, 19'd187908, 19'd187909, 19'd187910, 19'd187911, 19'd187912, 19'd187913, 19'd187914, 19'd187915, 19'd187916, 19'd187917, 19'd187918, 19'd187919, 19'd187920, 19'd187921, 19'd187922, 19'd187923, 19'd187924, 19'd188534, 19'd188535, 19'd188536, 19'd188537, 19'd188538, 19'd188539, 19'd188540, 19'd188541, 19'd188542, 19'd188543, 19'd188544, 19'd188545, 19'd188546, 19'd188547, 19'd188548, 19'd188549, 19'd188550, 19'd188551, 19'd188552, 19'd188553, 19'd188554, 19'd188555, 19'd188556, 19'd188557, 19'd188558, 19'd188559, 19'd188560, 19'd188561, 19'd188562, 19'd188563, 19'd189173, 19'd189174, 19'd189175, 19'd189176, 19'd189177, 19'd189178, 19'd189179, 19'd189180, 19'd189181, 19'd189182, 19'd189183, 19'd189184, 19'd189185, 19'd189186, 19'd189187, 19'd189188, 19'd189189, 19'd189190, 19'd189191, 19'd189192, 19'd189193, 19'd189194, 19'd189195, 19'd189196, 19'd189197, 19'd189198, 19'd189199, 19'd189200, 19'd189201, 19'd189202, 19'd189812, 19'd189813, 19'd189814, 19'd189815, 19'd189816, 19'd189817, 19'd189818, 19'd189819, 19'd189820, 19'd189821, 19'd189822, 19'd189823, 19'd189824, 19'd189825, 19'd189826, 19'd189827, 19'd189828, 19'd189829, 19'd189830, 19'd189831, 19'd189832, 19'd189833, 19'd189834, 19'd189835, 19'd189836, 19'd189837, 19'd189838, 19'd189839, 19'd189840, 19'd189841, 19'd190451, 19'd190452, 19'd190453, 19'd190454, 19'd190455, 19'd190456, 19'd190457, 19'd190458, 19'd190459, 19'd190460, 19'd190461, 19'd190462, 19'd190463, 19'd190464, 19'd190465, 19'd190466, 19'd190467, 19'd190468, 19'd190469, 19'd190470, 19'd190471, 19'd190472, 19'd190473, 19'd190474, 19'd190475, 19'd190476, 19'd190477, 19'd190478, 19'd190479, 19'd190480, 19'd191090, 19'd191091, 19'd191092, 19'd191093, 19'd191094, 19'd191095, 19'd191096, 19'd191097, 19'd191098, 19'd191099, 19'd191100, 19'd191101, 19'd191102, 19'd191103, 19'd191104, 19'd191105, 19'd191106, 19'd191107, 19'd191108, 19'd191109, 19'd191110, 19'd191111, 19'd191112, 19'd191113, 19'd191114, 19'd191115, 19'd191116, 19'd191117, 19'd191118, 19'd191119, 19'd191729, 19'd191730, 19'd191731, 19'd191732, 19'd191733, 19'd191734, 19'd191735, 19'd191736, 19'd191737, 19'd191738, 19'd191739, 19'd191740, 19'd191741, 19'd191742, 19'd191743, 19'd191744, 19'd191745, 19'd191746, 19'd191747, 19'd191748, 19'd191749, 19'd191750, 19'd191751, 19'd191752, 19'd191753, 19'd191754, 19'd191755, 19'd191756, 19'd191757, 19'd191758, 19'd146999, 19'd147000, 19'd147001, 19'd147002, 19'd147003, 19'd147004, 19'd147005, 19'd147006, 19'd147007, 19'd147008, 19'd147009, 19'd147010, 19'd147011, 19'd147012, 19'd147013, 19'd147014, 19'd147015, 19'd147016, 19'd147017, 19'd147018, 19'd147019, 19'd147020, 19'd147021, 19'd147022, 19'd147023, 19'd147024, 19'd147025, 19'd147026, 19'd147027, 19'd147028, 19'd147638, 19'd147639, 19'd147640, 19'd147641, 19'd147642, 19'd147643, 19'd147644, 19'd147645, 19'd147646, 19'd147647, 19'd147648, 19'd147649, 19'd147650, 19'd147651, 19'd147652, 19'd147653, 19'd147654, 19'd147655, 19'd147656, 19'd147657, 19'd147658, 19'd147659, 19'd147660, 19'd147661, 19'd147662, 19'd147663, 19'd147664, 19'd147665, 19'd147666, 19'd147667, 19'd148277, 19'd148278, 19'd148279, 19'd148280, 19'd148281, 19'd148282, 19'd148283, 19'd148284, 19'd148285, 19'd148286, 19'd148287, 19'd148288, 19'd148289, 19'd148290, 19'd148291, 19'd148292, 19'd148293, 19'd148294, 19'd148295, 19'd148296, 19'd148297, 19'd148298, 19'd148299, 19'd148300, 19'd148301, 19'd148302, 19'd148303, 19'd148304, 19'd148305, 19'd148306, 19'd148916, 19'd148917, 19'd148918, 19'd148919, 19'd148920, 19'd148921, 19'd148922, 19'd148923, 19'd148924, 19'd148925, 19'd148926, 19'd148927, 19'd148928, 19'd148929, 19'd148930, 19'd148931, 19'd148932, 19'd148933, 19'd148934, 19'd148935, 19'd148936, 19'd148937, 19'd148938, 19'd148939, 19'd148940, 19'd148941, 19'd148942, 19'd148943, 19'd148944, 19'd148945, 19'd149555, 19'd149556, 19'd149557, 19'd149558, 19'd149559, 19'd149560, 19'd149561, 19'd149562, 19'd149563, 19'd149564, 19'd149565, 19'd149566, 19'd149567, 19'd149568, 19'd149569, 19'd149570, 19'd149571, 19'd149572, 19'd149573, 19'd149574, 19'd149575, 19'd149576, 19'd149577, 19'd149578, 19'd149579, 19'd149580, 19'd149581, 19'd149582, 19'd149583, 19'd149584, 19'd150194, 19'd150195, 19'd150196, 19'd150197, 19'd150198, 19'd150199, 19'd150200, 19'd150201, 19'd150202, 19'd150203, 19'd150204, 19'd150205, 19'd150206, 19'd150207, 19'd150208, 19'd150209, 19'd150210, 19'd150211, 19'd150212, 19'd150213, 19'd150214, 19'd150215, 19'd150216, 19'd150217, 19'd150218, 19'd150219, 19'd150220, 19'd150221, 19'd150222, 19'd150223, 19'd150833, 19'd150834, 19'd150835, 19'd150836, 19'd150837, 19'd150838, 19'd150839, 19'd150840, 19'd150841, 19'd150842, 19'd150843, 19'd150844, 19'd150845, 19'd150846, 19'd150847, 19'd150848, 19'd150849, 19'd150850, 19'd150851, 19'd150852, 19'd150853, 19'd150854, 19'd150855, 19'd150856, 19'd150857, 19'd150858, 19'd150859, 19'd150860, 19'd150861, 19'd150862, 19'd151472, 19'd151473, 19'd151474, 19'd151475, 19'd151476, 19'd151477, 19'd151478, 19'd151479, 19'd151480, 19'd151481, 19'd151482, 19'd151483, 19'd151484, 19'd151485, 19'd151486, 19'd151487, 19'd151488, 19'd151489, 19'd151490, 19'd151491, 19'd151492, 19'd151493, 19'd151494, 19'd151495, 19'd151496, 19'd151497, 19'd151498, 19'd151499, 19'd151500, 19'd151501, 19'd152111, 19'd152112, 19'd152113, 19'd152114, 19'd152115, 19'd152116, 19'd152117, 19'd152118, 19'd152119, 19'd152120, 19'd152121, 19'd152122, 19'd152123, 19'd152124, 19'd152125, 19'd152126, 19'd152127, 19'd152128, 19'd152129, 19'd152130, 19'd152131, 19'd152132, 19'd152133, 19'd152134, 19'd152135, 19'd152136, 19'd152137, 19'd152138, 19'd152139, 19'd152140, 19'd152750, 19'd152751, 19'd152752, 19'd152753, 19'd152754, 19'd152755, 19'd152756, 19'd152757, 19'd152758, 19'd152759, 19'd152760, 19'd152761, 19'd152762, 19'd152763, 19'd152764, 19'd152765, 19'd152766, 19'd152767, 19'd152768, 19'd152769, 19'd152770, 19'd152771, 19'd152772, 19'd152773, 19'd152774, 19'd152775, 19'd152776, 19'd152777, 19'd152778, 19'd152779, 19'd153389, 19'd153390, 19'd153391, 19'd153392, 19'd153393, 19'd153394, 19'd153395, 19'd153396, 19'd153397, 19'd153398, 19'd153399, 19'd153400, 19'd153401, 19'd153402, 19'd153403, 19'd153404, 19'd153405, 19'd153406, 19'd153407, 19'd153408, 19'd153409, 19'd153410, 19'd153411, 19'd153412, 19'd153413, 19'd153414, 19'd153415, 19'd153416, 19'd153417, 19'd153418, 19'd154028, 19'd154029, 19'd154030, 19'd154031, 19'd154032, 19'd154033, 19'd154034, 19'd154035, 19'd154036, 19'd154037, 19'd154038, 19'd154039, 19'd154040, 19'd154041, 19'd154042, 19'd154043, 19'd154044, 19'd154045, 19'd154046, 19'd154047, 19'd154048, 19'd154049, 19'd154050, 19'd154051, 19'd154052, 19'd154053, 19'd154054, 19'd154055, 19'd154056, 19'd154057, 19'd154667, 19'd154668, 19'd154669, 19'd154670, 19'd154671, 19'd154672, 19'd154673, 19'd154674, 19'd154675, 19'd154676, 19'd154677, 19'd154678, 19'd154679, 19'd154680, 19'd154681, 19'd154682, 19'd154683, 19'd154684, 19'd154685, 19'd154686, 19'd154687, 19'd154688, 19'd154689, 19'd154690, 19'd154691, 19'd154692, 19'd154693, 19'd154694, 19'd154695, 19'd154696, 19'd155306, 19'd155307, 19'd155308, 19'd155309, 19'd155310, 19'd155311, 19'd155312, 19'd155313, 19'd155314, 19'd155315, 19'd155316, 19'd155317, 19'd155318, 19'd155319, 19'd155320, 19'd155321, 19'd155322, 19'd155323, 19'd155324, 19'd155325, 19'd155326, 19'd155327, 19'd155328, 19'd155329, 19'd155330, 19'd155331, 19'd155332, 19'd155333, 19'd155334, 19'd155335, 19'd155945, 19'd155946, 19'd155947, 19'd155948, 19'd155949, 19'd155950, 19'd155951, 19'd155952, 19'd155953, 19'd155954, 19'd155955, 19'd155956, 19'd155957, 19'd155958, 19'd155959, 19'd155960, 19'd155961, 19'd155962, 19'd155963, 19'd155964, 19'd155965, 19'd155966, 19'd155967, 19'd155968, 19'd155969, 19'd155970, 19'd155971, 19'd155972, 19'd155973, 19'd155974, 19'd156584, 19'd156585, 19'd156586, 19'd156587, 19'd156588, 19'd156589, 19'd156590, 19'd156591, 19'd156592, 19'd156593, 19'd156594, 19'd156595, 19'd156596, 19'd156597, 19'd156598, 19'd156599, 19'd156600, 19'd156601, 19'd156602, 19'd156603, 19'd156604, 19'd156605, 19'd156606, 19'd156607, 19'd156608, 19'd156609, 19'd156610, 19'd156611, 19'd156612, 19'd156613, 19'd157223, 19'd157224, 19'd157225, 19'd157226, 19'd157227, 19'd157228, 19'd157229, 19'd157230, 19'd157231, 19'd157232, 19'd157233, 19'd157234, 19'd157235, 19'd157236, 19'd157237, 19'd157238, 19'd157239, 19'd157240, 19'd157241, 19'd157242, 19'd157243, 19'd157244, 19'd157245, 19'd157246, 19'd157247, 19'd157248, 19'd157249, 19'd157250, 19'd157251, 19'd157252, 19'd157862, 19'd157863, 19'd157864, 19'd157865, 19'd157866, 19'd157867, 19'd157868, 19'd157869, 19'd157870, 19'd157871, 19'd157872, 19'd157873, 19'd157874, 19'd157875, 19'd157876, 19'd157877, 19'd157878, 19'd157879, 19'd157880, 19'd157881, 19'd157882, 19'd157883, 19'd157884, 19'd157885, 19'd157886, 19'd157887, 19'd157888, 19'd157889, 19'd157890, 19'd157891, 19'd158501, 19'd158502, 19'd158503, 19'd158504, 19'd158505, 19'd158506, 19'd158507, 19'd158508, 19'd158509, 19'd158510, 19'd158511, 19'd158512, 19'd158513, 19'd158514, 19'd158515, 19'd158516, 19'd158517, 19'd158518, 19'd158519, 19'd158520, 19'd158521, 19'd158522, 19'd158523, 19'd158524, 19'd158525, 19'd158526, 19'd158527, 19'd158528, 19'd158529, 19'd158530, 19'd159140, 19'd159141, 19'd159142, 19'd159143, 19'd159144, 19'd159145, 19'd159146, 19'd159147, 19'd159148, 19'd159149, 19'd159150, 19'd159151, 19'd159152, 19'd159153, 19'd159154, 19'd159155, 19'd159156, 19'd159157, 19'd159158, 19'd159159, 19'd159160, 19'd159161, 19'd159162, 19'd159163, 19'd159164, 19'd159165, 19'd159166, 19'd159167, 19'd159168, 19'd159169, 19'd159779, 19'd159780, 19'd159781, 19'd159782, 19'd159783, 19'd159784, 19'd159785, 19'd159786, 19'd159787, 19'd159788, 19'd159789, 19'd159790, 19'd159791, 19'd159792, 19'd159793, 19'd159794, 19'd159795, 19'd159796, 19'd159797, 19'd159798, 19'd159799, 19'd159800, 19'd159801, 19'd159802, 19'd159803, 19'd159804, 19'd159805, 19'd159806, 19'd159807, 19'd159808, 19'd115049, 19'd115050, 19'd115051, 19'd115052, 19'd115053, 19'd115054, 19'd115055, 19'd115056, 19'd115057, 19'd115058, 19'd115059, 19'd115060, 19'd115061, 19'd115062, 19'd115063, 19'd115064, 19'd115065, 19'd115066, 19'd115067, 19'd115068, 19'd115069, 19'd115070, 19'd115071, 19'd115072, 19'd115073, 19'd115074, 19'd115075, 19'd115076, 19'd115077, 19'd115078, 19'd115688, 19'd115689, 19'd115690, 19'd115691, 19'd115692, 19'd115693, 19'd115694, 19'd115695, 19'd115696, 19'd115697, 19'd115698, 19'd115699, 19'd115700, 19'd115701, 19'd115702, 19'd115703, 19'd115704, 19'd115705, 19'd115706, 19'd115707, 19'd115708, 19'd115709, 19'd115710, 19'd115711, 19'd115712, 19'd115713, 19'd115714, 19'd115715, 19'd115716, 19'd115717, 19'd116327, 19'd116328, 19'd116329, 19'd116330, 19'd116331, 19'd116332, 19'd116333, 19'd116334, 19'd116335, 19'd116336, 19'd116337, 19'd116338, 19'd116339, 19'd116340, 19'd116341, 19'd116342, 19'd116343, 19'd116344, 19'd116345, 19'd116346, 19'd116347, 19'd116348, 19'd116349, 19'd116350, 19'd116351, 19'd116352, 19'd116353, 19'd116354, 19'd116355, 19'd116356, 19'd116966, 19'd116967, 19'd116968, 19'd116969, 19'd116970, 19'd116971, 19'd116972, 19'd116973, 19'd116974, 19'd116975, 19'd116976, 19'd116977, 19'd116978, 19'd116979, 19'd116980, 19'd116981, 19'd116982, 19'd116983, 19'd116984, 19'd116985, 19'd116986, 19'd116987, 19'd116988, 19'd116989, 19'd116990, 19'd116991, 19'd116992, 19'd116993, 19'd116994, 19'd116995, 19'd117605, 19'd117606, 19'd117607, 19'd117608, 19'd117609, 19'd117610, 19'd117611, 19'd117612, 19'd117613, 19'd117614, 19'd117615, 19'd117616, 19'd117617, 19'd117618, 19'd117619, 19'd117620, 19'd117621, 19'd117622, 19'd117623, 19'd117624, 19'd117625, 19'd117626, 19'd117627, 19'd117628, 19'd117629, 19'd117630, 19'd117631, 19'd117632, 19'd117633, 19'd117634, 19'd118244, 19'd118245, 19'd118246, 19'd118247, 19'd118248, 19'd118249, 19'd118250, 19'd118251, 19'd118252, 19'd118253, 19'd118254, 19'd118255, 19'd118256, 19'd118257, 19'd118258, 19'd118259, 19'd118260, 19'd118261, 19'd118262, 19'd118263, 19'd118264, 19'd118265, 19'd118266, 19'd118267, 19'd118268, 19'd118269, 19'd118270, 19'd118271, 19'd118272, 19'd118273, 19'd118883, 19'd118884, 19'd118885, 19'd118886, 19'd118887, 19'd118888, 19'd118889, 19'd118890, 19'd118891, 19'd118892, 19'd118893, 19'd118894, 19'd118895, 19'd118896, 19'd118897, 19'd118898, 19'd118899, 19'd118900, 19'd118901, 19'd118902, 19'd118903, 19'd118904, 19'd118905, 19'd118906, 19'd118907, 19'd118908, 19'd118909, 19'd118910, 19'd118911, 19'd118912, 19'd119522, 19'd119523, 19'd119524, 19'd119525, 19'd119526, 19'd119527, 19'd119528, 19'd119529, 19'd119530, 19'd119531, 19'd119532, 19'd119533, 19'd119534, 19'd119535, 19'd119536, 19'd119537, 19'd119538, 19'd119539, 19'd119540, 19'd119541, 19'd119542, 19'd119543, 19'd119544, 19'd119545, 19'd119546, 19'd119547, 19'd119548, 19'd119549, 19'd119550, 19'd119551, 19'd120161, 19'd120162, 19'd120163, 19'd120164, 19'd120165, 19'd120166, 19'd120167, 19'd120168, 19'd120169, 19'd120170, 19'd120171, 19'd120172, 19'd120173, 19'd120174, 19'd120175, 19'd120176, 19'd120177, 19'd120178, 19'd120179, 19'd120180, 19'd120181, 19'd120182, 19'd120183, 19'd120184, 19'd120185, 19'd120186, 19'd120187, 19'd120188, 19'd120189, 19'd120190, 19'd120800, 19'd120801, 19'd120802, 19'd120803, 19'd120804, 19'd120805, 19'd120806, 19'd120807, 19'd120808, 19'd120809, 19'd120810, 19'd120811, 19'd120812, 19'd120813, 19'd120814, 19'd120815, 19'd120816, 19'd120817, 19'd120818, 19'd120819, 19'd120820, 19'd120821, 19'd120822, 19'd120823, 19'd120824, 19'd120825, 19'd120826, 19'd120827, 19'd120828, 19'd120829, 19'd121439, 19'd121440, 19'd121441, 19'd121442, 19'd121443, 19'd121444, 19'd121445, 19'd121446, 19'd121447, 19'd121448, 19'd121449, 19'd121450, 19'd121451, 19'd121452, 19'd121453, 19'd121454, 19'd121455, 19'd121456, 19'd121457, 19'd121458, 19'd121459, 19'd121460, 19'd121461, 19'd121462, 19'd121463, 19'd121464, 19'd121465, 19'd121466, 19'd121467, 19'd121468, 19'd122078, 19'd122079, 19'd122080, 19'd122081, 19'd122082, 19'd122083, 19'd122084, 19'd122085, 19'd122086, 19'd122087, 19'd122088, 19'd122089, 19'd122090, 19'd122091, 19'd122092, 19'd122093, 19'd122094, 19'd122095, 19'd122096, 19'd122097, 19'd122098, 19'd122099, 19'd122100, 19'd122101, 19'd122102, 19'd122103, 19'd122104, 19'd122105, 19'd122106, 19'd122107, 19'd122717, 19'd122718, 19'd122719, 19'd122720, 19'd122721, 19'd122722, 19'd122723, 19'd122724, 19'd122725, 19'd122726, 19'd122727, 19'd122728, 19'd122729, 19'd122730, 19'd122731, 19'd122732, 19'd122733, 19'd122734, 19'd122735, 19'd122736, 19'd122737, 19'd122738, 19'd122739, 19'd122740, 19'd122741, 19'd122742, 19'd122743, 19'd122744, 19'd122745, 19'd122746, 19'd123356, 19'd123357, 19'd123358, 19'd123359, 19'd123360, 19'd123361, 19'd123362, 19'd123363, 19'd123364, 19'd123365, 19'd123366, 19'd123367, 19'd123368, 19'd123369, 19'd123370, 19'd123371, 19'd123372, 19'd123373, 19'd123374, 19'd123375, 19'd123376, 19'd123377, 19'd123378, 19'd123379, 19'd123380, 19'd123381, 19'd123382, 19'd123383, 19'd123384, 19'd123385, 19'd123995, 19'd123996, 19'd123997, 19'd123998, 19'd123999, 19'd124000, 19'd124001, 19'd124002, 19'd124003, 19'd124004, 19'd124005, 19'd124006, 19'd124007, 19'd124008, 19'd124009, 19'd124010, 19'd124011, 19'd124012, 19'd124013, 19'd124014, 19'd124015, 19'd124016, 19'd124017, 19'd124018, 19'd124019, 19'd124020, 19'd124021, 19'd124022, 19'd124023, 19'd124024, 19'd124634, 19'd124635, 19'd124636, 19'd124637, 19'd124638, 19'd124639, 19'd124640, 19'd124641, 19'd124642, 19'd124643, 19'd124644, 19'd124645, 19'd124646, 19'd124647, 19'd124648, 19'd124649, 19'd124650, 19'd124651, 19'd124652, 19'd124653, 19'd124654, 19'd124655, 19'd124656, 19'd124657, 19'd124658, 19'd124659, 19'd124660, 19'd124661, 19'd124662, 19'd124663, 19'd125273, 19'd125274, 19'd125275, 19'd125276, 19'd125277, 19'd125278, 19'd125279, 19'd125280, 19'd125281, 19'd125282, 19'd125283, 19'd125284, 19'd125285, 19'd125286, 19'd125287, 19'd125288, 19'd125289, 19'd125290, 19'd125291, 19'd125292, 19'd125293, 19'd125294, 19'd125295, 19'd125296, 19'd125297, 19'd125298, 19'd125299, 19'd125300, 19'd125301, 19'd125302, 19'd125912, 19'd125913, 19'd125914, 19'd125915, 19'd125916, 19'd125917, 19'd125918, 19'd125919, 19'd125920, 19'd125921, 19'd125922, 19'd125923, 19'd125924, 19'd125925, 19'd125926, 19'd125927, 19'd125928, 19'd125929, 19'd125930, 19'd125931, 19'd125932, 19'd125933, 19'd125934, 19'd125935, 19'd125936, 19'd125937, 19'd125938, 19'd125939, 19'd125940, 19'd125941, 19'd126551, 19'd126552, 19'd126553, 19'd126554, 19'd126555, 19'd126556, 19'd126557, 19'd126558, 19'd126559, 19'd126560, 19'd126561, 19'd126562, 19'd126563, 19'd126564, 19'd126565, 19'd126566, 19'd126567, 19'd126568, 19'd126569, 19'd126570, 19'd126571, 19'd126572, 19'd126573, 19'd126574, 19'd126575, 19'd126576, 19'd126577, 19'd126578, 19'd126579, 19'd126580, 19'd127190, 19'd127191, 19'd127192, 19'd127193, 19'd127194, 19'd127195, 19'd127196, 19'd127197, 19'd127198, 19'd127199, 19'd127200, 19'd127201, 19'd127202, 19'd127203, 19'd127204, 19'd127205, 19'd127206, 19'd127207, 19'd127208, 19'd127209, 19'd127210, 19'd127211, 19'd127212, 19'd127213, 19'd127214, 19'd127215, 19'd127216, 19'd127217, 19'd127218, 19'd127219, 19'd127829, 19'd127830, 19'd127831, 19'd127832, 19'd127833, 19'd127834, 19'd127835, 19'd127836, 19'd127837, 19'd127838, 19'd127839, 19'd127840, 19'd127841, 19'd127842, 19'd127843, 19'd127844, 19'd127845, 19'd127846, 19'd127847, 19'd127848, 19'd127849, 19'd127850, 19'd127851, 19'd127852, 19'd127853, 19'd127854, 19'd127855, 19'd127856, 19'd127857, 19'd127858, 19'd83099, 19'd83100, 19'd83101, 19'd83102, 19'd83103, 19'd83104, 19'd83105, 19'd83106, 19'd83107, 19'd83108, 19'd83109, 19'd83110, 19'd83111, 19'd83112, 19'd83113, 19'd83114, 19'd83115, 19'd83116, 19'd83117, 19'd83118, 19'd83119, 19'd83120, 19'd83121, 19'd83122, 19'd83123, 19'd83124, 19'd83125, 19'd83126, 19'd83127, 19'd83128, 19'd83738, 19'd83739, 19'd83740, 19'd83741, 19'd83742, 19'd83743, 19'd83744, 19'd83745, 19'd83746, 19'd83747, 19'd83748, 19'd83749, 19'd83750, 19'd83751, 19'd83752, 19'd83753, 19'd83754, 19'd83755, 19'd83756, 19'd83757, 19'd83758, 19'd83759, 19'd83760, 19'd83761, 19'd83762, 19'd83763, 19'd83764, 19'd83765, 19'd83766, 19'd83767, 19'd84377, 19'd84378, 19'd84379, 19'd84380, 19'd84381, 19'd84382, 19'd84383, 19'd84384, 19'd84385, 19'd84386, 19'd84387, 19'd84388, 19'd84389, 19'd84390, 19'd84391, 19'd84392, 19'd84393, 19'd84394, 19'd84395, 19'd84396, 19'd84397, 19'd84398, 19'd84399, 19'd84400, 19'd84401, 19'd84402, 19'd84403, 19'd84404, 19'd84405, 19'd84406, 19'd85016, 19'd85017, 19'd85018, 19'd85019, 19'd85020, 19'd85021, 19'd85022, 19'd85023, 19'd85024, 19'd85025, 19'd85026, 19'd85027, 19'd85028, 19'd85029, 19'd85030, 19'd85031, 19'd85032, 19'd85033, 19'd85034, 19'd85035, 19'd85036, 19'd85037, 19'd85038, 19'd85039, 19'd85040, 19'd85041, 19'd85042, 19'd85043, 19'd85044, 19'd85045, 19'd85655, 19'd85656, 19'd85657, 19'd85658, 19'd85659, 19'd85660, 19'd85661, 19'd85662, 19'd85663, 19'd85664, 19'd85665, 19'd85666, 19'd85667, 19'd85668, 19'd85669, 19'd85670, 19'd85671, 19'd85672, 19'd85673, 19'd85674, 19'd85675, 19'd85676, 19'd85677, 19'd85678, 19'd85679, 19'd85680, 19'd85681, 19'd85682, 19'd85683, 19'd85684, 19'd86294, 19'd86295, 19'd86296, 19'd86297, 19'd86298, 19'd86299, 19'd86300, 19'd86301, 19'd86302, 19'd86303, 19'd86304, 19'd86305, 19'd86306, 19'd86307, 19'd86308, 19'd86309, 19'd86310, 19'd86311, 19'd86312, 19'd86313, 19'd86314, 19'd86315, 19'd86316, 19'd86317, 19'd86318, 19'd86319, 19'd86320, 19'd86321, 19'd86322, 19'd86323, 19'd86933, 19'd86934, 19'd86935, 19'd86936, 19'd86937, 19'd86938, 19'd86939, 19'd86940, 19'd86941, 19'd86942, 19'd86943, 19'd86944, 19'd86945, 19'd86946, 19'd86947, 19'd86948, 19'd86949, 19'd86950, 19'd86951, 19'd86952, 19'd86953, 19'd86954, 19'd86955, 19'd86956, 19'd86957, 19'd86958, 19'd86959, 19'd86960, 19'd86961, 19'd86962, 19'd87572, 19'd87573, 19'd87574, 19'd87575, 19'd87576, 19'd87577, 19'd87578, 19'd87579, 19'd87580, 19'd87581, 19'd87582, 19'd87583, 19'd87584, 19'd87585, 19'd87586, 19'd87587, 19'd87588, 19'd87589, 19'd87590, 19'd87591, 19'd87592, 19'd87593, 19'd87594, 19'd87595, 19'd87596, 19'd87597, 19'd87598, 19'd87599, 19'd87600, 19'd87601, 19'd88211, 19'd88212, 19'd88213, 19'd88214, 19'd88215, 19'd88216, 19'd88217, 19'd88218, 19'd88219, 19'd88220, 19'd88221, 19'd88222, 19'd88223, 19'd88224, 19'd88225, 19'd88226, 19'd88227, 19'd88228, 19'd88229, 19'd88230, 19'd88231, 19'd88232, 19'd88233, 19'd88234, 19'd88235, 19'd88236, 19'd88237, 19'd88238, 19'd88239, 19'd88240, 19'd88850, 19'd88851, 19'd88852, 19'd88853, 19'd88854, 19'd88855, 19'd88856, 19'd88857, 19'd88858, 19'd88859, 19'd88860, 19'd88861, 19'd88862, 19'd88863, 19'd88864, 19'd88865, 19'd88866, 19'd88867, 19'd88868, 19'd88869, 19'd88870, 19'd88871, 19'd88872, 19'd88873, 19'd88874, 19'd88875, 19'd88876, 19'd88877, 19'd88878, 19'd88879, 19'd89489, 19'd89490, 19'd89491, 19'd89492, 19'd89493, 19'd89494, 19'd89495, 19'd89496, 19'd89497, 19'd89498, 19'd89499, 19'd89500, 19'd89501, 19'd89502, 19'd89503, 19'd89504, 19'd89505, 19'd89506, 19'd89507, 19'd89508, 19'd89509, 19'd89510, 19'd89511, 19'd89512, 19'd89513, 19'd89514, 19'd89515, 19'd89516, 19'd89517, 19'd89518, 19'd90128, 19'd90129, 19'd90130, 19'd90131, 19'd90132, 19'd90133, 19'd90134, 19'd90135, 19'd90136, 19'd90137, 19'd90138, 19'd90139, 19'd90140, 19'd90141, 19'd90142, 19'd90143, 19'd90144, 19'd90145, 19'd90146, 19'd90147, 19'd90148, 19'd90149, 19'd90150, 19'd90151, 19'd90152, 19'd90153, 19'd90154, 19'd90155, 19'd90156, 19'd90157, 19'd90767, 19'd90768, 19'd90769, 19'd90770, 19'd90771, 19'd90772, 19'd90773, 19'd90774, 19'd90775, 19'd90776, 19'd90777, 19'd90778, 19'd90779, 19'd90780, 19'd90781, 19'd90782, 19'd90783, 19'd90784, 19'd90785, 19'd90786, 19'd90787, 19'd90788, 19'd90789, 19'd90790, 19'd90791, 19'd90792, 19'd90793, 19'd90794, 19'd90795, 19'd90796, 19'd91406, 19'd91407, 19'd91408, 19'd91409, 19'd91410, 19'd91411, 19'd91412, 19'd91413, 19'd91414, 19'd91415, 19'd91416, 19'd91417, 19'd91418, 19'd91419, 19'd91420, 19'd91421, 19'd91422, 19'd91423, 19'd91424, 19'd91425, 19'd91426, 19'd91427, 19'd91428, 19'd91429, 19'd91430, 19'd91431, 19'd91432, 19'd91433, 19'd91434, 19'd91435, 19'd92045, 19'd92046, 19'd92047, 19'd92048, 19'd92049, 19'd92050, 19'd92051, 19'd92052, 19'd92053, 19'd92054, 19'd92055, 19'd92056, 19'd92057, 19'd92058, 19'd92059, 19'd92060, 19'd92061, 19'd92062, 19'd92063, 19'd92064, 19'd92065, 19'd92066, 19'd92067, 19'd92068, 19'd92069, 19'd92070, 19'd92071, 19'd92072, 19'd92073, 19'd92074, 19'd92684, 19'd92685, 19'd92686, 19'd92687, 19'd92688, 19'd92689, 19'd92690, 19'd92691, 19'd92692, 19'd92693, 19'd92694, 19'd92695, 19'd92696, 19'd92697, 19'd92698, 19'd92699, 19'd92700, 19'd92701, 19'd92702, 19'd92703, 19'd92704, 19'd92705, 19'd92706, 19'd92707, 19'd92708, 19'd92709, 19'd92710, 19'd92711, 19'd92712, 19'd92713, 19'd93323, 19'd93324, 19'd93325, 19'd93326, 19'd93327, 19'd93328, 19'd93329, 19'd93330, 19'd93331, 19'd93332, 19'd93333, 19'd93334, 19'd93335, 19'd93336, 19'd93337, 19'd93338, 19'd93339, 19'd93340, 19'd93341, 19'd93342, 19'd93343, 19'd93344, 19'd93345, 19'd93346, 19'd93347, 19'd93348, 19'd93349, 19'd93350, 19'd93351, 19'd93352, 19'd93962, 19'd93963, 19'd93964, 19'd93965, 19'd93966, 19'd93967, 19'd93968, 19'd93969, 19'd93970, 19'd93971, 19'd93972, 19'd93973, 19'd93974, 19'd93975, 19'd93976, 19'd93977, 19'd93978, 19'd93979, 19'd93980, 19'd93981, 19'd93982, 19'd93983, 19'd93984, 19'd93985, 19'd93986, 19'd93987, 19'd93988, 19'd93989, 19'd93990, 19'd93991, 19'd94601, 19'd94602, 19'd94603, 19'd94604, 19'd94605, 19'd94606, 19'd94607, 19'd94608, 19'd94609, 19'd94610, 19'd94611, 19'd94612, 19'd94613, 19'd94614, 19'd94615, 19'd94616, 19'd94617, 19'd94618, 19'd94619, 19'd94620, 19'd94621, 19'd94622, 19'd94623, 19'd94624, 19'd94625, 19'd94626, 19'd94627, 19'd94628, 19'd94629, 19'd94630, 19'd95240, 19'd95241, 19'd95242, 19'd95243, 19'd95244, 19'd95245, 19'd95246, 19'd95247, 19'd95248, 19'd95249, 19'd95250, 19'd95251, 19'd95252, 19'd95253, 19'd95254, 19'd95255, 19'd95256, 19'd95257, 19'd95258, 19'd95259, 19'd95260, 19'd95261, 19'd95262, 19'd95263, 19'd95264, 19'd95265, 19'd95266, 19'd95267, 19'd95268, 19'd95269, 19'd95879, 19'd95880, 19'd95881, 19'd95882, 19'd95883, 19'd95884, 19'd95885, 19'd95886, 19'd95887, 19'd95888, 19'd95889, 19'd95890, 19'd95891, 19'd95892, 19'd95893, 19'd95894, 19'd95895, 19'd95896, 19'd95897, 19'd95898, 19'd95899, 19'd95900, 19'd95901, 19'd95902, 19'd95903, 19'd95904, 19'd95905, 19'd95906, 19'd95907, 19'd95908, 19'd51149, 19'd51150, 19'd51151, 19'd51152, 19'd51153, 19'd51154, 19'd51155, 19'd51156, 19'd51157, 19'd51158, 19'd51159, 19'd51160, 19'd51161, 19'd51162, 19'd51163, 19'd51164, 19'd51165, 19'd51166, 19'd51167, 19'd51168, 19'd51169, 19'd51170, 19'd51171, 19'd51172, 19'd51173, 19'd51174, 19'd51175, 19'd51176, 19'd51177, 19'd51178, 19'd51788, 19'd51789, 19'd51790, 19'd51791, 19'd51792, 19'd51793, 19'd51794, 19'd51795, 19'd51796, 19'd51797, 19'd51798, 19'd51799, 19'd51800, 19'd51801, 19'd51802, 19'd51803, 19'd51804, 19'd51805, 19'd51806, 19'd51807, 19'd51808, 19'd51809, 19'd51810, 19'd51811, 19'd51812, 19'd51813, 19'd51814, 19'd51815, 19'd51816, 19'd51817, 19'd52427, 19'd52428, 19'd52429, 19'd52430, 19'd52431, 19'd52432, 19'd52433, 19'd52434, 19'd52435, 19'd52436, 19'd52437, 19'd52438, 19'd52439, 19'd52440, 19'd52441, 19'd52442, 19'd52443, 19'd52444, 19'd52445, 19'd52446, 19'd52447, 19'd52448, 19'd52449, 19'd52450, 19'd52451, 19'd52452, 19'd52453, 19'd52454, 19'd52455, 19'd52456, 19'd53066, 19'd53067, 19'd53068, 19'd53069, 19'd53070, 19'd53071, 19'd53072, 19'd53073, 19'd53074, 19'd53075, 19'd53076, 19'd53077, 19'd53078, 19'd53079, 19'd53080, 19'd53081, 19'd53082, 19'd53083, 19'd53084, 19'd53085, 19'd53086, 19'd53087, 19'd53088, 19'd53089, 19'd53090, 19'd53091, 19'd53092, 19'd53093, 19'd53094, 19'd53095, 19'd53705, 19'd53706, 19'd53707, 19'd53708, 19'd53709, 19'd53710, 19'd53711, 19'd53712, 19'd53713, 19'd53714, 19'd53715, 19'd53716, 19'd53717, 19'd53718, 19'd53719, 19'd53720, 19'd53721, 19'd53722, 19'd53723, 19'd53724, 19'd53725, 19'd53726, 19'd53727, 19'd53728, 19'd53729, 19'd53730, 19'd53731, 19'd53732, 19'd53733, 19'd53734, 19'd54344, 19'd54345, 19'd54346, 19'd54347, 19'd54348, 19'd54349, 19'd54350, 19'd54351, 19'd54352, 19'd54353, 19'd54354, 19'd54355, 19'd54356, 19'd54357, 19'd54358, 19'd54359, 19'd54360, 19'd54361, 19'd54362, 19'd54363, 19'd54364, 19'd54365, 19'd54366, 19'd54367, 19'd54368, 19'd54369, 19'd54370, 19'd54371, 19'd54372, 19'd54373, 19'd54983, 19'd54984, 19'd54985, 19'd54986, 19'd54987, 19'd54988, 19'd54989, 19'd54990, 19'd54991, 19'd54992, 19'd54993, 19'd54994, 19'd54995, 19'd54996, 19'd54997, 19'd54998, 19'd54999, 19'd55000, 19'd55001, 19'd55002, 19'd55003, 19'd55004, 19'd55005, 19'd55006, 19'd55007, 19'd55008, 19'd55009, 19'd55010, 19'd55011, 19'd55012, 19'd55622, 19'd55623, 19'd55624, 19'd55625, 19'd55626, 19'd55627, 19'd55628, 19'd55629, 19'd55630, 19'd55631, 19'd55632, 19'd55633, 19'd55634, 19'd55635, 19'd55636, 19'd55637, 19'd55638, 19'd55639, 19'd55640, 19'd55641, 19'd55642, 19'd55643, 19'd55644, 19'd55645, 19'd55646, 19'd55647, 19'd55648, 19'd55649, 19'd55650, 19'd55651, 19'd56261, 19'd56262, 19'd56263, 19'd56264, 19'd56265, 19'd56266, 19'd56267, 19'd56268, 19'd56269, 19'd56270, 19'd56271, 19'd56272, 19'd56273, 19'd56274, 19'd56275, 19'd56276, 19'd56277, 19'd56278, 19'd56279, 19'd56280, 19'd56281, 19'd56282, 19'd56283, 19'd56284, 19'd56285, 19'd56286, 19'd56287, 19'd56288, 19'd56289, 19'd56290, 19'd56900, 19'd56901, 19'd56902, 19'd56903, 19'd56904, 19'd56905, 19'd56906, 19'd56907, 19'd56908, 19'd56909, 19'd56910, 19'd56911, 19'd56912, 19'd56913, 19'd56914, 19'd56915, 19'd56916, 19'd56917, 19'd56918, 19'd56919, 19'd56920, 19'd56921, 19'd56922, 19'd56923, 19'd56924, 19'd56925, 19'd56926, 19'd56927, 19'd56928, 19'd56929, 19'd57539, 19'd57540, 19'd57541, 19'd57542, 19'd57543, 19'd57544, 19'd57545, 19'd57546, 19'd57547, 19'd57548, 19'd57549, 19'd57550, 19'd57551, 19'd57552, 19'd57553, 19'd57554, 19'd57555, 19'd57556, 19'd57557, 19'd57558, 19'd57559, 19'd57560, 19'd57561, 19'd57562, 19'd57563, 19'd57564, 19'd57565, 19'd57566, 19'd57567, 19'd57568, 19'd58178, 19'd58179, 19'd58180, 19'd58181, 19'd58182, 19'd58183, 19'd58184, 19'd58185, 19'd58186, 19'd58187, 19'd58188, 19'd58189, 19'd58190, 19'd58191, 19'd58192, 19'd58193, 19'd58194, 19'd58195, 19'd58196, 19'd58197, 19'd58198, 19'd58199, 19'd58200, 19'd58201, 19'd58202, 19'd58203, 19'd58204, 19'd58205, 19'd58206, 19'd58207, 19'd58817, 19'd58818, 19'd58819, 19'd58820, 19'd58821, 19'd58822, 19'd58823, 19'd58824, 19'd58825, 19'd58826, 19'd58827, 19'd58828, 19'd58829, 19'd58830, 19'd58831, 19'd58832, 19'd58833, 19'd58834, 19'd58835, 19'd58836, 19'd58837, 19'd58838, 19'd58839, 19'd58840, 19'd58841, 19'd58842, 19'd58843, 19'd58844, 19'd58845, 19'd58846, 19'd59456, 19'd59457, 19'd59458, 19'd59459, 19'd59460, 19'd59461, 19'd59462, 19'd59463, 19'd59464, 19'd59465, 19'd59466, 19'd59467, 19'd59468, 19'd59469, 19'd59470, 19'd59471, 19'd59472, 19'd59473, 19'd59474, 19'd59475, 19'd59476, 19'd59477, 19'd59478, 19'd59479, 19'd59480, 19'd59481, 19'd59482, 19'd59483, 19'd59484, 19'd59485, 19'd60095, 19'd60096, 19'd60097, 19'd60098, 19'd60099, 19'd60100, 19'd60101, 19'd60102, 19'd60103, 19'd60104, 19'd60105, 19'd60106, 19'd60107, 19'd60108, 19'd60109, 19'd60110, 19'd60111, 19'd60112, 19'd60113, 19'd60114, 19'd60115, 19'd60116, 19'd60117, 19'd60118, 19'd60119, 19'd60120, 19'd60121, 19'd60122, 19'd60123, 19'd60124, 19'd60734, 19'd60735, 19'd60736, 19'd60737, 19'd60738, 19'd60739, 19'd60740, 19'd60741, 19'd60742, 19'd60743, 19'd60744, 19'd60745, 19'd60746, 19'd60747, 19'd60748, 19'd60749, 19'd60750, 19'd60751, 19'd60752, 19'd60753, 19'd60754, 19'd60755, 19'd60756, 19'd60757, 19'd60758, 19'd60759, 19'd60760, 19'd60761, 19'd60762, 19'd60763, 19'd61373, 19'd61374, 19'd61375, 19'd61376, 19'd61377, 19'd61378, 19'd61379, 19'd61380, 19'd61381, 19'd61382, 19'd61383, 19'd61384, 19'd61385, 19'd61386, 19'd61387, 19'd61388, 19'd61389, 19'd61390, 19'd61391, 19'd61392, 19'd61393, 19'd61394, 19'd61395, 19'd61396, 19'd61397, 19'd61398, 19'd61399, 19'd61400, 19'd61401, 19'd61402, 19'd62012, 19'd62013, 19'd62014, 19'd62015, 19'd62016, 19'd62017, 19'd62018, 19'd62019, 19'd62020, 19'd62021, 19'd62022, 19'd62023, 19'd62024, 19'd62025, 19'd62026, 19'd62027, 19'd62028, 19'd62029, 19'd62030, 19'd62031, 19'd62032, 19'd62033, 19'd62034, 19'd62035, 19'd62036, 19'd62037, 19'd62038, 19'd62039, 19'd62040, 19'd62041, 19'd62651, 19'd62652, 19'd62653, 19'd62654, 19'd62655, 19'd62656, 19'd62657, 19'd62658, 19'd62659, 19'd62660, 19'd62661, 19'd62662, 19'd62663, 19'd62664, 19'd62665, 19'd62666, 19'd62667, 19'd62668, 19'd62669, 19'd62670, 19'd62671, 19'd62672, 19'd62673, 19'd62674, 19'd62675, 19'd62676, 19'd62677, 19'd62678, 19'd62679, 19'd62680, 19'd63290, 19'd63291, 19'd63292, 19'd63293, 19'd63294, 19'd63295, 19'd63296, 19'd63297, 19'd63298, 19'd63299, 19'd63300, 19'd63301, 19'd63302, 19'd63303, 19'd63304, 19'd63305, 19'd63306, 19'd63307, 19'd63308, 19'd63309, 19'd63310, 19'd63311, 19'd63312, 19'd63313, 19'd63314, 19'd63315, 19'd63316, 19'd63317, 19'd63318, 19'd63319, 19'd63929, 19'd63930, 19'd63931, 19'd63932, 19'd63933, 19'd63934, 19'd63935, 19'd63936, 19'd63937, 19'd63938, 19'd63939, 19'd63940, 19'd63941, 19'd63942, 19'd63943, 19'd63944, 19'd63945, 19'd63946, 19'd63947, 19'd63948, 19'd63949, 19'd63950, 19'd63951, 19'd63952, 19'd63953, 19'd63954, 19'd63955, 19'd63956, 19'd63957, 19'd63958, 19'd4503, 19'd4504, 19'd4505, 19'd4506, 19'd4507, 19'd4508, 19'd4510, 19'd4511, 19'd4512, 19'd4513, 19'd4514, 19'd4515, 19'd4517, 19'd4518, 19'd4519, 19'd4520, 19'd4521, 19'd4522, 19'd4524, 19'd4525, 19'd4526, 19'd4527, 19'd4528, 19'd4529, 19'd5142, 19'd5143, 19'd5144, 19'd5145, 19'd5146, 19'd5147, 19'd5149, 19'd5150, 19'd5151, 19'd5152, 19'd5153, 19'd5154, 19'd5156, 19'd5157, 19'd5158, 19'd5159, 19'd5160, 19'd5161, 19'd5163, 19'd5164, 19'd5165, 19'd5166, 19'd5167, 19'd5168, 19'd5781, 19'd5788, 19'd5795, 19'd5802, 19'd6420, 19'd6427, 19'd6434, 19'd6441, 19'd7059, 19'd7066, 19'd7073, 19'd7080, 19'd7698, 19'd7705, 19'd7712, 19'd7719, 19'd8337, 19'd8344, 19'd8351, 19'd8358, 19'd8976, 19'd8983, 19'd8984, 19'd8985, 19'd8986, 19'd8987, 19'd8988, 19'd8990, 19'd8991, 19'd8992, 19'd8993, 19'd8994, 19'd8995, 19'd8997, 19'd8998, 19'd8999, 19'd9000, 19'd9001, 19'd9002, 19'd9615, 19'd9622, 19'd9623, 19'd9624, 19'd9625, 19'd9626, 19'd9627, 19'd9629, 19'd9630, 19'd9631, 19'd9632, 19'd9633, 19'd9634, 19'd9636, 19'd9637, 19'd9638, 19'd9639, 19'd9640, 19'd9641, 19'd10254, 19'd10266, 19'd10268, 19'd10275, 19'd10893, 19'd10905, 19'd10907, 19'd10914, 19'd11532, 19'd11544, 19'd11546, 19'd11553, 19'd12171, 19'd12183, 19'd12185, 19'd12192, 19'd12810, 19'd12811, 19'd12812, 19'd12813, 19'd12814, 19'd12815, 19'd12817, 19'd12818, 19'd12819, 19'd12820, 19'd12821, 19'd12822, 19'd12824, 19'd12825, 19'd12826, 19'd12827, 19'd12828, 19'd12829, 19'd12831, 19'd12832, 19'd12833, 19'd12834, 19'd12835, 19'd12836, 19'd13449, 19'd13450, 19'd13451, 19'd13452, 19'd13453, 19'd13454, 19'd13456, 19'd13457, 19'd13458, 19'd13459, 19'd13460, 19'd13461, 19'd13463, 19'd13464, 19'd13465, 19'd13466, 19'd13467, 19'd13468, 19'd13470, 19'd13471, 19'd13472, 19'd13473, 19'd13474, 19'd13475, 19'd16005, 19'd16012, 19'd16013, 19'd16014, 19'd16015, 19'd16016, 19'd16017, 19'd16019, 19'd16026, 19'd16027, 19'd16028, 19'd16029, 19'd16030, 19'd16031, 19'd16644, 19'd16651, 19'd16652, 19'd16653, 19'd16654, 19'd16655, 19'd16656, 19'd16658, 19'd16665, 19'd16666, 19'd16667, 19'd16668, 19'd16669, 19'd16670, 19'd17283, 19'd17290, 19'd17295, 19'd17297, 19'd17304, 19'd17309, 19'd17922, 19'd17925, 19'd17929, 19'd17934, 19'd17936, 19'd17939, 19'd17943, 19'd17948, 19'd18561, 19'd18564, 19'd18568, 19'd18573, 19'd18575, 19'd18578, 19'd18582, 19'd18587, 19'd19200, 19'd19203, 19'd19207, 19'd19212, 19'd19214, 19'd19217, 19'd19221, 19'd19226, 19'd19839, 19'd19842, 19'd19846, 19'd19851, 19'd19853, 19'd19856, 19'd19860, 19'd19865, 19'd20478, 19'd20481, 19'd20485, 19'd20486, 19'd20487, 19'd20488, 19'd20489, 19'd20490, 19'd20492, 19'd20495, 19'd20499, 19'd20504, 19'd21117, 19'd21120, 19'd21124, 19'd21125, 19'd21126, 19'd21127, 19'd21128, 19'd21129, 19'd21131, 19'd21134, 19'd21138, 19'd21143, 19'd21756, 19'd21759, 19'd21763, 19'd21768, 19'd21770, 19'd21773, 19'd21777, 19'd21782, 19'd22395, 19'd22398, 19'd22402, 19'd22407, 19'd22409, 19'd22412, 19'd22416, 19'd22421, 19'd23034, 19'd23035, 19'd23036, 19'd23037, 19'd23038, 19'd23039, 19'd23041, 19'd23046, 19'd23048, 19'd23049, 19'd23050, 19'd23051, 19'd23052, 19'd23053, 19'd23055, 19'd23060, 19'd23673, 19'd23674, 19'd23675, 19'd23676, 19'd23677, 19'd23678, 19'd23680, 19'd23685, 19'd23687, 19'd23688, 19'd23689, 19'd23690, 19'd23691, 19'd23692, 19'd23694, 19'd23699, 19'd24315, 19'd24319, 19'd24320, 19'd24321, 19'd24322, 19'd24323, 19'd24324, 19'd24329, 19'd24333, 19'd24334, 19'd24335, 19'd24336, 19'd24337, 19'd24338, 19'd24954, 19'd24958, 19'd24959, 19'd24960, 19'd24961, 19'd24962, 19'd24963, 19'd24968, 19'd24972, 19'd24973, 19'd24974, 19'd24975, 19'd24976, 19'd24977, 19'd5961, 19'd5962, 19'd5963, 19'd5964, 19'd5965, 19'd5966, 19'd5967, 19'd5968, 19'd5969, 19'd5970, 19'd5971, 19'd5972, 19'd5973, 19'd5974, 19'd5975, 19'd5979, 19'd5980, 19'd5981, 19'd5998, 19'd5999, 19'd6000, 19'd6001, 19'd6002, 19'd6003, 19'd6004, 19'd6005, 19'd6006, 19'd6007, 19'd6008, 19'd6009, 19'd6010, 19'd6011, 19'd6012, 19'd6016, 19'd6017, 19'd6018, 19'd6019, 19'd6020, 19'd6021, 19'd6022, 19'd6023, 19'd6024, 19'd6025, 19'd6026, 19'd6027, 19'd6028, 19'd6029, 19'd6030, 19'd6034, 19'd6035, 19'd6036, 19'd6037, 19'd6038, 19'd6039, 19'd6040, 19'd6041, 19'd6042, 19'd6043, 19'd6044, 19'd6045, 19'd6046, 19'd6047, 19'd6048, 19'd6052, 19'd6053, 19'd6054, 19'd6064, 19'd6065, 19'd6066, 19'd6070, 19'd6071, 19'd6072, 19'd6073, 19'd6085, 19'd6086, 19'd6087, 19'd6088, 19'd6096, 19'd6097, 19'd6098, 19'd6099, 19'd6100, 19'd6101, 19'd6102, 19'd6110, 19'd6111, 19'd6112, 19'd6113, 19'd6114, 19'd6115, 19'd6116, 19'd6117, 19'd6118, 19'd6119, 19'd6120, 19'd6121, 19'd6122, 19'd6123, 19'd6124, 19'd6128, 19'd6129, 19'd6130, 19'd6131, 19'd6132, 19'd6133, 19'd6134, 19'd6135, 19'd6136, 19'd6137, 19'd6138, 19'd6139, 19'd6140, 19'd6141, 19'd6142, 19'd6146, 19'd6147, 19'd6148, 19'd6149, 19'd6150, 19'd6151, 19'd6152, 19'd6153, 19'd6154, 19'd6155, 19'd6156, 19'd6157, 19'd6158, 19'd6159, 19'd6160, 19'd6164, 19'd6165, 19'd6166, 19'd6167, 19'd6168, 19'd6169, 19'd6170, 19'd6171, 19'd6600, 19'd6601, 19'd6602, 19'd6603, 19'd6604, 19'd6605, 19'd6606, 19'd6607, 19'd6608, 19'd6609, 19'd6610, 19'd6611, 19'd6612, 19'd6613, 19'd6614, 19'd6618, 19'd6619, 19'd6620, 19'd6633, 19'd6637, 19'd6638, 19'd6639, 19'd6640, 19'd6641, 19'd6642, 19'd6643, 19'd6644, 19'd6645, 19'd6646, 19'd6647, 19'd6648, 19'd6649, 19'd6650, 19'd6651, 19'd6655, 19'd6656, 19'd6657, 19'd6658, 19'd6659, 19'd6660, 19'd6661, 19'd6662, 19'd6663, 19'd6664, 19'd6665, 19'd6666, 19'd6667, 19'd6668, 19'd6669, 19'd6673, 19'd6674, 19'd6675, 19'd6676, 19'd6677, 19'd6678, 19'd6679, 19'd6680, 19'd6681, 19'd6682, 19'd6683, 19'd6684, 19'd6685, 19'd6686, 19'd6687, 19'd6691, 19'd6692, 19'd6693, 19'd6703, 19'd6704, 19'd6705, 19'd6709, 19'd6710, 19'd6711, 19'd6712, 19'd6713, 19'd6723, 19'd6724, 19'd6725, 19'd6726, 19'd6727, 19'd6734, 19'd6735, 19'd6736, 19'd6737, 19'd6738, 19'd6739, 19'd6740, 19'd6741, 19'd6742, 19'd6749, 19'd6750, 19'd6751, 19'd6752, 19'd6753, 19'd6754, 19'd6755, 19'd6756, 19'd6757, 19'd6758, 19'd6759, 19'd6760, 19'd6761, 19'd6762, 19'd6763, 19'd6767, 19'd6768, 19'd6769, 19'd6770, 19'd6771, 19'd6772, 19'd6773, 19'd6774, 19'd6775, 19'd6776, 19'd6777, 19'd6778, 19'd6779, 19'd6780, 19'd6781, 19'd6785, 19'd6786, 19'd6787, 19'd6788, 19'd6789, 19'd6790, 19'd6791, 19'd6792, 19'd6793, 19'd6794, 19'd6795, 19'd6796, 19'd6797, 19'd6798, 19'd6799, 19'd6803, 19'd6804, 19'd6805, 19'd6806, 19'd6807, 19'd6808, 19'd6809, 19'd6810, 19'd6811, 19'd6812, 19'd7239, 19'd7240, 19'd7241, 19'd7242, 19'd7243, 19'd7244, 19'd7245, 19'd7246, 19'd7247, 19'd7248, 19'd7249, 19'd7250, 19'd7251, 19'd7252, 19'd7253, 19'd7257, 19'd7258, 19'd7259, 19'd7271, 19'd7272, 19'd7276, 19'd7277, 19'd7278, 19'd7279, 19'd7280, 19'd7281, 19'd7282, 19'd7283, 19'd7284, 19'd7285, 19'd7286, 19'd7287, 19'd7288, 19'd7289, 19'd7290, 19'd7294, 19'd7295, 19'd7296, 19'd7297, 19'd7298, 19'd7299, 19'd7300, 19'd7301, 19'd7302, 19'd7303, 19'd7304, 19'd7305, 19'd7306, 19'd7307, 19'd7308, 19'd7312, 19'd7313, 19'd7314, 19'd7315, 19'd7316, 19'd7317, 19'd7318, 19'd7319, 19'd7320, 19'd7321, 19'd7322, 19'd7323, 19'd7324, 19'd7325, 19'd7326, 19'd7330, 19'd7331, 19'd7332, 19'd7342, 19'd7343, 19'd7344, 19'd7348, 19'd7349, 19'd7350, 19'd7351, 19'd7352, 19'd7353, 19'd7361, 19'd7362, 19'd7363, 19'd7364, 19'd7365, 19'd7366, 19'd7372, 19'd7373, 19'd7374, 19'd7375, 19'd7376, 19'd7377, 19'd7378, 19'd7379, 19'd7380, 19'd7381, 19'd7382, 19'd7388, 19'd7389, 19'd7390, 19'd7391, 19'd7392, 19'd7393, 19'd7394, 19'd7395, 19'd7396, 19'd7397, 19'd7398, 19'd7399, 19'd7400, 19'd7401, 19'd7402, 19'd7406, 19'd7407, 19'd7408, 19'd7409, 19'd7410, 19'd7411, 19'd7412, 19'd7413, 19'd7414, 19'd7415, 19'd7416, 19'd7417, 19'd7418, 19'd7419, 19'd7420, 19'd7424, 19'd7425, 19'd7426, 19'd7427, 19'd7428, 19'd7429, 19'd7430, 19'd7431, 19'd7432, 19'd7433, 19'd7434, 19'd7435, 19'd7436, 19'd7437, 19'd7438, 19'd7442, 19'd7443, 19'd7444, 19'd7445, 19'd7446, 19'd7447, 19'd7448, 19'd7449, 19'd7450, 19'd7451, 19'd7452, 19'd7453, 19'd7878, 19'd7879, 19'd7880, 19'd7896, 19'd7897, 19'd7898, 19'd7909, 19'd7910, 19'd7911, 19'd7915, 19'd7916, 19'd7917, 19'd7939, 19'd7940, 19'd7941, 19'd7951, 19'd7952, 19'd7953, 19'd7969, 19'd7970, 19'd7971, 19'd7981, 19'd7982, 19'd7983, 19'd7987, 19'd7988, 19'd7989, 19'd7991, 19'd7992, 19'd7993, 19'd7999, 19'd8000, 19'd8001, 19'd8003, 19'd8004, 19'd8005, 19'd8010, 19'd8011, 19'd8012, 19'd8020, 19'd8021, 19'd8022, 19'd8027, 19'd8028, 19'd8029, 19'd8051, 19'd8052, 19'd8053, 19'd8063, 19'd8064, 19'd8065, 19'd8081, 19'd8082, 19'd8083, 19'd8089, 19'd8090, 19'd8091, 19'd8092, 19'd8093, 19'd8517, 19'd8518, 19'd8519, 19'd8535, 19'd8536, 19'd8537, 19'd8547, 19'd8548, 19'd8549, 19'd8550, 19'd8554, 19'd8555, 19'd8556, 19'd8578, 19'd8579, 19'd8580, 19'd8590, 19'd8591, 19'd8592, 19'd8608, 19'd8609, 19'd8610, 19'd8620, 19'd8621, 19'd8622, 19'd8626, 19'd8627, 19'd8628, 19'd8631, 19'd8632, 19'd8633, 19'd8637, 19'd8638, 19'd8639, 19'd8642, 19'd8643, 19'd8644, 19'd8649, 19'd8650, 19'd8660, 19'd8661, 19'd8666, 19'd8667, 19'd8668, 19'd8690, 19'd8691, 19'd8692, 19'd8702, 19'd8703, 19'd8704, 19'd8720, 19'd8721, 19'd8722, 19'd8730, 19'd8731, 19'd8732, 19'd8733, 19'd9156, 19'd9157, 19'd9158, 19'd9174, 19'd9175, 19'd9176, 19'd9185, 19'd9186, 19'd9187, 19'd9188, 19'd9193, 19'd9194, 19'd9195, 19'd9217, 19'd9218, 19'd9219, 19'd9229, 19'd9230, 19'd9231, 19'd9247, 19'd9248, 19'd9249, 19'd9259, 19'd9260, 19'd9261, 19'd9265, 19'd9266, 19'd9267, 19'd9271, 19'd9272, 19'd9273, 19'd9275, 19'd9276, 19'd9277, 19'd9281, 19'd9282, 19'd9283, 19'd9288, 19'd9289, 19'd9299, 19'd9300, 19'd9305, 19'd9306, 19'd9307, 19'd9329, 19'd9330, 19'd9331, 19'd9341, 19'd9342, 19'd9343, 19'd9359, 19'd9360, 19'd9361, 19'd9371, 19'd9372, 19'd9373, 19'd9795, 19'd9796, 19'd9797, 19'd9813, 19'd9814, 19'd9815, 19'd9823, 19'd9824, 19'd9825, 19'd9826, 19'd9832, 19'd9833, 19'd9834, 19'd9856, 19'd9857, 19'd9858, 19'd9868, 19'd9869, 19'd9870, 19'd9886, 19'd9887, 19'd9888, 19'd9898, 19'd9899, 19'd9900, 19'd9904, 19'd9905, 19'd9906, 19'd9911, 19'd9912, 19'd9913, 19'd9914, 19'd9915, 19'd9920, 19'd9921, 19'd9922, 19'd9926, 19'd9927, 19'd9928, 19'd9938, 19'd9939, 19'd9940, 19'd9944, 19'd9945, 19'd9946, 19'd9968, 19'd9969, 19'd9970, 19'd9980, 19'd9981, 19'd9982, 19'd9998, 19'd9999, 19'd10000, 19'd10010, 19'd10011, 19'd10012, 19'd10434, 19'd10435, 19'd10436, 19'd10452, 19'd10453, 19'd10454, 19'd10461, 19'd10462, 19'd10463, 19'd10464, 19'd10471, 19'd10472, 19'd10473, 19'd10495, 19'd10496, 19'd10497, 19'd10507, 19'd10508, 19'd10509, 19'd10525, 19'd10526, 19'd10527, 19'd10537, 19'd10538, 19'd10539, 19'd10543, 19'd10544, 19'd10545, 19'd10551, 19'd10552, 19'd10553, 19'd10559, 19'd10560, 19'd10561, 19'd10565, 19'd10566, 19'd10567, 19'd10577, 19'd10578, 19'd10579, 19'd10583, 19'd10584, 19'd10585, 19'd10607, 19'd10608, 19'd10609, 19'd10619, 19'd10620, 19'd10621, 19'd10637, 19'd10638, 19'd10639, 19'd10649, 19'd10650, 19'd10651, 19'd11073, 19'd11074, 19'd11075, 19'd11091, 19'd11092, 19'd11093, 19'd11099, 19'd11100, 19'd11101, 19'd11102, 19'd11110, 19'd11111, 19'd11112, 19'd11134, 19'd11135, 19'd11136, 19'd11146, 19'd11147, 19'd11148, 19'd11164, 19'd11165, 19'd11166, 19'd11176, 19'd11177, 19'd11178, 19'd11182, 19'd11183, 19'd11184, 19'd11191, 19'd11198, 19'd11199, 19'd11200, 19'd11204, 19'd11205, 19'd11206, 19'd11216, 19'd11217, 19'd11218, 19'd11222, 19'd11223, 19'd11224, 19'd11246, 19'd11247, 19'd11248, 19'd11258, 19'd11259, 19'd11260, 19'd11276, 19'd11277, 19'd11278, 19'd11286, 19'd11287, 19'd11288, 19'd11289, 19'd11290, 19'd11712, 19'd11713, 19'd11714, 19'd11730, 19'd11731, 19'd11732, 19'd11737, 19'd11738, 19'd11739, 19'd11740, 19'd11749, 19'd11750, 19'd11751, 19'd11773, 19'd11774, 19'd11775, 19'd11785, 19'd11786, 19'd11787, 19'd11803, 19'd11804, 19'd11805, 19'd11815, 19'd11816, 19'd11817, 19'd11821, 19'd11822, 19'd11823, 19'd11837, 19'd11838, 19'd11839, 19'd11843, 19'd11844, 19'd11845, 19'd11855, 19'd11856, 19'd11857, 19'd11861, 19'd11862, 19'd11863, 19'd11885, 19'd11886, 19'd11887, 19'd11897, 19'd11898, 19'd11899, 19'd11915, 19'd11916, 19'd11917, 19'd11925, 19'd11926, 19'd11927, 19'd11928, 19'd12351, 19'd12352, 19'd12353, 19'd12369, 19'd12370, 19'd12371, 19'd12375, 19'd12376, 19'd12377, 19'd12378, 19'd12388, 19'd12389, 19'd12390, 19'd12412, 19'd12413, 19'd12414, 19'd12424, 19'd12425, 19'd12426, 19'd12442, 19'd12443, 19'd12444, 19'd12454, 19'd12455, 19'd12456, 19'd12460, 19'd12461, 19'd12462, 19'd12476, 19'd12477, 19'd12478, 19'd12482, 19'd12483, 19'd12484, 19'd12494, 19'd12495, 19'd12496, 19'd12500, 19'd12501, 19'd12502, 19'd12524, 19'd12525, 19'd12526, 19'd12536, 19'd12537, 19'd12538, 19'd12554, 19'd12555, 19'd12556, 19'd12562, 19'd12563, 19'd12564, 19'd12565, 19'd12990, 19'd12991, 19'd12992, 19'd13008, 19'd13009, 19'd13010, 19'd13013, 19'd13014, 19'd13015, 19'd13016, 19'd13027, 19'd13028, 19'd13029, 19'd13051, 19'd13052, 19'd13053, 19'd13063, 19'd13064, 19'd13065, 19'd13081, 19'd13082, 19'd13083, 19'd13093, 19'd13094, 19'd13095, 19'd13099, 19'd13100, 19'd13101, 19'd13115, 19'd13116, 19'd13117, 19'd13121, 19'd13122, 19'd13123, 19'd13124, 19'd13125, 19'd13126, 19'd13127, 19'd13128, 19'd13129, 19'd13130, 19'd13131, 19'd13132, 19'd13133, 19'd13134, 19'd13135, 19'd13139, 19'd13140, 19'd13141, 19'd13163, 19'd13164, 19'd13165, 19'd13175, 19'd13176, 19'd13177, 19'd13193, 19'd13194, 19'd13195, 19'd13196, 19'd13197, 19'd13198, 19'd13199, 19'd13200, 19'd13201, 19'd13202, 19'd13203, 19'd13629, 19'd13630, 19'd13631, 19'd13647, 19'd13648, 19'd13649, 19'd13651, 19'd13652, 19'd13653, 19'd13654, 19'd13666, 19'd13667, 19'd13668, 19'd13690, 19'd13691, 19'd13692, 19'd13702, 19'd13703, 19'd13704, 19'd13720, 19'd13721, 19'd13722, 19'd13732, 19'd13733, 19'd13734, 19'd13738, 19'd13739, 19'd13740, 19'd13754, 19'd13755, 19'd13756, 19'd13760, 19'd13761, 19'd13762, 19'd13763, 19'd13764, 19'd13765, 19'd13766, 19'd13767, 19'd13768, 19'd13769, 19'd13770, 19'd13771, 19'd13772, 19'd13773, 19'd13774, 19'd13778, 19'd13779, 19'd13780, 19'd13802, 19'd13803, 19'd13804, 19'd13814, 19'd13815, 19'd13816, 19'd13832, 19'd13833, 19'd13834, 19'd13835, 19'd13836, 19'd13837, 19'd13838, 19'd13839, 19'd13840, 19'd13841, 19'd14268, 19'd14269, 19'd14270, 19'd14271, 19'd14272, 19'd14273, 19'd14274, 19'd14275, 19'd14276, 19'd14277, 19'd14278, 19'd14279, 19'd14280, 19'd14281, 19'd14282, 19'd14286, 19'd14287, 19'd14288, 19'd14289, 19'd14290, 19'd14291, 19'd14292, 19'd14305, 19'd14306, 19'd14307, 19'd14308, 19'd14309, 19'd14310, 19'd14311, 19'd14312, 19'd14313, 19'd14314, 19'd14329, 19'd14330, 19'd14331, 19'd14341, 19'd14342, 19'd14343, 19'd14359, 19'd14360, 19'd14361, 19'd14362, 19'd14363, 19'd14364, 19'd14365, 19'd14366, 19'd14367, 19'd14368, 19'd14369, 19'd14370, 19'd14371, 19'd14372, 19'd14373, 19'd14377, 19'd14378, 19'd14379, 19'd14393, 19'd14394, 19'd14395, 19'd14399, 19'd14400, 19'd14401, 19'd14402, 19'd14403, 19'd14404, 19'd14405, 19'd14406, 19'd14407, 19'd14408, 19'd14409, 19'd14410, 19'd14411, 19'd14412, 19'd14413, 19'd14417, 19'd14418, 19'd14419, 19'd14420, 19'd14421, 19'd14422, 19'd14423, 19'd14424, 19'd14425, 19'd14426, 19'd14427, 19'd14428, 19'd14429, 19'd14430, 19'd14431, 19'd14441, 19'd14442, 19'd14443, 19'd14453, 19'd14454, 19'd14455, 19'd14456, 19'd14457, 19'd14458, 19'd14459, 19'd14460, 19'd14461, 19'd14462, 19'd14471, 19'd14472, 19'd14473, 19'd14474, 19'd14475, 19'd14476, 19'd14477, 19'd14478, 19'd14907, 19'd14908, 19'd14909, 19'd14910, 19'd14911, 19'd14912, 19'd14913, 19'd14914, 19'd14915, 19'd14916, 19'd14917, 19'd14918, 19'd14919, 19'd14920, 19'd14921, 19'd14925, 19'd14926, 19'd14927, 19'd14928, 19'd14929, 19'd14930, 19'd14944, 19'd14945, 19'd14946, 19'd14947, 19'd14948, 19'd14949, 19'd14950, 19'd14951, 19'd14952, 19'd14953, 19'd14968, 19'd14969, 19'd14970, 19'd14980, 19'd14981, 19'd14982, 19'd14998, 19'd14999, 19'd15000, 19'd15001, 19'd15002, 19'd15003, 19'd15004, 19'd15005, 19'd15006, 19'd15007, 19'd15008, 19'd15009, 19'd15010, 19'd15011, 19'd15012, 19'd15016, 19'd15017, 19'd15018, 19'd15032, 19'd15033, 19'd15034, 19'd15038, 19'd15039, 19'd15040, 19'd15050, 19'd15051, 19'd15052, 19'd15056, 19'd15057, 19'd15058, 19'd15059, 19'd15060, 19'd15061, 19'd15062, 19'd15063, 19'd15064, 19'd15065, 19'd15066, 19'd15067, 19'd15068, 19'd15069, 19'd15070, 19'd15080, 19'd15081, 19'd15082, 19'd15092, 19'd15093, 19'd15094, 19'd15095, 19'd15096, 19'd15097, 19'd15098, 19'd15099, 19'd15100, 19'd15101, 19'd15110, 19'd15111, 19'd15112, 19'd15546, 19'd15547, 19'd15548, 19'd15549, 19'd15550, 19'd15551, 19'd15552, 19'd15553, 19'd15554, 19'd15555, 19'd15556, 19'd15557, 19'd15558, 19'd15559, 19'd15560, 19'd15564, 19'd15565, 19'd15566, 19'd15567, 19'd15568, 19'd15569, 19'd15570, 19'd15583, 19'd15584, 19'd15585, 19'd15586, 19'd15587, 19'd15588, 19'd15589, 19'd15590, 19'd15591, 19'd15592, 19'd15607, 19'd15608, 19'd15609, 19'd15619, 19'd15620, 19'd15621, 19'd15637, 19'd15638, 19'd15639, 19'd15640, 19'd15641, 19'd15642, 19'd15643, 19'd15644, 19'd15645, 19'd15646, 19'd15647, 19'd15648, 19'd15649, 19'd15650, 19'd15651, 19'd15655, 19'd15656, 19'd15657, 19'd15671, 19'd15672, 19'd15673, 19'd15677, 19'd15678, 19'd15679, 19'd15689, 19'd15690, 19'd15691, 19'd15695, 19'd15696, 19'd15697, 19'd15698, 19'd15699, 19'd15700, 19'd15701, 19'd15702, 19'd15703, 19'd15704, 19'd15705, 19'd15706, 19'd15707, 19'd15708, 19'd15709, 19'd15719, 19'd15720, 19'd15721, 19'd15731, 19'd15732, 19'd15733, 19'd15734, 19'd15735, 19'd15736, 19'd15737, 19'd15738, 19'd15739, 19'd15740, 19'd15749, 19'd15750, 19'd15751, 19'd15752, 19'd16197, 19'd16198, 19'd16199, 19'd16203, 19'd16204, 19'd16205, 19'd16207, 19'd16208, 19'd16209, 19'd16210, 19'd16222, 19'd16223, 19'd16224, 19'd16246, 19'd16247, 19'd16248, 19'd16258, 19'd16259, 19'd16260, 19'd16276, 19'd16277, 19'd16278, 19'd16288, 19'd16289, 19'd16290, 19'd16294, 19'd16295, 19'd16296, 19'd16310, 19'd16311, 19'd16312, 19'd16316, 19'd16317, 19'd16318, 19'd16328, 19'd16329, 19'd16330, 19'd16346, 19'd16347, 19'd16348, 19'd16358, 19'd16359, 19'd16360, 19'd16370, 19'd16371, 19'd16372, 19'd16388, 19'd16389, 19'd16390, 19'd16391, 19'd16392, 19'd16836, 19'd16837, 19'd16838, 19'd16842, 19'd16843, 19'd16844, 19'd16847, 19'd16848, 19'd16849, 19'd16850, 19'd16861, 19'd16862, 19'd16863, 19'd16885, 19'd16886, 19'd16887, 19'd16897, 19'd16898, 19'd16899, 19'd16915, 19'd16916, 19'd16917, 19'd16927, 19'd16928, 19'd16929, 19'd16933, 19'd16934, 19'd16935, 19'd16949, 19'd16950, 19'd16951, 19'd16955, 19'd16956, 19'd16957, 19'd16967, 19'd16968, 19'd16969, 19'd16985, 19'd16986, 19'd16987, 19'd16997, 19'd16998, 19'd16999, 19'd17009, 19'd17010, 19'd17011, 19'd17027, 19'd17028, 19'd17029, 19'd17030, 19'd17031, 19'd17032, 19'd17475, 19'd17476, 19'd17477, 19'd17481, 19'd17482, 19'd17483, 19'd17487, 19'd17488, 19'd17489, 19'd17490, 19'd17500, 19'd17501, 19'd17502, 19'd17524, 19'd17525, 19'd17526, 19'd17536, 19'd17537, 19'd17538, 19'd17554, 19'd17555, 19'd17556, 19'd17566, 19'd17567, 19'd17568, 19'd17572, 19'd17573, 19'd17574, 19'd17588, 19'd17589, 19'd17590, 19'd17594, 19'd17595, 19'd17596, 19'd17606, 19'd17607, 19'd17608, 19'd17624, 19'd17625, 19'd17626, 19'd17636, 19'd17637, 19'd17638, 19'd17648, 19'd17649, 19'd17650, 19'd17666, 19'd17667, 19'd17668, 19'd17669, 19'd17670, 19'd17671, 19'd17672, 19'd18114, 19'd18115, 19'd18116, 19'd18120, 19'd18121, 19'd18122, 19'd18127, 19'd18128, 19'd18129, 19'd18130, 19'd18139, 19'd18140, 19'd18141, 19'd18163, 19'd18164, 19'd18165, 19'd18175, 19'd18176, 19'd18177, 19'd18193, 19'd18194, 19'd18195, 19'd18205, 19'd18206, 19'd18207, 19'd18211, 19'd18212, 19'd18213, 19'd18227, 19'd18228, 19'd18229, 19'd18233, 19'd18234, 19'd18235, 19'd18245, 19'd18246, 19'd18247, 19'd18263, 19'd18264, 19'd18265, 19'd18275, 19'd18276, 19'd18277, 19'd18287, 19'd18288, 19'd18289, 19'd18305, 19'd18306, 19'd18307, 19'd18309, 19'd18310, 19'd18311, 19'd18312, 19'd18753, 19'd18754, 19'd18755, 19'd18759, 19'd18760, 19'd18761, 19'd18767, 19'd18768, 19'd18769, 19'd18770, 19'd18778, 19'd18779, 19'd18780, 19'd18802, 19'd18803, 19'd18804, 19'd18814, 19'd18815, 19'd18816, 19'd18832, 19'd18833, 19'd18834, 19'd18844, 19'd18845, 19'd18846, 19'd18850, 19'd18851, 19'd18852, 19'd18866, 19'd18867, 19'd18868, 19'd18872, 19'd18873, 19'd18874, 19'd18884, 19'd18885, 19'd18886, 19'd18902, 19'd18903, 19'd18904, 19'd18914, 19'd18915, 19'd18916, 19'd18926, 19'd18927, 19'd18928, 19'd18944, 19'd18945, 19'd18946, 19'd18949, 19'd18950, 19'd18951, 19'd18952, 19'd19392, 19'd19393, 19'd19394, 19'd19398, 19'd19399, 19'd19400, 19'd19407, 19'd19408, 19'd19409, 19'd19410, 19'd19417, 19'd19418, 19'd19419, 19'd19441, 19'd19442, 19'd19443, 19'd19453, 19'd19454, 19'd19455, 19'd19471, 19'd19472, 19'd19473, 19'd19483, 19'd19484, 19'd19485, 19'd19489, 19'd19490, 19'd19491, 19'd19505, 19'd19506, 19'd19507, 19'd19511, 19'd19512, 19'd19513, 19'd19523, 19'd19524, 19'd19525, 19'd19541, 19'd19542, 19'd19543, 19'd19553, 19'd19554, 19'd19555, 19'd19565, 19'd19566, 19'd19567, 19'd19583, 19'd19584, 19'd19585, 19'd19589, 19'd19590, 19'd19591, 19'd19592, 19'd20031, 19'd20032, 19'd20033, 19'd20037, 19'd20038, 19'd20039, 19'd20047, 19'd20048, 19'd20049, 19'd20050, 19'd20056, 19'd20057, 19'd20058, 19'd20080, 19'd20081, 19'd20082, 19'd20092, 19'd20093, 19'd20094, 19'd20110, 19'd20111, 19'd20112, 19'd20122, 19'd20123, 19'd20124, 19'd20128, 19'd20129, 19'd20130, 19'd20144, 19'd20145, 19'd20146, 19'd20150, 19'd20151, 19'd20152, 19'd20162, 19'd20163, 19'd20164, 19'd20180, 19'd20181, 19'd20182, 19'd20192, 19'd20193, 19'd20194, 19'd20204, 19'd20205, 19'd20206, 19'd20222, 19'd20223, 19'd20224, 19'd20229, 19'd20230, 19'd20231, 19'd20232, 19'd20670, 19'd20671, 19'd20672, 19'd20676, 19'd20677, 19'd20678, 19'd20687, 19'd20688, 19'd20689, 19'd20690, 19'd20695, 19'd20696, 19'd20697, 19'd20719, 19'd20720, 19'd20721, 19'd20731, 19'd20732, 19'd20733, 19'd20749, 19'd20750, 19'd20751, 19'd20761, 19'd20762, 19'd20763, 19'd20767, 19'd20768, 19'd20769, 19'd20783, 19'd20784, 19'd20785, 19'd20789, 19'd20790, 19'd20791, 19'd20801, 19'd20802, 19'd20803, 19'd20819, 19'd20820, 19'd20821, 19'd20831, 19'd20832, 19'd20833, 19'd20843, 19'd20844, 19'd20845, 19'd20861, 19'd20862, 19'd20863, 19'd20869, 19'd20870, 19'd20871, 19'd20872, 19'd21309, 19'd21310, 19'd21311, 19'd21315, 19'd21316, 19'd21317, 19'd21327, 19'd21328, 19'd21329, 19'd21330, 19'd21334, 19'd21335, 19'd21336, 19'd21358, 19'd21359, 19'd21360, 19'd21370, 19'd21371, 19'd21372, 19'd21388, 19'd21389, 19'd21390, 19'd21400, 19'd21401, 19'd21402, 19'd21406, 19'd21407, 19'd21408, 19'd21422, 19'd21423, 19'd21424, 19'd21428, 19'd21429, 19'd21430, 19'd21440, 19'd21441, 19'd21442, 19'd21458, 19'd21459, 19'd21460, 19'd21470, 19'd21471, 19'd21472, 19'd21482, 19'd21483, 19'd21484, 19'd21500, 19'd21501, 19'd21502, 19'd21509, 19'd21510, 19'd21511, 19'd21512, 19'd21948, 19'd21949, 19'd21950, 19'd21954, 19'd21955, 19'd21956, 19'd21967, 19'd21968, 19'd21969, 19'd21973, 19'd21974, 19'd21975, 19'd21997, 19'd21998, 19'd21999, 19'd22009, 19'd22010, 19'd22011, 19'd22027, 19'd22028, 19'd22029, 19'd22039, 19'd22040, 19'd22041, 19'd22045, 19'd22046, 19'd22047, 19'd22061, 19'd22062, 19'd22063, 19'd22067, 19'd22068, 19'd22069, 19'd22079, 19'd22080, 19'd22081, 19'd22097, 19'd22098, 19'd22099, 19'd22109, 19'd22110, 19'd22111, 19'd22121, 19'd22122, 19'd22123, 19'd22139, 19'd22140, 19'd22141, 19'd22149, 19'd22150, 19'd22151, 19'd22152, 19'd22575, 19'd22576, 19'd22577, 19'd22578, 19'd22579, 19'd22580, 19'd22581, 19'd22582, 19'd22583, 19'd22584, 19'd22585, 19'd22586, 19'd22587, 19'd22588, 19'd22589, 19'd22593, 19'd22594, 19'd22595, 19'd22607, 19'd22608, 19'd22612, 19'd22613, 19'd22614, 19'd22615, 19'd22616, 19'd22617, 19'd22618, 19'd22619, 19'd22620, 19'd22621, 19'd22622, 19'd22623, 19'd22624, 19'd22625, 19'd22626, 19'd22636, 19'd22637, 19'd22638, 19'd22648, 19'd22649, 19'd22650, 19'd22651, 19'd22652, 19'd22653, 19'd22654, 19'd22655, 19'd22656, 19'd22657, 19'd22658, 19'd22659, 19'd22660, 19'd22661, 19'd22662, 19'd22666, 19'd22667, 19'd22668, 19'd22678, 19'd22679, 19'd22680, 19'd22684, 19'd22685, 19'd22686, 19'd22700, 19'd22701, 19'd22702, 19'd22706, 19'd22707, 19'd22708, 19'd22718, 19'd22719, 19'd22720, 19'd22724, 19'd22725, 19'd22726, 19'd22727, 19'd22728, 19'd22729, 19'd22730, 19'd22731, 19'd22732, 19'd22733, 19'd22734, 19'd22735, 19'd22736, 19'd22737, 19'd22738, 19'd22748, 19'd22749, 19'd22750, 19'd22760, 19'd22761, 19'd22762, 19'd22763, 19'd22764, 19'd22765, 19'd22766, 19'd22767, 19'd22768, 19'd22769, 19'd22770, 19'd22771, 19'd22772, 19'd22773, 19'd22774, 19'd22778, 19'd22779, 19'd22780, 19'd22789, 19'd22790, 19'd22791, 19'd22792, 19'd23214, 19'd23215, 19'd23216, 19'd23217, 19'd23218, 19'd23219, 19'd23220, 19'd23221, 19'd23222, 19'd23223, 19'd23224, 19'd23225, 19'd23226, 19'd23227, 19'd23228, 19'd23232, 19'd23233, 19'd23234, 19'd23247, 19'd23251, 19'd23252, 19'd23253, 19'd23254, 19'd23255, 19'd23256, 19'd23257, 19'd23258, 19'd23259, 19'd23260, 19'd23261, 19'd23262, 19'd23263, 19'd23264, 19'd23265, 19'd23275, 19'd23276, 19'd23277, 19'd23287, 19'd23288, 19'd23289, 19'd23290, 19'd23291, 19'd23292, 19'd23293, 19'd23294, 19'd23295, 19'd23296, 19'd23297, 19'd23298, 19'd23299, 19'd23300, 19'd23301, 19'd23305, 19'd23306, 19'd23307, 19'd23317, 19'd23318, 19'd23319, 19'd23323, 19'd23324, 19'd23325, 19'd23339, 19'd23340, 19'd23341, 19'd23345, 19'd23346, 19'd23347, 19'd23357, 19'd23358, 19'd23359, 19'd23363, 19'd23364, 19'd23365, 19'd23366, 19'd23367, 19'd23368, 19'd23369, 19'd23370, 19'd23371, 19'd23372, 19'd23373, 19'd23374, 19'd23375, 19'd23376, 19'd23377, 19'd23387, 19'd23388, 19'd23389, 19'd23399, 19'd23400, 19'd23401, 19'd23402, 19'd23403, 19'd23404, 19'd23405, 19'd23406, 19'd23407, 19'd23408, 19'd23409, 19'd23410, 19'd23411, 19'd23412, 19'd23413, 19'd23417, 19'd23418, 19'd23419, 19'd23429, 19'd23430, 19'd23431, 19'd23853, 19'd23854, 19'd23855, 19'd23856, 19'd23857, 19'd23858, 19'd23859, 19'd23860, 19'd23861, 19'd23862, 19'd23863, 19'd23864, 19'd23865, 19'd23866, 19'd23867, 19'd23871, 19'd23872, 19'd23873, 19'd23890, 19'd23891, 19'd23892, 19'd23893, 19'd23894, 19'd23895, 19'd23896, 19'd23897, 19'd23898, 19'd23899, 19'd23900, 19'd23901, 19'd23902, 19'd23903, 19'd23904, 19'd23914, 19'd23915, 19'd23916, 19'd23926, 19'd23927, 19'd23928, 19'd23929, 19'd23930, 19'd23931, 19'd23932, 19'd23933, 19'd23934, 19'd23935, 19'd23936, 19'd23937, 19'd23938, 19'd23939, 19'd23940, 19'd23944, 19'd23945, 19'd23946, 19'd23956, 19'd23957, 19'd23958, 19'd23962, 19'd23963, 19'd23964, 19'd23978, 19'd23979, 19'd23980, 19'd23984, 19'd23985, 19'd23986, 19'd23996, 19'd23997, 19'd23998, 19'd24002, 19'd24003, 19'd24004, 19'd24005, 19'd24006, 19'd24007, 19'd24008, 19'd24009, 19'd24010, 19'd24011, 19'd24012, 19'd24013, 19'd24014, 19'd24015, 19'd24016, 19'd24026, 19'd24027, 19'd24028, 19'd24038, 19'd24039, 19'd24040, 19'd24041, 19'd24042, 19'd24043, 19'd24044, 19'd24045, 19'd24046, 19'd24047, 19'd24048, 19'd24049, 19'd24050, 19'd24051, 19'd24052, 19'd24056, 19'd24057, 19'd24058, 19'd24069, 19'd24070}; 



// Designing the FSM for this model
//function [SIZE-1:0] fsm_function;
//	input []

// Taking the y_pos and x_pos from the software
   always_ff @(posedge clk) begin
     if (reset == 1) begin
	ball_h <= 32'h40;
	ball_v <= 32'h40; //figure out value
     end else if (chipselect && write) begin
       case (address)
	 3'h0 : ball_h <= writedata;
	 3'h1 : ball_v <= writedata;
      endcase
    end
    else if (chipselect && read) begin
	case (address)
	  
	  3'h2 : readdata <= {29'h0,pixel_out};
	endcase
    end
  end
	assign web = 0;

// Keeping write enable signal only when our coordinates are within the writing area
// Assume for now the writing coordinate are within ball_v > 50 and ball_h > 90
//   assign wea = flag ? ((ball_h > 'h50 && ball_v > 'h50) ? 1 :0)
//		      : 1;

   assign wea = flag ? (clear_screen ? 1 : ((ball_h > 80 && ball_h < 631 && ball_v > 80 && ball_v < 471) ? 1 :0))
		      : 1;
// Implement the clear screen functionality
// When there is tap on the top right corner, the writing area is cleared
// Add a clearscreen button - To Be Done
//assign clear_screen = flag ? ((ball_h > 597 && ball_h < 640 && ball_v > 12 && ball_v < 36) ? ~clear_screen : 0): 0;

	// Setting the clear_screen indication
	always @ (ball_h, ball_v, flag)
	begin	
		if(flag)
		begin
			if(ball_h > 580 && ball_h < 660 && ball_v > 12 && ball_v < 36)
				clear_screen = 1;
			else if(clear_done)
				clear_screen = 0;
		end
		else
			clear_screen = 0;
	end

assign clear_done = (clear_h == 635 && clear_v == 475) ? 1 : 0;

   // To keep assigning the addresses for clearing the sketching area
  assign clear_addr = clear_screen ? (clear_v * 639) + clear_h : 0;

   always_ff @ (posedge clk)
   begin
	if(reset) begin
	  clear_v <= 78;
	  clear_h <= 78;
	end
	else 
	begin
	  if(clear_screen) 
	  begin
		if(clear_h == 635 && clear_v == 475) begin
	  	  clear_v <= 78;
	  	  clear_h <= 78;
		end
		else if(clear_h == 635) 
		begin
		  if(clear_v == 475)
		  	clear_v <= 78;
		  else
			clear_v <= clear_v + 1;
		  clear_h <= 78;
		end
		else
 		  clear_h <= clear_h + 1;
	  end
	end
   end


// Take the track positions and convert to RAM address
assign addr_track = ((ball_v*639) + ball_h);
//assign addr_track = (ball_v * 639) + (ball_h);
  always @ (pixel_out)
  begin
    // Logic to decode from 3 pixel bits to 24 bits
    case (pixel_out)
      // RED Color
      3'b001 : begin // SKETCHMASTER, BOX 4
  	VGA_R = 8'hFF;
  	VGA_G = 8'h00;
  	VGA_B = 8'h00;
      end
      // Yellow
      3'b010 : begin // BOX 1
  	VGA_R = 8'hFF;
  	VGA_G = 8'hFF;
  	VGA_B = 8'h00;
      end
      // Pink
      3'b011 : begin // BOX 2
  	VGA_R = 8'h00;
  	VGA_G = 8'hFF;
  	VGA_B = 8'hFF;
      end
      // Cyan
      3'b100 : begin // BOX 3
  	VGA_R = 8'hFF;
  	VGA_G = 8'h00;
  	VGA_B = 8'hFF;
      end
      // Blue
      3'b101 : begin // BOX 5
  	VGA_R = 8'h00;
  	VGA_G = 8'h00;
  	VGA_B = 8'hFF;
      end
      // Green
      3'b110 : begin // BOX 6
  	VGA_R = 8'h00;
  	VGA_G = 8'hFF;
  	VGA_B = 8'h00;
      end
      // Black
      3'b111 : begin // 
  	VGA_R = 8'hFF;
  	VGA_G = 8'hFF;
  	VGA_B = 8'hFF;
      end
      // White
      3'b000 : begin // BOX 7
  	VGA_R = 8'h00;
	VGA_G = 8'h00;
	VGA_B = 8'h00;
      end
      // Black
      default : begin
  	VGA_R = 8'hFF;
  	VGA_G = 8'hFF;
  	VGA_B = 8'hFF;
      end
    endcase
  end

always_ff @ (posedge clk) begin
	if(reset)
		read_flag <= 0;
	else if(read && (~read_done))
		read_flag <= 1;
	else if(read_done)
		read_flag <= 0;
end


   always_ff @ (posedge clk)
   begin
	if(reset) begin
	  read_v <= 0;
	  read_h <= 0;
	end
	else 
	begin
	  if(read_flag) 
	  begin
		if(read_h == 639 && read_v == 479) begin
	  	  read_v <= 0;
	  	  read_h <= 0;
		end
		else if(read_h == 639) 
		begin
		  if(read_v == 479)
		  	read_v <= 0;
		  else
			read_v <= read_v + 1;
		  read_h <= 0;
		end
		else
 		  read_h <= read_h + 1;
	  end
	end
   end

assign read_addr = (read_v * 479) + read_h;

assign read_done = (clear_h == 635 && clear_v == 475) ? 1 : 0;

assign 	addr_b = web ? (read_flag ? read_addr : 19'h0) : vcount * 639 + hcount[10:1];

always_ff @ (posedge clk) begin
	addr_b_del <= addr_b;
	addr_b_del2 <= addr_b_del;
end


always_ff @ (posedge clk) begin
	addr_a_del <= addr_a;
	addr_a_del2 <= addr_a_del;
end


	// Display the Header and the Color Options 
	always_ff @ (posedge clk) begin
	  if(reset == 1) begin
	    temp_count <= 0;
	    flag <= 0;
	    heading_color <= 3'h7;
	    //ball_h <= 32'hA0;
	    //ball_v <= 32'hF0;
	  end
	  else if(temp_count >= 9308) begin
	    temp_count <= 0;
	    flag <= 1;
	    heading_color <= 3'h0;
	    //ball_h <= ball_h + 1;
	    //ball_v <= ball_v + 1;
	  end
	  else if(flag == 0 && temp_count <= 2498) begin // Sketchmaster, csee 4840 2499
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h1;
	  end
	  else if(flag == 0 && temp_count <= 3128) begin // BOX 1 630 values
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h2;
	  end
	  else if(flag == 0 && temp_count <= 3758) begin // 630 box 2
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h3;
	  end
	  else if(flag == 0 && temp_count <= 4388) begin // 630 box 3
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h4;
	  end
	  else if(flag == 0 && temp_count <= 5018) begin // 630 box 4
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h1;
	  end
	  else if(flag == 0 && temp_count <= 5648) begin // 630 box 5
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h5;
	  end
	  else if(flag == 0 && temp_count <= 6278) begin // 630 box 6
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h6;
	  end
	  else if(flag == 0 && temp_count <= 6908) begin // 630 box 7
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h7;
	  end
	  else if(flag == 0 && temp_count <= 7172) begin // ERASE 264 values
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h7;
	  end
	  else if(flag == 0 && temp_count <= 7373) begin // Clear print 201 values
	    temp_count <= temp_count + 1;
	    heading_color <= 3'h7;
	  end
	  else if(flag == 0 && temp_count <= 9307) begin // 967+967
	   temp_count <= temp_count + 1;
	   heading_color <= 3'h1;
	  end
	end


	// FSM to indicate the draw color
	always_ff @(posedge clk)
	begin
		if(reset)
			draw_color_state <= color8;
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 80 && ball_v <= 100) // choose color1
			draw_color_state <= color1; // then go to state edge.
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 130 && ball_v <= 150) // choose color2
			draw_color_state <= color2; // then go to state edge.
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 180 && ball_v <= 200) // choose color3
			draw_color_state <= color3; // then go to state edge.
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 230 && ball_v <= 250) // choose color4
			draw_color_state <= color4; // then go to state edge.
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 280 && ball_v <= 300) // choose color5
			draw_color_state <= color5; // then go to state edge.
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 330 && ball_v <= 350) // choose color6
			draw_color_state <= color6; // then go to state edge.
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 380 && ball_v <= 400) // choose color7
			draw_color_state <= color7; // then go to state edge.
		else if(flag == 1 && ball_h >= 30 && ball_h <= 60 && ball_v >= 430 && ball_v <= 450) // choose color8
			draw_color_state <= color8; //
		else
			draw_color_state <= draw_color_state;  
	end


	//Choosing the Pen color
	always @ (draw_color_state, ball_h, ball_v, flag) begin
	  case(draw_color_state)
		color1:
			draw_color = 3'h2;
		color2:
			draw_color = 3'h3;
		color3:
			draw_color = 3'h4;
		color4:
			draw_color = 3'h1;
		color5:
			draw_color = 3'h5;
		color6:
			draw_color = 3'h6;
		color7:
			draw_color = 3'h7;
		color8:
			draw_color = 3'h0;
		default :
			draw_color = 3'h7;
	  endcase
	end



// this is to print different colors on the screen
assign addr_a = flag ?  (clear_screen ? clear_addr[18:0] : addr_track[18:0]) : temp_addr[temp_count];
//assign addr_a = temp_addr[temp_count];

assign pixel = flag ? (clear_screen ? 3'b000 : draw_color) :  heading_color;
//assign pixel = heading_color;

dpbram dpram1(
	.clk(clk),
	.data_a(pixel), 
	.data_b(19'b0),
	.addr_a(addr_a_del),
	.addr_b(addr_b+1),
	.wea(wea), 
	.web(web),
  	.out_a(),
	.out_b(pixel_out)
	);


endmodule


module vga_counters(
 input logic 	     clk50, reset,
 output logic [10:0] hcount,  // hcount[10:1] is pixel column
 output logic [9:0]  vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) &
		      !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   
endmodule
// DUAL Port BRAM infer
// Port A used for writing based on the software pins 
// Port B used for reading the BRAM and sending to the VGA
module dpbram(
	input logic clk,			// Clock signal
	input logic [2:0] data_a, data_b,	// Data in forport a and port b
	input logic [18:0] addr_a,addr_b,	// Address for port a and port b
	input logic wea, web,			// Write enable for port a and port b
	output logic [2:0] out_a, out_b
	);

	logic [2:0] mem [307199:0]; // To store the data

	// Port A 
	always_ff @(posedge clk) begin
	  if (wea) begin
	    mem[addr_a] <= data_a;
	      out_a <= data_a;
	  end 
	  else 
	    out_a <= mem[data_a];
	  end
	
	// Port B
	always_ff @(posedge clk) begin
	  if (web) begin
	    mem[addr_b] <= data_b;
	    out_b <= data_b;
	  end 
          else out_b <= mem[addr_b];
	end
endmodule


