/*
 * Userspace program that communicates with the vga_ball device driver
 * through ioctls
 *
 * Rahul Shanbhag
 * Columbia University
 */

#include <stdio.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>



//File Write
#include <ctype.h>
#include <stddef.h>
#include <time.h>
#include "bitmap.h"

#include "wacom_hid_driver.h"
#include <hidapi.h>



// Preprocessor Macros
#define PIXEL_BUFFER_SIZE 218276//100000
#define MIN_DIFF 20
#define MAX_X 6190 //((0x30 << 7) | 0x2f)
#define MAX_Y 4700 //((0x24 << 7) | 0x77)


int vga_ball_fd;

//Read and print the the value of one pixel
void print_pixel_value() {
  vga_ball_arg_t vla;
  
  if (ioctl(vga_ball_fd, VGA_BALL_READ_PIXEL, &vla)) {
      perror("ioctl(VGA_BALL_READ_PIXEL) failed");
      return;
  }
  printf("%0x \n", vla.pixel_read);
}


// set the postion of the stylus
void set_position(vga_ball_pos_t *pos)
{
  vga_ball_arg_t vla;
  vla.position = *pos;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_POSITION, &vla)) {
      perror("ioctl(VGA_BALL_WRITE_POSITION) failed");
      return;
  }
}

int BRUSH_RADIUS = 2;

// set the position of the brush
void set_brush_position(vga_ball_pos_t *pos)
{
	int x, y;
	vga_ball_arg_t vla;
	vla.position = *pos;
	for (x = (pos->x - BRUSH_RADIUS); x <= (pos->x + BRUSH_RADIUS); x++)
	{
		for (y = (pos->y - BRUSH_RADIUS); y<= (pos->y + BRUSH_RADIUS); y++)
		{
			if ((x - pos->x)*(x - pos->x) + (y - pos->y)*(y - pos->y) <= BRUSH_RADIUS*BRUSH_RADIUS)
			{
				vla.position.x = x;
				vla.position.y = y;
				if (ioctl(vga_ball_fd, VGA_BALL_WRITE_POSITION, &vla)) 
				{
					perror("ioctl(VGA_BALL_WRITE_POSITION) failed");
					return;
				}
			}
		}
	}
  	
}

// read pixel data from the BRAM and save it in buffer
void get_pixel_value(unsigned int *pixel_array, int index)
{
	vga_ball_arg_t vla;
	
	if (ioctl(vga_ball_fd, VGA_BALL_READ_PIXEL, &vla)) {
		//printf("here\n");
      perror("ioctl(VGA_BALL_READ_PIXEL) failed");
      return;
  	}
	pixel_array[index] = vla.pixel_read;
}

// write to file
void write_to_file(unsigned int *pixel_array)
{
	printf("\n here");
	FILE *fp;
	fp = fopen("pixel.txt", "w"); // write to file log_data.txt
	if (fp == NULL)
		printf("invalid file pointer");
	for (int i = 0; i < PIXEL_BUFFER_SIZE; i++)
		fprintf(fp, "%d ", pixel_array[i]);
	fclose(fp);
}

// providing delay of nanoseconds
void sleep_nanoseconds(long nanoseconds) 
{
	struct timespec sleep_time;
	sleep_time.tv_sec = 0;
	sleep_time.tv_nsec = nanoseconds;

	nanosleep(&sleep_time, NULL);
}

int main(int argc, char* argv[])
{
    // HIDAPI
    (void)argc;
	(void)argv;
    int res;
	unsigned char buf[256];
	#define MAX_STR 255
	wchar_t wstr[MAX_STR];
	hid_device *handle;
	int i;

    struct hid_device_info *devs;

	if (wacom_hid_init())
		return -1;


	devs = wacom_hid_enumerate(0x0, 0x0);
	print_devices_with_descriptor(devs);
	wacom_hid_free_enumeration(devs);

	// Set up the command buffer.
	memset(buf,0x00,sizeof(buf));
	buf[0] = 0x01;
	buf[1] = 0x81;

    // Open the device using the VID, PID,
	// and optionally the Serial number.
	////handle = hid_open(0x4d8, 0x3f, L"12345");
	handle = wacom_hid_open(0x056a, 0x0038, NULL);
	if (!handle) {
		printf("unable to open device\n");
		wacom_hid_exit();
 		return 1;
	}

	// Read the Manufacturer String
	wstr[0] = 0x0000;
	res = wacom_hid_get_manufacturer_string(handle, wstr, MAX_STR);
	if (res < 0)
		printf("Unable to read manufacturer string\n");
	printf("Manufacturer String: %ls\n", wstr);

    // Read the Product String
	wstr[0] = 0x0000;
	res = wacom_hid_get_product_string(handle, wstr, MAX_STR);
	if (res < 0)
		printf("Unable to read product string\n");
	printf("Product String: %ls\n", wstr);

	// Read the Serial Number String
	wstr[0] = 0x0000;
	res = wacom_hid_get_serial_number_string(handle, wstr, MAX_STR);
	if (res < 0)
		printf("Unable to read serial number string\n");
	printf("Serial Number String: (%d) %ls\n", wstr[0], wstr);

	print_hid_report_descriptor_from_device(handle);

	struct hid_device_info* info = wacom_hid_get_device_info(handle);
	if (info == NULL) {
		printf("Unable to get device info\n");
	} else {
		print_devices(info);
	}

    // Read Indexed String 1
	wstr[0] = 0x0000;
	res = wacom_hid_get_indexed_string(handle, 1, wstr, MAX_STR);
	if (res < 0)
		printf("Unable to read indexed string 1\n");
	printf("Indexed String 1: %ls\n", wstr);

	// Set the hid_read() function to be non-blocking.
	wacom_hid_set_nonblocking(handle, 1);

	// Try to read from the device. There should be no
	// data here, but execution should not block.
	res = wacom_hid_read(handle, buf, 17);

	// Send a Feature Report to the device
	buf[0] = 0x2;
	buf[1] = 0x2;
	buf[2] = 0x2;
	//buf[3] = 0x00;
	//buf[4] = 0x00;
	res = wacom_hid_send_feature_report(handle, buf, 3);
	if (res < 0) {
		printf("Unable to send a feature report.\n");
	}

    memset(buf,0,sizeof(buf));

	// Read a Feature Report from the device
	buf[0] = 0x2;
	res = wacom_hid_get_feature_report(handle, buf, sizeof(buf));
	if (res < 0) {
		printf("Unable to get a feature report\n");
	}
	else {
		// Print out the returned buffer.
		printf("Feature Report\n   ");
		for (i = 0; i < res; i++)
			printf("%02x ", (unsigned int) buf[i]);
		printf("\n");
	}

	memset(buf,0,sizeof(buf));

    res = 0;
	i = 0;

  vga_ball_arg_t vla;
  vga_ball_pos_t stylus;

  static const char filename[] = "/dev/vga_ball";


  printf("SketchMaster Userspace program started\n");

  if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  int downscaled_x = 0;
  int downscaled_y = 0;
  unsigned int temp_buf[8];
  unsigned char pkt_buf[256];
  memset(pkt_buf, 0x00, sizeof(pkt_buf));
  unsigned int concatenated_x_pos;
  unsigned int concatenated_y_pos;

  struct pixel_pos
  {
	unsigned int x;
	unsigned int y;
  };


//#define MAX_DIFF 8
  int count = 0;
  struct pixel_pos previous_pixel;
  previous_pixel.x = 0;
  previous_pixel.y = 0;
  struct pixel_pos current_pixel;
  float angle = 0;
  int x_index, y_index;
   while (1) 
   {
		res = wacom_hid_read(handle, pkt_buf, sizeof(pkt_buf));
		if (res < 0) 
		{
			printf("Unable to read()\n");
			break;
		}
		
		if (res > 0) 
		{
			count++;	
			//when upper button pressed and screen not touched
			if (((unsigned int) pkt_buf[1] == 0xe8) && ((unsigned int) pkt_buf[4] == 0x10))
			{
				
				// Save as  bitmap
				/*printf("Printing pixel data \n");
				unsigned int pixel_data[PIXEL_BUFFER_SIZE];
				memset(pixel_data, 2, PIXEL_BUFFER_SIZE);
				
				for (int i = 0; i < PIXEL_BUFFER_SIZE; i++)
				{
					get_pixel_value(pixel_data, i);
					//printf("%d ", pixel_data[i]);
					//usleep(0.05);
					//sleep_nanoseconds(30);
				}
				//create_bitmap_file(pixel_data, PIXEL_BUFFER_SIZE);
				write_to_file(pixel_data);
				return 0;*/
				
				// increase brush size
				if (BRUSH_RADIUS >= 1 && BRUSH_RADIUS < 10)
				{
					BRUSH_RADIUS++;
					printf("Increasing brush size \n");
				}
				printf("Brush Size is: %d \n", BRUSH_RADIUS);

				usleep(500000);
				continue;
			}
			//when upper button pressed and screen not touched
			else if ((unsigned int) pkt_buf[1] == 0xe8 && ((unsigned int) pkt_buf[4] == 0x20))
			{
				// decrease brush size
				if (BRUSH_RADIUS > 1 && BRUSH_RADIUS <= 10)
				{
					BRUSH_RADIUS--;
					printf("Decreasing brush size \n");
				}
				printf("Brush Size is: %d \n", BRUSH_RADIUS);

				usleep(500000);
				continue;

			}
			// screen pressed hard
			else if ((unsigned int) pkt_buf[1] == 0xe8 )//&& (unsigned int) pkt_buf[4] >= 0x4c)
			{
				for (i = 0; i < res; i++) 
				{
					temp_buf[i] = pkt_buf[i];
				        //printf("%02x ", temp_buf[i]);
				}
				
				// convert absolute pixel positions to VGA resolution positions
				concatenated_x_pos = temp_buf[2] << 7 | (temp_buf[3]);
				downscaled_x = (unsigned int)((float)(concatenated_x_pos * 639.0) / MAX_X);
				concatenated_y_pos = temp_buf[5] << 7 | (temp_buf[6]);
				downscaled_y = (unsigned int)((float)(concatenated_y_pos * 479.0)/ MAX_Y);


				// Line tool Logic
				/*
				if (count == 1)
				{
					previous_pixel.x = downscaled_x;
					previous_pixel.y = downscaled_y;
				}
				current_pixel.x = downscaled_x;
				current_pixel.y = downscaled_y;
				
				int diff_pixel_x = current_pixel.x - previous_pixel.x;
				int diff_pixel_y = current_pixel.y - previous_pixel.y;
				
				
				/*if (pkt_buf[4] == 0x6c)
				{
					if ((diff_pixel_x > MIN_DIFF || diff_pixel_x < -MIN_DIFF) && (diff_pixel_y > MIN_DIFF || diff_pixel_y < -MIN_DIFF))
					{
						// checking for missing pixel_x values
						if (abs(diff_pixel_x) > MIN_DIFF && abs(diff_pixel_y) > MIN_DIFF)
						{
							printf("%d %d\n", diff_pixel_x, diff_pixel_y);
							x_index = 0;
							y_index = 0;
							
							while (x_index < diff_pixel_x && y_index < diff_pixel_y)
							{
								if (diff_pixel_x > diff_pixel_y)
								{
									angle = diff_pixel_x/diff_pixel_y;
									stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
									stylus.y = previous_pixel.y + y_index;
								}
								else if (diff_pixel_x < diff_pixel_y)
								{
									angle = diff_pixel_y/diff_pixel_x;
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
								}
								else
								{
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + y_index;
								}
								//printf("%d %d\n", stylus.x, stylus.y);
								set_brush_position(&stylus);
								if (x_index < diff_pixel_x)
									x_index++;
								if (y_index < diff_pixel_y)
									y_index++;
							}
						}
						else if (diff_pixel_x < -MIN_DIFF && diff_pixel_y < -MIN_DIFF)
						{
							printf("%d %d\n", diff_pixel_x, diff_pixel_y);
							x_index = 0;
							y_index = 0;
							while (x_index > diff_pixel_x && y_index > diff_pixel_y)
							{
								if (-diff_pixel_x > -diff_pixel_y)
								{
									angle = (-diff_pixel_x)/(-diff_pixel_y);
									stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
									stylus.y = previous_pixel.y + y_index;
								}
								else if (-diff_pixel_x < -diff_pixel_y)
								{
									angle = diff_pixel_y/diff_pixel_x;
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
								}
								else
								{
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + y_index;
								}
								
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + y_index;
								//printf("%d %d\n", stylus.x, stylus.y);
								set_brush_position(&stylus);
								x_index--;
								y_index--;
							}
						}
						else if (diff_pixel_x > MIN_DIFF && diff_pixel_y < -MIN_DIFF)
						{
							printf("%d %d\n", diff_pixel_x, diff_pixel_y);
							x_index = 0;
							y_index = 0;
							while (x_index < diff_pixel_x && y_index > diff_pixel_y)
							{
								if (diff_pixel_x > -diff_pixel_y)
								{
									angle = diff_pixel_x/(-diff_pixel_y);
									stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
									stylus.y = previous_pixel.y + y_index;
								}
								else if (diff_pixel_x < -diff_pixel_y)
								{
									angle = (-diff_pixel_y)/diff_pixel_x;
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
								}
								else
								{
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + y_index;
								}
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + y_index;
								//printf("%d %d\n", stylus.x, stylus.y);
								set_brush_position(&stylus);
								x_index++;
								y_index--;
							}
						}
						else if (diff_pixel_x < -MIN_DIFF && diff_pixel_y > MIN_DIFF)
						{
							printf("%d %d\n", diff_pixel_x, diff_pixel_y);
							x_index = 0;
							y_index = 0;
							while (x_index > diff_pixel_x && y_index < diff_pixel_y)
							{
								if (-diff_pixel_x > diff_pixel_y)
								{
									angle = (-diff_pixel_x)/diff_pixel_y;
									stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
									stylus.y = previous_pixel.y + y_index;
								}
								else if (diff_pixel_x < diff_pixel_y)
								{
									angle = diff_pixel_y/(-diff_pixel_x);
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
								}
								else
								{
									stylus.x = previous_pixel.x + x_index;
									stylus.y = previous_pixel.y + y_index;
								}
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + y_index;
								//printf("%d %d\n", stylus.x, stylus.y);
								set_position(&stylus);
								x_index--;
								y_index++;
							}
						}
					}
				}*/
				/*if ((diff_pixel_x > MIN_DIFF || diff_pixel_x < -MIN_DIFF) && (diff_pixel_y > MIN_DIFF || diff_pixel_y < -MIN_DIFF))
				{
					// checking for missing pixel_x values
					if (diff_pixel_x > MIN_DIFF && diff_pixel_y > MIN_DIFF)
					{
						printf("%d %d\n", diff_pixel_x, diff_pixel_y);
						x_index = 0;
						y_index = 0;
						
						while (x_index < diff_pixel_x && y_index < diff_pixel_y)
						{
							if (diff_pixel_x > diff_pixel_y)
							{
								angle = diff_pixel_x/diff_pixel_y;
								stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
								stylus.y = previous_pixel.y + y_index;
							}
							else if (diff_pixel_x < diff_pixel_y)
							{
								angle = diff_pixel_y/diff_pixel_x;
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
							}
							else
							{
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + y_index;
							}
							//printf("%d %d\n", stylus.x, stylus.y);
							set_brush_position(&stylus);
							if (x_index < diff_pixel_x)
								x_index++;
							if (y_index < diff_pixel_y)
								y_index++;
						}
					}
					else if (diff_pixel_x < -MIN_DIFF && diff_pixel_y < -MIN_DIFF)
					{
						printf("%d %d\n", diff_pixel_x, diff_pixel_y);
						x_index = 0;
						y_index = 0;
						while (x_index > diff_pixel_x && y_index > diff_pixel_y)
						{
							if (-diff_pixel_x > -diff_pixel_y)
							{
								angle = (-diff_pixel_x)/(-diff_pixel_y);
								stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
								stylus.y = previous_pixel.y + y_index;
							}
							else if (-diff_pixel_x < -diff_pixel_y)
							{
								angle = diff_pixel_y/diff_pixel_x;
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
							}
							else
							{
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + y_index;
							}
							
							stylus.x = previous_pixel.x + x_index;
							stylus.y = previous_pixel.y + y_index;
							//printf("%d %d\n", stylus.x, stylus.y);
							set_brush_position(&stylus);
							x_index--;
							y_index--;
						}
					}
					else if (diff_pixel_x > MIN_DIFF && diff_pixel_y < -MIN_DIFF)
					{
						printf("%d %d\n", diff_pixel_x, diff_pixel_y);
						x_index = 0;
						y_index = 0;
						while (x_index < diff_pixel_x && y_index > diff_pixel_y)
						{
							if (diff_pixel_x > -diff_pixel_y)
							{
								angle = diff_pixel_x/(-diff_pixel_y);
								stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
								stylus.y = previous_pixel.y + y_index;
							}
							else if (diff_pixel_x < -diff_pixel_y)
							{
								angle = (-diff_pixel_y)/diff_pixel_x;
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
							}
							else
							{
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + y_index;
							}
							stylus.x = previous_pixel.x + x_index;
							stylus.y = previous_pixel.y + y_index;
							//printf("%d %d\n", stylus.x, stylus.y);
							set_brush_position(&stylus);
							x_index++;
							y_index--;
						}
					}
					else if (diff_pixel_x < -MIN_DIFF && diff_pixel_y > MIN_DIFF)
					{
						printf("%d %d\n", diff_pixel_x, diff_pixel_y);
						x_index = 0;
						y_index = 0;
						while (x_index > diff_pixel_x && y_index < diff_pixel_y)
						{
							if (-diff_pixel_x > diff_pixel_y)
							{
								angle = (-diff_pixel_x)/diff_pixel_y;
								stylus.x = previous_pixel.x + (unsigned int) (float)(x_index*angle);
								stylus.y = previous_pixel.y + y_index;
							}
							else if (diff_pixel_x < diff_pixel_y)
							{
								angle = diff_pixel_y/(-diff_pixel_x);
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + (unsigned int) (float)(y_index*angle);
							}
							else
							{
								stylus.x = previous_pixel.x + x_index;
								stylus.y = previous_pixel.y + y_index;
							}
							stylus.x = previous_pixel.x + x_index;
							stylus.y = previous_pixel.y + y_index;
							//printf("%d %d\n", stylus.x, stylus.y);
							set_position(&stylus);
							x_index--;
							y_index++;
						}
					}
				}*/
				/*else
				{
					if (diff_pixel_x > MIN_DIFF || diff_pixel_x < -MIN_DIFF)
					{
						if (diff_pixel_x > MIN_DIFF)
						{
							for (int k = 0; k < diff_pixel_x; k++)
							{
								stylus.x = previous_pixel.x + k;
								stylus.y = previous_pixel.y;
								//printf("%d %d\n", stylus.x, stylus.y);
								set_position(&stylus);
							}
						}
						else if (diff_pixel_x < -MIN_DIFF)
						{
							for (int k = 0; k > diff_pixel_x; k--)
							{
								stylus.x = previous_pixel.x + k;
								stylus.y = previous_pixel.y;
								//printf("%d %d\n", stylus.x, stylus.y);
								set_position(&stylus);
							}
						}
					}
					else if (diff_pixel_y > MIN_DIFF || diff_pixel_y < -MIN_DIFF)
					{
						// checking for missing pixel_x values
						if (diff_pixel_y > MIN_DIFF)
						{
							for (int k = 0; k < diff_pixel_y; k++)
							{
								stylus.x = previous_pixel.x;
								stylus.y = previous_pixel.y + k;
								//printf("%d %d\n", stylus.x, stylus.y);
								set_position(&stylus);
							}
						}
						else if (diff_pixel_y < -MIN_DIFF)
						{
							for (int k = 0; k > diff_pixel_y; k--)
							{
								stylus.x = previous_pixel.x;
								stylus.y = previous_pixel.y + k;
								//printf("%d %d\n", stylus.x, stylus.y);
								set_position(&stylus);
							}
						}
					}	
					else
					{
						stylus.x = downscaled_x;
						stylus.y = downscaled_y;
						//printf("%d %d\n", stylus.x, stylus.y);
						set_position(&stylus);
					}
				}*/
				/*
				previous_pixel.x = current_pixel.x;
				previous_pixel.y = current_pixel.y;
				*/

				stylus.x = downscaled_x;
				stylus.y = downscaled_y;
				if (BRUSH_RADIUS > 1)
					set_brush_position(&stylus);
				else
					set_position(&stylus);
			}

			// stylus lifted
			else if ((unsigned int) pkt_buf[1] == 0xa0 && (unsigned int) pkt_buf[3] == 0x00)
			{
				count = 0;
			}
						
		}
		usleep(10);
	}
  
  printf("SketchMaster Userspace program terminating\n");
  return 0;
}
