/*
 * Avalon memory-mapped peripheral that generates VGA
 *
 * Stephen A. Edwards
 * Columbia University
 */

module vga_ball(input logic        clk,
	        input logic 	   reset,
		input logic [15:0]  writedata,
		input logic 	   write,
		input 		   chipselect,
		input logic [5:0]  address,   //2:0

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n);

   logic [10:0]	   hcount;
   logic [9:0]     vcount;

   logic [7:0] 	   background_r, background_g, background_b;
   
  

   logic [10:0]     bg_x, note_x_1, note_x_2, note_x_3, note_x_4, note_x_5, note_x_6, note_x_7, note_x_8;
   logic [10:0]     note_x_9, note_x_10, note_x_11, note_x_12, note_x_13, note_x_14, note_x_15, note_x_16;
   logic [9:0]      bg_y, note_y_0;
	
   logic [7:0]  ball_num;

   //logic [10:0]   bg_x = 
   //logic [9:0]   bg_y = 10;
   logic drawing, page;
   logic [10:0] address_sprite1, address_sprite2, address_sprite3, indicater1, indicater2, indicater3, indicater4;
   logic [15:0] address_bg, score;
   logic [23:0] pix_out;
   //logic enable_sprite;
   logic [23:0] out_sprite1, interlogic1, out_sprite2, interlogic2, out_sprite3, interlogic3, interbg;
   vga_counters counters(.clk50(clk), .*);
   sprite_rom_7 sprite1(.clk(clk), .rst(reset), .vcount(vcount), .hcount(hcount), 
                        .note_x_1(note_x_1), .note_x_2(note_x_2), .note_x_3(note_x_3), .note_x_4(note_x_4), 
                        .note_x_5(note_x_5), .note_x_6(note_x_6), .note_x_7(note_x_7), .note_x_8(note_x_8), 
                        .note_x_9(note_x_9), .note_x_10(note_x_10), .note_x_11(note_x_11), .note_x_12(note_x_12), 
                        .note_x_13(note_x_13), .note_x_14(note_x_14), .note_x_15(note_x_15), .note_x_16(note_x_16),
                        .indicater1(indicater1), .indicater2(indicater2), .indicater3(indicater3), .indicater4(indicater4), .score(score), .page(page),
                        .drawing(drawing), .pix_out(pix_out));
   //note_blue tile1(.address(address_sprite1),.clock(clk),.q(out_sprite1));
   //note_blue tile2(.address(address_sprite2),.clock(clk),.q(out_sprite2));
   //note_blue tile3(.address(address_sprite3),.clock(clk),.q(out_sprite3));
   //background bg1(.address(address_bg),.clock(clk),.q(out_bg));
    always_ff @(posedge clk) begin
      if (reset) begin
        background_r <= 8'h00;
        background_g <= 8'h00;
        background_b <= 8'h00;
        bg_x <= 1;
        bg_y <= 1;
        note_x_1  <= 160;
        note_x_2  <= 160;
        note_x_3  <= 160;
        note_x_4  <= 160;
        note_x_5  <= 260;
        note_x_6  <= 260;
        note_x_7  <= 260;
        note_x_8  <= 260;
        note_x_9  <= 360;
        note_x_10 <= 360;
        note_x_11 <= 360;
        note_x_12 <= 360;
        note_x_13 <= 460;
        note_x_14 <= 460;
        note_x_15 <= 460;
        note_x_16 <= 460;
        //note_y_0 <= 30;
        indicater1 <= 2;
        indicater2 <= 2;
        indicater3 <= 2;
        indicater4 <= 2;
        page <= 0;
        score <= 0;

  
      end else if (chipselect && write)
        case (address)
        //0`15: note, 16:19 hitmark, 20:23 good or bad; 
          6'h0  : note_x_1  <= writedata[15:0];
          6'h1  : note_x_2  <= writedata[15:0];
          6'h2  : note_x_3  <= writedata[15:0];
          6'h3  : note_x_4  <= writedata[15:0];
          6'h4  : note_x_5  <= writedata[15:0];
          6'h5  : note_x_6  <= writedata[15:0];
          6'h6  : note_x_7  <= writedata[15:0];
          6'h7  : note_x_8  <= writedata[15:0];
          6'h8  : note_x_9  <= writedata[15:0];
          6'h9  : note_x_10 <= writedata[15:0];
          6'ha : note_x_11 <= writedata[15:0];
          6'hb : note_x_12 <= writedata[15:0];
          6'hc : note_x_13 <= writedata[15:0];
          6'hd : note_x_14 <= writedata[15:0];
          6'he : note_x_15 <= writedata[15:0];
          6'hf : note_x_16 <= writedata[15:0];
          6'h10: indicater1 <= writedata[15:0];
          6'h11: indicater2 <= writedata[15:0];
          6'h12: indicater3 <= writedata[15:0];
          6'h13: indicater4 <= writedata[15:0];
          6'h14: page <= writedata[0];
          6'h15: score <= writedata[15:0];


          //4'h3 : note_x <=  writedata[10:0];  //new
          //4'h4 : note_y <=  writedata[9:0];  //new

          //4'h8 : ball_num <= writedata[7:0];
          //3'h5 : ball_y_MSB <=  writedata;  //new
          //3'h6 : ball_y_LSB <=  writedata;  //new
        endcase
    
    end
    
    always_comb begin
      {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
      if (VGA_BLANK_n )
      /*
      	if (hcount[10:0] == ball_x && vcount[9:0] == ball_y)  //hcount[10:6] == 5'd3 vcount[9:5] == 5'd3
	          {VGA_R, VGA_G, VGA_B} = {ball_r, ball_g, ball_b}; //changed
      */
        if (drawing)begin
             {VGA_R, VGA_G, VGA_B} = pix_out;
        end
	      else begin
                   //enable_sprite = 0;
	          {VGA_R, VGA_G, VGA_B} ={background_r, background_g, background_b};
              end
    end
    
	  //assign ball_x = {ball_x_MSB[2:0], ball_x_LSB[7:0]};
    //assign ball_y = {ball_y_MSB[1:0], ball_y_LSB[7:0]};
endmodule  //vga_ball


module vga_counters(
 input logic 	     clk50, reset,
 output logic [10:0] hcount,  // hcount[10:1] is pixel column
 output logic [9:0]  vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) &
		      !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   
endmodule


