module sprite_rom_6 (     //可以让bg横着，横轴纵轴个放大两倍+多个note 可实现全16个note，实现另外的note   + final line note
    input  wire logic clk,                            // clock
    input  wire logic rst,                            // reset
    input  logic [9:0]     vcount, 
    input  logic [10:0]	   hcount, note_x_1, note_x_2, note_x_3, note_x_4, 
    input  logic [10:0]	   note_x_5, note_x_6, note_x_7, note_x_8,
    input  logic [10:0]	   note_x_9, note_x_10, note_x_11, note_x_12,
    input  logic [10:0]	   note_x_13, note_x_14, note_x_15, note_x_16, indicater1, indicater2, indicater3, indicater4,
    output logic drawing,
    output logic  [23:0]   pix_out                        // drawing at position (sx,sy)
    );
    //parameter a = 323(vertical), AA = 382(horizantal,x2ed), b = 18, BB = 156;
    //parameter a = 191, AA = 1292, b = 78, BB = 36;
    //parameter a = 382, AA = 1292, b = 78, BB = 36, bg_x = 1, bg_y = 1;
    parameter a = 382, AA = 1292, b = 36, BB = 24, bg_x = 1, bg_y = 1; //原note_blue的width36 = b，height12 = BB（图片property）
    parameter note_y_1 = 110, note_y_2 = 174, note_y_3 = 238, note_y_4 = 302;
    parameter note_y_5 = 110, note_y_6 = 174, note_y_7 = 238, note_y_8 = 302;
    parameter note_y_9 = 110, note_y_10 = 174, note_y_11 = 238, note_y_12 = 302;
    parameter note_y_13 = 110, note_y_14 = 174, note_y_15 = 238, note_y_16 = 302;
    //--------indicater
    parameter hm = 30, HMM = 60, ind = 35, INDD = 50;
    parameter hm_x = 1105, hm_y_1 = 112, hm_y_2 =176, hm_y_3 = 240, hm_y_4 = 304;
    parameter indi_x = 1045, indi_y_1 = 110, indi_y_2 = 174, indi_y_3 = 238, indi_y_4 = 302;
    parameter finalline_x = 1108, finalline_y = 110, FLL = 38, fl = 53;  //wid53 hei 19
    //--------indicater
    logic line_active, line_end, bg_active, note_active, frame_finish;
    logic indicater_active, mark_active, finalline_active;
    logic [10:0] address_note, address_hitind, address_missind, address_hitmark;
    logic [9:0] address_finalline;
    logic [15:0] address_bg;
    logic [23:0] out_bg, out_note, interbuffer, out_hitind, out_hitmark, out_missind, out_finalline;
    //logic [23:0] out_note5, out_note6, out_note7, out_note8;
    //logic [23:0] out_note9, out_note10, out_note11, out_note12;
    //logic [23:0] out_note13, out_note14, out_note15, out_note16;

    // sprite state machine
    enum {
        IDLE,      // screen
        WAIT,
        DRAW_BG,
        DRAW_NOTE,
        RESET,
        INDICATER,
        DRAW_FINAL,
        MARK
    } state;

    note_blue tile1(.address(address_note),.clock(clk),.q(out_note));
    background bg(.address(address_bg),.clock(clk),.q(out_bg));
    hit_indicater hitind(.address(address_hitind),.clock(clk),.q(out_hitind));
    hit_mark hitmark(.address(address_hitmark),.clock(clk),.q(out_hitmark));
    miss_indicater missind(.address(address_missind),.clock(clk),.q(out_missind));
    note_red line(.address(address_finalline),.clock(clk),.q(out_finalline));

    always_comb begin
        line_active = ((vcount - note_y_1 >= 0)&&(vcount - note_y_1 <= b-1)) || 
                      ((vcount - note_y_2 >= 0)&&(vcount - note_y_2 <= b-1)) || 
                      ((vcount - note_y_3 >= 0)&&(vcount - note_y_3 <= b-1)) || 
                      ((vcount - note_y_4 >= 0)&&(vcount - note_y_4 <= b-1)) || 
                      ((vcount - note_y_5 >= 0)&&(vcount - note_y_5 <= b-1)) || 
                      ((vcount - note_y_6 >= 0)&&(vcount - note_y_6 <= b-1)) || 
                      ((vcount - note_y_7 >= 0)&&(vcount - note_y_7 <= b-1)) || 
                      ((vcount - note_y_8 >= 0)&&(vcount - note_y_8 <= b-1)) || 
                      ((vcount - note_y_9 >= 0)&&(vcount - note_y_9 <= b-1)) || 
                      ((vcount - note_y_10 >= 0)&&(vcount - note_y_10 <= b-1)) || 
                      ((vcount - note_y_11 >= 0)&&(vcount - note_y_11 <= b-1)) || 
                      ((vcount - note_y_12 >= 0)&&(vcount - note_y_12 <= b-1)) || 
                      ((vcount - note_y_13 >= 0)&&(vcount - note_y_13 <= b-1)) || 
                      ((vcount - note_y_14 >= 0)&&(vcount - note_y_14 <= b-1)) || 
                      ((vcount - note_y_15 >= 0)&&(vcount - note_y_15 <= b-1)) || 
                      ((vcount - note_y_16 >= 0)&&(vcount - note_y_16 <= b-1)) || 
                      ((vcount - bg_y >= 0)&&(vcount - bg_y <= a-1));//多个note的code
        line_end = hcount >= 1260;
        bg_active  = hcount >= bg_x && hcount <= bg_x + AA - 1;
        note_active  =  (hcount >= note_x_1 && hcount <= note_x_1 + BB - 1 && vcount - note_y_1 >= 0 && vcount - note_y_1 <= b-1) || 
                        (hcount >= note_x_2 && hcount <= note_x_2 + BB - 1 && vcount - note_y_2 >= 0 && vcount - note_y_2 <= b-1) || 
                        (hcount >= note_x_3 && hcount <= note_x_3 + BB - 1 && vcount - note_y_3 >= 0 && vcount - note_y_3 <= b-1) || 
                        (hcount >= note_x_4 && hcount <= note_x_4 + BB - 1 && vcount - note_y_4 >= 0 && vcount - note_y_4 <= b-1) ||
                        (hcount >= note_x_5 && hcount <= note_x_5 + BB - 1 && vcount - note_y_5 >= 0 && vcount - note_y_5 <= b-1) || 
                        (hcount >= note_x_6 && hcount <= note_x_6 + BB - 1 && vcount - note_y_6 >= 0 && vcount - note_y_6 <= b-1) || 
                        (hcount >= note_x_7 && hcount <= note_x_7 + BB - 1 && vcount - note_y_7 >= 0 && vcount - note_y_7 <= b-1) || 
                        (hcount >= note_x_8 && hcount <= note_x_8 + BB - 1 && vcount - note_y_8 >= 0 && vcount - note_y_8 <= b-1) ||
                        (hcount >= note_x_9 && hcount <= note_x_9 + BB - 1 && vcount - note_y_9 >= 0 && vcount - note_y_9 <= b-1) || 
                        (hcount >= note_x_10 && hcount <= note_x_10 + BB - 1 && vcount - note_y_10 >= 0 && vcount - note_y_10 <= b-1) || 
                        (hcount >= note_x_11 && hcount <= note_x_11 + BB - 1 && vcount - note_y_11 >= 0 && vcount - note_y_11 <= b-1) || 
                        (hcount >= note_x_12 && hcount <= note_x_12 + BB - 1 && vcount - note_y_12 >= 0 && vcount - note_y_12 <= b-1) ||
                        (hcount >= note_x_13 && hcount <= note_x_13 + BB - 1 && vcount - note_y_13 >= 0 && vcount - note_y_13 <= b-1) || 
                        (hcount >= note_x_14 && hcount <= note_x_14 + BB - 1 && vcount - note_y_14 >= 0 && vcount - note_y_14 <= b-1) || 
                        (hcount >= note_x_15 && hcount <= note_x_15 + BB - 1 && vcount - note_y_15 >= 0 && vcount - note_y_15 <= b-1) || 
                        (hcount >= note_x_16 && hcount <= note_x_16 + BB - 1 && vcount - note_y_16 >= 0 && vcount - note_y_16 <= b-1);
        frame_finish = hcount == 1255 && vcount == 475;
        indicater_active = ((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_1 >= 0 && vcount - indi_y_1 <= ind-1)&&(indicater1==2||indicater1==3||indicater1==4))||
                           ((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_2 >= 0 && vcount - indi_y_2 <= ind-1)&&(indicater2==2||indicater2==3||indicater2==4))||
                           ((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_3 >= 0 && vcount - indi_y_3 <= ind-1)&&(indicater3==2||indicater3==3||indicater3==4))||
                           ((hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_4 >= 0 && vcount - indi_y_4 <= ind-1)&&(indicater4==2||indicater4==3||indicater4==4));

        mark_active = ((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_1 >= 0 && vcount - hm_y_1 <= hm-1)&&(indicater1==1||indicater1==2||indicater1==3))||
                      ((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_2 >= 0 && vcount - hm_y_2 <= hm-1)&&(indicater2==1||indicater2==2||indicater2==3))||
                      ((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_3 >= 0 && vcount - hm_y_3 <= hm-1)&&(indicater3==1||indicater3==2||indicater3==3))||
                      ((hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_4 >= 0 && vcount - hm_y_4 <= hm-1)&&(indicater4==1||indicater4==2||indicater4==3));

        finalline_active = hcount >= finalline_x && hcount <= finalline_x + 2*FLL - 1 && vcount - finalline_y >= 0 && vcount - finalline_y <= 4*fl-1;
    end

    always_ff @(posedge clk) begin
        if (rst) begin  // prepare for new line
            state <= IDLE;
            pix_out <= 0;
            drawing <= 0;
            address_bg <= 0;
            address_note <= 0;
        end else begin
            case (state)
                IDLE:begin
                    if(line_active)begin
                        state <= WAIT;
                    end else begin
                        state <= IDLE;
                    end
                end
                RESET: begin
                    state <= IDLE;
                    pix_out <= 0;
                    drawing <= 0;
                    address_bg <= 0;
                    address_note <= 0; 
                end
                WAIT:begin
                    if(frame_finish) state <= RESET;
                    else begin
                        if(line_end) state <= IDLE;
                        else begin
                            if(note_active) begin
				                state <= DRAW_NOTE;
			                end
                            else if(bg_active)begin
                                state <= DRAW_BG;
                            end
                        end
                    end
                    pix_out <= 0;
                    drawing <= 0;
                end
                DRAW_BG:begin
                    if(finalline_active && !note_active && !mark_active)begin
                        state <= DRAW_FINAL;
                    end
                    else begin
                        if(!indicater_active && !mark_active)begin
                            if(note_active) state <= DRAW_NOTE;
                            else  begin
			                    if (!bg_active) state <= WAIT;
			                    else state <= DRAW_BG;
                            end
                        end
                        else if(indicater_active && !mark_active)begin
                              state <= INDICATER;
                        end
                        else if(!indicater_active && mark_active)begin
                            state <= MARK;
                        end
                    end
                    address_bg = (190 - ((vcount - bg_y)>>1)) + (((hcount - bg_x)>>2)*191);
                    drawing = 1;
                    pix_out = out_bg;
                end
                DRAW_NOTE:begin
                    if(!indicater_active && !mark_active)begin
                        if(!note_active && !finalline_active)begin
                            state <= bg_active ? DRAW_BG : WAIT;
                        end
                        else if(!note_active && finalline_active)begin
                            state <= DRAW_FINAL;
                        end
                        else begin
                             state <= DRAW_NOTE;
                        end
                        // if(!note_active)begin
                        //     state <= bg_active ? DRAW_BG : WAIT;
                        // end
                        // else begin
                        //     state <= DRAW_NOTE;
                        // end
                    end
                    else if(indicater_active && !mark_active)begin
                          state <= INDICATER;
                    end
                    else if(!indicater_active && mark_active)begin
                          state <= MARK;
                    end
                    if(hcount >= note_x_1 && hcount <= note_x_1 + BB - 1 && vcount - note_y_1 >= 0 && vcount - note_y_1 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_1)) + (((hcount - note_x_1)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_2 && hcount <= note_x_2 + BB - 1 && vcount - note_y_2 >= 0 && vcount - note_y_2 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_2)) + (((hcount - note_x_2)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_3 && hcount <= note_x_3 + BB - 1 && vcount - note_y_3 >= 0 && vcount - note_y_3 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_3)) + (((hcount - note_x_3)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_4 && hcount <= note_x_4 + BB - 1 && vcount - note_y_4 >= 0 && vcount - note_y_4 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_4)) + (((hcount - note_x_4)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_5 && hcount <= note_x_5 + BB - 1 && vcount - note_y_5 >= 0 && vcount - note_y_5 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_5)) + (((hcount - note_x_5)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_6 && hcount <= note_x_6 + BB - 1 && vcount - note_y_6 >= 0 && vcount - note_y_6 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_6)) + (((hcount - note_x_6)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_7 && hcount <= note_x_7 + BB - 1 && vcount - note_y_7 >= 0 && vcount - note_y_7 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_7)) + (((hcount - note_x_7)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_8 && hcount <= note_x_8 + BB - 1 && vcount - note_y_8 >= 0 && vcount - note_y_8 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_8)) + (((hcount - note_x_8)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_9 && hcount <= note_x_9 + BB - 1 && vcount - note_y_9 >= 0 && vcount - note_y_9 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_9)) + (((hcount - note_x_9)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_10 && hcount <= note_x_10 + BB - 1 && vcount - note_y_10 >= 0 && vcount - note_y_10 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_10)) + (((hcount - note_x_10)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_11 && hcount <= note_x_11 + BB - 1 && vcount - note_y_11 >= 0 && vcount - note_y_11 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_11)) + (((hcount - note_x_11)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_12 && hcount <= note_x_12 + BB - 1 && vcount - note_y_12 >= 0 && vcount - note_y_12 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_12)) + (((hcount - note_x_12)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_13 && hcount <= note_x_13 + BB - 1 && vcount - note_y_13 >= 0 && vcount - note_y_13 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_13)) + (((hcount - note_x_13)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_14 && hcount <= note_x_14 + BB - 1 && vcount - note_y_14 >= 0 && vcount - note_y_14 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_14)) + (((hcount - note_x_14)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_15 && hcount <= note_x_15 + BB - 1 && vcount - note_y_15 >= 0 && vcount - note_y_15 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_15)) + (((hcount - note_x_15)>>1)*b);
                          pix_out = out_note;
                    end
                    else if(hcount >= note_x_16 && hcount <= note_x_16 + BB - 1 && vcount - note_y_16 >= 0 && vcount - note_y_16 <= b-1)begin
                          address_note = (b - 1 - (vcount - note_y_16)) + (((hcount - note_x_16)>>1)*b);
                          pix_out = out_note;
                    end
                    drawing = 1;
                end
                INDICATER:begin
                    if(indicater_active)begin
                        state <= INDICATER;
                    end
                    else begin
                        if(note_active)begin
                            state <= DRAW_NOTE;
                        end
                        else state <= DRAW_BG;
                    end
                    if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_1 >= 0 && vcount - indi_y_1 <= ind-1)begin
                        if(indicater1==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_1)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_1)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    else if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_2 >= 0 && vcount - indi_y_2 <= ind-1)begin
                        if(indicater2==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_2)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_2)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    else if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_3 >= 0 && vcount - indi_y_3 <= ind-1)begin
                        if(indicater3==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_3)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_3)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    else if(hcount >= indi_x && hcount <= indi_x + INDD - 1 && vcount - indi_y_4 >= 0 && vcount - indi_y_4 <= ind-1)begin
                        if(indicater4==2)begin
                            address_hitind = (ind - 1 - (vcount - indi_y_4)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_hitind;
                        end
                        else begin   //||indicater1==3||indicater1==4
                            address_missind = (ind - 1 - (vcount - indi_y_4)) + (((hcount - indi_x)>>1)*ind);
                            pix_out = out_missind;
                        end
                    end
                    drawing = 1;
                end
                MARK:begin
                    if(mark_active)begin
                        state <= MARK;
                    end
                    else begin
                        if(note_active)begin
                            state <= DRAW_NOTE;
                        end
                        else if(!note_active && finalline_active)begin
                            state <= DRAW_FINAL;
                        end
                        else state <= DRAW_BG;
                    end
                    if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_1 >= 0 && vcount - hm_y_1 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_1)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    else if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_2 >= 0 && vcount - hm_y_2 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_2)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    else if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_3 >= 0 && vcount - hm_y_3 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_3)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    else if(hcount >= hm_x && hcount <= hm_x + HMM - 1 && vcount - hm_y_4 >= 0 && vcount - hm_y_4 <= hm-1)begin
                            address_hitmark = (hm - 1 - (vcount - hm_y_4)) + (((hcount - hm_x)>>1)*hm);
                            pix_out = out_hitmark;
                    end
                    drawing = 1;
                end

                DRAW_FINAL:begin
                    if(!note_active && !mark_active && finalline_active)begin
                        state <= DRAW_FINAL;
                    end
                    else if(note_active && !mark_active)begin
                        state <= DRAW_NOTE;
                    end
                    else if(mark_active)begin
                        state <= MARK;
                    end
                    else state <= DRAW_BG;
                    address_finalline = (fl - 1 - ((vcount - finalline_y)>>2)) + (((hcount - finalline_x)>>2)*fl);
                    drawing = 1;
                    pix_out = out_finalline;
                end
                default: state <= IDLE;
            endcase
        end
    end

endmodule
