// Client side implementation of UDP client-server model
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include "cam_vga.h"
	
#define SERVER_IP "128.59.149.136" // replace with server IP address    
#define PORT	 1337
#define BUFFER_SIZE 640*480 + 1 
#define READ_PIXELS 640*480 // read 640x480 pixels in YUV422 format

void read_frame(char* buf, int cam_fd)
{
	/*for (int i = 0; i < READ_PIXELS; ++i) {

		unsigned int info;

		if (ioctl(cam_fd, cam_vga_READ_INFO, &info)) {
			perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
			return;
		}
		buf[i] = i / 1204;
	}*/

	unsigned int info;
	unsigned int address, prev_addr = READ_PIXELS + 2;
	unsigned char pixel;
	unsigned int first_frame = 1;
	while(1){

		if (ioctl(cam_fd, cam_vga_READ_INFO, &info)) {
			perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
			return;
		}

		address = info >> 8;
		pixel = (info & 0xFF);

		if(address != prev_addr){
			if (address < 20)
				first_frame = 0;

			if (!first_frame) {
				buf[address] = pixel;
				prev_addr = address;
			}
		}

		if (!first_frame && address > READ_PIXELS - 10)
			break;

	}
}
	
// Driver code
int main() {
	int sockfd;
	char buffer[BUFFER_SIZE] = {0};
	//char *hello = "Hello from client";
	struct sockaddr_in server_addr, client_addr;
	
	// Creating socket file descriptor
	if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) {
		perror("socket creation failed");
		exit(EXIT_FAILURE);
	}
	
	memset(&server_addr, 0, sizeof(server_addr));
    memset(&client_addr, 0, sizeof(client_addr));
		
	// Filling server information
	server_addr.sin_family = AF_INET;
	server_addr.sin_port = htons(PORT);
	server_addr.sin_addr.s_addr = inet_addr(SERVER_IP);
    //server_addr.sin_addr.s_addr = INADDR_ANY;

    // open camera SCCB interface
    // Figure out driver stuff
     /*
        TODO
    */
    int cam_fd = 0; 
    /*
    if (ioctl(cam_fd, CAM_READ_FRAME, &vla)) {
      perror("ioctl(CAM_READ_FRAME) failed");
      return;
  }
    //cam_fd = open("/dev/i2c-1", O_RDWR); // /dev/i2c-1 is just a placeholder
    if (cam_fd < 0)
    {
        perror("Failed to open camera SCCB interface");
        exit(1);
    }
    */

    // === get FPGA addresses ==================
    // Open /dev/mem
	if( ( cam_fd = open( "/dev/cam_vga", ( O_RDWR | O_SYNC ) ) ) == -1 ) 	{
		printf( "ERROR: could not open \"/dev/cam_vga\"...\n" );
		return( 1 );
	}

		
	int n, len;
	int udp_iteration = READ_PIXELS / 508 + 1; //sending 508 bytes for udp_iteration amount of times
    while(1)
    {
        // read video frame from camera and store it in buffer
        usleep(6000);
        read_frame(buffer, cam_fd);
    	
        // send 508 bytes else when reaching the end send the remaining amount which is 368 bytes.
	    for(int i = 0; i < udp_iteration; i++)
	    	if (udp_iteration - 1 != i){
			    sendto(sockfd, (char *) (buffer + i * 508), 508,
				    0, (const struct sockaddr *) &server_addr,
					    sizeof(server_addr));
	    	}
	    	
	    	else {
	    		sendto(sockfd, (char *) (buffer + i * 508), 368,
				    0, (const struct sockaddr *) &server_addr,
					    sizeof(server_addr));
	    	}
	    

	    /*for(int i = 0; i < udp_iteration; i++){
	    	if (udp_iteration - 1 != i){
			    send(sockfd, (char *) (buffer + i * 508), 508, 0);
	    	}
	    	
	    	else {
	    		send(sockfd, (char *) (buffer + i * 508), 368, 0);
	    	}
	    }*/
	    
	    printf("Frame sent.\n");
	    for(int i = 0; i < READ_PIXELS; i++){
	    	buffer[i] = 0;
	    }
        // wait for a short time before reading next video frame
        usleep(60000);
    }		

    close(cam_fd);
	close(sockfd);
	return 0;
}
