module cam_vga(
			// Driver I/O 
			input logic        	clk,
			input logic 	   	reset,
			output logic [31:0]  readdata,
			input logic [31:0] 	writedata,
			input logic 	   	write,
			input logic 		read, 
			input 		   	   	chipselect,
			input logic [7:0]  address,    		 
			
			
			// VGA
			output logic [7:0] 	VGA_R, VGA_G, VGA_B,
			output logic 	   	VGA_CLK, VGA_HS, VGA_VS,
				               	VGA_BLANK_N,
			output logic 	   	VGA_SYNC_N,
			
			// Camera
			output logic [9:0]	DEBUG_LED, 		// LEDR[0]
			output logic [9:0]	GPIO_DEBUG,		// GPIO_0[35:26]
			output wire			SCLK, 			// GPIO_0[0]
			inout logic			SDA,			// GPIO_0[1]
			input logic		 	VS,				// GPIO_0[2] 
			input logic 		HREF, 			// GPIO_0[3]
			input logic 		PCLK,			// GPIO_0[4]
			output logic 		MCLK, 			// GPIO_0[5]  		25MHz
			input logic [7:0]	DATA, 			// GPIO_O[13:6]
			output logic 		CAM_RESET 		// GPIO_0[14] 
			
			);
	

	////////////////////////////////////////////////////////
	clk_div clk_div_0(
			.clk_ref(clk),
			.clk_out(MCLK));    				// 25 MHz
	////////////////////////////////////////////////////////

	camera_configure #(.CLK_FREQ(25_000_000))
		camera_configure_0(
			.clk		(MCLK			),
			.start 		((strt == 3'h6) ),
			.sioc 		(SCLK			),
			.siod 		(SDA			),
			.done 		(conf_done		),
		 	.SCCB_addr 	(SCCB_addr		),
		 	.SCCB_data 	(SCCB_data		)
		);
				
	logic	[7:0] 	SCCB_addr;
	logic	[7:0] 	SCCB_data;
	logic 			conf_done;
	logic 	[2:0]	strt = 3'd0;
	
	always @(posedge MCLK)
		if (&strt)	strt <= strt;
		else		strt <= strt + 1'h1;

	assign DEBUG_LED[0]  	= conf_done;
	assign GPIO_DEBUG[0]	= SCLK;  //GPIO_0[26]

	////////////////////////////////////////////////////////
	ram ram_0(			// a is write port, b is port
		.data(data_in),
		.rdaddress(add_b),
		.clock(clk),
		.wraddress(add_a),
		.wren(wren),
		.q(data_out)
		);
	
	logic [7:0] 	data_in, data_out;
	logic [18:0]	add_a, add_b;
	logic 			wren;
	/////////////////////////////////////////////////////////
	// Get data
	logic [2:0]	write_state = 0;
	logic 		valid_byte 	= 1'b1;
	
	assign CAM_RESET		= 1'b1;
	
	logic [18:0]	pcount;
	logic [1:0]		count_state;
	logic 			valid = 1'b1;
	always @(posedge PCLK) begin
		case (count_state)
			0:
				if (VS && conf_done)
					count_state <= 1;
			
			1:
				if (!VS) begin
					pcount 		<= 0;
					count_state <= 2;
				end
			2:
				if (HREF) begin
					if (valid)
						pcount 	<= pcount + 1;
					valid	<= ~valid;
				end else if (VS)
					count_state <= 1;
		endcase
	end
	
	/////////////////////////////////////////////////////////////////////////////
	always @(posedge PCLK) begin
		case (write_state)
			0: 
				if (VS && conf_done)
					write_state 	<= 1;
			1:
				if (!VS && pcount == 0) begin
					wren 		<= 1'b1;
					add_a 		<= 0;
					write_state	<= 2;
				end
			2:
				if (HREF) begin
					if (valid_byte) begin
						add_a		<= add_a + 1'd1;
						data_in		<= DATA;
					end
					valid_byte	<= ~valid_byte;
				end else if (VS) begin
					write_state 	<= 3;
					wren			<= 1'b0;
				end
			3:  // start reading from BRAM
				// write_state remains at 3 until done reading from BRAM to VGA
				if (read_state == 2) begin
					write_state <= 1;
				end
		endcase
	end
	/////////////////////////////////////////////////////////////////////////////
	always @(posedge clk) begin
		case (read_state)
			0: begin 
				// waits for camera to be done writing, then
				// reset add_b, 
				if (write_state == 3) begin
					if (endOfField == 1) begin
						add_b 		<= 0;
						read_state 	<= 1;
					end else begin
						add_b		<= vcount * 640 + (hcount >> 1);
						read_state 	<= 3;
					end
				end
			end
			
			1: 	begin // start reading from BRAM
				//vga_reset 	<= 0;
				if (VGA_BLANK_N && hcount[0]) //
					add_b <= add_b + 1;
				if (add_b == 19'd307_199) begin
					read_state 	<= 2;
				end
			end
			2: 	begin // Done reading, write_state should still be at 3 
					read_state <= 0;
				end
			3: begin 
				// start reading from BRAM, partial read, if at any point 
				// endOfField is true, start reading the whole frame
				if (endOfField == 1) begin
					add_b 		<= 0;
					read_state	<= 1;
				end
				if (VGA_BLANK_N && hcount[0]) //
					add_b <= add_b + 1;
				if (add_b == 19'd307_199) begin
					read_state 	<= 0;
				end
			end
				
		endcase
	end

	/////////////////////////////////////////////////////////
	// Read from BRAM to HPS
	always_ff @(posedge VGA_CLK) //clk
		if (chipselect && read)
			if (VGA_BLANK_N && read_state == 1) // full read out 
				readdata <= {5'b0, add_b, data_out};

				/*
				readdata <= {8'b0, data_out};
			else if (read_state == 2) // just done reading from ram
				readdata <= 61440; // 1111_0000_0000_0000
			else if (endOfField == 1 && read_state == 3)
				readdata <= 65535; // 1111_1111_1111_1111
			else
				readdata <= 960; //0000_1111_0000_0000
			*/

	/////////////////////////////////////////////////////////
	// VGA module
	logic [10:0] 	hcount;
	logic [9:0]		vcount;
	logic 			endOfField;
	logic [2:0] 	read_state = 0;
	
	vga_counter counter_0(
		.clk50(clk),
		.reset(reset),
		.hcount(hcount),
		.vcount(vcount),
		.VGA_CLK(VGA_CLK),
		.VGA_HS(VGA_HS),
		.VGA_VS(VGA_VS),
		.VGA_BLANK_N(VGA_BLANK_N),
		.VGA_SYNC_N(VGA_SYNC_N),
		.endOfField(endOfField)
		);

	//always_comb begin
		//{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	always_ff @(posedge VGA_CLK) begin
		if (VGA_BLANK_N) begin
			if (read_state == 1 || read_state == 3)
				//{VGA_R, VGA_G, VGA_B} = {{data_out, 4'b0}, {data_out, 4'b0}, {data_out, 4'b0}};
				{VGA_R, VGA_G, VGA_B} <= {data_out, data_out, data_out};
		end
			
	end
	// know read_state cycles thru all states
	// add_a and add_b never gets to 307199
	// add_b resets to 0 okay
	// count_state seems to cycle between state 1 & 2 okay
	
	/*
	assign DEBUG_LED[1] = (pixel[0] == 1) ? 1'b1 : 1'b0;
	assign DEBUG_LED[2] = (pixel[1] == 1) ? 1'b1 : 1'b0;
	assign DEBUG_LED[3] = (pixel[2] == 1) ? 1'b1 : 1'b0;
	assign DEBUG_LED[4] = (pixel[3] == 1) ? 1'b1 : 1'b0;
	assign DEBUG_LED[5] = (pixel[4] == 1) ? 1'b1 : 1'b0;
	assign DEBUG_LED[6] = (pixel[5] == 1) ? 1'b1 : 1'b0;
	assign DEBUG_LED[7] = (pixel[6] == 1) ? 1'b1 : 1'b0;
	assign DEBUG_LED[8] = (pixel[7] == 1) ? 1'b1 : 1'b0;
	*/
	//assign DEBUG_LED[9] = (temp[8] == 0) ? 1'b1 : 1'b0;
	
endmodule





















