#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>

typedef struct cam_data_pixel_t {
	unsigned int pixel;
} cam_data_pixel_t;

  
typedef struct {
	unsigned int pos_x;
	unsigned int pos_y;
} cam_data_position_t;

typedef struct {
	unsigned int address;
} cam_address_t;

typedef struct {
    cam_data_pixel_t pixel;
    cam_data_position_t position;
	cam_address_t address;
} cam_data_arg_t;


#define CAM_DATA_MAGIC 'q'

/* ioctls and their arguments */
#define CAM_DATA_WRITE_PIXEL  _IOW(CAM_DATA_MAGIC, 1, cam_data_arg_t *)
#define CAM_DATA_WRITE_POSITION  _IOW(CAM_DATA_MAGIC, 2, cam_data_arg_t *)
#define CAM_DATA_WRITE_ADDRESS _IOW(CAM_DATA_MAGIC, 3, cam_data_arg_t *)

#endif

