//  THIS IS THE SERVER SIDE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include "vga_ball.h"


#define SERVER_HOST "128.59.19.114" //Placeholder IP Address
#define SERVER_PORT 1338           //PLaceholder Port

#define BUFFER_SIZE 640*480

int cam_fd;


/* Set the background color */
void set_pixel(const cam_data_pixel_t *p)
{
  cam_data_arg_t vla;
  vla.pixel = *p;
  if (ioctl(cam_fd, CAM_DATA_WRITE_PIXEL, &vla)) {
      perror("ioctl(CAM_DATA_WRITE_PIXEL) failed");
      return;
  }

}

void set_address(const cam_address_t *a){
	cam_data_arg_t vla;
	vla.address = *a;
	if (ioctl(cam_fd, CAM_DATA_WRITE_ADDRESS, &vla)) {
      perror("ioctl(CAM_DATA_WRITE_ADDRESS) failed");
      return;
  	}

}

void set_frame(int sockfd, unsigned char *temp, struct sockaddr_in client_addr, int client_length, unsigned char *buffer, int n, 
int* end_flag, int* byte_count, cam_data_pixel_t* temp_pixel){
	n = recvfrom(sockfd, temp, 508, 0,
        (struct sockaddr*)&client_addr, &client_length);
		for (int i = 0; i < n; i++)
        	//printf("temp[%d]: %d\n", i, temp[i]);
		//break;
        if (*end_flag) {
            for(int j = 0; j < n; j++){
                buffer[j+(*byte_count)] = temp[j];
				//printf("temp to buffer: %d\n", buffer[j+(*byte_count)]);
			}
            *byte_count += n;
			//printf("Buffer[%d]: \n", buffer[*byte_count]);
        }
         if (n <= 508 && *end_flag){
            printf("hello");
			*end_flag = 0;
            *byte_count = 0;
         	for(unsigned int i = 0; i < BUFFER_SIZE; i++){
        		temp_pixel->pixel = 0x100*i + buffer[i];
				printf("%d\n", buffer[i]);
				set_pixel(temp_pixel);
    		}
	
		 	memset(buffer, 0, BUFFER_SIZE);
        }
		if (n <= 508 && !(*end_flag)) *end_flag = 1;
		

}

int main(void){
    int sockfd; /* Socket file descriptor */
    struct sockaddr_in server_addr, client_addr;
	int addrlen = sizeof(server_addr);
    unsigned char buffer[BUFFER_SIZE];
 		
		if ( (cam_fd = open("/dev/vga_ball", O_RDWR)) == -1) {
    	fprintf(stderr, "could not open /dev/cam_data \n");
    	return -1;
 		 }   
    
    // Create UDP socket:
    if ( (sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0 ) {
	// Create TCP socket
   // if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0 ) {
		perror("socket creation failed");
		exit(EXIT_FAILURE);
	}
    //sockfd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    printf("Socket created successfully\n");

    memset(&server_addr, 0, sizeof(server_addr));
    memset(&client_addr, 0, sizeof(client_addr));
    
    server_addr.sin_family = AF_INET; // IPv4
    server_addr.sin_port = htons(SERVER_PORT);
    server_addr.sin_addr.s_addr = htonl(INADDR_ANY);//htonl was recently added 1:30AM
    //server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
    
    // Bind to the set port and IP:
    if(bind(sockfd, (const struct sockaddr*)&server_addr, sizeof(server_addr)) < 0){
        perror("bind failed");
		exit(EXIT_FAILURE);
    }
    printf("Done with binding\n");
    
    printf("Listening for incoming connections...\n\n");

	/*
	if (listen(sockfd, 3) < 0) {
		perror("Listen failed");
		exit(EXIT_FAILURE);
	}
	*/
	//printf("yes");
	// Accept incoming connections
    
    // Receive client's message:
    int client_length, n;
    int counter = 0;
    //int total_recieved = 0;

		
	// set values to send to hardware
	cam_address_t addr;
	cam_data_pixel_t color;


	//color.pixel = 0x00000064;
	//unsigned int address = 0;
	//unsigned char color_var;

	FILE *fptr;
	fptr = fopen("out.txt", "w");
	int byte_count = 0;
	unsigned char temp[508];
	int end_flag = 0;
	int new_socket;
	cam_data_pixel_t temp_pixel;

	//call set_frame  
	//set_frame(sockfd, temp, client_addr, client_length, buffer, n, end_flag, byte_count);

	//printf("set_pixel\n");
	while (1) {
		printf("Placeholder\n");
		set_frame(sockfd, temp, server_addr, client_length, buffer, n, &end_flag, &byte_count, &temp_pixel);
		printf("Frame recieved\n");
	/*
		temp_pixel.pixel = 805306368;
		set_pixel(&temp_pixel);
		temp_pixel.pixel = 0;
		*/
	}

		
	/*
    	for (int i = 0; i< 307200; i++) {
			if(pixel_counter == 307199){
				//fwrite(&buffer, sizeof(buffer), 1, fptr);
			}
			set_pixel(&color);
			pixel_counter++;
			color.pixel = color.pixel + 0x00000100;
			if (i == 150000)
				color.pixel = color.pixel + 0x5A;
			if (i == 200000)
				color.pixel = color.pixel + 0x5a;
		}
		color.pixel = 0x30000000;
		set_pixel(&color);
		color.pixel = 0x64;
	*/
	
	//write buffer into file
		
	for(int i =0; i < sizeof(buffer); i++){
		fprintf(fptr, "%hu\n", buffer[i]);		
	}
	

	//fwrite(buffer, sizeof(buffer), 1, fptr);
	printf("Size of packet %d\n", n);
	//close(new_socket);
	close(sockfd);
	fclose(fptr);

    return 0;
}
