module vga_ball(input logic        clk,
	        input logic 	   reset,
		input logic [7:0]  writedata,
		input logic 	   write,
		input 		   chipselect,
		input logic [2:0]  address,

    input logic [7:0] VGA_G,

		output logic [7:0] VGA_R, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n);

   logic [7:0] 	   motor0_degree, motor1_degree, motor2_degree, motor3_degree;

logic [31:0] pwm_motor0; //Servo 0 PWM setting
logic [31:0] pwm_motor1; //Servo 1 PWM setting
logic [31:0] pwm_motor2; //Servo 2 PWM setting
logic [31:0] pwm_motor3; //Servo 3 PWM setting

initial begin
  motor0_degree  <= 8'd135;//Initialize the steering gear to 0 angle
  motor1_degree  <= 8'd135;//Initialize the steering gear to 1 angle
  motor2_degree  <= 8'd135;//Initialize the steering gear to 2 angle
  motor3_degree  <= 8'd26;//Initialize the steering gear to 3 angle
  pwm_motor0 = 25000;//Initialize servos
  pwm_motor1 = 25000;//Initialize servos
  pwm_motor2 = 25000;//Initialize servos
  pwm_motor3 = 25000;//Initialize servos
end

always_ff @(posedge clk) begin
  if (reset) begin
    motor0_degree  <= 8'd135;//Initialize the steering gear to 0 angle
    motor1_degree  <= 8'd135;//Initialize the steering gear to 1 angle
    motor2_degree  <= 8'd135;//Initialize the steering gear to 2 angle
    motor3_degree  <= 8'd26;//Initialize the steering gear to 3 angle
  end else if (chipselect && write)
    case (address)
    3'h0 : motor0_degree <= writedata;
    3'h1 : motor1_degree <= writedata;
    3'h2 : motor2_degree <= writedata;
    3'h3 : motor3_degree <= writedata;
    endcase
end
	       
always_ff @(posedge clk) begin
  if(reset) begin
    pwm_motor0 = 25000;//Initialize servos
    pwm_motor1 = 25000;//Initialize servos
    pwm_motor2 = 25000;//Initialize servos
    pwm_motor3 = 25000;//Initialize servos
  end else begin
    pwm_motor0 <= 25000 + motor0_degree * 370;
    pwm_motor1 <= 25000 + motor1_degree * 370;
    pwm_motor2 <= 25000 + motor2_degree * 370;
    pwm_motor3 <= 25000 + motor3_degree * 555;
  end
end

servo_set servo0(
  .CLK (clk),
  .h_time (pwm_motor0),
  .servo_pwm (VGA_R[0])
);

servo_set servo1(
  .CLK (clk),
  .h_time (pwm_motor1),
  .servo_pwm (VGA_R[1])
);

servo_set servo2(
  .CLK (clk),
  .h_time (pwm_motor2),
  .servo_pwm (VGA_R[2])
);

servo_set servo3(
  .CLK (clk),
  .h_time (pwm_motor3),
  .servo_pwm (VGA_R[3])
);

endmodule

module servo_set(
  input CLK,//Clock input 50MHz
  input logic [31:0] h_time, //Time On for one duty cycle
  output logic servo_pwm //Servo PWM output
);

logic [31:0] CNT;
logic [31:0] period; //Period

initial begin
  CNT=32'd0;
  period = 32'd1000000; //20ms period for 50MHz Clock
end

always_ff @ (posedge CLK) begin
  if(CNT >= period - 32'd1 )
    CNT <= 32'd0;
  else
    CNT <= CNT + 32'd1;
end

always_ff @ (posedge CLK) begin
  if(CNT <= h_time - 32'd1)
    servo_pwm <= 1'b1;
  else
    servo_pwm <= 1'b0;
end
endmodule