#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>

typedef struct
{
  unsigned int x, y;
} tank_loc_t;

typedef struct
{
  // msb 3 bits is sound select next bit 1 is display last 3 bits are direction
  unsigned int gtank_dis_dir_btank_dis_dir;
} tank_data_t;

typedef struct
{
  unsigned int index;
  tank_loc_t location;
} object_data_t;

typedef struct
{
  unsigned short score;
} score_data_t;

typedef struct
{
  tank_loc_t location;
  tank_data_t data;
  object_data_t explosion_data;
  score_data_t score_data;
  unsigned short controller_input;
  unsigned short sound_selection;
} tank_arg_t;

#define VGA_BALL_MAGIC 'q'

/* ioctls and their arguments */

#define GTANK_WRITE_LOC _IOW(VGA_BALL_MAGIC, 1, tank_arg_t *)
#define GTANK_READ_LOC _IOR(VGA_BALL_MAGIC, 2, tank_arg_t *)
#define TANK_DATA_WRITE _IOW(VGA_BALL_MAGIC, 3, tank_arg_t *)

#define BTANK_WRITE_LOC _IOW(VGA_BALL_MAGIC, 4, tank_arg_t *)
#define BTANK_READ_LOC _IOR(VGA_BALL_MAGIC, 5, tank_arg_t *)
#define AUDIO_SELECT _IOW(VGA_BALL_MAGIC, 6, tank_arg_t *)

#define GBULLET_WRITE_LOC _IOW(VGA_BALL_MAGIC, 7, tank_arg_t *)
#define GBULLET_READ_LOC _IOR(VGA_BALL_MAGIC, 8, tank_arg_t *)
#define GBULLET_DATA _IOW(VGA_BALL_MAGIC, 9, tank_arg_t *)

#define BBULLET_WRITE_LOC _IOW(VGA_BALL_MAGIC, 10, tank_arg_t *)
#define BBULLET_READ_LOC _IOR(VGA_BALL_MAGIC, 11, tank_arg_t *)
#define BBULLET_DATA _IOW(VGA_BALL_MAGIC, 12, tank_arg_t *)

#define EXP_WRITE_DATA _IOW(VGA_BALL_MAGIC, 13, tank_arg_t *)
#define SCORE_WRITE_DATA _IOW(VGA_BALL_MAGIC, 14, tank_arg_t *)

#define READ_CONTROLS _IOR(VGA_BALL_MAGIC, 15, tank_arg_t *)

#define test_read_gtank _IOR(VGA_BALL_MAGIC, 16, tank_arg_t *)

#endif
