/*
 * Combat Game
 *
 * Tameem Asif and Patrick Puma
 */

module vga_ball(input logic        clk,
	        input logic 	   reset,
		input logic [15:0]  writedata,
		input logic 	   write,
    input logic     read,
    output logic [15:0] readdata,
		input 		   chipselect,
		input logic [3:0]  address,
    input logic left_ready, right_ready,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n,
    output logic left_valid, right_valid,
    output logic [15:0] left_data, right_data,
    
    input logic contr1_up, contr1_left, contr1_right, contr1_down, contr1_fire,
    input logic contr2_up, contr2_left, contr2_right, contr2_down, contr2_fire
    );

   /* For audio, streaming source 0 == left */
   logic [10:0]	   hcount;
   logic [9:0]     vcount;

   logic [9:0]	   gtank_x;
   logic [9:0]     gtank_y;
   logic [2:0]     gtank_dir;

   logic [9:0]	   btank_x;
   logic [9:0]     btank_y;
   logic [2:0]     btank_dir;

   logic [9:0]	   gbullet_x;
   logic [9:0]     gbullet_y;
   logic [2:0]     gbullet_dir;

   logic [9:0]	   bbullet_x;
   logic [9:0]     bbullet_y;
   logic [2:0]     bbullet_dir;

   logic [9:0]	   explosion_x;
   logic [9:0]     explosion_y;
   logic [2:0]     explosion_index;
   
   logic [3:0]    digit1_idx;
   logic [3:0]    digit2_idx;
   logic [3:0]    digit3_idx;
   logic [3:0]    digit4_idx;

   logic          display_gtank;
   logic display_btank;
   logic display_gbullet;
   logic display_bbullet;

   logic display_title;
    
    logic[2:0] sound_effect;

   vga_counters counters(.clk50(clk), .*);

   always_ff @(posedge clk)begin
     if (reset) begin
      gtank_x <= 10'd50;
      gtank_y <= 10'd50;
      gtank_dir <= 3'd1;

      btank_x <= 10'd100;
      btank_y <= 10'd100;
      btank_dir <= 3'd01;

      gbullet_x <= 10'd150;
      gbullet_y <= 10'd50;
      gbullet_dir <= 3'd01;

      bbullet_x <= 10'd50;
      bbullet_y <= 10'd150;
      bbullet_dir <= 3'd01;

      explosion_x <= 10'd50;
      explosion_y <= 10'd150;
      explosion_index <= 4'd00;

      display_bbullet <= 1'b1;
      display_gbullet <= 1'b1;
      display_btank <= 1'b1;
      display_gtank <= 1'b1;

      sound_effect <= 3'd0;
      display_title <=1'd1;
     end else if (chipselect && write)
       case (address)

        4'h0 : gtank_x <= writedata[9:0];
        4'h1 : gtank_y <= writedata[9:0];
        4'h2 : begin 
          display_gtank <= writedata[7];
          gtank_dir <= writedata[6:4];
          display_btank <= writedata[3];
          btank_dir <= writedata[2:0];  
        end

        4'h3 : btank_x <= writedata[9:0];
        4'h4 : btank_y <= writedata[9:0];
        4'h5 : begin 
          display_title <=writedata[3];
          sound_effect <= writedata[2:0]; 
        end

        4'h6 : gbullet_x <= writedata[9:0];
        4'h7 : gbullet_y <= writedata[9:0];
        4'h8 : begin 
          display_gbullet <= writedata[3];
          gbullet_dir <= writedata[2:0];
        end

   	    4'h9 : bbullet_x <= writedata[9:0];
        4'ha : bbullet_y <= writedata[9:0];
        4'hb : 
        begin 
          display_bbullet <= writedata[3];
          bbullet_dir <= writedata[2:0];
        end

        4'hc : explosion_x <= writedata[9:0];
        4'hd : explosion_y <= writedata[9:0];
        4'he : explosion_index <= writedata[3:0];

        4'hf : begin 
          digit2_idx <=writedata[3:0];
          digit1_idx <=writedata[7:4];
          digit4_idx <=writedata[11:8];
          digit3_idx <=writedata[15:12];
        end

       endcase
       
    end

  // audio audio_unit(.clk(clk), .reset(reset), .left_ready(left_ready), .right_ready(right_ready), .sound_effect(sound_effect), .left_valid(left_valid), .right_valid(right_valid), .left_data(left_data),.right_data(right_data));
  
  reg [13:0] counter;
  logic flag1;
  logic flag2;
  logic flag3;

  logic [8:0]  address1;
  logic [15:0]  output1;
  tank_hit audio1(.address(address1), .clock(clk), .q(output1));

  logic [8:0]  address2;
  logic [15:0]  output2;
  tank_shoot audio2(.address(address2), .clock(clk), .q(output2));

  logic [8:0]  address3;
  logic [15:0]  output3;
  tank_move audio3(.address(address3), .clock(clk), .q(output3));

  always_ff @(posedge clk) begin
      if(reset) begin
        counter <= 0;
        left_valid <= 0;
        right_valid <= 0;
        address1 <= 0;
        address2 <= 0;
        address3 <= 0;
        flag1 <= 1;
        flag2 <= 1;
        flag3 <= 1;
      end
      else if(left_ready == 1 && right_ready == 1 && counter < 6250) begin
        counter <= counter + 1;
        left_valid <= 0;
        right_valid <= 0;
      end
      else if(left_ready == 1 && right_ready == 1 && counter == 6250) begin
        counter <= 0;
        left_valid <= 1;
        right_valid <= 1;
        /* Play no sound */
        if (sound_effect[2:0] == 3'd0) begin
          left_data <= 0;
          right_data <= 0;
          flag1 <= 1'b1;
          flag2 <= 1'b1;
          flag3 <= 1'b1;
        end
        /* Play Tank Hit Sound */
        else if (sound_effect[2:0] == 3'd1 || flag1 == 1'b0) begin
          if (address1 < 14'd8056) begin
            address1 <= address1+1;
            flag1 <= 1'b0;
          end
          else begin
             address1 <= 0;
             flag1 <= 1'b1;
          end
          left_data <= output1;
          right_data <= output1;
        end
        /* Play Tank Shoot Sound */
        else if (sound_effect[2:0] == 3'd2 || flag2 == 1'b0) begin
          if (address2 < 12'd2127) begin
            address2 <= address2+1;
            flag2 <= 1'b0;
          end
          else begin
            address2 <= 0;
            flag2 <= 1'b1;
          end
          left_data <= output2;
          right_data <= output2;
        end
        /* Play Tank Move Sound */
        else if (sound_effect[2:0] == 3'd3 || flag3 == 1'b0) begin
          if (address3 < 12'd4060) begin
            address3 <= address3+1;
            flag3 <= 1'b0;
          end
          else begin
            address3 <= 0;
            flag3 <= 1'b1;
          end
          left_data <= output3;
          right_data <= output3;
        end

        else begin
          left_data <= 0;
          right_data <= 0;
        end
      end
      else begin
        left_valid <= 0;
        right_valid <= 0;
      end
  end

  logic [13:0] gtank_address;
  logic [15:0] gtank_output;
  gtank gtank_unit(.address(gtank_address),.clock(clk),.q(gtank_output));
  logic [1:0] gtank_en;

	always_ff @(posedge clk) begin
		//ball
		//if (hcount[10:5] == 6'd20 && vcount[9:4] == 6'd22) begin
		if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd0)begin
      gtank_address <= (hcount[10:1]-gtank_x + 1) + (vcount[9:0]-gtank_y)*27;
      gtank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd1)begin
      gtank_address <= (hcount[10:1]-gtank_x+1) + (vcount[9:0]-gtank_y)*27 + 27*27 * gtank_dir;
      gtank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd2)begin
      gtank_address <= (hcount[10:1]-gtank_x+1) + (vcount[9:0]-gtank_y)*27 + 27*27 * gtank_dir;
      gtank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd3)begin
      gtank_address <= (hcount[10:1]-gtank_x+1) + (vcount[9:0]-gtank_y)*27 + 27*27 * gtank_dir;
      gtank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd4)begin
      gtank_address <= (hcount[10:1]-gtank_x+1) + (vcount[9:0]-gtank_y)*27 + 27*27 * gtank_dir;
      gtank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd5)begin
      gtank_address <= (hcount[10:1]-gtank_x+1) + (vcount[9:0]-gtank_y)*27 + 27*27 * gtank_dir;
      gtank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd6)begin
      gtank_address <= (hcount[10:1]-gtank_x+1) + (vcount[9:0]-gtank_y)*27 + 27*27 * gtank_dir;
      gtank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gtank_x && hcount[10:1] < gtank_x+27 && vcount[9:0] >= gtank_y && vcount[9:0]<gtank_y+27 && gtank_dir == 3'd7)begin
      gtank_address <= (hcount[10:1]-gtank_x+1) + (vcount[9:0]-gtank_y)*27 + 27*27 * gtank_dir;
      gtank_en <= 2'b1;  
		end
		else begin
			gtank_en <= 2'b0;
		end
	end

  logic [13:0] btank_address;
  logic [15:0] btank_output;
  btank btank_unit(.address(btank_address),.clock(clk),.q(btank_output));
  logic [1:0] btank_en;

	always_ff @(posedge clk) begin
		//ball
		//if (hcount[10:5] == 6'd20 && vcount[9:4] == 6'd22) begin
		if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd0)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27;
      btank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd1)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27 + 27*27 * btank_dir;
      btank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd2)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27 + 27*27 * btank_dir;
      btank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd3)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27 + 27*27 * btank_dir;
      btank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd4)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27 + 27*27 * btank_dir;
      btank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd5)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27 + 27*27 * btank_dir;
      btank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd6)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27 + 27*27 * btank_dir;
      btank_en <= 2'b1;  
		end
    else if (hcount[10:1] >= btank_x && hcount[10:1] < btank_x+27 && vcount[9:0] >= btank_y && vcount[9:0]<btank_y+27 && btank_dir == 3'd7)begin
      btank_address <= (hcount[10:1]-btank_x+1) + (vcount[9:0]-btank_y)*27 + 27*27 * btank_dir;
      btank_en <= 2'b1;  
		end
		else begin
			btank_en <= 2'b0;
		end
	end

  //GREEN BULLET
  logic [9:0] bulleta_address;
  logic [15:0] bulleta_output;
  greenbullets greenbullet_unit(.address(bulleta_address),.clock(clk),.q(bulleta_output));
  logic [1:0] bulleta_en;
  
  always_ff @(posedge clk) begin
		//ball
		//if (hcount[10:5] == 6'd20 && vcount[9:4] == 6'd22) begin
		if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd0)begin
      bulleta_address <= (hcount[10:1]-gbullet_x+1) + (vcount[9:0]-gbullet_y)*10 + 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd1)begin
      bulleta_address <= (hcount[10:1]-gbullet_x+1) + (vcount[9:0]-gbullet_y)*10 + 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd2)begin
      bulleta_address <= (hcount[10:1]-gbullet_x) + (vcount[9:0]-gbullet_y)*10+ 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd3)begin
      bulleta_address <= (hcount[10:1]-gbullet_x+1) + (vcount[9:0]-gbullet_y)*10+ 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd4)begin
      bulleta_address <= (hcount[10:1]-gbullet_x+1) + (vcount[9:0]-gbullet_y)*10+ 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd5)begin
      bulleta_address <= (hcount[10:1]-gbullet_x+1) + (vcount[9:0]-gbullet_y)*10+ 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd6)begin
      bulleta_address <= (hcount[10:1]-gbullet_x+1) + (vcount[9:0]-gbullet_y)*10+ 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else if (hcount[10:1] >= gbullet_x && hcount[10:1] < gbullet_x+10 && vcount[9:0] >= gbullet_y && vcount[9:0]<gbullet_y+10 && gbullet_dir == 3'd7)begin
      bulleta_address <= (hcount[10:1]-gbullet_x+1) + (vcount[9:0]-gbullet_y)*10+ 10*10 * gbullet_dir;
      bulleta_en <= 2'b1;  
		end
    else begin
			bulleta_en <= 2'b0;
		end
  end

  //BLUE BULLET
  logic [9:0] bulletb_address;
  logic [15:0] bulletb_output;
  bluebullets bluebullet_unit(.address(bulletb_address),.clock(clk),.q(bulletb_output));
  logic [1:0] bulletb_en;
  always_ff @(posedge clk) begin
    if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd0)begin
      bulletb_address <= (hcount[10:1]-bbullet_x+1) + (vcount[9:0]-bbullet_y)*10 + 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd1)begin
      bulletb_address <= (hcount[10:1]-bbullet_x+1) + (vcount[9:0]-bbullet_y)*10 + 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd2)begin
      bulletb_address <= (hcount[10:1]-bbullet_x) + (vcount[9:0]-bbullet_y)*10+ 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd3)begin
      bulletb_address <= (hcount[10:1]-bbullet_x+1) + (vcount[9:0]-bbullet_y)*10+ 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd4)begin
      bulletb_address <= (hcount[10:1]-bbullet_x+1) + (vcount[9:0]-bbullet_y)*10+ 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd5)begin
      bulletb_address <= (hcount[10:1]-bbullet_x+1) + (vcount[9:0]-bbullet_y)*10+ 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd6)begin
      bulletb_address <= (hcount[10:1]-bbullet_x+1) + (vcount[9:0]-bbullet_y)*10+ 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else if (hcount[10:1] >= bbullet_x && hcount[10:1] < bbullet_x+10 && vcount[9:0] >= bbullet_y && vcount[9:0]<bbullet_y+10 && bbullet_dir == 3'd7)begin
      bulletb_address <= (hcount[10:1]-bbullet_x+1) + (vcount[9:0]-bbullet_y)*10+ 10*10 * bbullet_dir;
      bulletb_en <= 2'b1;  
		end
    else begin
			bulletb_en <= 2'b0;
		end
  end

  //Red Jug
  logic [9:0] redjug_x;
  logic [9:0] redjug_y;
  logic [9:0] woodx_x;
  logic [9:0] woodx_y;
  logic [10:0] redjug_address;
  redjug redjug_unit(.address(redjug_address),.clock(clk),.q(redjug_output));
  logic [15:0] redjug_output;
  logic [1:0] redjug_en;
  always_ff @(posedge clk) begin
    redjug_x <= 304;
    redjug_y <= 274;
     woodx_x <= 304;
    woodx_y <= 174;
    //the top three
    if (hcount[10:1] >= redjug_x && hcount[10:1] < redjug_x+36 && vcount[9:0] >= redjug_y && vcount[9:0]<redjug_y+36)begin
      redjug_address <= (hcount[10:1]-redjug_x+1) + (vcount[9:0]-redjug_y)*36;
      redjug_en <= 2'b1;  
    end
    
    else if (hcount[10:1] >= redjug_x && hcount[10:1] < redjug_x+36 && vcount[9:0] >= redjug_y+58 && vcount[9:0]<redjug_y+36+58)begin
      redjug_address <= (hcount[10:1]-redjug_x+1) + (vcount[9:0]-redjug_y-58)*36;
      redjug_en <= 2'b1;
    end
    else if (hcount[10:1] >= woodx_x && hcount[10:1] < woodx_x+36 && vcount[9:0] >= woodx_y-29 && vcount[9:0]<woodx_y+36-29)begin
      redjug_address <= (hcount[10:1]-woodx_x+1) + (vcount[9:0]-woodx_y+29)*36;
      redjug_en <= 2'b1;  
    end
    
    else begin
      redjug_en <= 2'b0;
    end
    
  end
  // Wood X
  
  logic [10:0] woodx_address;
  woodx woodx_unit(.address(woodx_address), .clock(clk), .q(woodx_output));
  logic [15:0] woodx_output;
  logic [1:0] woodx_en;
  always_ff @(posedge clk) begin
   
    //the bottom three
    if (hcount[10:1] >= redjug_x && hcount[10:1] < redjug_x+36 && vcount[9:0] >= redjug_y+29 && vcount[9:0]<redjug_y+36+29)begin
      woodx_address <= (hcount[10:1]-redjug_x+1) + (vcount[9:0]-redjug_y-29)*36;
      woodx_en <= 2'b1;
    end
    
    else if (hcount[10:1] >= woodx_x && hcount[10:1] < woodx_x+36 && vcount[9:0] >= woodx_y && vcount[9:0]<woodx_y+36)begin
      woodx_address <= (hcount[10:1]-woodx_x+1) + (vcount[9:0]-woodx_y)*36;
      woodx_en <= 2'b1;  
    end
    else if (hcount[10:1] >= woodx_x && hcount[10:1] < woodx_x+36 && vcount[9:0] >= woodx_y-58 && vcount[9:0]<woodx_y+36-58)begin
      woodx_address <= (hcount[10:1]-woodx_x+1) + (vcount[9:0]-woodx_y+58)*36;
      woodx_en <= 2'b1;  
    end
    
    else begin
      woodx_en <= 2'b0;
    end
  end

  // Steel Barrel
  logic [9:0] steelbarrel_x;
  logic [9:0] steelbarrel_y;
  logic [10:0] steelbarrel_address;
  steelbarrel steelbarrel_unit(.address(steelbarrel_address),.clock(clk),.q(steelbarrel_output));
  logic [15:0] steelbarrel_output;
  logic [1:0] steelbarrel_en;
  always_ff @(posedge clk) begin
    steelbarrel_x <= 274;
    steelbarrel_y <= 374;
    if (hcount[10:1] >= steelbarrel_x && hcount[10:1] < steelbarrel_x+36 && vcount[9:0] >= steelbarrel_y && vcount[9:0]<steelbarrel_y+36)begin
        steelbarrel_address <= (hcount[10:1]-steelbarrel_x+1) + (vcount[9:0]-steelbarrel_y)*36;
        steelbarrel_en <= 2'b0;  
      end
    else begin
      steelbarrel_en <= 2'b0;
    end
  end

  // Steel Box
  logic [9:0] steelbox_x;
  logic [9:0] steelbox_y;
  logic [10:0] steelbox_address;
  steelbox steelbox_unit(.address(steelbox_address),.clock(clk),.q(steelbox_output));
  logic [15:0] steelbox_output;
  logic [1:0] steelbox_en;
  always_ff @(posedge clk) begin
    steelbox_x<= 85;
    steelbox_y <= 148;
    if (hcount[10:1] >= steelbox_x && hcount[10:1] < steelbox_x+36 && vcount[9:0] >= steelbox_y && vcount[9:0]<steelbox_y+36)begin
      steelbox_address <= (hcount[10:1]-steelbox_x+1) + (vcount[9:0]-steelbox_y)*36;
      steelbox_en <= 2'b1;  
    end
    else if (hcount[10:1] >= steelbox_x && hcount[10:1] < steelbox_x+36 && vcount[9:0] >= steelbox_y+4*36+7 && vcount[9:0]<steelbox_y+5*36+7)begin
        steelbox_address <= (hcount[10:1]-steelbox_x+1) + (vcount[9:0]-steelbox_y-(4*36+7))*36;
        steelbox_en <= 2'b1;  
    end
    //right side
    else if (hcount[10:1] >= 499+16 && hcount[10:1] < 499+16+36 && vcount[9:0] >= steelbox_y && vcount[9:0]<steelbox_y+36)begin
      steelbox_address <= (hcount[10:1]-499+16+1) + (vcount[9:0]-steelbox_y)*36;
      steelbox_en <= 2'b1;  
    end
    else if (hcount[10:1] >= 499+16 && hcount[10:1] < 499+16+36 && vcount[9:0] >= steelbox_y+4*36+7 && vcount[9:0]<steelbox_y+5*36+7)begin
      steelbox_address <= (hcount[10:1]-499+16+1) + (vcount[9:0]-steelbox_y-(4*36+7))*36;
      steelbox_en <= 2'b1;
    end
    else begin
      steelbox_en <= 2'b0;
    end
  end

  // Steel Jug
  logic [9:0] steeljug_x;
  logic [9:0] steeljug_y;
  logic [10:0] steeljug_address;
  steeljug steeljug_unit(.address(steeljug_address), .clock(clk), .q(steeljug_output));
  logic [15:0] steeljug_output;
  logic [1:0] steeljug_en;
  always_ff @(posedge clk) begin
    steeljug_x <= 374;
    steeljug_y <= 74;
    if (hcount[10:1] >= steeljug_x && hcount[10:1] < steeljug_x+36 && vcount[9:0] >= steeljug_y && vcount[9:0]<steeljug_y+36)begin
        steeljug_address <= (hcount[10:1]-steeljug_x+1) + (vcount[9:0]-steeljug_y)*36;
        steeljug_en <= 2'b0;  
      end
    else begin
      steeljug_en <= 2'b0;
    end
  end

  // Sticks
  logic [9:0] sticks_x;
  logic [9:0] sticks_y;
  logic [10:0] sticks_address;
  sticks sticks_unit(.address(sticks_address), .clock(clk), .q(sticks_output));
  logic [15:0] sticks_output;
  logic [1:0] sticks_en;
  always_ff @(posedge clk) begin
    sticks_x <= 174;
    sticks_y <= 174;
    if (hcount[10:1] >= sticks_x && hcount[10:1] < sticks_x+36 && vcount[9:0] >= sticks_y && vcount[9:0]<sticks_y+36)begin
        sticks_address <= (hcount[10:1]-sticks_x+1) + (vcount[9:0]-sticks_y)*36;
        sticks_en <= 2'b0; 
      end
    else begin
      sticks_en <= 2'b0;
    end
  end

  // Tree
  logic [9:0] tree_x;
  logic [9:0] tree_y;
  logic [10:0] tree_address;
  tree tree_unit(.address(tree_address), .clock(clk), .q(tree_output));
  logic [15:0] tree_output;
  logic [1:0] tree_en;
  always_ff @(posedge clk) begin
    tree_x <= 205;
    tree_y <= 362;
    if (hcount[10:1] >= tree_x && hcount[10:1] < tree_x+36 && vcount[9:0] >= tree_y && vcount[9:0]<tree_y+36)begin
        tree_address <= (hcount[10:1]-tree_x+1) + (vcount[9:0]-tree_y)*36;
        tree_en <= 2'b1;
      end
    else if (hcount[10:1] >= 398 && hcount[10:1] < 398+36 && vcount[9:0] >= tree_y && vcount[9:0]<tree_y+36)begin
        tree_address <= (hcount[10:1]-398+1) + (vcount[9:0]-tree_y)*36;
        tree_en <= 2'b1;
      end
    else if (hcount[10:1] >= tree_x && hcount[10:1] < tree_x+36 && vcount[9:0] >= 85 && vcount[9:0]<85+36)begin
        tree_address <= (hcount[10:1]-tree_x+1) + (vcount[9:0]-85)*36;
        tree_en <= 2'b1;
      end
    else if (hcount[10:1] >= 398 && hcount[10:1] < 398+36 && vcount[9:0] >= 85 && vcount[9:0]<85+36)begin
        tree_address <= (hcount[10:1]-398+1) + (vcount[9:0]-85)*36;
        tree_en <= 2'b1;
      end
    else begin
      tree_en <= 2'b0;
    end
  end

    // Wood Box
  logic [9:0] woodbox_x;
  logic [9:0] woodbox_y;
  logic [10:0] woodbox_address;
  woodbox woodbox_unit(.address(woodbox_address), .clock(clk), .q(woodbox_output));
  logic [15:0] woodbox_output;
  logic [1:0] woodbox_en;
  always_ff @(posedge clk) begin
    woodbox_x <= 300;
    woodbox_y <= 27;
    if (hcount[10:1] >= woodbox_x && hcount[10:1] < woodbox_x+36 && vcount[9:0] >= woodbox_y && vcount[9:0]<woodbox_y+36)begin
        woodbox_address <= (hcount[10:1]-woodbox_x+1) + (vcount[9:0]-woodbox_y)*36;
        woodbox_en <= 2'b0;
      end
    else begin
      woodbox_en <= 2'b0;
    end
  end

  

  // Yellow Wall
  logic [9:0] yellowwall_x;
  logic [9:0] yellowwall_y;
  logic [10:0] yellowwall_address;
  yellowwall yellowwall_unit(.address(yellowwall_address), .clock(clk), .q(yellowwall_output));
  logic [15:0] yellowwall_output;
  logic [1:0] yellowwall_en;
  always_ff @(posedge clk) begin
    yellowwall_x <= 105;
    yellowwall_y <= 224;

    //left side
    if (hcount[10:1] >= yellowwall_x && hcount[10:1] < yellowwall_x+36 && vcount[9:0] >= yellowwall_y+36 && vcount[9:0]<yellowwall_y+36+36)begin
        yellowwall_address <= (hcount[10:1]-yellowwall_x+1) + (vcount[9:0]-yellowwall_y-36)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= yellowwall_x && hcount[10:1] < yellowwall_x+36 && vcount[9:0] >= yellowwall_y && vcount[9:0]<yellowwall_y+36)begin
        yellowwall_address <= (hcount[10:1]-yellowwall_x+1) + (vcount[9:0]-yellowwall_y)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= yellowwall_x && hcount[10:1] < yellowwall_x+36 && vcount[9:0] >= yellowwall_y-36 && vcount[9:0]<yellowwall_y)begin
        yellowwall_address <= (hcount[10:1]-yellowwall_x+1) + (vcount[9:0]-yellowwall_y+36)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= yellowwall_x && hcount[10:1] < yellowwall_x+36 && vcount[9:0] >= yellowwall_y+72 && vcount[9:0]<yellowwall_y+108)begin
        yellowwall_address <= (hcount[10:1]-yellowwall_x+1) + (vcount[9:0]-yellowwall_y-72)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= yellowwall_x && hcount[10:1] < yellowwall_x+36 && vcount[9:0] >= yellowwall_y-72 && vcount[9:0]<yellowwall_y-36)begin
        yellowwall_address <= (hcount[10:1]-yellowwall_x+1) + (vcount[9:0]-yellowwall_y+72)*36;
        yellowwall_en <= 2'b1;  
      end
    //right side
    else if (hcount[10:1] >= 499 && hcount[10:1] < 499+36 && vcount[9:0] >= yellowwall_y && vcount[9:0]<yellowwall_y+36)begin
        yellowwall_address <= (hcount[10:1]-499+1) + (vcount[9:0]-yellowwall_y)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= 499 && hcount[10:1] < 499+36 && vcount[9:0] >= yellowwall_y+36 && vcount[9:0]<yellowwall_y+72)begin
        yellowwall_address <= (hcount[10:1]-499+1) + (vcount[9:0]-yellowwall_y-36)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= 499 && hcount[10:1] < 499+36 && vcount[9:0] >= yellowwall_y-36 && vcount[9:0]<yellowwall_y)begin
        yellowwall_address <= (hcount[10:1]-499+1) + (vcount[9:0]-yellowwall_y+36)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= 499 && hcount[10:1] < 499+36 && vcount[9:0] >= yellowwall_y+72 && vcount[9:0]<yellowwall_y+108)begin
        yellowwall_address <= (hcount[10:1]-499+1) + (vcount[9:0]-yellowwall_y-72)*36;
        yellowwall_en <= 2'b1;  
      end
    else if (hcount[10:1] >= 499 && hcount[10:1] < 499+36 && vcount[9:0] >= yellowwall_y-72 && vcount[9:0]<yellowwall_y-36)begin
        yellowwall_address <= (hcount[10:1]-499+1) + (vcount[9:0]-yellowwall_y+72)*36;
        yellowwall_en <= 2'b1;  
      end
    else begin
      yellowwall_en <= 2'b0;
    end
  end

  // Red Wall
  logic [9:0] redwall_x;
  logic [9:0] redwall_y;
  logic [10:0] redwall_address;
  redwall redwall_unit(.address(redwall_address), .clock(clk), .q(redwall_output));
  logic [15:0] redwall_output;
  logic [1:0] redwall_en;
  always_ff @(posedge clk) begin
    redwall_x <= 200;
    redwall_y <= 54;
    if (hcount[10:1] >= redwall_x && hcount[10:1] < redwall_x+36 && vcount[9:0] >= redwall_y && vcount[9:0]<redwall_y+36)begin
        redwall_address <= (hcount[10:1]-redwall_x+1) + (vcount[9:0]-redwall_y)*36;
        redwall_en <= 2'b0;
      end
    else begin
      redwall_en <= 2'b0;
    end
  end


  //EXPLOSION
  logic [12:0] explosion_address;
  logic [15:0] explosion_output;
  explosion explosion_unit(.address(explosion_address),.clock(clk),.q(explosion_output));
  logic[1:0] explosion_en;
  always_ff @(posedge clk) begin
		if (hcount[10:1] >= explosion_x && hcount[10:1] < explosion_x+32 && vcount[9:0] >= explosion_y && vcount[9:0]<explosion_y+32 && explosion_index == 4'd0)begin
      explosion_address <= (hcount[10:1]-explosion_x+1) + (vcount[9:0]-explosion_y)*32 + 32*32 * explosion_index;
      explosion_en <= 2'b1;  
		end
    else if (hcount[10:1] >= explosion_x && hcount[10:1] < explosion_x+32 && vcount[9:0] >= explosion_y && vcount[9:0]<explosion_y+32 && explosion_index == 4'd1)begin
      explosion_address <= (hcount[10:1]-explosion_x+1) + (vcount[9:0]-explosion_y)*32 + 32*32 * explosion_index;
      explosion_en <= 2'b1;  
		end
    else if (hcount[10:1] >= explosion_x && hcount[10:1] < explosion_x+32 && vcount[9:0] >= explosion_y && vcount[9:0]<explosion_y+32 && explosion_index == 4'd2)begin
      explosion_address <= (hcount[10:1]-explosion_x+1) + (vcount[9:0]-explosion_y)*32 + 32*32 * explosion_index;
      explosion_en <= 2'b1;  
		end
    else if (hcount[10:1] >= explosion_x && hcount[10:1] < explosion_x+32 && vcount[9:0] >= explosion_y && vcount[9:0]<explosion_y+32 && explosion_index == 4'd3)begin
      explosion_address <= (hcount[10:1]-explosion_x+1) + (vcount[9:0]-explosion_y)*32 + 32*32 * explosion_index;
      explosion_en <= 2'b1;  
		end
    else if (hcount[10:1] >= explosion_x && hcount[10:1] < explosion_x+32 && vcount[9:0] >= explosion_y && vcount[9:0]<explosion_y+32 && explosion_index == 4'd4)begin
      explosion_address <= (hcount[10:1]-explosion_x+1) + (vcount[9:0]-explosion_y)*32 + 32*32 * explosion_index;
      explosion_en <= 2'b1;  
		end
    else begin
			explosion_en <= 2'b0;
		end
  
  end

  //NUMBERS (44x52) 
  logic [10:0] h1;
  logic [14:0] digit1_address;
  logic [1:0] digit1_output;
  numbers digit1_unit(.address(digit1_address),.clock(clk),.q(digit1_output));
  logic[1:0] digit1_en;
  always_ff @(posedge clk) begin
    h1<= 200;
    if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd0)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd1)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    // Repeat for 4'd2 through 4'd9
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd2)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd3)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd4)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd5)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd6)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd7)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd8)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h1 && hcount[10:1] < h1+44 &&  vcount[9:0]< 52 && digit1_idx == 4'd9)begin
      digit1_address <= (hcount[10:1]-h1+1) + (vcount[9:0])*44 + 44*52 * digit1_idx;
      digit1_en <= 2'b1;  
    end
     else begin
			digit1_en <= 2'b0;
		end//54
  end

  logic [10:0] h2;
  logic [14:0] digit2_address;
  logic [1:0] digit2_output;
  numbers digit2_unit(.address(digit2_address),.clock(clk),.q(digit2_output));
  logic[1:0] digit2_en;
  always_ff @(posedge clk) begin
    h2 <= 146;
    if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd0)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd1)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    // Repeat for 4'd2 through 4'd9
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd2)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd3)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd4)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
     else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd5)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
            digit2_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd6)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd7)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd8)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h2 && hcount[10:1] < h2+44 &&  vcount[9:0]< 52 && digit2_idx == 4'd9)begin
      digit2_address <= (hcount[10:1]-h2+1) + (vcount[9:0])*44 + 44*52 * digit2_idx;
      digit2_en <= 2'b1;  
    end
    else begin
      digit2_en <= 2'b0;  
    end
  end
  
  logic [10:0] h3;
  logic [14:0] digit3_address;
  logic [1:0] digit3_output;
  numbers digit3_unit(.address(digit3_address),.clock(clk),.q(digit3_output));
  logic[1:0] digit3_en;
  always_ff @(posedge clk) begin
    h3<=448;
    if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd0)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd1)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1; 
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd2)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd3)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd4)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd5)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
        else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd6)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd7)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd8)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
    else if (hcount[10:1] >= h3 && hcount[10:1] < h3+44 &&  vcount[9:0]< 52 && digit3_idx == 4'd9)begin
      digit3_address <= (hcount[10:1]-h3+1) + (vcount[9:0])*44 + 44*52 * digit3_idx;
      digit3_en <= 2'b1;
    end
    else begin
      digit3_en <= 2'b0;  
    end
  end
  logic [10:0] h4;
  logic [14:0] digit4_address;
  logic [1:0] digit4_output;
  numbers digit4_unit(.address(digit4_address),.clock(clk),.q(digit4_output));
  logic[1:0] digit4_en;
  always_ff @(posedge clk) begin
    h4 <=394;
    if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd0)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1;  
    end
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd1)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    // Continue for 4'd2 through 4'd9
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd2)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd3)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd4)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd5)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd6)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd7)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd8)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else if (hcount[10:1] >= h4 && hcount[10:1] < h4+44 &&  vcount[9:0]< 52 && digit4_idx == 4'd9)begin
      digit4_address <= (hcount[10:1]-h4+1) + (vcount[9:0])*44 + 44*52 * digit4_idx;
      digit4_en <= 2'b1; 
    end 
    else begin
      digit4_en <= 2'b0; 
    end
  end

  logic [9:0] title_x;
  logic [9:0] title_y;
  logic [14:0] title_address;
  logic [15:0] title_output;
  title title_unit(.address(title_address),.clock(clk),.q(title_output));
  logic[1:0] title_en;
  always_ff @(posedge clk) begin
    title_x <= 160;
    title_y <= 213;
    if (hcount[10:1] >= title_x && hcount[10:1] < title_x+336 && vcount[9:0] >= title_y && vcount[9:0]<title_y+53)begin
        title_address <= (hcount[10:1]-title_x+1) + (vcount[9:0]-title_y)*336;
        title_en <= 2'b1;  
      end
    else begin
      title_en <= 2'b0;
    end
  end
   always_comb begin

      readdata = 16'd69;
      
      if(address == 4'hf)
        if(read)
          readdata ={contr2_fire, contr2_down, contr2_right, contr2_left, contr2_up, contr1_fire, contr1_down, contr1_right, contr1_left, contr1_up};
      {VGA_R, VGA_G, VGA_B} = {8'hc8, 8'had, 8'h7f}; // beige
      if (VGA_BLANK_n )begin
        //scores
        if(digit4_en && digit4_output[1:0] != 2'd0)begin 
          if(digit4_output == 2'd2)
            {VGA_R, VGA_G, VGA_B} = 24'hffffff;
          else if(digit4_output == 2'd1)
            {VGA_R, VGA_G, VGA_B} = 24'h3b92cb;
        end
        else if(digit3_en && digit3_output[1:0] != 2'd0)begin 
          if(digit3_output == 2'd2)
            {VGA_R, VGA_G, VGA_B} = 24'hffffff;
          else if(digit3_output == 2'd1)
            {VGA_R, VGA_G, VGA_B} = 24'h3b92cb;

        end
        else if(digit2_en && digit2_output[1:0] != 2'd0)begin 
          if(digit2_output == 2'd2)
            {VGA_R, VGA_G, VGA_B} = 24'hffffff;
          else if(digit2_output == 2'd1)
            {VGA_R, VGA_G, VGA_B} = 24'h23a158;

        end
        else if(digit1_en && digit1_output[1:0] != 2'd0)begin 
          if(digit1_output == 2'd2)
            {VGA_R, VGA_G, VGA_B} = 24'hffffff;
          else if(digit1_output == 2'd1)
            {VGA_R, VGA_G, VGA_B} = 24'h23a158;

        end

        else if(title_en && title_output[15:0]!=16'd0 && display_title)
          {VGA_R, VGA_G, VGA_B} = {{title_output[15:11],3'b000}, {title_output[10:5],2'b00}, {title_output[4:0],3'b000}};
        //borders
        else if (hcount[10:1] < 40 || hcount[10:1] > 600 || vcount[9:0] >440 || vcount[9:0]<50)
          {VGA_R, VGA_G, VGA_B} = {8'hc8, 8'h7b, 8'h2f};
        //explosion
        else if(explosion_en && explosion_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{explosion_output[15:11],3'b000}, {explosion_output[10:5],2'b00}, {explosion_output[4:0],3'b000}}; 
        //tanks
        else if(gtank_en && gtank_output[15:0] != 16'd0 && display_gtank)
          {VGA_R, VGA_G, VGA_B} = {{gtank_output[15:11],3'b000}, {gtank_output[10:5],2'b00}, {gtank_output[4:0],3'b000}};
        else if(btank_en && btank_output[15:0]!=16'd0 && display_btank)
          {VGA_R, VGA_G, VGA_B} = {{btank_output[15:11],3'b000}, {btank_output[10:5],2'b00}, {btank_output[4:0],3'b000}};
       //bullets
       else if(bulleta_en && bulleta_output[15:0] != 16'd0 && display_gbullet)
          {VGA_R, VGA_G, VGA_B} = {{bulleta_output[15:11],3'b000}, {bulleta_output[10:5],2'b00}, {bulleta_output[4:0],3'b000}};
        else if(bulletb_en && bulletb_output[15:0] != 16'd0 && display_bbullet)
          {VGA_R, VGA_G, VGA_B} = {{bulletb_output[15:11],3'b000}, {bulletb_output[10:5],2'b00}, {bulletb_output[4:0],3'b000}};
        
        
       
        // Red Jug
        else if(redjug_en && redjug_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{redjug_output[15:11],3'b000}, {redjug_output[10:5],2'b00}, {redjug_output[4:0],3'b000}};
        // Steel Barrel
        else if(steelbarrel_en && steelbarrel_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{steelbarrel_output[15:11],3'b000}, {steelbarrel_output[10:5],2'b00}, {steelbarrel_output[4:0],3'b000}};
        // Steel Box
        else if(steelbox_en && steelbox_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{steelbox_output[15:11],3'b000}, {steelbox_output[10:5],2'b00}, {steelbox_output[4:0],3'b000}};
        // Steel Jug
        else if(steeljug_en && steeljug_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{steeljug_output[15:11],3'b000}, {steeljug_output[10:5],2'b00}, {steeljug_output[4:0],3'b000}};
        // Sticks
        else if(sticks_en && sticks_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{sticks_output[15:11],3'b000}, {sticks_output[10:5],2'b00}, {sticks_output[4:0],3'b000}};
        // Tree
        else if(tree_en && tree_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{tree_output[15:11],3'b000}, {tree_output[10:5],2'b00}, {tree_output[4:0],3'b000}};
        // Wood Box
        else if(woodbox_en && woodbox_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{woodbox_output[15:11],3'b000}, {woodbox_output[10:5],2'b00}, {woodbox_output[4:0],3'b000}};
        // Wood X
        else if(woodx_en && woodx_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{woodx_output[15:11],3'b000}, {woodx_output[10:5],2'b00}, {woodx_output[4:0],3'b000}};
        // Yellow Wall
        else if(yellowwall_en && yellowwall_output[15:0] != 16'd0)
          {VGA_R, VGA_G, VGA_B} = {{yellowwall_output[15:11],3'b000}, {yellowwall_output[10:5],2'b00}, {yellowwall_output[4:0],3'b000}};

        // Red Wall
        else if(redwall_en && redwall_output[15:0] != 16'd0 && left_ready)
          {VGA_R, VGA_G, VGA_B} = {{redwall_output[15:11],3'b000}, {redwall_output[10:5],2'b00}, {redwall_output[4:0],3'b000}};
      end
   end
	       
endmodule



module vga_counters(
 input logic 	     clk50, reset,
 output logic [10:0] hcount,  // hcount[10:1] is pixel column
 output logic [9:0]  vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) &
		      !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   
endmodule
