

/*
 * modified from https://github.com/rmcbarreto/DE1-SoC-pipeline-haddoc2-rebuild
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>
#include <errno.h>
#include <fcntl.h>
#include <stdint.h>

#include "hwlib.h"
#include "socal/socal.h"
#include "socal/hps.h"
#include "socal/alt_gpio.h"

#include "hps_0.h"
#include "dma.h"

#define STB_IMAGE_IMPLEMENTATION
#include "stb_image.h"
#define STB_IMAGE_WRITE_IMPLEMENTATION
#include "stb_image_write.h"
#define IMAGE_FILE "test.png"


// settings for the lightweight HPS-to-FPGA bridge
// The ALT_STM_OFST starts at 0xfc000000 and the HW_REGS_SPAN of 0x04000000 occupies all the physical space until the end
// The lightweight HPS-to-FPGA bridge starts at 0xff200000 -> ALT_LWFPGASLVS_OFST
#define HW_REGS_BASE ( 0xfc000000 )
#define HW_REGS_SPAN ( 0x04000000 )
#define HW_REGS_MASK ( HW_REGS_SPAN - 1 )
#define ALT_LWFPGASLVS_OFST (0xff200000)

//setting for the HPS2FPGA AXI Bridge
#define ALT_AXI_FPGASLVS_OFST (0xC0000000) // axi_master
#define HW_FPGA_AXI_SPAN (0x40000000) // Bridge span 1GB
#define HW_FPGA_AXI_MASK ( HW_FPGA_AXI_SPAN - 1 )


#define _DMA_CONTROL_OFFSET	0x024


unsigned int * DMA_control_ptr = NULL;

int main(int argc, char **argv){

        // read image data from sd card (modified later when camera part finished)
	int width, height, channels;
	unsigned char *image_data = stbi_load(IMAGE_FILE, &width, &height, &channels, 1);
	int image_size = width*height;
	size_t MAP_SIZE = image_size * sizeof(unsigned char);

	int mem_fd = open("/dev/mem", ( O_RDWR | O_SYNC ));
	unsigned long physical_addr = 0x20000000;
	void *map_base = mmap(0, MAP_SIZE, PROT_READ|PROT_WRITE, MAP_SHARED, mem_fd, physical_addr);
	if (map_base == MAP_FAILED){
		printf("Can't mmap\n"); 
		return 1;
	}
	printf("map_base %p \n", map_base);
	memset(map_base, 0, MAP_SIZE);
	for(int i = 0; i < image_size; i++){
		*((unsigned char *)map_base+i) = image_data[i];
	}

	// DMA
	int fd = open("/dev/mem", O_RDWR|O_SYNC);
	if (fd == -1){
		printf("Error opening /dev/mem\n");
		return 1;
	}
	printf("/dev/mem opened. \n");
	void *virtual_base = mmap( NULL, HW_REGS_SPAN, ( PROT_READ | PROT_WRITE ), MAP_SHARED, fd, HW_REGS_BASE );
	if (map_base == MAP_FAILED){
		printf("Can't mmap\n"); 
		return 1;
	}
	printf("virtual base %p \n", virtual_base);


	void *lw_dma_addr = NULL;
	lw_dma_addr = virtual_base + ((unsigned int)(ALT_LWFPGASLVS_OFST + DMA_0_BASE) & (unsigned int)(HW_REGS_MASK));
	printf("lw_dma_addr %p\n", lw_dma_addr);

        clearDMAcontrol(lw_dma_addr);
   	_DMA_REG_STATUS(lw_dma_addr) = 0;
   	_DMA_REG_READ_ADDR(lw_dma_addr)  = physical_addr; 
   	_DMA_REG_WRITE_ADDR(lw_dma_addr) = 0;  
  	_DMA_REG_LENGTH(lw_dma_addr) = image_size;		
	
	//start the transfer
	_DMA_REG_CONTROL(lw_dma_addr) = _DMA_CTR_BYTE | _DMA_CTR_GO | _DMA_CTR_LEEN;
	waitDMAFinish(lw_dma_addr);
	printf("finished transfers to OCM \n");

	clearDMAcontrol(lw_dma_addr);
	_DMA_REG_STATUS(lw_dma_addr) = 0;


	// ready to read 
	void *start_read = virtual_base + ((unsigned long)(ALT_LWFPGASLVS_OFST+IMAGE_READ_START_BASE) & (unsigned long)( HW_REGS_MASK ) );
	*((uint32_t *)start_read) = 1;

	// check data written in the memroy
	for (int j=0; j < 4096; j++){
		unsigned char *data;
		data = map_base + j;
		printf("%u", *data);
	}


	if(munmap(map_base, MAP_SIZE) == -1){
		printf("Can't munmap\n");
		return 1;
	}


	close(mem_fd);

	
	return 0;



}
