`timescale 1ns / 1ps

// LeNet module representing a hardware implementation of the LeNet-5 Convolutional Neural Network
module LeNet
#(parameter M=8, N=0, Ma = 16, S_in1=28, N_ch1=1, S_f1=5, N_f1=6, S_C1=S_in1-S_f1+1, S_P1=S_C1/2,
  S_in2=S_P1, N_ch2=N_f1, S_f2=5, N_f2=12, S_C2=S_in2-S_f2+1, S_P2=S_C2/2,
  S_fc=N_f2*S_P2*S_P2, C=10,
  N_Weights=N_ch1*S_f1*S_f1*N_f1+N_ch2*S_f2*S_f2*N_f2+S_fc*C)(
// Declaration Block
input clk, rst,
output [M-1:0]LeNet_Out);

// Control Signals
wire [M-1:0]O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, I10, I11, I12, I13, I14;
wire [Ma-1:0]A;
reg [Ma-1:0]A1, A2, A3, A4, A5, A6,
           A11, A12, A13, A14, A15,
           ori, CA, C_c, S_in, N_ch, S_P, S_C;
wire a, C_finish, FC_finish, rstp;

reg rstc, rstf;

// Control Signals
reg [Ma-1:0]Wi;

// Convolution Reg/Wire
wire [Ma-1:0]Ai0, Ai1, Ai2, Ai3, Ai4;
wire [Ma-1:0]Fri, Fi;
wire [M-1:0]Po1, Po2, Po3, Po4, Po5, Po6;
wire [M-1:0]W10, W11, W12, W13, W14,
            W20, W21, W22, W23, W24,
            W30, W31, W32, W33, W34,
            W40, W41, W42, W43, W44,
            W50, W51, W52, W53, W54,
            W60, W61, W62, W63, W64;
wire [Ma-1:0]Aw0, Aw1, Aw2, Aw3, Aw4,
            Aw5, Aw6, Aw7, Aw8, Aw9,
            Aw10, Aw11, Aw12, Aw13,
            Aw14, Aw15, Aw16, Aw17,
            Aw18, Aw19, Aw20, Aw21,
            Aw22, Aw23, Aw24, Aw25,
            Aw26, Aw27, Aw28, Aw29;

// Convolution Control Signals
wire [Ma-1:0]FCi, FcFi;

// Fully Connected Reg/Wire
wire [M-1:0]W0, W1, W2, W3, W4, W5, W6, W7, W8, W9;
wire [M-1:0]Ii;

// Memory
reg [M-1:0]W[0:N_Weights-1], I[0:S_in1*S_in1*N_ch1-1],
           P1[0:(S_P1*S_P1-1)][0:N_f1-1], P2[0:(S_P2*S_P2-1)][0:N_f2-1];

// Fully Connected Control Signals
wire [Ma-1:0]Wfi, Wf;
reg [Ma-1:0]Poolif;

// Initialization Block
initial 
begin
I[0] = 8'b0000000000;
I[1] = 8'b0000000000;
I[2] = 8'b0000000000;
I[3] = 8'b0000000000;
I[4] = 8'b0000000000;
I[5] = 8'b0000000000;
I[6] = 8'b0000000000;
I[7] = 8'b0000000000;
I[8] = 8'b0000000000;
I[9] = 8'b0000000000;
I[10] = 8'b0000000000;
I[11] = 8'b0000000000;
I[12] = 8'b0000000000;
I[13] = 8'b0000000000;
I[14] = 8'b0000000000;
I[15] = 8'b0000000000;
I[16] = 8'b0000000000;
I[17] = 8'b0000000000;
I[18] = 8'b0000000000;
I[19] = 8'b0000000000;
I[20] = 8'b0000000000;
I[21] = 8'b0000000000;
I[22] = 8'b0000000000;
I[23] = 8'b0000000000;
I[24] = 8'b0000000000;
I[25] = 8'b0000000000;
I[26] = 8'b0000000000;
I[27] = 8'b0000000000;
I[28] = 8'b0000000000;
I[29] = 8'b0000000000;
I[30] = 8'b0000000000;
I[31] = 8'b0000000000;
I[32] = 8'b0000000000;
I[33] = 8'b0000000000;
I[34] = 8'b0000000000;
I[35] = 8'b0000000000;
I[36] = 8'b0000000000;
I[37] = 8'b0000000000;
I[38] = 8'b0000000000;
I[39] = 8'b0000000000;
I[40] = 8'b0000000000;
I[41] = 8'b0000000000;
I[42] = 8'b0000000000;
I[43] = 8'b0000000000;
I[44] = 8'b0000000000;
I[45] = 8'b0000000000;
I[46] = 8'b0000000000;
I[47] = 8'b0000000000;
I[48] = 8'b0000000000;
I[49] = 8'b0000000000;
I[50] = 8'b0000000000;
I[51] = 8'b0000000000;
I[52] = 8'b0000000000;
I[53] = 8'b0000000000;
I[54] = 8'b0000000000;
I[55] = 8'b0000000000;
I[56] = 8'b0000000000;
I[57] = 8'b0000000000;
I[58] = 8'b0000000000;
I[59] = 8'b0000000000;
I[60] = 8'b0000000000;
I[61] = 8'b0000000000;
I[62] = 8'b0000000000;
I[63] = 8'b0000000000;
I[64] = 8'b0000000000;
I[65] = 8'b0000000000;
I[66] = 8'b0000000000;
I[67] = 8'b0000000000;
I[68] = 8'b0000000000;
I[69] = 8'b0000000000;
I[70] = 8'b0000000000;
I[71] = 8'b0000000000;
I[72] = 8'b0000000000;
I[73] = 8'b0000000000;
I[74] = 8'b0000000000;
I[75] = 8'b0000000000;
I[76] = 8'b0000000000;
I[77] = 8'b0000000000;
I[78] = 8'b0000000000;
I[79] = 8'b0000000000;
I[80] = 8'b0000000000;
I[81] = 8'b0000000000;
I[82] = 8'b0000000000;
I[83] = 8'b0000000000;
I[84] = 8'b0000000000;
I[85] = 8'b0000000000;
I[86] = 8'b0000000000;
I[87] = 8'b0000000000;
I[88] = 8'b0000000000;
I[89] = 8'b0000000000;
I[90] = 8'b0000000000;
I[91] = 8'b0000000000;
I[92] = 8'b0000000000;
I[93] = 8'b0000000000;
I[94] = 8'b0000000000;
I[95] = 8'b0000000000;
I[96] = 8'b0000000000;
I[97] = 8'b0000000000;
I[98] = 8'b0000000000;
I[99] = 8'b0000000000;
I[100] = 8'b0000000000;
I[101] = 8'b0000000000;
I[102] = 8'b0000000000;
I[103] = 8'b0000000000;
I[104] = 8'b0000000000;
I[105] = 8'b0000000000;
I[106] = 8'b0000000000;
I[107] = 8'b0000000000;
I[108] = 8'b0000000000;
I[109] = 8'b0000000000;
I[110] = 8'b0000000000;
I[111] = 8'b0000000000;
I[112] = 8'b0000000000;
I[113] = 8'b0000000000;
I[114] = 8'b0000000000;
I[115] = 8'b0000000000;
I[116] = 8'b0000000000;
I[117] = 8'b0000000000;
I[118] = 8'b0000000000;
I[119] = 8'b0000000000;
I[120] = 8'b0000000000;
I[121] = 8'b0000000000;
I[122] = 8'b0000000000;
I[123] = 8'b0000000000;
I[124] = 8'b0000000000;
I[125] = 8'b0000000000;
I[126] = 8'b0000000000;
I[127] = 8'b0000000000;
I[128] = 8'b0000000000;
I[129] = 8'b0000000000;
I[130] = 8'b0000000000;
I[131] = 8'b0000000000;
I[132] = 8'b0000000000;
I[133] = 8'b0000000000;
I[134] = 8'b0000000000;
I[135] = 8'b0000000000;
I[136] = 8'b0000000000;
I[137] = 8'b0000000000;
I[138] = 8'b0000000000;
I[139] = 8'b0000000000;
I[140] = 8'b0000000000;
I[141] = 8'b0000000000;
I[142] = 8'b0000000000;
I[143] = 8'b0000000000;
I[144] = 8'b0000000000;
I[145] = 8'b0000000000;
I[146] = 8'b0000000000;
I[147] = 8'b0000000000;
I[148] = 8'b0000000000;
I[149] = 8'b0000000000;
I[150] = 8'b0000000000;
I[151] = 8'b0000100110;
I[152] = 8'b0000101011;
I[153] = 8'b0001101001;
I[154] = 8'b0100000000;
I[155] = 8'b0011111101;
I[156] = 8'b0011111101;
I[157] = 8'b0011111101;
I[158] = 8'b0011111101;
I[159] = 8'b0011111101;
I[160] = 8'b0010101110;
I[161] = 8'b0000000110;
I[162] = 8'b0000000000;
I[163] = 8'b0000000000;
I[164] = 8'b0000000000;
I[165] = 8'b0000000000;
I[166] = 8'b0000000000;
I[167] = 8'b0000000000;
I[168] = 8'b0000000000;
I[169] = 8'b0000000000;
I[170] = 8'b0000000000;
I[171] = 8'b0000000000;
I[172] = 8'b0000000000;
I[173] = 8'b0000000000;
I[174] = 8'b0000000000;
I[175] = 8'b0000000000;
I[176] = 8'b0000000000;
I[177] = 8'b0000101011;
I[178] = 8'b0010001011;
I[179] = 8'b0011100000;
I[180] = 8'b0011100010;
I[181] = 8'b0011111100;
I[182] = 8'b0011111101;
I[183] = 8'b0011111100;
I[184] = 8'b0011111100;
I[185] = 8'b0011111100;
I[186] = 8'b0011111100;
I[187] = 8'b0011111100;
I[188] = 8'b0011111100;
I[189] = 8'b0010011110;
I[190] = 8'b0000001110;
I[191] = 8'b0000000000;
I[192] = 8'b0000000000;
I[193] = 8'b0000000000;
I[194] = 8'b0000000000;
I[195] = 8'b0000000000;
I[196] = 8'b0000000000;
I[197] = 8'b0000000000;
I[198] = 8'b0000000000;
I[199] = 8'b0000000000;
I[200] = 8'b0000000000;
I[201] = 8'b0000000000;
I[202] = 8'b0000000000;
I[203] = 8'b0000000000;
I[204] = 8'b0000000000;
I[205] = 8'b0010110010;
I[206] = 8'b0011111100;
I[207] = 8'b0011111100;
I[208] = 8'b0011111100;
I[209] = 8'b0011111100;
I[210] = 8'b0011111101;
I[211] = 8'b0011111100;
I[212] = 8'b0011111100;
I[213] = 8'b0011111100;
I[214] = 8'b0011111100;
I[215] = 8'b0011111100;
I[216] = 8'b0011111100;
I[217] = 8'b0011111100;
I[218] = 8'b0000111011;
I[219] = 8'b0000000000;
I[220] = 8'b0000000000;
I[221] = 8'b0000000000;
I[222] = 8'b0000000000;
I[223] = 8'b0000000000;
I[224] = 8'b0000000000;
I[225] = 8'b0000000000;
I[226] = 8'b0000000000;
I[227] = 8'b0000000000;
I[228] = 8'b0000000000;
I[229] = 8'b0000000000;
I[230] = 8'b0000000000;
I[231] = 8'b0000000000;
I[232] = 8'b0000000000;
I[233] = 8'b0001101101;
I[234] = 8'b0011111100;
I[235] = 8'b0011111100;
I[236] = 8'b0011100110;
I[237] = 8'b0010000100;
I[238] = 8'b0010000101;
I[239] = 8'b0010000100;
I[240] = 8'b0010000100;
I[241] = 8'b0010111101;
I[242] = 8'b0011111100;
I[243] = 8'b0011111100;
I[244] = 8'b0011111100;
I[245] = 8'b0011111100;
I[246] = 8'b0000111011;
I[247] = 8'b0000000000;
I[248] = 8'b0000000000;
I[249] = 8'b0000000000;
I[250] = 8'b0000000000;
I[251] = 8'b0000000000;
I[252] = 8'b0000000000;
I[253] = 8'b0000000000;
I[254] = 8'b0000000000;
I[255] = 8'b0000000000;
I[256] = 8'b0000000000;
I[257] = 8'b0000000000;
I[258] = 8'b0000000000;
I[259] = 8'b0000000000;
I[260] = 8'b0000000000;
I[261] = 8'b0000000100;
I[262] = 8'b0000011101;
I[263] = 8'b0000011101;
I[264] = 8'b0000011000;
I[265] = 8'b0000000000;
I[266] = 8'b0000000000;
I[267] = 8'b0000000000;
I[268] = 8'b0000000000;
I[269] = 8'b0000001110;
I[270] = 8'b0011100010;
I[271] = 8'b0011111100;
I[272] = 8'b0011111100;
I[273] = 8'b0010101100;
I[274] = 8'b0000000111;
I[275] = 8'b0000000000;
I[276] = 8'b0000000000;
I[277] = 8'b0000000000;
I[278] = 8'b0000000000;
I[279] = 8'b0000000000;
I[280] = 8'b0000000000;
I[281] = 8'b0000000000;
I[282] = 8'b0000000000;
I[283] = 8'b0000000000;
I[284] = 8'b0000000000;
I[285] = 8'b0000000000;
I[286] = 8'b0000000000;
I[287] = 8'b0000000000;
I[288] = 8'b0000000000;
I[289] = 8'b0000000000;
I[290] = 8'b0000000000;
I[291] = 8'b0000000000;
I[292] = 8'b0000000000;
I[293] = 8'b0000000000;
I[294] = 8'b0000000000;
I[295] = 8'b0000000000;
I[296] = 8'b0000000000;
I[297] = 8'b0001010101;
I[298] = 8'b0011110011;
I[299] = 8'b0011111100;
I[300] = 8'b0011111100;
I[301] = 8'b0010010000;
I[302] = 8'b0000000000;
I[303] = 8'b0000000000;
I[304] = 8'b0000000000;
I[305] = 8'b0000000000;
I[306] = 8'b0000000000;
I[307] = 8'b0000000000;
I[308] = 8'b0000000000;
I[309] = 8'b0000000000;
I[310] = 8'b0000000000;
I[311] = 8'b0000000000;
I[312] = 8'b0000000000;
I[313] = 8'b0000000000;
I[314] = 8'b0000000000;
I[315] = 8'b0000000000;
I[316] = 8'b0000000000;
I[317] = 8'b0000000000;
I[318] = 8'b0000000000;
I[319] = 8'b0000000000;
I[320] = 8'b0000000000;
I[321] = 8'b0000000000;
I[322] = 8'b0000000000;
I[323] = 8'b0000000000;
I[324] = 8'b0001011000;
I[325] = 8'b0010111101;
I[326] = 8'b0011111100;
I[327] = 8'b0011111100;
I[328] = 8'b0011111100;
I[329] = 8'b0000001110;
I[330] = 8'b0000000000;
I[331] = 8'b0000000000;
I[332] = 8'b0000000000;
I[333] = 8'b0000000000;
I[334] = 8'b0000000000;
I[335] = 8'b0000000000;
I[336] = 8'b0000000000;
I[337] = 8'b0000000000;
I[338] = 8'b0000000000;
I[339] = 8'b0000000000;
I[340] = 8'b0000000000;
I[341] = 8'b0000000000;
I[342] = 8'b0000000000;
I[343] = 8'b0000000000;
I[344] = 8'b0000000000;
I[345] = 8'b0000000000;
I[346] = 8'b0000000000;
I[347] = 8'b0000000000;
I[348] = 8'b0000000000;
I[349] = 8'b0000000000;
I[350] = 8'b0001011011;
I[351] = 8'b0011010100;
I[352] = 8'b0011110111;
I[353] = 8'b0011111100;
I[354] = 8'b0011111100;
I[355] = 8'b0011111100;
I[356] = 8'b0011001100;
I[357] = 8'b0000001001;
I[358] = 8'b0000000000;
I[359] = 8'b0000000000;
I[360] = 8'b0000000000;
I[361] = 8'b0000000000;
I[362] = 8'b0000000000;
I[363] = 8'b0000000000;
I[364] = 8'b0000000000;
I[365] = 8'b0000000000;
I[366] = 8'b0000000000;
I[367] = 8'b0000000000;
I[368] = 8'b0000000000;
I[369] = 8'b0000000000;
I[370] = 8'b0000000000;
I[371] = 8'b0000000000;
I[372] = 8'b0000000000;
I[373] = 8'b0000100000;
I[374] = 8'b0001111101;
I[375] = 8'b0011000001;
I[376] = 8'b0011000001;
I[377] = 8'b0011000001;
I[378] = 8'b0011111101;
I[379] = 8'b0011111100;
I[380] = 8'b0011111100;
I[381] = 8'b0011111100;
I[382] = 8'b0011101110;
I[383] = 8'b0001100110;
I[384] = 8'b0000011100;
I[385] = 8'b0000000000;
I[386] = 8'b0000000000;
I[387] = 8'b0000000000;
I[388] = 8'b0000000000;
I[389] = 8'b0000000000;
I[390] = 8'b0000000000;
I[391] = 8'b0000000000;
I[392] = 8'b0000000000;
I[393] = 8'b0000000000;
I[394] = 8'b0000000000;
I[395] = 8'b0000000000;
I[396] = 8'b0000000000;
I[397] = 8'b0000000000;
I[398] = 8'b0000000000;
I[399] = 8'b0000000000;
I[400] = 8'b0000101101;
I[401] = 8'b0011011110;
I[402] = 8'b0011111100;
I[403] = 8'b0011111100;
I[404] = 8'b0011111100;
I[405] = 8'b0011111100;
I[406] = 8'b0011111101;
I[407] = 8'b0011111100;
I[408] = 8'b0011111100;
I[409] = 8'b0011111100;
I[410] = 8'b0010110001;
I[411] = 8'b0000000000;
I[412] = 8'b0000000000;
I[413] = 8'b0000000000;
I[414] = 8'b0000000000;
I[415] = 8'b0000000000;
I[416] = 8'b0000000000;
I[417] = 8'b0000000000;
I[418] = 8'b0000000000;
I[419] = 8'b0000000000;
I[420] = 8'b0000000000;
I[421] = 8'b0000000000;
I[422] = 8'b0000000000;
I[423] = 8'b0000000000;
I[424] = 8'b0000000000;
I[425] = 8'b0000000000;
I[426] = 8'b0000000000;
I[427] = 8'b0000000000;
I[428] = 8'b0000101101;
I[429] = 8'b0011011111;
I[430] = 8'b0011111101;
I[431] = 8'b0011111101;
I[432] = 8'b0011111101;
I[433] = 8'b0011111101;
I[434] = 8'b0100000000;
I[435] = 8'b0011111101;
I[436] = 8'b0011111101;
I[437] = 8'b0011111101;
I[438] = 8'b0011111101;
I[439] = 8'b0001001010;
I[440] = 8'b0000000000;
I[441] = 8'b0000000000;
I[442] = 8'b0000000000;
I[443] = 8'b0000000000;
I[444] = 8'b0000000000;
I[445] = 8'b0000000000;
I[446] = 8'b0000000000;
I[447] = 8'b0000000000;
I[448] = 8'b0000000000;
I[449] = 8'b0000000000;
I[450] = 8'b0000000000;
I[451] = 8'b0000000000;
I[452] = 8'b0000000000;
I[453] = 8'b0000000000;
I[454] = 8'b0000000000;
I[455] = 8'b0000000000;
I[456] = 8'b0000000000;
I[457] = 8'b0000011111;
I[458] = 8'b0001111011;
I[459] = 8'b0000110100;
I[460] = 8'b0000101100;
I[461] = 8'b0000101100;
I[462] = 8'b0000101100;
I[463] = 8'b0000101100;
I[464] = 8'b0010001111;
I[465] = 8'b0011111100;
I[466] = 8'b0011111100;
I[467] = 8'b0001001010;
I[468] = 8'b0000000000;
I[469] = 8'b0000000000;
I[470] = 8'b0000000000;
I[471] = 8'b0000000000;
I[472] = 8'b0000000000;
I[473] = 8'b0000000000;
I[474] = 8'b0000000000;
I[475] = 8'b0000000000;
I[476] = 8'b0000000000;
I[477] = 8'b0000000000;
I[478] = 8'b0000000000;
I[479] = 8'b0000000000;
I[480] = 8'b0000000000;
I[481] = 8'b0000000000;
I[482] = 8'b0000000000;
I[483] = 8'b0000000000;
I[484] = 8'b0000000000;
I[485] = 8'b0000000000;
I[486] = 8'b0000000000;
I[487] = 8'b0000000000;
I[488] = 8'b0000000000;
I[489] = 8'b0000000000;
I[490] = 8'b0000000000;
I[491] = 8'b0000000000;
I[492] = 8'b0000001111;
I[493] = 8'b0011111100;
I[494] = 8'b0011111100;
I[495] = 8'b0001001010;
I[496] = 8'b0000000000;
I[497] = 8'b0000000000;
I[498] = 8'b0000000000;
I[499] = 8'b0000000000;
I[500] = 8'b0000000000;
I[501] = 8'b0000000000;
I[502] = 8'b0000000000;
I[503] = 8'b0000000000;
I[504] = 8'b0000000000;
I[505] = 8'b0000000000;
I[506] = 8'b0000000000;
I[507] = 8'b0000000000;
I[508] = 8'b0000000000;
I[509] = 8'b0000000000;
I[510] = 8'b0000000000;
I[511] = 8'b0000000000;
I[512] = 8'b0000000000;
I[513] = 8'b0000000000;
I[514] = 8'b0000000000;
I[515] = 8'b0000000000;
I[516] = 8'b0000000000;
I[517] = 8'b0000000000;
I[518] = 8'b0000000000;
I[519] = 8'b0000000000;
I[520] = 8'b0001010110;
I[521] = 8'b0011111100;
I[522] = 8'b0011111100;
I[523] = 8'b0001001010;
I[524] = 8'b0000000000;
I[525] = 8'b0000000000;
I[526] = 8'b0000000000;
I[527] = 8'b0000000000;
I[528] = 8'b0000000000;
I[529] = 8'b0000000000;
I[530] = 8'b0000000000;
I[531] = 8'b0000000000;
I[532] = 8'b0000000000;
I[533] = 8'b0000000000;
I[534] = 8'b0000000000;
I[535] = 8'b0000000000;
I[536] = 8'b0000000000;
I[537] = 8'b0000000000;
I[538] = 8'b0000000101;
I[539] = 8'b0001001011;
I[540] = 8'b0000001001;
I[541] = 8'b0000000000;
I[542] = 8'b0000000000;
I[543] = 8'b0000000000;
I[544] = 8'b0000000000;
I[545] = 8'b0000000000;
I[546] = 8'b0000000000;
I[547] = 8'b0001100010;
I[548] = 8'b0011110010;
I[549] = 8'b0011111100;
I[550] = 8'b0011111100;
I[551] = 8'b0001001010;
I[552] = 8'b0000000000;
I[553] = 8'b0000000000;
I[554] = 8'b0000000000;
I[555] = 8'b0000000000;
I[556] = 8'b0000000000;
I[557] = 8'b0000000000;
I[558] = 8'b0000000000;
I[559] = 8'b0000000000;
I[560] = 8'b0000000000;
I[561] = 8'b0000000000;
I[562] = 8'b0000000000;
I[563] = 8'b0000000000;
I[564] = 8'b0000000000;
I[565] = 8'b0000111101;
I[566] = 8'b0010110111;
I[567] = 8'b0011111100;
I[568] = 8'b0000011101;
I[569] = 8'b0000000000;
I[570] = 8'b0000000000;
I[571] = 8'b0000000000;
I[572] = 8'b0000000000;
I[573] = 8'b0000010010;
I[574] = 8'b0001011100;
I[575] = 8'b0011101111;
I[576] = 8'b0011111100;
I[577] = 8'b0011111100;
I[578] = 8'b0011110011;
I[579] = 8'b0001000001;
I[580] = 8'b0000000000;
I[581] = 8'b0000000000;
I[582] = 8'b0000000000;
I[583] = 8'b0000000000;
I[584] = 8'b0000000000;
I[585] = 8'b0000000000;
I[586] = 8'b0000000000;
I[587] = 8'b0000000000;
I[588] = 8'b0000000000;
I[589] = 8'b0000000000;
I[590] = 8'b0000000000;
I[591] = 8'b0000000000;
I[592] = 8'b0000000000;
I[593] = 8'b0011010000;
I[594] = 8'b0011111100;
I[595] = 8'b0011111100;
I[596] = 8'b0010010011;
I[597] = 8'b0010000110;
I[598] = 8'b0010000110;
I[599] = 8'b0010000110;
I[600] = 8'b0010000110;
I[601] = 8'b0011001011;
I[602] = 8'b0011111101;
I[603] = 8'b0011111100;
I[604] = 8'b0011111100;
I[605] = 8'b0010111100;
I[606] = 8'b0001010011;
I[607] = 8'b0000000000;
I[608] = 8'b0000000000;
I[609] = 8'b0000000000;
I[610] = 8'b0000000000;
I[611] = 8'b0000000000;
I[612] = 8'b0000000000;
I[613] = 8'b0000000000;
I[614] = 8'b0000000000;
I[615] = 8'b0000000000;
I[616] = 8'b0000000000;
I[617] = 8'b0000000000;
I[618] = 8'b0000000000;
I[619] = 8'b0000000000;
I[620] = 8'b0000000000;
I[621] = 8'b0011010000;
I[622] = 8'b0011111100;
I[623] = 8'b0011111100;
I[624] = 8'b0011111100;
I[625] = 8'b0011111100;
I[626] = 8'b0011111100;
I[627] = 8'b0011111100;
I[628] = 8'b0011111100;
I[629] = 8'b0011111100;
I[630] = 8'b0011111101;
I[631] = 8'b0011100110;
I[632] = 8'b0010011001;
I[633] = 8'b0000001000;
I[634] = 8'b0000000000;
I[635] = 8'b0000000000;
I[636] = 8'b0000000000;
I[637] = 8'b0000000000;
I[638] = 8'b0000000000;
I[639] = 8'b0000000000;
I[640] = 8'b0000000000;
I[641] = 8'b0000000000;
I[642] = 8'b0000000000;
I[643] = 8'b0000000000;
I[644] = 8'b0000000000;
I[645] = 8'b0000000000;
I[646] = 8'b0000000000;
I[647] = 8'b0000000000;
I[648] = 8'b0000000000;
I[649] = 8'b0000110001;
I[650] = 8'b0010011101;
I[651] = 8'b0011111100;
I[652] = 8'b0011111100;
I[653] = 8'b0011111100;
I[654] = 8'b0011111100;
I[655] = 8'b0011111100;
I[656] = 8'b0011011001;
I[657] = 8'b0011001111;
I[658] = 8'b0010010010;
I[659] = 8'b0000101101;
I[660] = 8'b0000000000;
I[661] = 8'b0000000000;
I[662] = 8'b0000000000;
I[663] = 8'b0000000000;
I[664] = 8'b0000000000;
I[665] = 8'b0000000000;
I[666] = 8'b0000000000;
I[667] = 8'b0000000000;
I[668] = 8'b0000000000;
I[669] = 8'b0000000000;
I[670] = 8'b0000000000;
I[671] = 8'b0000000000;
I[672] = 8'b0000000000;
I[673] = 8'b0000000000;
I[674] = 8'b0000000000;
I[675] = 8'b0000000000;
I[676] = 8'b0000000000;
I[677] = 8'b0000000000;
I[678] = 8'b0000000111;
I[679] = 8'b0001100111;
I[680] = 8'b0011101011;
I[681] = 8'b0011111100;
I[682] = 8'b0010101100;
I[683] = 8'b0001100111;
I[684] = 8'b0000011000;
I[685] = 8'b0000000000;
I[686] = 8'b0000000000;
I[687] = 8'b0000000000;
I[688] = 8'b0000000000;
I[689] = 8'b0000000000;
I[690] = 8'b0000000000;
I[691] = 8'b0000000000;
I[692] = 8'b0000000000;
I[693] = 8'b0000000000;
I[694] = 8'b0000000000;
I[695] = 8'b0000000000;
I[696] = 8'b0000000000;
I[697] = 8'b0000000000;
I[698] = 8'b0000000000;
I[699] = 8'b0000000000;
I[700] = 8'b0000000000;
I[701] = 8'b0000000000;
I[702] = 8'b0000000000;
I[703] = 8'b0000000000;
I[704] = 8'b0000000000;
I[705] = 8'b0000000000;
I[706] = 8'b0000000000;
I[707] = 8'b0000000000;
I[708] = 8'b0000000000;
I[709] = 8'b0000000000;
I[710] = 8'b0000000000;
I[711] = 8'b0000000000;
I[712] = 8'b0000000000;
I[713] = 8'b0000000000;
I[714] = 8'b0000000000;
I[715] = 8'b0000000000;
I[716] = 8'b0000000000;
I[717] = 8'b0000000000;
I[718] = 8'b0000000000;
I[719] = 8'b0000000000;
I[720] = 8'b0000000000;
I[721] = 8'b0000000000;
I[722] = 8'b0000000000;
I[723] = 8'b0000000000;
I[724] = 8'b0000000000;
I[725] = 8'b0000000000;
I[726] = 8'b0000000000;
I[727] = 8'b0000000000;
I[728] = 8'b0000000000;
I[729] = 8'b0000000000;
I[730] = 8'b0000000000;
I[731] = 8'b0000000000;
I[732] = 8'b0000000000;
I[733] = 8'b0000000000;
I[734] = 8'b0000000000;
I[735] = 8'b0000000000;
I[736] = 8'b0000000000;
I[737] = 8'b0000000000;
I[738] = 8'b0000000000;
I[739] = 8'b0000000000;
I[740] = 8'b0000000000;
I[741] = 8'b0000000000;
I[742] = 8'b0000000000;
I[743] = 8'b0000000000;
I[744] = 8'b0000000000;
I[745] = 8'b0000000000;
I[746] = 8'b0000000000;
I[747] = 8'b0000000000;
I[748] = 8'b0000000000;
I[749] = 8'b0000000000;
I[750] = 8'b0000000000;
I[751] = 8'b0000000000;
I[752] = 8'b0000000000;
I[753] = 8'b0000000000;
I[754] = 8'b0000000000;
I[755] = 8'b0000000000;
I[756] = 8'b0000000000;
I[757] = 8'b0000000000;
I[758] = 8'b0000000000;
I[759] = 8'b0000000000;
I[760] = 8'b0000000000;
I[761] = 8'b0000000000;
I[762] = 8'b0000000000;
I[763] = 8'b0000000000;
I[764] = 8'b0000000000;
I[765] = 8'b0000000000;
I[766] = 8'b0000000000;
I[767] = 8'b0000000000;
I[768] = 8'b0000000000;
I[769] = 8'b0000000000;
I[770] = 8'b0000000000;
I[771] = 8'b0000000000;
I[772] = 8'b0000000000;
I[773] = 8'b0000000000;
I[774] = 8'b0000000000;
I[775] = 8'b0000000000;
I[776] = 8'b0000000000;
I[777] = 8'b0000000000;
I[778] = 8'b0000000000;
I[779] = 8'b0000000000;
I[780] = 8'b0000000000;
I[781] = 8'b0000000000;
I[782] = 8'b0000000000;
I[783] = 8'b0000000000;
W[0] = 8'b0000000110;
W[1] = 8'b0000010101;
W[2] = 8'b0000110010;
W[3] = 8'b1111110000;
W[4] = 8'b0000000110;
W[5] = 8'b1111010101;
W[6] = 8'b1111110010;
W[7] = 8'b1111111011;
W[8] = 8'b1110110000;
W[9] = 8'b1111000111;
W[10] = 8'b1111001000;
W[11] = 8'b0000010000;
W[12] = 8'b0000101001;
W[13] = 8'b0000100011;
W[14] = 8'b0000000010;
W[15] = 8'b1111011000;
W[16] = 8'b0001101000;
W[17] = 8'b0001010000;
W[18] = 8'b0000011000;
W[19] = 8'b0000100101;
W[20] = 8'b1111100111;
W[21] = 8'b0000101001;
W[22] = 8'b1110100101;
W[23] = 8'b1110010000;
W[24] = 8'b0000010101;
W[25] = 8'b1111110111;
W[26] = 8'b1111100111;
W[27] = 8'b1111000011;
W[28] = 8'b1110110011;
W[29] = 8'b1111100001;
W[30] = 8'b0000001110;
W[31] = 8'b1110110100;
W[32] = 8'b1110010011;
W[33] = 8'b1110111111;
W[34] = 8'b1111011100;
W[35] = 8'b0001000000;
W[36] = 8'b0000100000;
W[37] = 8'b0000010000;
W[38] = 8'b1111100000;
W[39] = 8'b1111100100;
W[40] = 8'b0001010111;
W[41] = 8'b0000100000;
W[42] = 8'b0001100010;
W[43] = 8'b0000111110;
W[44] = 8'b0001000001;
W[45] = 8'b0000000110;
W[46] = 8'b0000001000;
W[47] = 8'b0001000011;
W[48] = 8'b1111110100;
W[49] = 8'b0000110000;
W[50] = 8'b1111011111;
W[51] = 8'b0000100001;
W[52] = 8'b0000001001;
W[53] = 8'b0000110001;
W[54] = 8'b0000100011;
W[55] = 8'b1111111000;
W[56] = 8'b0000010101;
W[57] = 8'b1111010011;
W[58] = 8'b1111101000;
W[59] = 8'b1111000011;
W[60] = 8'b1111110100;
W[61] = 8'b0000011101;
W[62] = 8'b1111100010;
W[63] = 8'b0000010111;
W[64] = 8'b1111111111;
W[65] = 8'b0000001101;
W[66] = 8'b0000000010;
W[67] = 8'b0000001101;
W[68] = 8'b0000100110;
W[69] = 8'b0000000000;
W[70] = 8'b0000100000;
W[71] = 8'b1111110000;
W[72] = 8'b0000001110;
W[73] = 8'b1111111100;
W[74] = 8'b1111011101;
W[75] = 8'b1111100000;
W[76] = 8'b0000110000;
W[77] = 8'b1111111010;
W[78] = 8'b0000000000;
W[79] = 8'b1111100111;
W[80] = 8'b1111001101;
W[81] = 8'b0000001011;
W[82] = 8'b0000000100;
W[83] = 8'b1111110011;
W[84] = 8'b1111001110;
W[85] = 8'b1111100111;
W[86] = 8'b0001000101;
W[87] = 8'b0000010110;
W[88] = 8'b1110111000;
W[89] = 8'b1111011101;
W[90] = 8'b0000000010;
W[91] = 8'b0000000011;
W[92] = 8'b0000011010;
W[93] = 8'b1111101011;
W[94] = 8'b1111000010;
W[95] = 8'b0000010001;
W[96] = 8'b0000000010;
W[97] = 8'b0000011001;
W[98] = 8'b1111011001;
W[99] = 8'b1111101110;
W[100] = 8'b0000101100;
W[101] = 8'b0000011000;
W[102] = 8'b0000011101;
W[103] = 8'b1111110100;
W[104] = 8'b0000001111;
W[105] = 8'b0000111101;
W[106] = 8'b1111111111;
W[107] = 8'b1111001101;
W[108] = 8'b1111000101;
W[109] = 8'b0000001101;
W[110] = 8'b1111011011;
W[111] = 8'b1111110110;
W[112] = 8'b1110110101;
W[113] = 8'b1110010011;
W[114] = 8'b1111011110;
W[115] = 8'b0000000010;
W[116] = 8'b1111011111;
W[117] = 8'b1111010100;
W[118] = 8'b0000000101;
W[119] = 8'b0000000101;
W[120] = 8'b0000011010;
W[121] = 8'b0000110001;
W[122] = 8'b0000000000;
W[123] = 8'b0000101101;
W[124] = 8'b0000001101;
W[125] = 8'b1111100011;
W[126] = 8'b0000000111;
W[127] = 8'b0000111000;
W[128] = 8'b0000001110;
W[129] = 8'b0000010000;
W[130] = 8'b0000011100;
W[131] = 8'b1111110101;
W[132] = 8'b0000011011;
W[133] = 8'b0000011100;
W[134] = 8'b0000010001;
W[135] = 8'b0000011011;
W[136] = 8'b0000000110;
W[137] = 8'b1111000011;
W[138] = 8'b1110101100;
W[139] = 8'b1111010011;
W[140] = 8'b0000100001;
W[141] = 8'b1111101001;
W[142] = 8'b1111010011;
W[143] = 8'b1110111101;
W[144] = 8'b0000001111;
W[145] = 8'b1111100101;
W[146] = 8'b0000101100;
W[147] = 8'b0000110110;
W[148] = 8'b0000001010;
W[149] = 8'b0000110111;
W[150] = 8'b1111001100;
W[151] = 8'b0000011110;
W[152] = 8'b0000000010;
W[153] = 8'b0000000000;
W[154] = 8'b1111110100;
W[155] = 8'b1110111110;
W[156] = 8'b0001000011;
W[157] = 8'b0000110010;
W[158] = 8'b0000000011;
W[159] = 8'b1111101000;
W[160] = 8'b0000011111;
W[161] = 8'b1111001011;
W[162] = 8'b1110101100;
W[163] = 8'b1111101111;
W[164] = 8'b0000010111;
W[165] = 8'b0001011101;
W[166] = 8'b0000001001;
W[167] = 8'b0000110101;
W[168] = 8'b1111111010;
W[169] = 8'b0000100000;
W[170] = 8'b0000001110;
W[171] = 8'b1110100011;
W[172] = 8'b1111000100;
W[173] = 8'b1111011011;
W[174] = 8'b0001000101;
W[175] = 8'b1111110100;
W[176] = 8'b1111111101;
W[177] = 8'b0000010100;
W[178] = 8'b0000000110;
W[179] = 8'b1110011100;
W[180] = 8'b1111111101;
W[181] = 8'b0000000001;
W[182] = 8'b0000010101;
W[183] = 8'b0000010000;
W[184] = 8'b0001011100;
W[185] = 8'b1111111100;
W[186] = 8'b1111110110;
W[187] = 8'b1111101001;
W[188] = 8'b0000011010;
W[189] = 8'b0001011010;
W[190] = 8'b0000111001;
W[191] = 8'b0000111001;
W[192] = 8'b0000110101;
W[193] = 8'b0001001010;
W[194] = 8'b0000010001;
W[195] = 8'b0000000101;
W[196] = 8'b1111101110;
W[197] = 8'b1111110000;
W[198] = 8'b0000011001;
W[199] = 8'b0000110110;
W[200] = 8'b1110100111;
W[201] = 8'b1111110001;
W[202] = 8'b0000010110;
W[203] = 8'b1111100011;
W[204] = 8'b1111011101;
W[205] = 8'b1110101110;
W[206] = 8'b0000100000;
W[207] = 8'b0000001001;
W[208] = 8'b0000100010;
W[209] = 8'b0000010000;
W[210] = 8'b1111101101;
W[211] = 8'b0000010111;
W[212] = 8'b1111001101;
W[213] = 8'b1111101101;
W[214] = 8'b1111011101;
W[215] = 8'b0000100010;
W[216] = 8'b0001001010;
W[217] = 8'b0000011011;
W[218] = 8'b0000010000;
W[219] = 8'b0000010111;
W[220] = 8'b0000011000;
W[221] = 8'b1111100001;
W[222] = 8'b1111110101;
W[223] = 8'b0000001100;
W[224] = 8'b0000111001;
W[225] = 8'b1111100110;
W[226] = 8'b1111011100;
W[227] = 8'b1111111011;
W[228] = 8'b0000100100;
W[229] = 8'b0001010010;
W[230] = 8'b1111000011;
W[231] = 8'b0000000000;
W[232] = 8'b1111110011;
W[233] = 8'b0001001110;
W[234] = 8'b0001000101;
W[235] = 8'b0000000000;
W[236] = 8'b0000100000;
W[237] = 8'b0000001111;
W[238] = 8'b1111111011;
W[239] = 8'b0001000011;
W[240] = 8'b0000000110;
W[241] = 8'b0000010110;
W[242] = 8'b0000011011;
W[243] = 8'b0000001101;
W[244] = 8'b0000101101;
W[245] = 8'b1111011101;
W[246] = 8'b1111011001;
W[247] = 8'b1111110011;
W[248] = 8'b1111011011;
W[249] = 8'b0000101011;
W[250] = 8'b0000011011;
W[251] = 8'b1111001110;
W[252] = 8'b1111111000;
W[253] = 8'b0001000110;
W[254] = 8'b0001000100;
W[255] = 8'b1111110010;
W[256] = 8'b1111001111;
W[257] = 8'b1111101110;
W[258] = 8'b0000100001;
W[259] = 8'b0001111110;
W[260] = 8'b1111000001;
W[261] = 8'b0000000111;
W[262] = 8'b0000101111;
W[263] = 8'b0000100000;
W[264] = 8'b0001001010;
W[265] = 8'b1111011110;
W[266] = 8'b0000010100;
W[267] = 8'b0000001100;
W[268] = 8'b1111101110;
W[269] = 8'b1111110010;
W[270] = 8'b1111100101;
W[271] = 8'b1111101001;
W[272] = 8'b0000001010;
W[273] = 8'b0000100000;
W[274] = 8'b0000001011;
W[275] = 8'b0000011101;
W[276] = 8'b1111101000;
W[277] = 8'b0000001010;
W[278] = 8'b1111111101;
W[279] = 8'b0000111000;
W[280] = 8'b1111100001;
W[281] = 8'b1111100100;
W[282] = 8'b1111110011;
W[283] = 8'b0000000000;
W[284] = 8'b0000100100;
W[285] = 8'b1111001100;
W[286] = 8'b0000110111;
W[287] = 8'b0000100110;
W[288] = 8'b1111110100;
W[289] = 8'b1111100001;
W[290] = 8'b1111100011;
W[291] = 8'b1111101011;
W[292] = 8'b1110010000;
W[293] = 8'b1111111000;
W[294] = 8'b1111110001;
W[295] = 8'b0001100011;
W[296] = 8'b0000101111;
W[297] = 8'b0001010111;
W[298] = 8'b1111111001;
W[299] = 8'b0001000010;
W[300] = 8'b1111110111;
W[301] = 8'b1111011011;
W[302] = 8'b0001001101;
W[303] = 8'b0000011000;
W[304] = 8'b1111100100;
W[305] = 8'b0000000100;
W[306] = 8'b0000001010;
W[307] = 8'b1111000011;
W[308] = 8'b0000010101;
W[309] = 8'b1111011001;
W[310] = 8'b0000011001;
W[311] = 8'b1111011111;
W[312] = 8'b0000000111;
W[313] = 8'b0000010110;
W[314] = 8'b0000010000;
W[315] = 8'b0000111111;
W[316] = 8'b1111010100;
W[317] = 8'b0000001111;
W[318] = 8'b1111011000;
W[319] = 8'b0000000110;
W[320] = 8'b1111000011;
W[321] = 8'b1111010100;
W[322] = 8'b0000000000;
W[323] = 8'b1111010000;
W[324] = 8'b0000100000;
W[325] = 8'b0000010101;
W[326] = 8'b0001010101;
W[327] = 8'b0001000101;
W[328] = 8'b0001011110;
W[329] = 8'b0000110101;
W[330] = 8'b1101111111;
W[331] = 8'b1111101110;
W[332] = 8'b1111011001;
W[333] = 8'b1110100111;
W[334] = 8'b1111111011;
W[335] = 8'b1111110000;
W[336] = 8'b0000010000;
W[337] = 8'b0000010001;
W[338] = 8'b0000001101;
W[339] = 8'b0000100111;
W[340] = 8'b1111110010;
W[341] = 8'b1111011011;
W[342] = 8'b1110100010;
W[343] = 8'b1111101101;
W[344] = 8'b0000000101;
W[345] = 8'b1111011110;
W[346] = 8'b0000001001;
W[347] = 8'b1111100101;
W[348] = 8'b0000000100;
W[349] = 8'b1111010001;
W[350] = 8'b0000010110;
W[351] = 8'b0000111010;
W[352] = 8'b0000000001;
W[353] = 8'b1111110001;
W[354] = 8'b1111101111;
W[355] = 8'b1110101000;
W[356] = 8'b1111101010;
W[357] = 8'b1111000011;
W[358] = 8'b1111100010;
W[359] = 8'b1111000011;
W[360] = 8'b0000100010;
W[361] = 8'b1111011101;
W[362] = 8'b1111101010;
W[363] = 8'b0001010101;
W[364] = 8'b1111110010;
W[365] = 8'b0000000001;
W[366] = 8'b1110110100;
W[367] = 8'b1111010011;
W[368] = 8'b1111101111;
W[369] = 8'b1111111000;
W[370] = 8'b1111010111;
W[371] = 8'b0000101011;
W[372] = 8'b0000111001;
W[373] = 8'b1111100010;
W[374] = 8'b1111110000;
W[375] = 8'b1111000110;
W[376] = 8'b0000010011;
W[377] = 8'b0000010000;
W[378] = 8'b1111111101;
W[379] = 8'b1111111001;
W[380] = 8'b1111010101;
W[381] = 8'b0000100001;
W[382] = 8'b1111111111;
W[383] = 8'b1111101101;
W[384] = 8'b1111001011;
W[385] = 8'b0000010110;
W[386] = 8'b1111111100;
W[387] = 8'b1111011010;
W[388] = 8'b0000101100;
W[389] = 8'b1111010111;
W[390] = 8'b0001001011;
W[391] = 8'b1111110100;
W[392] = 8'b0000100010;
W[393] = 8'b0000001101;
W[394] = 8'b1110100101;
W[395] = 8'b0000100101;
W[396] = 8'b0001000100;
W[397] = 8'b0000111111;
W[398] = 8'b0000010000;
W[399] = 8'b0000000101;
W[400] = 8'b1111111000;
W[401] = 8'b0000010000;
W[402] = 8'b0000001000;
W[403] = 8'b1111010100;
W[404] = 8'b1111101111;
W[405] = 8'b1110111011;
W[406] = 8'b0000001110;
W[407] = 8'b0000000110;
W[408] = 8'b0000001001;
W[409] = 8'b0000010011;
W[410] = 8'b0000000000;
W[411] = 8'b0001011000;
W[412] = 8'b1111110110;
W[413] = 8'b0000100010;
W[414] = 8'b1111111100;
W[415] = 8'b1111111011;
W[416] = 8'b0000010111;
W[417] = 8'b1111011010;
W[418] = 8'b0000000110;
W[419] = 8'b1111010010;
W[420] = 8'b0001111101;
W[421] = 8'b0000111111;
W[422] = 8'b0001011110;
W[423] = 8'b0000111011;
W[424] = 8'b0000001111;
W[425] = 8'b0000101101;
W[426] = 8'b0000001100;
W[427] = 8'b1111000101;
W[428] = 8'b1110011111;
W[429] = 8'b1111111100;
W[430] = 8'b1111111011;
W[431] = 8'b0000001101;
W[432] = 8'b0000000100;
W[433] = 8'b1111110001;
W[434] = 8'b1111101011;
W[435] = 8'b1111101110;
W[436] = 8'b1111110100;
W[437] = 8'b1110110100;
W[438] = 8'b1111011000;
W[439] = 8'b1111101111;
W[440] = 8'b1111110101;
W[441] = 8'b1110111101;
W[442] = 8'b1111001000;
W[443] = 8'b0000000111;
W[444] = 8'b0000010000;
W[445] = 8'b0000101001;
W[446] = 8'b1111100111;
W[447] = 8'b0001001101;
W[448] = 8'b1111111111;
W[449] = 8'b0000010110;
W[450] = 8'b1111110000;
W[451] = 8'b0010000011;
W[452] = 8'b1110011001;
W[453] = 8'b0000110010;
W[454] = 8'b1111110010;
W[455] = 8'b0000011100;
W[456] = 8'b1111110001;
W[457] = 8'b0000011101;
W[458] = 8'b0001100101;
W[459] = 8'b1111100111;
W[460] = 8'b1111100111;
W[461] = 8'b1110001101;
W[462] = 8'b0000101011;
W[463] = 8'b1111011001;
W[464] = 8'b1111010001;
W[465] = 8'b0001101100;
W[466] = 8'b1111001001;
W[467] = 8'b0000111100;
W[468] = 8'b1111011001;
W[469] = 8'b0000010001;
W[470] = 8'b0000111011;
W[471] = 8'b1111100000;
W[472] = 8'b0000101010;
W[473] = 8'b1111001100;
W[474] = 8'b1111101011;
W[475] = 8'b1110101111;
W[476] = 8'b1111100110;
W[477] = 8'b0000000111;
W[478] = 8'b0000011101;
W[479] = 8'b0001100101;
W[480] = 8'b0000001101;
W[481] = 8'b1111010111;
W[482] = 8'b0000010001;
W[483] = 8'b0000110110;
W[484] = 8'b0000100110;
W[485] = 8'b1111011000;
W[486] = 8'b0000010110;
W[487] = 8'b1111011101;
W[488] = 8'b0001000100;
W[489] = 8'b0000101010;
W[490] = 8'b0000101111;
W[491] = 8'b0001110100;
W[492] = 8'b0001001110;
W[493] = 8'b0000100101;
W[494] = 8'b1111101011;
W[495] = 8'b0000100010;
W[496] = 8'b0000001000;
W[497] = 8'b0000011100;
W[498] = 8'b0000000011;
W[499] = 8'b1111101000;
W[500] = 8'b0000000011;
W[501] = 8'b0000111100;
W[502] = 8'b1111101110;
W[503] = 8'b0000010011;
W[504] = 8'b1111010001;
W[505] = 8'b0000111110;
W[506] = 8'b1111110000;
W[507] = 8'b1111111100;
W[508] = 8'b0000100010;
W[509] = 8'b1111010010;
W[510] = 8'b0000011110;
W[511] = 8'b1111010111;
W[512] = 8'b1111101010;
W[513] = 8'b0000101000;
W[514] = 8'b1111011100;
W[515] = 8'b0000101110;
W[516] = 8'b1111010101;
W[517] = 8'b0000011101;
W[518] = 8'b1111101011;
W[519] = 8'b1111010101;
W[520] = 8'b0000001001;
W[521] = 8'b1111001100;
W[522] = 8'b0001110110;
W[523] = 8'b0000110010;
W[524] = 8'b0000000101;
W[525] = 8'b0000001111;
W[526] = 8'b0010000010;
W[527] = 8'b0000101100;
W[528] = 8'b0010011011;
W[529] = 8'b0000011111;
W[530] = 8'b0001001001;
W[531] = 8'b0000011011;
W[532] = 8'b0000010101;
W[533] = 8'b0001010101;
W[534] = 8'b1111101110;
W[535] = 8'b0010001010;
W[536] = 8'b0000011010;
W[537] = 8'b0000011101;
W[538] = 8'b0000011010;
W[539] = 8'b1111101111;
W[540] = 8'b0000110011;
W[541] = 8'b1111110011;
W[542] = 8'b0001001010;
W[543] = 8'b0000000001;
W[544] = 8'b0000010010;
W[545] = 8'b0000011000;
W[546] = 8'b1111010111;
W[547] = 8'b0001011000;
W[548] = 8'b0000110110;
W[549] = 8'b1111101100;
W[550] = 8'b0000010101;
W[551] = 8'b0000011110;
W[552] = 8'b0001011101;
W[553] = 8'b0010011001;
W[554] = 8'b0001001101;
W[555] = 8'b0000110110;
W[556] = 8'b0001000000;
W[557] = 8'b0000101001;
W[558] = 8'b0000111101;
W[559] = 8'b0000001100;
W[560] = 8'b0001111011;
W[561] = 8'b0001101010;
W[562] = 8'b1111101111;
W[563] = 8'b0000111101;
W[564] = 8'b0000101110;
W[565] = 8'b0000111010;
W[566] = 8'b0000010011;
W[567] = 8'b1111100010;
W[568] = 8'b1111100100;
W[569] = 8'b1111111101;
W[570] = 8'b0000111000;
W[571] = 8'b1111100100;
W[572] = 8'b0000101001;
W[573] = 8'b0000100011;
W[574] = 8'b0000010110;
W[575] = 8'b1111111000;
W[576] = 8'b1111101100;
W[577] = 8'b0000110111;
W[578] = 8'b0000110100;
W[579] = 8'b1110101000;
W[580] = 8'b1111101101;
W[581] = 8'b0000100111;
W[582] = 8'b1111010110;
W[583] = 8'b1111101000;
W[584] = 8'b1111100010;
W[585] = 8'b0010011010;
W[586] = 8'b0000011001;
W[587] = 8'b1111111000;
W[588] = 8'b0000101101;
W[589] = 8'b1111111001;
W[590] = 8'b1111011110;
W[591] = 8'b1110010100;
W[592] = 8'b1111100110;
W[593] = 8'b1111010101;
W[594] = 8'b1111010101;
W[595] = 8'b0000100100;
W[596] = 8'b1111001100;
W[597] = 8'b0000011010;
W[598] = 8'b0001110110;
W[599] = 8'b0000010101;
W[600] = 8'b1110010011;
W[601] = 8'b0000011000;
W[602] = 8'b0000111010;
W[603] = 8'b0001001111;
W[604] = 8'b0000110101;
W[605] = 8'b1111110101;
W[606] = 8'b0000010010;
W[607] = 8'b1110111011;
W[608] = 8'b1110110101;
W[609] = 8'b0000000110;
W[610] = 8'b1111100111;
W[611] = 8'b0000100000;
W[612] = 8'b0000000111;
W[613] = 8'b0001001010;
W[614] = 8'b0001010000;
W[615] = 8'b1111111110;
W[616] = 8'b0000101111;
W[617] = 8'b1110101000;
W[618] = 8'b1111000011;
W[619] = 8'b1110100001;
W[620] = 8'b0001000100;
W[621] = 8'b1111010111;
W[622] = 8'b1111010011;
W[623] = 8'b0001101111;
W[624] = 8'b1111010100;
W[625] = 8'b1111010110;
W[626] = 8'b1111011000;
W[627] = 8'b0000010101;
W[628] = 8'b0000011000;
W[629] = 8'b0010011111;
W[630] = 8'b1111100000;
W[631] = 8'b1111001000;
W[632] = 8'b1111101001;
W[633] = 8'b1110111101;
W[634] = 8'b0000000011;
W[635] = 8'b1111110100;
W[636] = 8'b0000000011;
W[637] = 8'b0000100101;
W[638] = 8'b0000100010;
W[639] = 8'b0000001010;
W[640] = 8'b0001010100;
W[641] = 8'b0000100010;
W[642] = 8'b1110110101;
W[643] = 8'b1110110010;
W[644] = 8'b1110011011;
W[645] = 8'b0001111011;
W[646] = 8'b0010010010;
W[647] = 8'b0001001001;
W[648] = 8'b0000110011;
W[649] = 8'b0001000000;
W[650] = 8'b1111110011;
W[651] = 8'b0001011011;
W[652] = 8'b0000001000;
W[653] = 8'b1111111110;
W[654] = 8'b0000000010;
W[655] = 8'b0000000000;
W[656] = 8'b0000000000;
W[657] = 8'b0000001010;
W[658] = 8'b1111101110;
W[659] = 8'b0000000010;
W[660] = 8'b0000001000;
W[661] = 8'b1111110000;
W[662] = 8'b0000000010;
W[663] = 8'b0000110111;
W[664] = 8'b0000110111;
W[665] = 8'b1111110111;
W[666] = 8'b0001000110;
W[667] = 8'b1111010011;
W[668] = 8'b1111110000;
W[669] = 8'b1110110101;
W[670] = 8'b0000010010;
W[671] = 8'b0010101011;
W[672] = 8'b0000001010;
W[673] = 8'b0000101111;
W[674] = 8'b1111110010;
W[675] = 8'b1111100100;
W[676] = 8'b1111101110;
W[677] = 8'b1111101001;
W[678] = 8'b1111100010;
W[679] = 8'b0000010000;
W[680] = 8'b1111110001;
W[681] = 8'b0000101111;
W[682] = 8'b0000000000;
W[683] = 8'b0000000011;
W[684] = 8'b1111000111;
W[685] = 8'b0000100001;
W[686] = 8'b0000100001;
W[687] = 8'b0000100001;
W[688] = 8'b0000000100;
W[689] = 8'b1111100101;
W[690] = 8'b1111111100;
W[691] = 8'b0000100001;
W[692] = 8'b0000111011;
W[693] = 8'b0000110000;
W[694] = 8'b1111010011;
W[695] = 8'b1111101101;
W[696] = 8'b0001011111;
W[697] = 8'b1111110011;
W[698] = 8'b0000001001;
W[699] = 8'b1110011011;
W[700] = 8'b1110111010;
W[701] = 8'b1111100110;
W[702] = 8'b1111101110;
W[703] = 8'b1111011101;
W[704] = 8'b0000000001;
W[705] = 8'b1111010100;
W[706] = 8'b0000100011;
W[707] = 8'b0000000000;
W[708] = 8'b0000110000;
W[709] = 8'b0000010000;
W[710] = 8'b0000011011;
W[711] = 8'b0000111010;
W[712] = 8'b0000000010;
W[713] = 8'b1111101010;
W[714] = 8'b1111101001;
W[715] = 8'b0000000101;
W[716] = 8'b0000000110;
W[717] = 8'b0000001100;
W[718] = 8'b0000101001;
W[719] = 8'b0000100010;
W[720] = 8'b1111011001;
W[721] = 8'b0001011100;
W[722] = 8'b0001010110;
W[723] = 8'b0000110011;
W[724] = 8'b0000000000;
W[725] = 8'b0000000001;
W[726] = 8'b0000101010;
W[727] = 8'b1111010000;
W[728] = 8'b1111001000;
W[729] = 8'b1111000010;
W[730] = 8'b1110101011;
W[731] = 8'b0000011100;
W[732] = 8'b0001010110;
W[733] = 8'b0001000101;
W[734] = 8'b0001001001;
W[735] = 8'b0000000011;
W[736] = 8'b0000011100;
W[737] = 8'b1111001110;
W[738] = 8'b1110101011;
W[739] = 8'b1111010111;
W[740] = 8'b0000011011;
W[741] = 8'b0000011110;
W[742] = 8'b0000100111;
W[743] = 8'b0001010100;
W[744] = 8'b0001010100;
W[745] = 8'b1111000000;
W[746] = 8'b0000111110;
W[747] = 8'b1111100011;
W[748] = 8'b1111100101;
W[749] = 8'b1111001111;
W[750] = 8'b1111011000;
W[751] = 8'b1111010001;
W[752] = 8'b0000011010;
W[753] = 8'b1111111110;
W[754] = 8'b0000010000;
W[755] = 8'b1111101001;
W[756] = 8'b0000011000;
W[757] = 8'b1111111111;
W[758] = 8'b0000011010;
W[759] = 8'b1111001010;
W[760] = 8'b0000000000;
W[761] = 8'b0000011011;
W[762] = 8'b1111101110;
W[763] = 8'b1111010110;
W[764] = 8'b1111111011;
W[765] = 8'b1111101111;
W[766] = 8'b0000100011;
W[767] = 8'b1111111101;
W[768] = 8'b0000010100;
W[769] = 8'b0000101100;
W[770] = 8'b1111110100;
W[771] = 8'b1111101100;
W[772] = 8'b0000101000;
W[773] = 8'b1111110100;
W[774] = 8'b1111101110;
W[775] = 8'b0001100001;
W[776] = 8'b1111101101;
W[777] = 8'b0000011011;
W[778] = 8'b0000110101;
W[779] = 8'b0000001011;
W[780] = 8'b0000101011;
W[781] = 8'b1111101010;
W[782] = 8'b1111011011;
W[783] = 8'b1111111110;
W[784] = 8'b0000101001;
W[785] = 8'b1111101110;
W[786] = 8'b0000000000;
W[787] = 8'b0000001000;
W[788] = 8'b0000110001;
W[789] = 8'b0000111011;
W[790] = 8'b0000011111;
W[791] = 8'b1111100001;
W[792] = 8'b0000000001;
W[793] = 8'b0000010101;
W[794] = 8'b1111010000;
W[795] = 8'b0000010001;
W[796] = 8'b0000011110;
W[797] = 8'b1111100000;
W[798] = 8'b1111000110;
W[799] = 8'b1101001100;
W[800] = 8'b1111111010;
W[801] = 8'b1111110101;
W[802] = 8'b0000101111;
W[803] = 8'b0000100101;
W[804] = 8'b0000001111;
W[805] = 8'b1111111010;
W[806] = 8'b0000001101;
W[807] = 8'b0000010010;
W[808] = 8'b1111100010;
W[809] = 8'b1111010111;
W[810] = 8'b1111100010;
W[811] = 8'b1111010111;
W[812] = 8'b0000101110;
W[813] = 8'b1111110101;
W[814] = 8'b0000011000;
W[815] = 8'b0000001010;
W[816] = 8'b0000001001;
W[817] = 8'b0000001100;
W[818] = 8'b0000111000;
W[819] = 8'b0000010010;
W[820] = 8'b1111110001;
W[821] = 8'b1110111110;
W[822] = 8'b0000011111;
W[823] = 8'b0000110000;
W[824] = 8'b1111111111;
W[825] = 8'b1111101100;
W[826] = 8'b1111101110;
W[827] = 8'b1111001001;
W[828] = 8'b1110011000;
W[829] = 8'b1110111000;
W[830] = 8'b1111101011;
W[831] = 8'b1111100100;
W[832] = 8'b1111100101;
W[833] = 8'b1110110111;
W[834] = 8'b1111000000;
W[835] = 8'b0000000011;
W[836] = 8'b1111110010;
W[837] = 8'b1111111000;
W[838] = 8'b1111001101;
W[839] = 8'b1110101010;
W[840] = 8'b0000000110;
W[841] = 8'b1111110011;
W[842] = 8'b1111010100;
W[843] = 8'b1110111100;
W[844] = 8'b1110011100;
W[845] = 8'b0000011001;
W[846] = 8'b1111100001;
W[847] = 8'b1111110000;
W[848] = 8'b1111100011;
W[849] = 8'b0000010111;
W[850] = 8'b0000100100;
W[851] = 8'b1111011101;
W[852] = 8'b1111110111;
W[853] = 8'b1111000001;
W[854] = 8'b1110110010;
W[855] = 8'b0000001010;
W[856] = 8'b1111100111;
W[857] = 8'b1111011011;
W[858] = 8'b1111110010;
W[859] = 8'b1110100100;
W[860] = 8'b0000100100;
W[861] = 8'b1111100101;
W[862] = 8'b1111110101;
W[863] = 8'b1111100011;
W[864] = 8'b1110111011;
W[865] = 8'b0000010100;
W[866] = 8'b0000110000;
W[867] = 8'b1111111010;
W[868] = 8'b1111011000;
W[869] = 8'b1101101011;
W[870] = 8'b0000011001;
W[871] = 8'b1111011111;
W[872] = 8'b1110110101;
W[873] = 8'b1111011110;
W[874] = 8'b1111000011;
W[875] = 8'b1111011100;
W[876] = 8'b1111000111;
W[877] = 8'b0000000000;
W[878] = 8'b0000010101;
W[879] = 8'b0000010100;
W[880] = 8'b1111111011;
W[881] = 8'b0000010000;
W[882] = 8'b0000011100;
W[883] = 8'b1111111110;
W[884] = 8'b0000000101;
W[885] = 8'b1111111011;
W[886] = 8'b1111101101;
W[887] = 8'b0000100000;
W[888] = 8'b0000001001;
W[889] = 8'b1111100011;
W[890] = 8'b0000000111;
W[891] = 8'b1111111101;
W[892] = 8'b1111101110;
W[893] = 8'b1111100111;
W[894] = 8'b1111001100;
W[895] = 8'b1111101111;
W[896] = 8'b1111111100;
W[897] = 8'b1111001010;
W[898] = 8'b0000000110;
W[899] = 8'b0000110001;
W[900] = 8'b0000100000;
W[901] = 8'b1111100101;
W[902] = 8'b1111001001;
W[903] = 8'b1111100010;
W[904] = 8'b0000001101;
W[905] = 8'b0000100101;
W[906] = 8'b0000111110;
W[907] = 8'b1111100000;
W[908] = 8'b0000101000;
W[909] = 8'b1110101110;
W[910] = 8'b1111101001;
W[911] = 8'b0001000110;
W[912] = 8'b1111010111;
W[913] = 8'b0001010101;
W[914] = 8'b0000100111;
W[915] = 8'b0000111111;
W[916] = 8'b0001000011;
W[917] = 8'b0000011111;
W[918] = 8'b1111010010;
W[919] = 8'b1110101111;
W[920] = 8'b0000111000;
W[921] = 8'b1110110111;
W[922] = 8'b1110011111;
W[923] = 8'b0001001010;
W[924] = 8'b0000100110;
W[925] = 8'b1110110111;
W[926] = 8'b1111111011;
W[927] = 8'b0000001110;
W[928] = 8'b1111010011;
W[929] = 8'b1101111011;
W[930] = 8'b0000000110;
W[931] = 8'b0001111001;
W[932] = 8'b0001001101;
W[933] = 8'b0000100010;
W[934] = 8'b1111111001;
W[935] = 8'b1111100100;
W[936] = 8'b0000001000;
W[937] = 8'b1111001010;
W[938] = 8'b1111000010;
W[939] = 8'b0000000001;
W[940] = 8'b0001000110;
W[941] = 8'b0001100111;
W[942] = 8'b0000000111;
W[943] = 8'b0001100010;
W[944] = 8'b0000101101;
W[945] = 8'b1111110001;
W[946] = 8'b0000010110;
W[947] = 8'b0000001111;
W[948] = 8'b0000010101;
W[949] = 8'b0001011000;
W[950] = 8'b1111111010;
W[951] = 8'b0000000000;
W[952] = 8'b1111001111;
W[953] = 8'b1111111100;
W[954] = 8'b1111010011;
W[955] = 8'b1111100111;
W[956] = 8'b0000100000;
W[957] = 8'b0000000011;
W[958] = 8'b0000011110;
W[959] = 8'b1111011101;
W[960] = 8'b0000010010;
W[961] = 8'b0000001111;
W[962] = 8'b1111010011;
W[963] = 8'b0000100100;
W[964] = 8'b1111011011;
W[965] = 8'b0000010010;
W[966] = 8'b0001010001;
W[967] = 8'b1111111100;
W[968] = 8'b0000010000;
W[969] = 8'b1111010010;
W[970] = 8'b1111100100;
W[971] = 8'b0000011011;
W[972] = 8'b1111010101;
W[973] = 8'b1111111000;
W[974] = 8'b0000110001;
W[975] = 8'b0000100111;
W[976] = 8'b0000001000;
W[977] = 8'b0000000110;
W[978] = 8'b0000001110;
W[979] = 8'b1110000010;
W[980] = 8'b1111111001;
W[981] = 8'b0000001011;
W[982] = 8'b1110111111;
W[983] = 8'b0000101000;
W[984] = 8'b1110101100;
W[985] = 8'b1111110011;
W[986] = 8'b0000000000;
W[987] = 8'b1111101110;
W[988] = 8'b0001000000;
W[989] = 8'b1111010100;
W[990] = 8'b1110110100;
W[991] = 8'b0000010100;
W[992] = 8'b0000010011;
W[993] = 8'b0000101011;
W[994] = 8'b1111111001;
W[995] = 8'b1111001001;
W[996] = 8'b0000001000;
W[997] = 8'b1111010100;
W[998] = 8'b1111011101;
W[999] = 8'b1111111101;
W[1000] = 8'b1111101010;
W[1001] = 8'b0001001001;
W[1002] = 8'b0000110000;
W[1003] = 8'b1111110010;
W[1004] = 8'b1110000111;
W[1005] = 8'b1111000110;
W[1006] = 8'b0000110010;
W[1007] = 8'b1111010010;
W[1008] = 8'b0000100100;
W[1009] = 8'b0000000100;
W[1010] = 8'b1110111001;
W[1011] = 8'b0000011111;
W[1012] = 8'b1111101100;
W[1013] = 8'b0000010101;
W[1014] = 8'b1111100111;
W[1015] = 8'b1110110010;
W[1016] = 8'b0000010001;
W[1017] = 8'b1111111000;
W[1018] = 8'b0000100111;
W[1019] = 8'b0000000010;
W[1020] = 8'b1110000111;
W[1021] = 8'b1111101100;
W[1022] = 8'b0000010101;
W[1023] = 8'b0000000001;
W[1024] = 8'b0000000000;
W[1025] = 8'b0000010101;
W[1026] = 8'b0001111100;
W[1027] = 8'b1111100000;
W[1028] = 8'b0000001000;
W[1029] = 8'b0000010000;
W[1030] = 8'b1110110010;
W[1031] = 8'b0000001110;
W[1032] = 8'b1111100111;
W[1033] = 8'b0000010011;
W[1034] = 8'b1111110101;
W[1035] = 8'b1110111011;
W[1036] = 8'b0000000111;
W[1037] = 8'b0000000001;
W[1038] = 8'b1111111111;
W[1039] = 8'b1111001111;
W[1040] = 8'b1111000011;
W[1041] = 8'b0000101110;
W[1042] = 8'b1111111001;
W[1043] = 8'b0000100101;
W[1044] = 8'b1111100010;
W[1045] = 8'b0000010101;
W[1046] = 8'b0000111010;
W[1047] = 8'b0000010010;
W[1048] = 8'b1110101100;
W[1049] = 8'b1110111000;
W[1050] = 8'b0000110000;
W[1051] = 8'b0000010101;
W[1052] = 8'b1111110110;
W[1053] = 8'b0000001110;
W[1054] = 8'b1111010011;
W[1055] = 8'b0000011111;
W[1056] = 8'b1110101111;
W[1057] = 8'b0000001001;
W[1058] = 8'b0000001101;
W[1059] = 8'b1111110000;
W[1060] = 8'b0001010010;
W[1061] = 8'b1111100101;
W[1062] = 8'b0000111111;
W[1063] = 8'b1111000111;
W[1064] = 8'b1111000100;
W[1065] = 8'b1111111011;
W[1066] = 8'b1111001010;
W[1067] = 8'b0000110111;
W[1068] = 8'b1111001100;
W[1069] = 8'b1111110011;
W[1070] = 8'b1111111111;
W[1071] = 8'b1111110111;
W[1072] = 8'b0000110101;
W[1073] = 8'b0000000000;
W[1074] = 8'b0000011111;
W[1075] = 8'b1111011010;
W[1076] = 8'b0000101001;
W[1077] = 8'b0000000001;
W[1078] = 8'b1111110111;
W[1079] = 8'b1111101111;
W[1080] = 8'b1110110011;
W[1081] = 8'b1111111100;
W[1082] = 8'b0000010101;
W[1083] = 8'b0000101110;
W[1084] = 8'b0000101001;
W[1085] = 8'b0001000101;
W[1086] = 8'b0000010011;
W[1087] = 8'b1111101110;
W[1088] = 8'b0000101011;
W[1089] = 8'b1111110100;
W[1090] = 8'b1111011010;
W[1091] = 8'b1110101101;
W[1092] = 8'b1111000110;
W[1093] = 8'b0000100111;
W[1094] = 8'b0000000000;
W[1095] = 8'b1111000100;
W[1096] = 8'b0000010001;
W[1097] = 8'b0000011000;
W[1098] = 8'b0000001111;
W[1099] = 8'b1111101010;
W[1100] = 8'b0000110100;
W[1101] = 8'b0000000100;
W[1102] = 8'b1111001111;
W[1103] = 8'b0001011010;
W[1104] = 8'b1111011101;
W[1105] = 8'b1111011000;
W[1106] = 8'b1111101101;
W[1107] = 8'b1111101100;
W[1108] = 8'b0000101101;
W[1109] = 8'b1111001010;
W[1110] = 8'b0000010101;
W[1111] = 8'b1111100010;
W[1112] = 8'b0000110000;
W[1113] = 8'b0000110011;
W[1114] = 8'b1111011011;
W[1115] = 8'b0000110111;
W[1116] = 8'b1111100101;
W[1117] = 8'b1111111101;
W[1118] = 8'b0000000101;
W[1119] = 8'b1111111011;
W[1120] = 8'b1111001101;
W[1121] = 8'b1111110010;
W[1122] = 8'b0000010011;
W[1123] = 8'b0000000111;
W[1124] = 8'b0000001011;
W[1125] = 8'b1111111101;
W[1126] = 8'b0000011011;
W[1127] = 8'b1111110011;
W[1128] = 8'b0000110001;
W[1129] = 8'b0000011010;
W[1130] = 8'b0000100100;
W[1131] = 8'b1111100001;
W[1132] = 8'b1111111111;
W[1133] = 8'b0000111010;
W[1134] = 8'b1111100100;
W[1135] = 8'b0001000111;
W[1136] = 8'b1111001001;
W[1137] = 8'b0000011111;
W[1138] = 8'b0000010011;
W[1139] = 8'b1111101111;
W[1140] = 8'b0000111101;
W[1141] = 8'b1111001011;
W[1142] = 8'b0000001111;
W[1143] = 8'b1111111000;
W[1144] = 8'b1111001100;
W[1145] = 8'b0000000110;
W[1146] = 8'b0000000000;
W[1147] = 8'b0000100111;
W[1148] = 8'b0000100010;
W[1149] = 8'b0000000001;
W[1150] = 8'b1110111110;
W[1151] = 8'b0000010100;
W[1152] = 8'b1111111111;
W[1153] = 8'b0000100011;
W[1154] = 8'b0001001101;
W[1155] = 8'b1111101100;
W[1156] = 8'b0000001000;
W[1157] = 8'b1111000110;
W[1158] = 8'b0000101100;
W[1159] = 8'b1111100111;
W[1160] = 8'b0000001111;
W[1161] = 8'b1111100010;
W[1162] = 8'b1110111100;
W[1163] = 8'b0000100101;
W[1164] = 8'b1111100011;
W[1165] = 8'b1111101001;
W[1166] = 8'b0000000010;
W[1167] = 8'b0000001010;
W[1168] = 8'b0000010010;
W[1169] = 8'b1111101011;
W[1170] = 8'b0001001011;
W[1171] = 8'b0000011010;
W[1172] = 8'b0000001110;
W[1173] = 8'b1111110111;
W[1174] = 8'b1111100001;
W[1175] = 8'b1111111001;
W[1176] = 8'b0000010111;
W[1177] = 8'b1110110110;
W[1178] = 8'b1111111100;
W[1179] = 8'b0001010100;
W[1180] = 8'b0000000101;
W[1181] = 8'b0000000101;
W[1182] = 8'b1110111010;
W[1183] = 8'b0000101010;
W[1184] = 8'b1110100000;
W[1185] = 8'b1111001111;
W[1186] = 8'b1110101010;
W[1187] = 8'b1111110110;
W[1188] = 8'b0000110011;
W[1189] = 8'b1111100001;
W[1190] = 8'b0000011001;
W[1191] = 8'b1111010000;
W[1192] = 8'b0000100001;
W[1193] = 8'b0000110101;
W[1194] = 8'b1111001010;
W[1195] = 8'b0000110001;
W[1196] = 8'b1111110101;
W[1197] = 8'b1111100101;
W[1198] = 8'b1110110100;
W[1199] = 8'b1111001000;
W[1200] = 8'b1111011111;
W[1201] = 8'b1111110000;
W[1202] = 8'b1111000001;
W[1203] = 8'b1111001110;
W[1204] = 8'b0000000110;
W[1205] = 8'b1111010101;
W[1206] = 8'b0001111011;
W[1207] = 8'b0000111000;
W[1208] = 8'b0000111110;
W[1209] = 8'b1111100100;
W[1210] = 8'b1111011101;
W[1211] = 8'b1110101110;
W[1212] = 8'b1110000000;
W[1213] = 8'b0000111101;
W[1214] = 8'b0000001001;
W[1215] = 8'b0000101001;
W[1216] = 8'b0001111011;
W[1217] = 8'b0001011000;
W[1218] = 8'b1111111001;
W[1219] = 8'b0000101100;
W[1220] = 8'b1110011100;
W[1221] = 8'b1111100110;
W[1222] = 8'b0000000101;
W[1223] = 8'b1111100101;
W[1224] = 8'b1111100110;
W[1225] = 8'b1111100011;
W[1226] = 8'b0000001111;
W[1227] = 8'b1111101110;
W[1228] = 8'b1111011111;
W[1229] = 8'b1111000011;
W[1230] = 8'b1111011000;
W[1231] = 8'b0000001001;
W[1232] = 8'b0000101011;
W[1233] = 8'b0000111000;
W[1234] = 8'b0001011101;
W[1235] = 8'b0000110001;
W[1236] = 8'b1111011011;
W[1237] = 8'b1110111111;
W[1238] = 8'b1110100110;
W[1239] = 8'b0001110000;
W[1240] = 8'b0000110111;
W[1241] = 8'b1111111001;
W[1242] = 8'b1111110101;
W[1243] = 8'b1111001011;
W[1244] = 8'b1111001000;
W[1245] = 8'b1110011000;
W[1246] = 8'b1101111011;
W[1247] = 8'b1110001011;
W[1248] = 8'b1111011100;
W[1249] = 8'b1111100100;
W[1250] = 8'b0000010010;
W[1251] = 8'b1111100111;
W[1252] = 8'b0000001111;
W[1253] = 8'b0000000001;
W[1254] = 8'b1111101001;
W[1255] = 8'b1111110111;
W[1256] = 8'b0000011010;
W[1257] = 8'b1111010100;
W[1258] = 8'b0000010101;
W[1259] = 8'b0000111101;
W[1260] = 8'b0000100001;
W[1261] = 8'b1111011000;
W[1262] = 8'b1111000010;
W[1263] = 8'b1111111010;
W[1264] = 8'b1111100001;
W[1265] = 8'b0000110000;
W[1266] = 8'b0000101001;
W[1267] = 8'b0001000100;
W[1268] = 8'b0000101111;
W[1269] = 8'b1110111100;
W[1270] = 8'b1110011110;
W[1271] = 8'b1111000101;
W[1272] = 8'b1111100111;
W[1273] = 8'b1111111001;
W[1274] = 8'b1110110000;
W[1275] = 8'b0000000000;
W[1276] = 8'b0000111000;
W[1277] = 8'b0000000001;
W[1278] = 8'b1111111000;
W[1279] = 8'b0001010101;
W[1280] = 8'b1111101111;
W[1281] = 8'b0000100001;
W[1282] = 8'b1110100110;
W[1283] = 8'b0000011100;
W[1284] = 8'b0010011001;
W[1285] = 8'b1111111000;
W[1286] = 8'b0000101010;
W[1287] = 8'b1110111010;
W[1288] = 8'b0000100100;
W[1289] = 8'b0001100111;
W[1290] = 8'b0000000010;
W[1291] = 8'b0000101010;
W[1292] = 8'b0000111000;
W[1293] = 8'b0000100000;
W[1294] = 8'b1111110110;
W[1295] = 8'b1111111110;
W[1296] = 8'b0000100111;
W[1297] = 8'b0000010011;
W[1298] = 8'b0000011001;
W[1299] = 8'b1111111000;
W[1300] = 8'b0000100100;
W[1301] = 8'b0000000001;
W[1302] = 8'b1111101100;
W[1303] = 8'b0000010110;
W[1304] = 8'b0000101010;
W[1305] = 8'b1111101000;
W[1306] = 8'b1111101111;
W[1307] = 8'b1110111001;
W[1308] = 8'b1111101110;
W[1309] = 8'b0001111100;
W[1310] = 8'b1111110001;
W[1311] = 8'b0001000111;
W[1312] = 8'b0000011100;
W[1313] = 8'b1111000000;
W[1314] = 8'b0001100100;
W[1315] = 8'b1111011010;
W[1316] = 8'b1111100001;
W[1317] = 8'b1111101110;
W[1318] = 8'b1111110001;
W[1319] = 8'b0000011100;
W[1320] = 8'b0000011110;
W[1321] = 8'b0000010101;
W[1322] = 8'b0000010101;
W[1323] = 8'b0000110101;
W[1324] = 8'b0000111100;
W[1325] = 8'b0000110000;
W[1326] = 8'b0000000000;
W[1327] = 8'b0000100111;
W[1328] = 8'b0000001101;
W[1329] = 8'b0000000100;
W[1330] = 8'b1111011110;
W[1331] = 8'b1111101110;
W[1332] = 8'b1110111100;
W[1333] = 8'b1110111110;
W[1334] = 8'b0000101101;
W[1335] = 8'b1111111011;
W[1336] = 8'b0001100010;
W[1337] = 8'b0000101010;
W[1338] = 8'b1111111101;
W[1339] = 8'b0000101110;
W[1340] = 8'b0000000010;
W[1341] = 8'b1111011110;
W[1342] = 8'b1111110001;
W[1343] = 8'b0000101100;
W[1344] = 8'b1111010000;
W[1345] = 8'b0001101100;
W[1346] = 8'b0001000000;
W[1347] = 8'b1111111111;
W[1348] = 8'b0000010100;
W[1349] = 8'b0000010011;
W[1350] = 8'b0000010000;
W[1351] = 8'b0001000101;
W[1352] = 8'b1110111110;
W[1353] = 8'b0000000011;
W[1354] = 8'b1111011010;
W[1355] = 8'b1111111000;
W[1356] = 8'b0000011010;
W[1357] = 8'b0000001001;
W[1358] = 8'b1111101111;
W[1359] = 8'b1111001010;
W[1360] = 8'b0000110001;
W[1361] = 8'b0000100011;
W[1362] = 8'b1111001110;
W[1363] = 8'b0000100000;
W[1364] = 8'b0001010101;
W[1365] = 8'b0000101110;
W[1366] = 8'b1111011001;
W[1367] = 8'b0000001100;
W[1368] = 8'b1110101110;
W[1369] = 8'b1111111010;
W[1370] = 8'b0001010001;
W[1371] = 8'b0000000100;
W[1372] = 8'b0001001110;
W[1373] = 8'b1111001011;
W[1374] = 8'b0000010000;
W[1375] = 8'b1111100101;
W[1376] = 8'b0000001001;
W[1377] = 8'b0000000001;
W[1378] = 8'b1111110010;
W[1379] = 8'b1110101101;
W[1380] = 8'b1111101110;
W[1381] = 8'b0001010001;
W[1382] = 8'b0001111111;
W[1383] = 8'b0001111000;
W[1384] = 8'b1111111111;
W[1385] = 8'b1111111100;
W[1386] = 8'b1111011011;
W[1387] = 8'b1111110101;
W[1388] = 8'b0000011110;
W[1389] = 8'b0000100101;
W[1390] = 8'b1111110001;
W[1391] = 8'b0000100011;
W[1392] = 8'b0001000110;
W[1393] = 8'b1111111100;
W[1394] = 8'b1111010100;
W[1395] = 8'b0000000100;
W[1396] = 8'b0000110011;
W[1397] = 8'b0000100111;
W[1398] = 8'b0001010000;
W[1399] = 8'b0001000011;
W[1400] = 8'b0000100001;
W[1401] = 8'b0000100000;
W[1402] = 8'b0000110010;
W[1403] = 8'b0000000010;
W[1404] = 8'b0000011000;
W[1405] = 8'b0000010001;
W[1406] = 8'b0000101001;
W[1407] = 8'b0000000010;
W[1408] = 8'b1111011000;
W[1409] = 8'b0000101010;
W[1410] = 8'b0000000110;
W[1411] = 8'b0000011001;
W[1412] = 8'b0000000011;
W[1413] = 8'b1111101010;
W[1414] = 8'b0000111011;
W[1415] = 8'b0000010010;
W[1416] = 8'b0000001100;
W[1417] = 8'b0000000100;
W[1418] = 8'b1111000110;
W[1419] = 8'b1111101100;
W[1420] = 8'b0000101110;
W[1421] = 8'b1111001010;
W[1422] = 8'b0000000000;
W[1423] = 8'b0000001001;
W[1424] = 8'b0000010000;
W[1425] = 8'b1111111000;
W[1426] = 8'b0000111011;
W[1427] = 8'b0001001110;
W[1428] = 8'b0000110011;
W[1429] = 8'b1111011011;
W[1430] = 8'b1111100000;
W[1431] = 8'b0000011101;
W[1432] = 8'b0000101111;
W[1433] = 8'b0000011011;
W[1434] = 8'b0000000100;
W[1435] = 8'b1111000000;
W[1436] = 8'b0000010010;
W[1437] = 8'b1111101101;
W[1438] = 8'b1110110010;
W[1439] = 8'b0000100100;
W[1440] = 8'b0000000101;
W[1441] = 8'b1111110111;
W[1442] = 8'b1111010100;
W[1443] = 8'b1111011011;
W[1444] = 8'b0000001100;
W[1445] = 8'b1111101111;
W[1446] = 8'b1111011101;
W[1447] = 8'b0000100110;
W[1448] = 8'b1111010011;
W[1449] = 8'b0000000000;
W[1450] = 8'b1111101010;
W[1451] = 8'b0000110000;
W[1452] = 8'b0001011001;
W[1453] = 8'b0001001010;
W[1454] = 8'b1111101010;
W[1455] = 8'b1111101010;
W[1456] = 8'b1111010001;
W[1457] = 8'b0000100001;
W[1458] = 8'b0000100110;
W[1459] = 8'b1111110010;
W[1460] = 8'b1111010111;
W[1461] = 8'b1111100110;
W[1462] = 8'b1111110101;
W[1463] = 8'b1111100111;
W[1464] = 8'b1111010100;
W[1465] = 8'b1111011000;
W[1466] = 8'b1111111010;
W[1467] = 8'b0000000011;
W[1468] = 8'b1111101101;
W[1469] = 8'b1111011101;
W[1470] = 8'b1111011000;
W[1471] = 8'b1111010100;
W[1472] = 8'b1110110101;
W[1473] = 8'b0000001011;
W[1474] = 8'b1111100101;
W[1475] = 8'b1111101100;
W[1476] = 8'b0000011100;
W[1477] = 8'b0000111000;
W[1478] = 8'b0000001001;
W[1479] = 8'b1111000110;
W[1480] = 8'b1111101111;
W[1481] = 8'b1111010101;
W[1482] = 8'b1111001001;
W[1483] = 8'b1111101010;
W[1484] = 8'b1111101001;
W[1485] = 8'b1111010000;
W[1486] = 8'b0000011010;
W[1487] = 8'b0000101001;
W[1488] = 8'b1111101101;
W[1489] = 8'b1111101101;
W[1490] = 8'b1110110100;
W[1491] = 8'b0000111010;
W[1492] = 8'b0000110101;
W[1493] = 8'b0000000111;
W[1494] = 8'b0000010101;
W[1495] = 8'b1111101001;
W[1496] = 8'b1111001000;
W[1497] = 8'b1111101001;
W[1498] = 8'b0000001110;
W[1499] = 8'b1111111001;
W[1500] = 8'b0000001010;
W[1501] = 8'b1111000110;
W[1502] = 8'b1111111001;
W[1503] = 8'b0001000010;
W[1504] = 8'b0000000110;
W[1505] = 8'b0000100100;
W[1506] = 8'b1111010011;
W[1507] = 8'b1111100010;
W[1508] = 8'b1111101001;
W[1509] = 8'b1111101010;
W[1510] = 8'b0000110110;
W[1511] = 8'b0001011101;
W[1512] = 8'b0000011010;
W[1513] = 8'b0000101101;
W[1514] = 8'b1111000100;
W[1515] = 8'b0000001011;
W[1516] = 8'b1111000011;
W[1517] = 8'b1110110011;
W[1518] = 8'b0000011000;
W[1519] = 8'b1111011101;
W[1520] = 8'b1111001010;
W[1521] = 8'b0001101010;
W[1522] = 8'b0000001111;
W[1523] = 8'b0000100100;
W[1524] = 8'b1111110111;
W[1525] = 8'b1111110110;
W[1526] = 8'b1111001100;
W[1527] = 8'b0000011011;
W[1528] = 8'b0001100010;
W[1529] = 8'b0001100100;
W[1530] = 8'b0000011110;
W[1531] = 8'b0000000010;
W[1532] = 8'b1111000010;
W[1533] = 8'b1111110110;
W[1534] = 8'b0000111101;
W[1535] = 8'b0001011101;
W[1536] = 8'b0001011111;
W[1537] = 8'b0000000101;
W[1538] = 8'b1111110010;
W[1539] = 8'b0000011111;
W[1540] = 8'b1111101011;
W[1541] = 8'b0000001111;
W[1542] = 8'b0000011010;
W[1543] = 8'b0000110011;
W[1544] = 8'b0000100010;
W[1545] = 8'b1110101001;
W[1546] = 8'b0001000011;
W[1547] = 8'b0001001100;
W[1548] = 8'b0000110010;
W[1549] = 8'b1111111101;
W[1550] = 8'b1111100110;
W[1551] = 8'b1111010110;
W[1552] = 8'b1111000001;
W[1553] = 8'b0001011001;
W[1554] = 8'b0000101000;
W[1555] = 8'b0000001011;
W[1556] = 8'b1111110000;
W[1557] = 8'b1111000001;
W[1558] = 8'b1111001000;
W[1559] = 8'b1111011010;
W[1560] = 8'b0000010110;
W[1561] = 8'b0000110011;
W[1562] = 8'b0000110011;
W[1563] = 8'b1111100110;
W[1564] = 8'b1110110111;
W[1565] = 8'b1111111100;
W[1566] = 8'b1111101010;
W[1567] = 8'b1111001110;
W[1568] = 8'b1111111101;
W[1569] = 8'b1111110010;
W[1570] = 8'b1111001001;
W[1571] = 8'b0000000101;
W[1572] = 8'b0000110011;
W[1573] = 8'b0000011000;
W[1574] = 8'b0000110001;
W[1575] = 8'b0000100011;
W[1576] = 8'b0000000001;
W[1577] = 8'b1111001011;
W[1578] = 8'b0000010000;
W[1579] = 8'b0000000010;
W[1580] = 8'b0000010101;
W[1581] = 8'b0000000010;
W[1582] = 8'b1111011110;
W[1583] = 8'b0000011100;
W[1584] = 8'b1111110010;
W[1585] = 8'b1111100101;
W[1586] = 8'b0000100100;
W[1587] = 8'b0000001111;
W[1588] = 8'b0000101001;
W[1589] = 8'b1111101011;
W[1590] = 8'b0000000011;
W[1591] = 8'b1111100101;
W[1592] = 8'b1111100100;
W[1593] = 8'b0000001101;
W[1594] = 8'b1111111111;
W[1595] = 8'b1111001010;
W[1596] = 8'b1111101110;
W[1597] = 8'b1111101100;
W[1598] = 8'b0000001111;
W[1599] = 8'b1111111001;
W[1600] = 8'b1111011101;
W[1601] = 8'b1111011100;
W[1602] = 8'b0000001100;
W[1603] = 8'b0000011011;
W[1604] = 8'b0000111110;
W[1605] = 8'b0000000110;
W[1606] = 8'b0001000011;
W[1607] = 8'b1111001110;
W[1608] = 8'b1111001010;
W[1609] = 8'b1111111101;
W[1610] = 8'b0000001101;
W[1611] = 8'b0000010110;
W[1612] = 8'b1111111111;
W[1613] = 8'b0000011101;
W[1614] = 8'b1111111111;
W[1615] = 8'b1110100010;
W[1616] = 8'b0000010100;
W[1617] = 8'b0001011001;
W[1618] = 8'b0000011111;
W[1619] = 8'b1111001000;
W[1620] = 8'b0000001110;
W[1621] = 8'b0000011001;
W[1622] = 8'b1111000011;
W[1623] = 8'b1111000000;
W[1624] = 8'b1111101100;
W[1625] = 8'b1111101001;
W[1626] = 8'b0000001001;
W[1627] = 8'b0000000101;
W[1628] = 8'b1111110001;
W[1629] = 8'b1111100100;
W[1630] = 8'b0000010001;
W[1631] = 8'b0000100111;
W[1632] = 8'b1111110000;
W[1633] = 8'b1111100101;
W[1634] = 8'b0000100110;
W[1635] = 8'b1111010011;
W[1636] = 8'b1110110100;
W[1637] = 8'b0000000101;
W[1638] = 8'b0000011111;
W[1639] = 8'b0000011110;
W[1640] = 8'b1111110101;
W[1641] = 8'b0001100100;
W[1642] = 8'b0000010011;
W[1643] = 8'b1111100010;
W[1644] = 8'b1111001010;
W[1645] = 8'b0001000001;
W[1646] = 8'b1111011110;
W[1647] = 8'b1110110010;
W[1648] = 8'b1111100101;
W[1649] = 8'b0000111011;
W[1650] = 8'b0000111110;
W[1651] = 8'b1110101100;
W[1652] = 8'b1111101100;
W[1653] = 8'b0000110011;
W[1654] = 8'b0000000100;
W[1655] = 8'b0000011001;
W[1656] = 8'b1111010001;
W[1657] = 8'b0000010110;
W[1658] = 8'b1111111010;
W[1659] = 8'b1111111001;
W[1660] = 8'b1111101110;
W[1661] = 8'b1111111111;
W[1662] = 8'b1111011100;
W[1663] = 8'b0000010101;
W[1664] = 8'b0000101110;
W[1665] = 8'b1111011000;
W[1666] = 8'b0000111001;
W[1667] = 8'b1111010111;
W[1668] = 8'b1111110110;
W[1669] = 8'b0001101011;
W[1670] = 8'b1111001111;
W[1671] = 8'b1111100111;
W[1672] = 8'b0000100011;
W[1673] = 8'b1110101010;
W[1674] = 8'b1111101010;
W[1675] = 8'b0001011101;
W[1676] = 8'b0000010101;
W[1677] = 8'b0000000000;
W[1678] = 8'b1111110101;
W[1679] = 8'b1111111001;
W[1680] = 8'b0000111001;
W[1681] = 8'b0000110111;
W[1682] = 8'b0000110110;
W[1683] = 8'b0000011001;
W[1684] = 8'b0001001011;
W[1685] = 8'b1111100011;
W[1686] = 8'b0000100010;
W[1687] = 8'b0000010111;
W[1688] = 8'b1111110101;
W[1689] = 8'b0001001001;
W[1690] = 8'b1111111010;
W[1691] = 8'b1111000001;
W[1692] = 8'b1111011101;
W[1693] = 8'b1111100100;
W[1694] = 8'b0000000011;
W[1695] = 8'b1111111110;
W[1696] = 8'b1111000100;
W[1697] = 8'b0000100110;
W[1698] = 8'b0000110100;
W[1699] = 8'b1110110011;
W[1700] = 8'b0000000011;
W[1701] = 8'b0000000101;
W[1702] = 8'b1111010001;
W[1703] = 8'b1111110011;
W[1704] = 8'b0000011101;
W[1705] = 8'b1111010011;
W[1706] = 8'b1111110011;
W[1707] = 8'b0000001000;
W[1708] = 8'b1111011101;
W[1709] = 8'b0001000011;
W[1710] = 8'b1111001100;
W[1711] = 8'b0000000010;
W[1712] = 8'b0000110101;
W[1713] = 8'b1111000001;
W[1714] = 8'b0000000110;
W[1715] = 8'b0000011010;
W[1716] = 8'b1111011111;
W[1717] = 8'b0000101010;
W[1718] = 8'b0000001010;
W[1719] = 8'b0000101001;
W[1720] = 8'b0001001001;
W[1721] = 8'b1111101111;
W[1722] = 8'b0000001110;
W[1723] = 8'b0000101010;
W[1724] = 8'b0000111001;
W[1725] = 8'b0001010001;
W[1726] = 8'b0000100000;
W[1727] = 8'b0000000101;
W[1728] = 8'b1111111011;
W[1729] = 8'b0001000010;
W[1730] = 8'b0000000101;
W[1731] = 8'b0000000111;
W[1732] = 8'b0000000011;
W[1733] = 8'b0000001001;
W[1734] = 8'b0001001000;
W[1735] = 8'b1111011001;
W[1736] = 8'b0000010000;
W[1737] = 8'b0000000011;
W[1738] = 8'b1111001000;
W[1739] = 8'b0000101110;
W[1740] = 8'b1111011111;
W[1741] = 8'b1111011101;
W[1742] = 8'b0000011011;
W[1743] = 8'b1111000010;
W[1744] = 8'b1111100111;
W[1745] = 8'b1111111010;
W[1746] = 8'b1111000001;
W[1747] = 8'b0000010001;
W[1748] = 8'b1111010110;
W[1749] = 8'b1111100010;
W[1750] = 8'b0000111000;
W[1751] = 8'b0000101111;
W[1752] = 8'b0000000001;
W[1753] = 8'b0000001101;
W[1754] = 8'b0000010001;
W[1755] = 8'b1111110001;
W[1756] = 8'b0000001001;
W[1757] = 8'b1111110010;
W[1758] = 8'b1111111010;
W[1759] = 8'b0001000110;
W[1760] = 8'b0000100101;
W[1761] = 8'b1111010110;
W[1762] = 8'b1111110011;
W[1763] = 8'b1111100100;
W[1764] = 8'b0000000101;
W[1765] = 8'b1111111000;
W[1766] = 8'b1111001111;
W[1767] = 8'b0000010010;
W[1768] = 8'b1111010010;
W[1769] = 8'b1111000110;
W[1770] = 8'b1111111111;
W[1771] = 8'b1111111110;
W[1772] = 8'b0000011101;
W[1773] = 8'b1111111100;
W[1774] = 8'b1111011011;
W[1775] = 8'b1110110001;
W[1776] = 8'b1111101100;
W[1777] = 8'b1111110101;
W[1778] = 8'b1111001000;
W[1779] = 8'b1111111010;
W[1780] = 8'b0000010100;
W[1781] = 8'b1111100100;
W[1782] = 8'b1111011001;
W[1783] = 8'b1111110001;
W[1784] = 8'b1111111000;
W[1785] = 8'b0001000010;
W[1786] = 8'b0000000110;
W[1787] = 8'b0000110001;
W[1788] = 8'b0000001001;
W[1789] = 8'b0000000111;
W[1790] = 8'b1111010000;
W[1791] = 8'b1111110000;
W[1792] = 8'b0000110111;
W[1793] = 8'b1111110001;
W[1794] = 8'b1110111000;
W[1795] = 8'b0001000110;
W[1796] = 8'b0000110100;
W[1797] = 8'b0000010000;
W[1798] = 8'b0000011001;
W[1799] = 8'b0000100111;
W[1800] = 8'b1111011010;
W[1801] = 8'b0001000110;
W[1802] = 8'b1111001111;
W[1803] = 8'b0001001011;
W[1804] = 8'b0000001101;
W[1805] = 8'b1101111010;
W[1806] = 8'b1111010110;
W[1807] = 8'b0000001000;
W[1808] = 8'b1111011010;
W[1809] = 8'b1110111111;
W[1810] = 8'b1111110001;
W[1811] = 8'b0001001011;
W[1812] = 8'b0000011011;
W[1813] = 8'b0001001011;
W[1814] = 8'b0001110011;
W[1815] = 8'b1110011011;
W[1816] = 8'b1110111110;
W[1817] = 8'b1111010110;
W[1818] = 8'b1111011110;
W[1819] = 8'b0000010001;
W[1820] = 8'b0000101110;
W[1821] = 8'b1111100000;
W[1822] = 8'b0000011100;
W[1823] = 8'b0000001100;
W[1824] = 8'b0000001101;
W[1825] = 8'b1110010000;
W[1826] = 8'b1110111000;
W[1827] = 8'b1110001000;
W[1828] = 8'b1110000110;
W[1829] = 8'b1111110110;
W[1830] = 8'b1111110110;
W[1831] = 8'b1111110110;
W[1832] = 8'b1111100111;
W[1833] = 8'b0000110001;
W[1834] = 8'b0000011001;
W[1835] = 8'b1111110001;
W[1836] = 8'b0000001011;
W[1837] = 8'b1111101110;
W[1838] = 8'b0000010100;
W[1839] = 8'b0000101110;
W[1840] = 8'b1111110000;
W[1841] = 8'b0000011000;
W[1842] = 8'b1111101101;
W[1843] = 8'b1111010100;
W[1844] = 8'b0000010110;
W[1845] = 8'b0000101010;
W[1846] = 8'b0011000011;
W[1847] = 8'b0001110010;
W[1848] = 8'b1111111001;
W[1849] = 8'b0000011010;
W[1850] = 8'b0000010000;
W[1851] = 8'b1111110100;
W[1852] = 8'b0000010000;
W[1853] = 8'b0000110111;
W[1854] = 8'b0000000011;
W[1855] = 8'b1111001100;
W[1856] = 8'b1111100111;
W[1857] = 8'b0000000100;
W[1858] = 8'b0000101111;
W[1859] = 8'b0000001010;
W[1860] = 8'b1111100111;
W[1861] = 8'b1111101101;
W[1862] = 8'b1111100111;
W[1863] = 8'b1111101011;
W[1864] = 8'b0001010100;
W[1865] = 8'b1111100111;
W[1866] = 8'b1111100100;
W[1867] = 8'b1111000010;
W[1868] = 8'b1111101110;
W[1869] = 8'b1111100111;
W[1870] = 8'b1110101111;
W[1871] = 8'b0000011010;
W[1872] = 8'b0000101001;
W[1873] = 8'b0000001110;
W[1874] = 8'b1111100011;
W[1875] = 8'b1111101000;
W[1876] = 8'b1111011111;
W[1877] = 8'b1110111111;
W[1878] = 8'b0001100101;
W[1879] = 8'b1111011010;
W[1880] = 8'b1111101000;
W[1881] = 8'b1111010010;
W[1882] = 8'b1111101011;
W[1883] = 8'b0000100000;
W[1884] = 8'b0000000000;
W[1885] = 8'b1111110000;
W[1886] = 8'b1111110001;
W[1887] = 8'b1111100010;
W[1888] = 8'b1110110110;
W[1889] = 8'b0000101010;
W[1890] = 8'b0000010111;
W[1891] = 8'b0000000111;
W[1892] = 8'b1111101100;
W[1893] = 8'b1111101001;
W[1894] = 8'b0001001110;
W[1895] = 8'b1111000011;
W[1896] = 8'b1111011011;
W[1897] = 8'b1111111010;
W[1898] = 8'b1111101110;
W[1899] = 8'b0000001101;
W[1900] = 8'b1111000001;
W[1901] = 8'b0000000000;
W[1902] = 8'b1111100010;
W[1903] = 8'b0000111101;
W[1904] = 8'b0000101000;
W[1905] = 8'b0001000011;
W[1906] = 8'b0001000000;
W[1907] = 8'b0000110000;
W[1908] = 8'b0000010010;
W[1909] = 8'b0000111110;
W[1910] = 8'b0000010100;
W[1911] = 8'b1111000010;
W[1912] = 8'b1111111011;
W[1913] = 8'b1111100010;
W[1914] = 8'b1111110101;
W[1915] = 8'b0000100011;
W[1916] = 8'b0001000010;
W[1917] = 8'b0000001010;
W[1918] = 8'b1111011101;
W[1919] = 8'b0000101010;
W[1920] = 8'b0000000000;
W[1921] = 8'b1111100110;
W[1922] = 8'b1111100110;
W[1923] = 8'b1111100101;
W[1924] = 8'b0000000010;
W[1925] = 8'b1111111111;
W[1926] = 8'b0000101100;
W[1927] = 8'b0000111011;
W[1928] = 8'b0001000011;
W[1929] = 8'b1111010010;
W[1930] = 8'b0001110100;
W[1931] = 8'b1111111111;
W[1932] = 8'b0000011011;
W[1933] = 8'b0000101100;
W[1934] = 8'b0000101101;
W[1935] = 8'b0000001001;
W[1936] = 8'b1110100100;
W[1937] = 8'b0000011100;
W[1938] = 8'b1111010011;
W[1939] = 8'b1111010001;
W[1940] = 8'b0001101000;
W[1941] = 8'b0001101001;
W[1942] = 8'b0000111010;
W[1943] = 8'b0000101100;
W[1944] = 8'b0001000110;
W[1945] = 8'b1111000010;
W[1946] = 8'b1110101011;
W[1947] = 8'b1111000010;
W[1948] = 8'b1111010111;
W[1949] = 8'b0000010100;
W[1950] = 8'b0000100001;
W[1951] = 8'b0000000111;
W[1952] = 8'b0001011110;
W[1953] = 8'b0000111010;
W[1954] = 8'b1110111001;
W[1955] = 8'b1110010010;
W[1956] = 8'b1111011110;
W[1957] = 8'b1111111000;
W[1958] = 8'b0000000010;
W[1959] = 8'b0000000000;
W[1960] = 8'b1110101001;
W[1961] = 8'b0001000011;
W[1962] = 8'b1111100011;
W[1963] = 8'b0000100001;
W[1964] = 8'b0001001010;
W[1965] = 8'b0001110110;
W[1966] = 8'b1110101001;
W[1967] = 8'b1111011111;
W[1968] = 8'b1111100011;
W[1969] = 8'b0000100100;
W[1970] = 8'b0000000111;
W[1971] = 8'b1111101010;
W[1972] = 8'b1101111000;
W[1973] = 8'b1111010101;
W[1974] = 8'b1110001101;
W[1975] = 8'b0011001111;
W[1976] = 8'b0001001001;
W[1977] = 8'b0001010011;
W[1978] = 8'b1110110100;
W[1979] = 8'b1111001010;
W[1980] = 8'b0001011011;
W[1981] = 8'b0000110110;
W[1982] = 8'b1110010010;
W[1983] = 8'b0000000000;
W[1984] = 8'b1110111001;
W[1985] = 8'b1110101101;
W[1986] = 8'b0000011011;
W[1987] = 8'b0001010010;
W[1988] = 8'b0000010011;
W[1989] = 8'b1110111010;
W[1990] = 8'b0000000110;
W[1991] = 8'b1110101000;
W[1992] = 8'b0000011001;
W[1993] = 8'b0000001111;
W[1994] = 8'b1111000111;
W[1995] = 8'b1111001111;
W[1996] = 8'b0000100101;
W[1997] = 8'b0000000111;
W[1998] = 8'b0001110010;
W[1999] = 8'b1111100000;
W[2000] = 8'b0001001011;
W[2001] = 8'b1111001000;
W[2002] = 8'b1110010010;
W[2003] = 8'b0000010011;
W[2004] = 8'b0000000100;
W[2005] = 8'b0000011001;
W[2006] = 8'b0001010011;
W[2007] = 8'b1111001111;
W[2008] = 8'b1111000101;
W[2009] = 8'b0001001000;
W[2010] = 8'b0001010111;
W[2011] = 8'b0001000000;
W[2012] = 8'b0000110101;
W[2013] = 8'b0001110010;
W[2014] = 8'b1011111100;
W[2015] = 8'b1111101011;
W[2016] = 8'b0001101100;
W[2017] = 8'b0000011110;
W[2018] = 8'b0000110101;
W[2019] = 8'b1111011111;
W[2020] = 8'b1110011010;
W[2021] = 8'b1111110000;
W[2022] = 8'b0000100001;
W[2023] = 8'b0001101100;
W[2024] = 8'b0001000001;
W[2025] = 8'b0000110010;
W[2026] = 8'b1111100000;
W[2027] = 8'b0000010111;
W[2028] = 8'b1111111111;
W[2029] = 8'b0000000000;
W[2030] = 8'b1111101111;
W[2031] = 8'b0001100101;
W[2032] = 8'b1111000100;
W[2033] = 8'b0000001111;
W[2034] = 8'b1110010100;
W[2035] = 8'b0001001100;
W[2036] = 8'b1111011110;
W[2037] = 8'b0000011001;
W[2038] = 8'b0001010001;
W[2039] = 8'b1101101110;
W[2040] = 8'b0000001110;
W[2041] = 8'b0000101101;
W[2042] = 8'b1111100010;
W[2043] = 8'b1110111100;
W[2044] = 8'b0000001111;
W[2045] = 8'b1111111110;
W[2046] = 8'b0001100010;
W[2047] = 8'b1111011001;
W[2048] = 8'b0000010110;
W[2049] = 8'b1111001110;
W[2050] = 8'b1101011001;
W[2051] = 8'b1111100000;
W[2052] = 8'b1111001011;
W[2053] = 8'b0001011000;
W[2054] = 8'b0001110101;
W[2055] = 8'b1110111101;
W[2056] = 8'b0000101101;
W[2057] = 8'b0001010010;
W[2058] = 8'b0010110000;
W[2059] = 8'b1111100000;
W[2060] = 8'b0010111010;
W[2061] = 8'b0000001001;
W[2062] = 8'b1100100100;
W[2063] = 8'b0000101010;
W[2064] = 8'b0001011100;
W[2065] = 8'b0000011010;
W[2066] = 8'b0000111101;
W[2067] = 8'b1111101010;
W[2068] = 8'b1111101001;
W[2069] = 8'b0000000010;
W[2070] = 8'b1110110100;
W[2071] = 8'b0000100011;
W[2072] = 8'b0011111111;
W[2073] = 8'b0010000011;
W[2074] = 8'b0000101101;
W[2075] = 8'b1111011110;
W[2076] = 8'b0000010011;
W[2077] = 8'b0000010101;
W[2078] = 8'b1111110101;
W[2079] = 8'b0000001010;
W[2080] = 8'b1111001001;
W[2081] = 8'b0000010110;
W[2082] = 8'b1101101001;
W[2083] = 8'b0000101001;
W[2084] = 8'b1111110000;
W[2085] = 8'b0000010100;
W[2086] = 8'b0001000011;
W[2087] = 8'b1110001100;
W[2088] = 8'b1110110100;
W[2089] = 8'b1111111101;
W[2090] = 8'b1111111101;
W[2091] = 8'b0000010000;
W[2092] = 8'b1110111101;
W[2093] = 8'b1111010100;
W[2094] = 8'b0010011110;
W[2095] = 8'b1111011000;
W[2096] = 8'b0000001100;
W[2097] = 8'b0000001111;
W[2098] = 8'b1111001001;
W[2099] = 8'b1111011011;
W[2100] = 8'b0000000001;
W[2101] = 8'b0010011010;
W[2102] = 8'b1111011000;
W[2103] = 8'b0000100000;
W[2104] = 8'b0001100010;
W[2105] = 8'b1111100100;
W[2106] = 8'b0010111100;
W[2107] = 8'b1110101011;
W[2108] = 8'b0011011010;
W[2109] = 8'b0000001011;
W[2110] = 8'b1100111001;
W[2111] = 8'b0000100100;
W[2112] = 8'b0001011010;
W[2113] = 8'b1111100001;
W[2114] = 8'b0001111000;
W[2115] = 8'b0000000101;
W[2116] = 8'b1111111111;
W[2117] = 8'b0000100000;
W[2118] = 8'b1111110010;
W[2119] = 8'b1111011101;
W[2120] = 8'b0001100010;
W[2121] = 8'b0000111010;
W[2122] = 8'b1110101110;
W[2123] = 8'b0001101000;
W[2124] = 8'b1111011101;
W[2125] = 8'b1111111010;
W[2126] = 8'b0000111010;
W[2127] = 8'b0001000101;
W[2128] = 8'b1110100101;
W[2129] = 8'b0001001001;
W[2130] = 8'b1111010111;
W[2131] = 8'b0001100110;
W[2132] = 8'b0000000111;
W[2133] = 8'b0001111100;
W[2134] = 8'b0000010100;
W[2135] = 8'b0001001011;
W[2136] = 8'b1111011011;
W[2137] = 8'b1111100100;
W[2138] = 8'b1111001011;
W[2139] = 8'b1110101110;
W[2140] = 8'b1110101010;
W[2141] = 8'b0000011000;
W[2142] = 8'b0001001010;
W[2143] = 8'b0000010110;
W[2144] = 8'b0100101111;
W[2145] = 8'b0010111011;
W[2146] = 8'b1101001110;
W[2147] = 8'b1110011111;
W[2148] = 8'b1110111001;
W[2149] = 8'b0000011001;
W[2150] = 8'b1111010000;
W[2151] = 8'b1110011110;
W[2152] = 8'b1101011110;
W[2153] = 8'b0000110111;
W[2154] = 8'b0000010000;
W[2155] = 8'b0000010001;
W[2156] = 8'b0000100001;
W[2157] = 8'b0001000101;
W[2158] = 8'b1111110011;
W[2159] = 8'b1110011011;
W[2160] = 8'b0000011010;
W[2161] = 8'b0000100000;
W[2162] = 8'b1101011011;
W[2163] = 8'b1111011110;
W[2164] = 8'b0000000011;
W[2165] = 8'b0001100001;
W[2166] = 8'b0000000000;
W[2167] = 8'b0000110100;
W[2168] = 8'b0001001110;
W[2169] = 8'b1111111111;
W[2170] = 8'b1101111001;
W[2171] = 8'b1110101010;
W[2172] = 8'b1111011100;
W[2173] = 8'b0000001011;
W[2174] = 8'b1111000101;
W[2175] = 8'b1111010011;
W[2176] = 8'b1110000010;
W[2177] = 8'b0000001100;
W[2178] = 8'b1110011001;
W[2179] = 8'b0001000001;
W[2180] = 8'b0000000010;
W[2181] = 8'b0010011111;
W[2182] = 8'b1110000110;
W[2183] = 8'b1111010110;
W[2184] = 8'b0001010011;
W[2185] = 8'b0000111001;
W[2186] = 8'b1101110000;
W[2187] = 8'b0001110011;
W[2188] = 8'b1101101100;
W[2189] = 8'b0000100010;
W[2190] = 8'b0001101101;
W[2191] = 8'b0000100111;
W[2192] = 8'b0011100000;
W[2193] = 8'b0001111101;
W[2194] = 8'b1100011110;
W[2195] = 8'b0010000001;
W[2196] = 8'b0010001111;
W[2197] = 8'b0001000101;
W[2198] = 8'b0010011011;
W[2199] = 8'b0001010100;
W[2200] = 8'b1110101001;
W[2201] = 8'b1110011101;
W[2202] = 8'b0000110000;
W[2203] = 8'b1111101011;
W[2204] = 8'b0001111111;
W[2205] = 8'b1111011000;
W[2206] = 8'b1111110101;
W[2207] = 8'b1110000101;
W[2208] = 8'b0000000010;
W[2209] = 8'b0011100000;
W[2210] = 8'b0001000011;
W[2211] = 8'b0001100011;
W[2212] = 8'b1111001100;
W[2213] = 8'b0010010011;
W[2214] = 8'b0000011100;
W[2215] = 8'b0000011001;
W[2216] = 8'b1111111101;
W[2217] = 8'b0000001010;
W[2218] = 8'b1101011111;
W[2219] = 8'b1111111110;
W[2220] = 8'b0001111001;
W[2221] = 8'b1111111001;
W[2222] = 8'b0010011100;
W[2223] = 8'b1101010011;
W[2224] = 8'b0001111011;
W[2225] = 8'b1101110001;
W[2226] = 8'b1111110100;
W[2227] = 8'b0001110000;
W[2228] = 8'b0100011000;
W[2229] = 8'b0000010100;
W[2230] = 8'b0000010001;
W[2231] = 8'b1110010111;
W[2232] = 8'b0000111111;
W[2233] = 8'b0000011110;
W[2234] = 8'b1110011001;
W[2235] = 8'b1110110111;
W[2236] = 8'b1111011111;
W[2237] = 8'b0001010111;
W[2238] = 8'b0000110101;
W[2239] = 8'b0001111000;
W[2240] = 8'b0011110010;
W[2241] = 8'b0010010110;
W[2242] = 8'b1110111010;
W[2243] = 8'b0000111101;
W[2244] = 8'b0010001111;
W[2245] = 8'b1101110100;
W[2246] = 8'b0001011110;
W[2247] = 8'b1111101110;
W[2248] = 8'b1110111110;
W[2249] = 8'b0001010101;
W[2250] = 8'b0000011111;
W[2251] = 8'b0000001001;
W[2252] = 8'b0000011101;
W[2253] = 8'b0010000100;
W[2254] = 8'b1111001111;
W[2255] = 8'b1111100100;
W[2256] = 8'b1111011110;
W[2257] = 8'b0001111011;
W[2258] = 8'b0000011100;
W[2259] = 8'b1111011011;
W[2260] = 8'b1111100110;
W[2261] = 8'b0000011110;
W[2262] = 8'b0001000011;
W[2263] = 8'b0000010110;
W[2264] = 8'b0001100111;
W[2265] = 8'b1111100100;
W[2266] = 8'b1100110101;
W[2267] = 8'b1111111010;
W[2268] = 8'b0000101100;
W[2269] = 8'b0000100101;
W[2270] = 8'b0000001011;
W[2271] = 8'b0000000000;
W[2272] = 8'b1111001101;
W[2273] = 8'b1110010010;
W[2274] = 8'b1101010101;
W[2275] = 8'b0011001110;
W[2276] = 8'b0100111100;
W[2277] = 8'b0001000011;
W[2278] = 8'b0001000110;
W[2279] = 8'b1110001010;
W[2280] = 8'b0001101001;
W[2281] = 8'b1101011100;
W[2282] = 8'b0000000000;
W[2283] = 8'b0000000110;
W[2284] = 8'b1110111011;
W[2285] = 8'b0001011111;
W[2286] = 8'b0001000001;
W[2287] = 8'b1110101001;
W[2288] = 8'b0100100000;
W[2289] = 8'b1111000111;
W[2290] = 8'b1111001001;
W[2291] = 8'b0000011101;
W[2292] = 8'b1111110110;
W[2293] = 8'b0001000000;
W[2294] = 8'b0011100011;
W[2295] = 8'b0000100001;
W[2296] = 8'b1111100101;
W[2297] = 8'b0001001111;
W[2298] = 8'b0001001101;
W[2299] = 8'b0010000111;
W[2300] = 8'b0000010101;
W[2301] = 8'b0001011101;
W[2302] = 8'b1101111000;
W[2303] = 8'b0000100000;
W[2304] = 8'b0010101000;
W[2305] = 8'b0010000111;
W[2306] = 8'b1111110001;
W[2307] = 8'b0001001110;
W[2308] = 8'b0000011110;
W[2309] = 8'b0000100010;
W[2310] = 8'b0000011100;
W[2311] = 8'b0001010001;
W[2312] = 8'b0011000010;
W[2313] = 8'b0000100110;
W[2314] = 8'b1111010001;
W[2315] = 8'b1110111000;
W[2316] = 8'b1110110000;
W[2317] = 8'b1110000100;
W[2318] = 8'b0001101011;
W[2319] = 8'b1110100011;
W[2320] = 8'b1110110111;
W[2321] = 8'b0000010110;
W[2322] = 8'b1110010011;
W[2323] = 8'b1110001100;
W[2324] = 8'b0001011010;
W[2325] = 8'b1111001111;
W[2326] = 8'b1111011100;
W[2327] = 8'b0000011010;
W[2328] = 8'b1111111000;
W[2329] = 8'b1111000011;
W[2330] = 8'b0010100100;
W[2331] = 8'b1111110101;
W[2332] = 8'b1111011111;
W[2333] = 8'b0010101010;
W[2334] = 8'b0000110100;
W[2335] = 8'b0010000110;
W[2336] = 8'b1110011100;
W[2337] = 8'b0010001010;
W[2338] = 8'b1110010111;
W[2339] = 8'b1111010000;
W[2340] = 8'b1111000110;
W[2341] = 8'b0010100010;
W[2342] = 8'b1110101010;
W[2343] = 8'b1110100101;
W[2344] = 8'b1110101100;
W[2345] = 8'b1110100110;
W[2346] = 8'b0000010010;
W[2347] = 8'b0011100001;
W[2348] = 8'b1111111110;
W[2349] = 8'b0010000100;
W[2350] = 8'b1110011111;
W[2351] = 8'b1101101001;
W[2352] = 8'b0000011011;
W[2353] = 8'b0001000101;
W[2354] = 8'b1101011111;
W[2355] = 8'b1111110100;
W[2356] = 8'b1110001111;
W[2357] = 8'b1111011100;
W[2358] = 8'b1111100111;
W[2359] = 8'b0010101000;
W[2360] = 8'b0000101111;
W[2361] = 8'b0001111100;
W[2362] = 8'b1110110010;
W[2363] = 8'b1101010101;
W[2364] = 8'b0000110011;
W[2365] = 8'b1111101101;
W[2366] = 8'b1110111100;
W[2367] = 8'b1111111011;
W[2368] = 8'b1110101000;
W[2369] = 8'b0000000000;
W[2370] = 8'b0000001111;
W[2371] = 8'b0001000110;
W[2372] = 8'b0010011010;
W[2373] = 8'b0001101111;
W[2374] = 8'b1110000010;
W[2375] = 8'b1111010011;
W[2376] = 8'b0010001011;
W[2377] = 8'b0000010010;
W[2378] = 8'b1111100011;
W[2379] = 8'b1111001100;
W[2380] = 8'b1110100111;
W[2381] = 8'b0001010011;
W[2382] = 8'b0010000111;
W[2383] = 8'b1111111000;
W[2384] = 8'b0001101111;
W[2385] = 8'b0001110111;
W[2386] = 8'b1110010111;
W[2387] = 8'b1111100100;
W[2388] = 8'b1110100011;
W[2389] = 8'b1111100111;
W[2390] = 8'b0000010110;
W[2391] = 8'b1111101001;
W[2392] = 8'b1101110111;
W[2393] = 8'b0010011110;
W[2394] = 8'b0001100000;
W[2395] = 8'b0001001011;
W[2396] = 8'b0001110100;
W[2397] = 8'b0000100001;
W[2398] = 8'b1110110110;
W[2399] = 8'b1110101010;
W[2400] = 8'b0000010010;
W[2401] = 8'b1111100000;
W[2402] = 8'b0001010100;
W[2403] = 8'b1110111100;
W[2404] = 8'b1110100110;
W[2405] = 8'b0000000011;
W[2406] = 8'b0000011010;
W[2407] = 8'b0000110001;
W[2408] = 8'b0010011011;
W[2409] = 8'b0001101111;
W[2410] = 8'b1110011011;
W[2411] = 8'b1111010110;
W[2412] = 8'b0000111100;
W[2413] = 8'b0001011010;
W[2414] = 8'b0000011110;
W[2415] = 8'b1111001000;
W[2416] = 8'b1110001000;
W[2417] = 8'b0000100010;
W[2418] = 8'b1111101101;
W[2419] = 8'b0001100110;
W[2420] = 8'b0010010000;
W[2421] = 8'b0001001101;
W[2422] = 8'b1110111101;
W[2423] = 8'b1111010100;
W[2424] = 8'b0001011110;
W[2425] = 8'b0001000100;
W[2426] = 8'b0000000100;
W[2427] = 8'b1111011010;
W[2428] = 8'b0000001011;
W[2429] = 8'b1111101100;
W[2430] = 8'b0000111000;
W[2431] = 8'b1110100100;
W[2432] = 8'b0001110010;
W[2433] = 8'b1111001010;
W[2434] = 8'b1110011100;
W[2435] = 8'b0000111110;
W[2436] = 8'b0001011010;
W[2437] = 8'b0000000111;
W[2438] = 8'b0001110111;
W[2439] = 8'b0001111010;
W[2440] = 8'b0000000000;
W[2441] = 8'b0010100111;
W[2442] = 8'b0001110110;
W[2443] = 8'b0000010101;
W[2444] = 8'b0010000001;
W[2445] = 8'b0000000000;
W[2446] = 8'b1110011001;
W[2447] = 8'b0000010000;
W[2448] = 8'b0000100101;
W[2449] = 8'b0010101010;
W[2450] = 8'b0001001100;
W[2451] = 8'b1111010110;
W[2452] = 8'b1111100000;
W[2453] = 8'b0000000010;
W[2454] = 8'b1111101100;
W[2455] = 8'b0001011001;
W[2456] = 8'b0000111000;
W[2457] = 8'b0000110110;
W[2458] = 8'b1101110010;
W[2459] = 8'b1111100011;
W[2460] = 8'b0000011011;
W[2461] = 8'b0000000100;
W[2462] = 8'b0001010001;
W[2463] = 8'b0000011000;
W[2464] = 8'b1111110011;
W[2465] = 8'b1111001011;
W[2466] = 8'b1110110000;
W[2467] = 8'b0000010110;
W[2468] = 8'b0001100101;
W[2469] = 8'b1111110101;
W[2470] = 8'b0010110100;
W[2471] = 8'b1111100000;
W[2472] = 8'b0000100010;
W[2473] = 8'b1110111100;
W[2474] = 8'b0000000000;
W[2475] = 8'b0000000111;
W[2476] = 8'b0000000000;
W[2477] = 8'b0001010111;
W[2478] = 8'b0010000010;
W[2479] = 8'b0000011000;
W[2480] = 8'b0000001001;
W[2481] = 8'b1111001010;
W[2482] = 8'b1111101100;
W[2483] = 8'b1111110001;
W[2484] = 8'b0000001000;
W[2485] = 8'b0000000001;
W[2486] = 8'b0000110111;
W[2487] = 8'b0001000001;
W[2488] = 8'b0000111100;
W[2489] = 8'b1111010000;
W[2490] = 8'b0001000101;
W[2491] = 8'b1111010001;
W[2492] = 8'b0000000000;
W[2493] = 8'b0001101101;
W[2494] = 8'b1110011000;
W[2495] = 8'b0001011000;
W[2496] = 8'b0000111001;
W[2497] = 8'b0001010111;
W[2498] = 8'b0000111101;
W[2499] = 8'b0001001110;
W[2500] = 8'b0000010100;
W[2501] = 8'b0000100110;
W[2502] = 8'b0000000100;
W[2503] = 8'b1111001111;
W[2504] = 8'b0001000011;
W[2505] = 8'b0001000010;
W[2506] = 8'b0001010100;
W[2507] = 8'b0001101111;
W[2508] = 8'b0000100000;
W[2509] = 8'b1110101011;
W[2510] = 8'b0000010011;
W[2511] = 8'b0001011011;
W[2512] = 8'b1111110001;
W[2513] = 8'b0000001000;
W[2514] = 8'b1101100111;
W[2515] = 8'b1110010111;
W[2516] = 8'b1111110000;
W[2517] = 8'b1111011001;
W[2518] = 8'b0100101011;
W[2519] = 8'b1111110110;
W[2520] = 8'b1100110111;
W[2521] = 8'b1110110110;
W[2522] = 8'b0001010001;
W[2523] = 8'b1110011110;
W[2524] = 8'b0000001010;
W[2525] = 8'b0000010011;
W[2526] = 8'b0000001111;
W[2527] = 8'b0010011010;
W[2528] = 8'b1101100000;
W[2529] = 8'b0001110101;
W[2530] = 8'b1110010100;
W[2531] = 8'b0001000011;
W[2532] = 8'b1111011110;
W[2533] = 8'b0001011011;
W[2534] = 8'b1110110010;
W[2535] = 8'b1110011000;
W[2536] = 8'b1110000110;
W[2537] = 8'b1101101110;
W[2538] = 8'b1111111111;
W[2539] = 8'b0001110001;
W[2540] = 8'b0000000100;
W[2541] = 8'b0001100000;
W[2542] = 8'b0000001010;
W[2543] = 8'b1110010100;
W[2544] = 8'b1111100101;
W[2545] = 8'b0000111011;
W[2546] = 8'b1110001110;
W[2547] = 8'b1111001101;
W[2548] = 8'b1110111100;
W[2549] = 8'b0000000101;
W[2550] = 8'b1111111110;
W[2551] = 8'b0001011010;
W[2552] = 8'b0000000100;
W[2553] = 8'b0001011011;
W[2554] = 8'b1111011011;
W[2555] = 8'b1110001000;
W[2556] = 8'b0000101100;
W[2557] = 8'b0000000001;
W[2558] = 8'b1110001001;
W[2559] = 8'b1111110011;
W[2560] = 8'b1111000100;
W[2561] = 8'b1111111001;
W[2562] = 8'b0000100100;
W[2563] = 8'b0001111011;
W[2564] = 8'b0001010101;
W[2565] = 8'b1111111000;
W[2566] = 8'b1110100001;
W[2567] = 8'b1110110111;
W[2568] = 8'b0001110010;
W[2569] = 8'b0000100011;
W[2570] = 8'b1110110110;
W[2571] = 8'b1111001000;
W[2572] = 8'b1110010010;
W[2573] = 8'b0001011100;
W[2574] = 8'b0010000011;
W[2575] = 8'b1111110110;
W[2576] = 8'b0001110101;
W[2577] = 8'b0010110111;
W[2578] = 8'b1111000100;
W[2579] = 8'b0000011100;
W[2580] = 8'b0000000101;
W[2581] = 8'b1111111011;
W[2582] = 8'b0000001010;
W[2583] = 8'b1111110000;
W[2584] = 8'b1101101111;
W[2585] = 8'b0010011110;
W[2586] = 8'b0000000000;
W[2587] = 8'b0000011001;
W[2588] = 8'b0000111110;
W[2589] = 8'b0001011111;
W[2590] = 8'b1111110111;
W[2591] = 8'b1111100000;
W[2592] = 8'b0000110101;
W[2593] = 8'b0001011101;
W[2594] = 8'b0000100010;
W[2595] = 8'b1111111111;
W[2596] = 8'b1110101101;
W[2597] = 8'b0001100001;
W[2598] = 8'b1110110101;
W[2599] = 8'b0000110110;
W[2600] = 8'b0000001100;
W[2601] = 8'b0001110101;
W[2602] = 8'b1101100101;
W[2603] = 8'b1111000000;
W[2604] = 8'b0001100011;
W[2605] = 8'b0000110001;
W[2606] = 8'b0000011010;
W[2607] = 8'b1111000110;
W[2608] = 8'b0000000001;
W[2609] = 8'b0000001000;
W[2610] = 8'b0000011101;
W[2611] = 8'b0001000110;
W[2612] = 8'b0010010101;
W[2613] = 8'b0000010100;
W[2614] = 8'b1110011111;
W[2615] = 8'b1111010100;
W[2616] = 8'b0001101011;
W[2617] = 8'b0000001001;
W[2618] = 8'b0000001010;
W[2619] = 8'b0000110000;
W[2620] = 8'b1111011000;
W[2621] = 8'b1111000101;
W[2622] = 8'b0001101101;
W[2623] = 8'b1111111000;
W[2624] = 8'b0001111001;
W[2625] = 8'b0010101011;
W[2626] = 8'b1100111001;
W[2627] = 8'b0001101110;
W[2628] = 8'b0000111000;
W[2629] = 8'b0000010010;
W[2630] = 8'b0011100011;
W[2631] = 8'b0001011001;
W[2632] = 8'b1110111110;
W[2633] = 8'b0001011001;
W[2634] = 8'b0000010111;
W[2635] = 8'b0010001110;
W[2636] = 8'b0001010000;
W[2637] = 8'b0001011110;
W[2638] = 8'b1110000101;
W[2639] = 8'b1111101111;
W[2640] = 8'b0001101001;
W[2641] = 8'b0001000111;
W[2642] = 8'b0000011111;
W[2643] = 8'b0000000111;
W[2644] = 8'b1111010011;
W[2645] = 8'b0000001101;
W[2646] = 8'b1111101001;
W[2647] = 8'b0000100110;
W[2648] = 8'b0001011101;
W[2649] = 8'b0000000010;
W[2650] = 8'b0000010110;
W[2651] = 8'b1111001100;
W[2652] = 8'b0000101001;
W[2653] = 8'b1111101111;
W[2654] = 8'b0000010000;
W[2655] = 8'b0000010100;
W[2656] = 8'b1111110100;
W[2657] = 8'b1111011011;
W[2658] = 8'b0000101001;
W[2659] = 8'b1111001010;
W[2660] = 8'b0010100100;
W[2661] = 8'b0000100100;
W[2662] = 8'b1111100000;
W[2663] = 8'b1110111100;
W[2664] = 8'b1111111110;
W[2665] = 8'b1111111101;
W[2666] = 8'b0000110010;
W[2667] = 8'b1110111000;
W[2668] = 8'b1111100111;
W[2669] = 8'b0001011100;
W[2670] = 8'b0010010110;
W[2671] = 8'b1110000000;
W[2672] = 8'b0001011011;
W[2673] = 8'b0000001000;
W[2674] = 8'b1110010010;
W[2675] = 8'b0011010100;
W[2676] = 8'b1111100100;
W[2677] = 8'b1111110101;
W[2678] = 8'b0100000111;
W[2679] = 8'b0001100010;
W[2680] = 8'b1111110110;
W[2681] = 8'b0001101001;
W[2682] = 8'b0001000101;
W[2683] = 8'b1110111000;
W[2684] = 8'b0001001011;
W[2685] = 8'b0001001001;
W[2686] = 8'b1111000000;
W[2687] = 8'b0000010100;
W[2688] = 8'b0000111110;
W[2689] = 8'b1110110111;
W[2690] = 8'b0001011001;
W[2691] = 8'b0010111001;
W[2692] = 8'b1110101101;
W[2693] = 8'b0010110011;
W[2694] = 8'b0000001000;
W[2695] = 8'b0000000000;
W[2696] = 8'b0001001000;
W[2697] = 8'b0001011011;
W[2698] = 8'b1111001000;
W[2699] = 8'b0000110010;
W[2700] = 8'b1111110011;
W[2701] = 8'b1110000100;
W[2702] = 8'b0010001100;
W[2703] = 8'b0000110101;
W[2704] = 8'b1110110111;
W[2705] = 8'b0010001011;
W[2706] = 8'b0000000000;
W[2707] = 8'b0000001000;
W[2708] = 8'b0000110100;
W[2709] = 8'b0001100101;
W[2710] = 8'b1111001001;
W[2711] = 8'b1111011010;
W[2712] = 8'b1101110001;
W[2713] = 8'b1111011001;
W[2714] = 8'b1111101011;
W[2715] = 8'b1110011110;
W[2716] = 8'b1111100000;
W[2717] = 8'b1111001110;
W[2718] = 8'b0011000100;
W[2719] = 8'b0001010110;
W[2720] = 8'b0010000111;
W[2721] = 8'b0000001010;
W[2722] = 8'b1101111001;
W[2723] = 8'b1110100100;
W[2724] = 8'b0000001100;
W[2725] = 8'b0001000010;
W[2726] = 8'b0000110000;
W[2727] = 8'b1111011110;
W[2728] = 8'b0000100111;
W[2729] = 8'b0000011110;
W[2730] = 8'b0000110010;
W[2731] = 8'b0000101100;
W[2732] = 8'b0011010001;
W[2733] = 8'b0001000111;
W[2734] = 8'b1100110001;
W[2735] = 8'b1111100110;
W[2736] = 8'b1111011001;
W[2737] = 8'b0000001001;
W[2738] = 8'b0000000101;
W[2739] = 8'b1111101000;
W[2740] = 8'b1111011001;
W[2741] = 8'b0000000000;
W[2742] = 8'b1111000010;
W[2743] = 8'b0000111000;
W[2744] = 8'b0001111010;
W[2745] = 8'b0001100001;
W[2746] = 8'b1111111100;
W[2747] = 8'b1110101011;
W[2748] = 8'b0000110010;
W[2749] = 8'b1111100111;
W[2750] = 8'b1110100101;
W[2751] = 8'b1111000011;
W[2752] = 8'b1110000010;
W[2753] = 8'b1111010111;
W[2754] = 8'b1101110000;
W[2755] = 8'b0000111000;
W[2756] = 8'b1110001111;
W[2757] = 8'b0010100100;
W[2758] = 8'b1110100011;
W[2759] = 8'b1101110000;
W[2760] = 8'b1111110001;
W[2761] = 8'b0000100110;
W[2762] = 8'b1110011100;
W[2763] = 8'b1111101001;
W[2764] = 8'b1111001000;
W[2765] = 8'b1111110100;
W[2766] = 8'b0001011101;
W[2767] = 8'b1111010010;
W[2768] = 8'b0001110110;
W[2769] = 8'b0000000010;
W[2770] = 8'b1110101011;
W[2771] = 8'b1101101011;
W[2772] = 8'b0001000101;
W[2773] = 8'b0010101110;
W[2774] = 8'b0000000100;
W[2775] = 8'b0000010110;
W[2776] = 8'b1111100111;
W[2777] = 8'b0001000101;
W[2778] = 8'b0001110011;
W[2779] = 8'b0000010111;
W[2780] = 8'b0001110011;
W[2781] = 8'b0001011110;
W[2782] = 8'b1100111100;
W[2783] = 8'b1111110111;
W[2784] = 8'b0010011110;
W[2785] = 8'b0000010100;
W[2786] = 8'b0000111111;
W[2787] = 8'b0000000000;
W[2788] = 8'b1111011111;
W[2789] = 8'b0000001011;
W[2790] = 8'b1110111001;
W[2791] = 8'b0000111010;
W[2792] = 8'b0010101111;
W[2793] = 8'b0000001001;
W[2794] = 8'b1111101101;
W[2795] = 8'b0000100001;
W[2796] = 8'b0000110111;
W[2797] = 8'b0001000011;
W[2798] = 8'b0001000111;
W[2799] = 8'b0000000111;
W[2800] = 8'b0000010110;
W[2801] = 8'b0000010001;
W[2802] = 8'b1111101011;
W[2803] = 8'b1111010110;
W[2804] = 8'b0000000101;
W[2805] = 8'b1110101111;
W[2806] = 8'b1111110010;
W[2807] = 8'b0000010111;
W[2808] = 8'b1110111100;
W[2809] = 8'b0010000010;
W[2810] = 8'b1110111011;
W[2811] = 8'b1110001001;
W[2812] = 8'b0000000010;
W[2813] = 8'b1111100011;
W[2814] = 8'b0001111110;
W[2815] = 8'b0001100011;
W[2816] = 8'b0000001010;
W[2817] = 8'b0001010001;
W[2818] = 8'b1110111001;
W[2819] = 8'b1111001101;
W[2820] = 8'b0001001011;
W[2821] = 8'b0001101001;
W[2822] = 8'b0000100111;
W[2823] = 8'b1110110100;
W[2824] = 8'b0000001001;
W[2825] = 8'b1101101010;
W[2826] = 8'b0000101011;
W[2827] = 8'b0001100010;
W[2828] = 8'b0001101011;
W[2829] = 8'b0000010100;
W[2830] = 8'b1111011000;
W[2831] = 8'b1110110111;
W[2832] = 8'b0000111110;
W[2833] = 8'b0000010100;
W[2834] = 8'b0000111010;
W[2835] = 8'b0001000100;
W[2836] = 8'b1111100110;
W[2837] = 8'b1111101010;
W[2838] = 8'b1111111000;
W[2839] = 8'b0001111011;
W[2840] = 8'b0001001100;
W[2841] = 8'b0000111000;
W[2842] = 8'b1110110011;
W[2843] = 8'b1111011001;
W[2844] = 8'b0001101100;
W[2845] = 8'b0000100111;
W[2846] = 8'b0000000111;
W[2847] = 8'b1111111101;
W[2848] = 8'b0000110001;
W[2849] = 8'b1111011010;
W[2850] = 8'b1111011101;
W[2851] = 8'b0010110110;
W[2852] = 8'b0001101010;
W[2853] = 8'b0001100001;
W[2854] = 8'b1110101001;
W[2855] = 8'b1111011001;
W[2856] = 8'b0001010010;
W[2857] = 8'b0001010100;
W[2858] = 8'b0000010011;
W[2859] = 8'b0000100110;
W[2860] = 8'b0000011010;
W[2861] = 8'b1111110010;
W[2862] = 8'b0001110100;
W[2863] = 8'b1111010110;
W[2864] = 8'b0001101011;
W[2865] = 8'b0001000100;
W[2866] = 8'b1110011100;
W[2867] = 8'b1111101001;
W[2868] = 8'b0000100010;
W[2869] = 8'b1111101010;
W[2870] = 8'b1111000010;
W[2871] = 8'b0010001001;
W[2872] = 8'b1110011011;
W[2873] = 8'b0001100100;
W[2874] = 8'b0000001110;
W[2875] = 8'b0000100101;
W[2876] = 8'b0001011111;
W[2877] = 8'b0001101001;
W[2878] = 8'b1110111001;
W[2879] = 8'b0001001111;
W[2880] = 8'b1111111010;
W[2881] = 8'b0001000011;
W[2882] = 8'b0000110001;
W[2883] = 8'b0000101101;
W[2884] = 8'b1110000110;
W[2885] = 8'b0000011100;
W[2886] = 8'b0001101110;
W[2887] = 8'b0000010110;
W[2888] = 8'b0001000110;
W[2889] = 8'b0000011001;
W[2890] = 8'b1111000011;
W[2891] = 8'b0000001101;
W[2892] = 8'b1111111001;
W[2893] = 8'b0000010111;
W[2894] = 8'b0000000111;
W[2895] = 8'b1110111000;
W[2896] = 8'b1110001010;
W[2897] = 8'b0000110100;
W[2898] = 8'b0001011010;
W[2899] = 8'b1110111111;
W[2900] = 8'b0010110011;
W[2901] = 8'b1111010100;
W[2902] = 8'b1110101000;
W[2903] = 8'b0000000101;
W[2904] = 8'b1111011101;
W[2905] = 8'b0000000000;
W[2906] = 8'b0000000000;
W[2907] = 8'b0000100010;
W[2908] = 8'b1101101011;
W[2909] = 8'b0001001111;
W[2910] = 8'b0000000010;
W[2911] = 8'b0000101111;
W[2912] = 8'b0010110110;
W[2913] = 8'b0000000111;
W[2914] = 8'b1111110110;
W[2915] = 8'b1111001110;
W[2916] = 8'b0000100011;
W[2917] = 8'b0000000111;
W[2918] = 8'b1110011100;
W[2919] = 8'b1111111101;
W[2920] = 8'b1111100011;
W[2921] = 8'b0001000110;
W[2922] = 8'b0001111000;
W[2923] = 8'b0000110010;
W[2924] = 8'b0000101000;
W[2925] = 8'b0000000001;
W[2926] = 8'b1101100110;
W[2927] = 8'b1111101100;
W[2928] = 8'b1111100101;
W[2929] = 8'b1111111110;
W[2930] = 8'b1111101111;
W[2931] = 8'b1111010100;
W[2932] = 8'b1110111110;
W[2933] = 8'b0000000100;
W[2934] = 8'b1110100011;
W[2935] = 8'b0001101101;
W[2936] = 8'b0001010111;
W[2937] = 8'b0010101101;
W[2938] = 8'b1110011011;
W[2939] = 8'b1111001110;
W[2940] = 8'b0000011000;
W[2941] = 8'b0000001001;
W[2942] = 8'b1110001011;
W[2943] = 8'b0000010010;
W[2944] = 8'b1110000000;
W[2945] = 8'b0000011010;
W[2946] = 8'b1011101001;
W[2947] = 8'b0100100001;
W[2948] = 8'b0000010000;
W[2949] = 8'b0001010100;
W[2950] = 8'b0101001011;
W[2951] = 8'b1100000100;
W[2952] = 8'b0001111000;
W[2953] = 8'b1111101011;
W[2954] = 8'b1110010001;
W[2955] = 8'b1110111001;
W[2956] = 8'b0000011001;
W[2957] = 8'b1110000011;
W[2958] = 8'b0000101010;
W[2959] = 8'b1111010011;
W[2960] = 8'b1111101001;
W[2961] = 8'b0000101111;
W[2962] = 8'b0000000011;
W[2963] = 8'b1111010000;
W[2964] = 8'b0001001110;
W[2965] = 8'b0001111100;
W[2966] = 8'b0000100001;
W[2967] = 8'b0000101011;
W[2968] = 8'b0000101000;
W[2969] = 8'b0000101001;
W[2970] = 8'b0010011100;
W[2971] = 8'b0001001000;
W[2972] = 8'b0000101100;
W[2973] = 8'b0001001000;
W[2974] = 8'b1110001100;
W[2975] = 8'b1111011100;
W[2976] = 8'b0001010011;
W[2977] = 8'b0001101100;
W[2978] = 8'b0000111100;
W[2979] = 8'b1111101110;
W[2980] = 8'b1110010100;
W[2981] = 8'b0001001010;
W[2982] = 8'b1111011000;
W[2983] = 8'b0010001111;
W[2984] = 8'b0000010011;
W[2985] = 8'b0001001111;
W[2986] = 8'b1110110001;
W[2987] = 8'b1111000100;
W[2988] = 8'b0001001100;
W[2989] = 8'b0000101110;
W[2990] = 8'b0000111001;
W[2991] = 8'b1111001111;
W[2992] = 8'b1111100101;
W[2993] = 8'b0001011101;
W[2994] = 8'b1011100111;
W[2995] = 8'b0001000010;
W[2996] = 8'b1111101010;
W[2997] = 8'b0000110100;
W[2998] = 8'b0000011010;
W[2999] = 8'b1111100000;
W[3000] = 8'b0000000000;
W[3001] = 8'b1100000000;
W[3002] = 8'b1111100111;
W[3003] = 8'b1111000101;
W[3004] = 8'b1101000110;
W[3005] = 8'b1111000111;
W[3006] = 8'b0001101110;
W[3007] = 8'b1111101011;
W[3008] = 8'b0000011111;
W[3009] = 8'b0001110001;
W[3010] = 8'b1101010100;
W[3011] = 8'b1111011000;
W[3012] = 8'b1111110110;
W[3013] = 8'b0001111001;
W[3014] = 8'b0001010000;
W[3015] = 8'b0000101001;
W[3016] = 8'b1111011110;
W[3017] = 8'b0000100001;
W[3018] = 8'b0001110010;
W[3019] = 8'b0000110110;
W[3020] = 8'b0000011111;
W[3021] = 8'b0001101000;
W[3022] = 8'b1110000101;
W[3023] = 8'b0000110110;
W[3024] = 8'b0000111110;
W[3025] = 8'b0001001111;
W[3026] = 8'b0000111101;
W[3027] = 8'b0000000010;
W[3028] = 8'b1111000001;
W[3029] = 8'b0001000110;
W[3030] = 8'b1111110111;
W[3031] = 8'b0000000110;
W[3032] = 8'b0010101010;
W[3033] = 8'b0001001000;
W[3034] = 8'b1110011000;
W[3035] = 8'b1111000110;
W[3036] = 8'b0000001110;
W[3037] = 8'b0000000001;
W[3038] = 8'b0000000000;
W[3039] = 8'b0000011110;
W[3040] = 8'b1110111011;
W[3041] = 8'b1111111001;
W[3042] = 8'b1111110010;
W[3043] = 8'b0000000000;
W[3044] = 8'b0000000000;
W[3045] = 8'b1110111011;
W[3046] = 8'b1111011010;
W[3047] = 8'b0000110000;
W[3048] = 8'b0001001101;
W[3049] = 8'b0000001111;
W[3050] = 8'b0001011101;
W[3051] = 8'b1110101111;
W[3052] = 8'b1111111110;
W[3053] = 8'b0001001010;
W[3054] = 8'b0001010110;
W[3055] = 8'b1111000110;
W[3056] = 8'b1111100001;
W[3057] = 8'b0000011000;
W[3058] = 8'b1111101000;
W[3059] = 8'b0000111010;
W[3060] = 8'b0000101010;
W[3061] = 8'b0000010110;
W[3062] = 8'b0011000111;
W[3063] = 8'b1111011000;
W[3064] = 8'b0000001001;
W[3065] = 8'b0000100000;
W[3066] = 8'b0001110010;
W[3067] = 8'b1110000101;
W[3068] = 8'b0010000000;
W[3069] = 8'b0000001011;
W[3070] = 8'b1110111010;
W[3071] = 8'b0000101101;
W[3072] = 8'b0000110100;
W[3073] = 8'b1111100000;
W[3074] = 8'b0001100000;
W[3075] = 8'b0010100011;
W[3076] = 8'b0000001011;
W[3077] = 8'b0010101110;
W[3078] = 8'b0000101100;
W[3079] = 8'b1111010001;
W[3080] = 8'b0010000110;
W[3081] = 8'b0001010011;
W[3082] = 8'b1111100001;
W[3083] = 8'b0001100101;
W[3084] = 8'b1110110110;
W[3085] = 8'b1101110110;
W[3086] = 8'b0010000110;
W[3087] = 8'b0001011000;
W[3088] = 8'b1111000101;
W[3089] = 8'b0001011001;
W[3090] = 8'b1111101011;
W[3091] = 8'b1110001110;
W[3092] = 8'b0001000100;
W[3093] = 8'b0000010000;
W[3094] = 8'b0000111011;
W[3095] = 8'b1110110101;
W[3096] = 8'b1110001010;
W[3097] = 8'b1110101110;
W[3098] = 8'b1111111110;
W[3099] = 8'b1111011000;
W[3100] = 8'b0000111101;
W[3101] = 8'b0001001001;
W[3102] = 8'b0000110010;
W[3103] = 8'b1111011111;
W[3104] = 8'b1111110101;
W[3105] = 8'b0000011000;
W[3106] = 8'b1110010100;
W[3107] = 8'b1111111011;
W[3108] = 8'b0001011010;
W[3109] = 8'b0000001010;
W[3110] = 8'b1101101101;
W[3111] = 8'b1101111010;
W[3112] = 8'b1110111000;
W[3113] = 8'b0000111011;
W[3114] = 8'b0000100010;
W[3115] = 8'b1111010100;
W[3116] = 8'b0001010111;
W[3117] = 8'b0001111010;
W[3118] = 8'b1101110100;
W[3119] = 8'b1111001101;
W[3120] = 8'b1111100000;
W[3121] = 8'b1111101000;
W[3122] = 8'b1111011100;
W[3123] = 8'b1110000001;
W[3124] = 8'b1101110011;
W[3125] = 8'b0001110110;
W[3126] = 8'b1110000101;
W[3127] = 8'b0001001010;
W[3128] = 8'b0001011001;
W[3129] = 8'b0010001011;
W[3130] = 8'b1100110001;
W[3131] = 8'b1110111101;
W[3132] = 8'b0000010011;
W[3133] = 8'b1111110101;
W[3134] = 8'b1110110101;
W[3135] = 8'b1111010000;
W[3136] = 8'b1100100011;
W[3137] = 8'b0001101111;
W[3138] = 8'b1110110001;
W[3139] = 8'b0001011110;
W[3140] = 8'b0001000110;
W[3141] = 8'b0001110101;
W[3142] = 8'b1111000001;
W[3143] = 8'b1110101010;
W[3144] = 8'b0000110010;
W[3145] = 8'b1111101110;
W[3146] = 8'b1100110000;
W[3147] = 8'b0000000000;
W[3148] = 8'b1010100101;
W[3149] = 8'b0001010100;
W[3150] = 8'b0001010010;
W[3151] = 8'b1111001100;
W[3152] = 8'b0001100010;
W[3153] = 8'b1111011111;
W[3154] = 8'b1110010110;
W[3155] = 8'b1111011000;
W[3156] = 8'b0001011111;
W[3157] = 8'b0000101111;
W[3158] = 8'b0000001111;
W[3159] = 8'b0000100100;
W[3160] = 8'b0000101101;
W[3161] = 8'b1111111010;
W[3162] = 8'b0001111000;
W[3163] = 8'b1111111011;
W[3164] = 8'b0010000010;
W[3165] = 8'b1111111001;
W[3166] = 8'b1101101011;
W[3167] = 8'b0000001011;
W[3168] = 8'b0000100110;
W[3169] = 8'b0000111101;
W[3170] = 8'b0001010010;
W[3171] = 8'b1111111001;
W[3172] = 8'b1111001110;
W[3173] = 8'b0000101100;
W[3174] = 8'b0000101110;
W[3175] = 8'b0001000000;
W[3176] = 8'b0011101111;
W[3177] = 8'b0000010110;
W[3178] = 8'b1110011000;
W[3179] = 8'b1111001111;
W[3180] = 8'b0000100011;
W[3181] = 8'b0000000111;
W[3182] = 8'b0001101000;
W[3183] = 8'b1111011011;
W[3184] = 8'b1111011100;
W[3185] = 8'b0000101000;
W[3186] = 8'b1111010000;
W[3187] = 8'b0000000101;
W[3188] = 8'b0010010111;
W[3189] = 8'b1110011010;
W[3190] = 8'b0010001000;
W[3191] = 8'b1101110011;
W[3192] = 8'b0001001001;
W[3193] = 8'b0001010101;
W[3194] = 8'b0000111110;
W[3195] = 8'b1110110100;
W[3196] = 8'b0000110001;
W[3197] = 8'b0010110010;
W[3198] = 8'b0000110011;
W[3199] = 8'b0000101010;
W[3200] = 8'b0001111100;
W[3201] = 8'b1111001100;
W[3202] = 8'b1111010111;
W[3203] = 8'b1110011110;
W[3204] = 8'b0000010110;
W[3205] = 8'b0000011101;
W[3206] = 8'b1111111000;
W[3207] = 8'b0000010111;
W[3208] = 8'b0000101010;
W[3209] = 8'b0000010011;
W[3210] = 8'b0001101101;
W[3211] = 8'b1110111001;
W[3212] = 8'b0001011000;
W[3213] = 8'b0000000011;
W[3214] = 8'b1101001001;
W[3215] = 8'b1111011001;
W[3216] = 8'b0000010101;
W[3217] = 8'b1111110010;
W[3218] = 8'b0000101011;
W[3219] = 8'b0001010011;
W[3220] = 8'b0000010000;
W[3221] = 8'b0001000010;
W[3222] = 8'b0000001111;
W[3223] = 8'b0000110010;
W[3224] = 8'b0011000101;
W[3225] = 8'b0000101100;
W[3226] = 8'b1110011100;
W[3227] = 8'b0000111100;
W[3228] = 8'b0000100100;
W[3229] = 8'b1111011010;
W[3230] = 8'b0001000011;
W[3231] = 8'b0000110010;
W[3232] = 8'b1111110001;
W[3233] = 8'b1111111110;
W[3234] = 8'b1110010001;
W[3235] = 8'b0000110010;
W[3236] = 8'b0001001000;
W[3237] = 8'b0000101000;
W[3238] = 8'b0000000011;
W[3239] = 8'b1111001011;
W[3240] = 8'b0000110001;
W[3241] = 8'b0001000100;
W[3242] = 8'b1111101000;
W[3243] = 8'b0000100000;
W[3244] = 8'b1111011011;
W[3245] = 8'b1111111000;
W[3246] = 8'b0000110010;
W[3247] = 8'b0000111011;
W[3248] = 8'b0000110010;
W[3249] = 8'b0010010000;
W[3250] = 8'b0000001111;
W[3251] = 8'b1111110111;
W[3252] = 8'b1111101101;
W[3253] = 8'b0001000100;
W[3254] = 8'b0000101010;
W[3255] = 8'b0001000000;
W[3256] = 8'b1111100001;
W[3257] = 8'b0001001111;
W[3258] = 8'b0001110011;
W[3259] = 8'b0000010101;
W[3260] = 8'b0000111110;
W[3261] = 8'b0000111001;
W[3262] = 8'b1110110111;
W[3263] = 8'b0000100101;
W[3264] = 8'b0010100000;
W[3265] = 8'b0001000001;
W[3266] = 8'b0001010110;
W[3267] = 8'b1111001110;
W[3268] = 8'b0001010110;
W[3269] = 8'b1111101001;
W[3270] = 8'b1111110110;
W[3271] = 8'b0001010010;
W[3272] = 8'b0000101000;
W[3273] = 8'b0000111110;
W[3274] = 8'b1101110101;
W[3275] = 8'b0000001010;
W[3276] = 8'b1111111111;
W[3277] = 8'b1111101001;
W[3278] = 8'b0001000100;
W[3279] = 8'b0001101011;
W[3280] = 8'b0000110001;
W[3281] = 8'b0000010000;
W[3282] = 8'b1111001100;
W[3283] = 8'b0000001010;
W[3284] = 8'b1111100010;
W[3285] = 8'b0000110000;
W[3286] = 8'b1111111101;
W[3287] = 8'b0000110010;
W[3288] = 8'b0000010011;
W[3289] = 8'b1111110000;
W[3290] = 8'b1111010110;
W[3291] = 8'b1111001000;
W[3292] = 8'b1111101000;
W[3293] = 8'b0001001011;
W[3294] = 8'b0010010011;
W[3295] = 8'b0000101011;
W[3296] = 8'b1111100001;
W[3297] = 8'b0001101100;
W[3298] = 8'b1110000000;
W[3299] = 8'b0000011101;
W[3300] = 8'b1111110011;
W[3301] = 8'b0010110111;
W[3302] = 8'b0001010101;
W[3303] = 8'b1111000010;
W[3304] = 8'b1111100000;
W[3305] = 8'b1110010110;
W[3306] = 8'b0000111100;
W[3307] = 8'b0001111010;
W[3308] = 8'b0001001100;
W[3309] = 8'b1111110001;
W[3310] = 8'b1110101110;
W[3311] = 8'b1110101011;
W[3312] = 8'b0000010101;
W[3313] = 8'b0001011010;
W[3314] = 8'b1111000010;
W[3315] = 8'b1111000111;
W[3316] = 8'b1111111111;
W[3317] = 8'b1111001110;
W[3318] = 8'b0000000110;
W[3319] = 8'b0000000000;
W[3320] = 8'b0011001011;
W[3321] = 8'b1111001100;
W[3322] = 8'b1111001000;
W[3323] = 8'b1110001111;
W[3324] = 8'b0000101011;
W[3325] = 8'b0000111111;
W[3326] = 8'b1111110111;
W[3327] = 8'b1111011100;
W[3328] = 8'b1111101011;
W[3329] = 8'b1111111001;
W[3330] = 8'b1111100110;
W[3331] = 8'b1111101010;
W[3332] = 8'b0000101001;
W[3333] = 8'b0000010111;
W[3334] = 8'b1110101110;
W[3335] = 8'b0000010010;
W[3336] = 8'b0000100000;
W[3337] = 8'b0001110011;
W[3338] = 8'b0000000101;
W[3339] = 8'b1111010101;
W[3340] = 8'b1110111000;
W[3341] = 8'b0000101000;
W[3342] = 8'b0000111100;
W[3343] = 8'b0000100001;
W[3344] = 8'b1111111010;
W[3345] = 8'b0001111001;
W[3346] = 8'b1100100000;
W[3347] = 8'b1111010011;
W[3348] = 8'b0001011010;
W[3349] = 8'b0010101001;
W[3350] = 8'b0000110101;
W[3351] = 8'b0000100010;
W[3352] = 8'b1101011111;
W[3353] = 8'b1111011101;
W[3354] = 8'b1111000010;
W[3355] = 8'b0001011001;
W[3356] = 8'b0000100010;
W[3357] = 8'b0001001101;
W[3358] = 8'b1111000110;
W[3359] = 8'b1111010011;
W[3360] = 8'b0001110100;
W[3361] = 8'b0000110000;
W[3362] = 8'b0000011000;
W[3363] = 8'b0001110101;
W[3364] = 8'b1101110110;
W[3365] = 8'b0000011101;
W[3366] = 8'b1110110001;
W[3367] = 8'b0010010001;
W[3368] = 8'b0001000011;
W[3369] = 8'b0001100101;
W[3370] = 8'b0000011111;
W[3371] = 8'b1111101101;
W[3372] = 8'b0001011000;
W[3373] = 8'b1111010011;
W[3374] = 8'b0001010101;
W[3375] = 8'b1110001100;
W[3376] = 8'b1101111100;
W[3377] = 8'b1111101001;
W[3378] = 8'b0000000100;
W[3379] = 8'b0001011000;
W[3380] = 8'b0001101010;
W[3381] = 8'b0000101100;
W[3382] = 8'b0000001011;
W[3383] = 8'b1110110011;
W[3384] = 8'b0000000011;
W[3385] = 8'b0000010001;
W[3386] = 8'b0000100101;
W[3387] = 8'b1111100000;
W[3388] = 8'b1111000001;
W[3389] = 8'b1111100000;
W[3390] = 8'b0001110001;
W[3391] = 8'b0010011100;
W[3392] = 8'b0010010110;
W[3393] = 8'b0010110001;
W[3394] = 8'b1101110101;
W[3395] = 8'b1111011111;
W[3396] = 8'b0001111010;
W[3397] = 8'b0001111101;
W[3398] = 8'b0000000100;
W[3399] = 8'b0000001011;
W[3400] = 8'b1111010000;
W[3401] = 8'b0001000010;
W[3402] = 8'b0000000001;
W[3403] = 8'b0000100011;
W[3404] = 8'b0010000110;
W[3405] = 8'b0000110100;
W[3406] = 8'b1111011001;
W[3407] = 8'b1110011001;
W[3408] = 8'b1111110010;
W[3409] = 8'b0000001011;
W[3410] = 8'b0000001110;
W[3411] = 8'b0000100001;
W[3412] = 8'b1110010011;
W[3413] = 8'b0001100111;
W[3414] = 8'b1111011100;
W[3415] = 8'b1111101010;
W[3416] = 8'b0000011110;
W[3417] = 8'b0001010110;
W[3418] = 8'b1111101100;
W[3419] = 8'b1111001010;
W[3420] = 8'b0001011101;
W[3421] = 8'b0000010111;
W[3422] = 8'b1111111011;
W[3423] = 8'b1111110111;
W[3424] = 8'b1110010000;
W[3425] = 8'b0001010100;
W[3426] = 8'b1101100110;
W[3427] = 8'b0010011010;
W[3428] = 8'b1111100000;
W[3429] = 8'b0001101010;
W[3430] = 8'b1110011000;
W[3431] = 8'b1110111111;
W[3432] = 8'b0010111001;
W[3433] = 8'b0001110001;
W[3434] = 8'b1111010101;
W[3435] = 8'b1110011110;
W[3436] = 8'b1111010010;
W[3437] = 8'b1111011011;
W[3438] = 8'b0010010000;
W[3439] = 8'b1111000100;
W[3440] = 8'b0101011101;
W[3441] = 8'b0010010011;
W[3442] = 8'b1101010100;
W[3443] = 8'b0000110001;
W[3444] = 8'b0000011101;
W[3445] = 8'b1111110111;
W[3446] = 8'b0010101001;
W[3447] = 8'b0001001011;
W[3448] = 8'b1100011010;
W[3449] = 8'b0010001001;
W[3450] = 8'b0000011101;
W[3451] = 8'b1111111111;
W[3452] = 8'b0010011010;
W[3453] = 8'b0001111001;
W[3454] = 8'b1111000111;
W[3455] = 8'b0001000010;
W[3456] = 8'b0000101110;
W[3457] = 8'b1111001000;
W[3458] = 8'b0010100110;
W[3459] = 8'b0001010001;
W[3460] = 8'b0000000100;
W[3461] = 8'b0010101101;
W[3462] = 8'b0000110011;
W[3463] = 8'b1111110000;
W[3464] = 8'b1111110111;
W[3465] = 8'b0010010001;
W[3466] = 8'b1100011100;
W[3467] = 8'b0000011100;
W[3468] = 8'b1110010001;
W[3469] = 8'b1110101000;
W[3470] = 8'b0001111111;
W[3471] = 8'b1111111010;
W[3472] = 8'b1111011111;
W[3473] = 8'b0001001111;
W[3474] = 8'b1110101110;
W[3475] = 8'b0000101011;
W[3476] = 8'b0010011011;
W[3477] = 8'b0101101100;
W[3478] = 8'b1110111001;
W[3479] = 8'b1111111000;
W[3480] = 8'b1111100100;
W[3481] = 8'b1100001101;
W[3482] = 8'b1111100001;
W[3483] = 8'b1111100111;
W[3484] = 8'b1101101101;
W[3485] = 8'b0001010101;
W[3486] = 8'b0000111011;
W[3487] = 8'b0000100001;
W[3488] = 8'b0001111000;
W[3489] = 8'b0000000110;
W[3490] = 8'b1111101100;
W[3491] = 8'b1111111000;
W[3492] = 8'b1111100100;
W[3493] = 8'b0001010011;
W[3494] = 8'b1110111101;
W[3495] = 8'b1111011101;
W[3496] = 8'b1111111001;
W[3497] = 8'b1111010001;
W[3498] = 8'b0000101001;
W[3499] = 8'b0001000101;
W[3500] = 8'b0000000101;
W[3501] = 8'b0001011111;
W[3502] = 8'b1110001001;
W[3503] = 8'b1111010110;
W[3504] = 8'b1110110111;
W[3505] = 8'b0000011010;
W[3506] = 8'b1110010010;
W[3507] = 8'b0000010011;
W[3508] = 8'b1110001100;
W[3509] = 8'b1111011110;
W[3510] = 8'b1110110011;
W[3511] = 8'b0010000101;
W[3512] = 8'b0000111100;
W[3513] = 8'b0001111100;
W[3514] = 8'b1111001101;
W[3515] = 8'b1111001101;
W[3516] = 8'b0001000110;
W[3517] = 8'b1111110010;
W[3518] = 8'b1111000100;
W[3519] = 8'b1111010100;
W[3520] = 8'b1110101100;
W[3521] = 8'b1111001010;
W[3522] = 8'b1111011110;
W[3523] = 8'b0000110100;
W[3524] = 8'b0001100101;
W[3525] = 8'b0000110111;
W[3526] = 8'b0001011100;
W[3527] = 8'b1101111111;
W[3528] = 8'b0000111011;
W[3529] = 8'b1111011010;
W[3530] = 8'b1111010101;
W[3531] = 8'b1111000010;
W[3532] = 8'b0000010010;
W[3533] = 8'b0000011111;
W[3534] = 8'b0000110001;
W[3535] = 8'b0000011110;
W[3536] = 8'b1111110100;
W[3537] = 8'b0001100011;
W[3538] = 8'b1110111000;
W[3539] = 8'b1111000010;
W[3540] = 8'b0001110101;
W[3541] = 8'b0001110100;
W[3542] = 8'b0000100000;
W[3543] = 8'b0000110001;
W[3544] = 8'b1110011100;
W[3545] = 8'b1111110101;
W[3546] = 8'b0001100010;
W[3547] = 8'b0000011101;
W[3548] = 8'b0001000100;
W[3549] = 8'b0000111110;
W[3550] = 8'b1111000101;
W[3551] = 8'b1111010011;
W[3552] = 8'b0000011010;
W[3553] = 8'b0000111011;
W[3554] = 8'b0000111000;
W[3555] = 8'b1111011010;
W[3556] = 8'b1111010101;
W[3557] = 8'b0001100111;
W[3558] = 8'b1111100111;
W[3559] = 8'b0001010101;
W[3560] = 8'b0001010101;
W[3561] = 8'b0000110111;
W[3562] = 8'b1110010100;
W[3563] = 8'b1111010101;
W[3564] = 8'b0000011011;
W[3565] = 8'b1111110001;
W[3566] = 8'b0001010011;
W[3567] = 8'b0000000011;
W[3568] = 8'b1111001011;
W[3569] = 8'b0000001010;
W[3570] = 8'b1110010100;
W[3571] = 8'b0001101111;
W[3572] = 8'b0000000000;
W[3573] = 8'b0001010111;
W[3574] = 8'b1111100111;
W[3575] = 8'b1101111000;
W[3576] = 8'b0000000001;
W[3577] = 8'b0001010100;
W[3578] = 8'b0000000011;
W[3579] = 8'b1110000011;
W[3580] = 8'b1111001111;
W[3581] = 8'b0000000111;
W[3582] = 8'b0000101011;
W[3583] = 8'b0000001000;
W[3584] = 8'b0010011011;
W[3585] = 8'b1111110110;
W[3586] = 8'b1111110101;
W[3587] = 8'b1101101110;
W[3588] = 8'b0001001011;
W[3589] = 8'b0000010110;
W[3590] = 8'b0000100110;
W[3591] = 8'b0000000010;
W[3592] = 8'b1110000110;
W[3593] = 8'b0001110101;
W[3594] = 8'b0001010111;
W[3595] = 8'b0001010011;
W[3596] = 8'b0000100011;
W[3597] = 8'b0001100111;
W[3598] = 8'b1101101000;
W[3599] = 8'b1111011011;
W[3600] = 8'b0001100000;
W[3601] = 8'b0010010011;
W[3602] = 8'b0000011010;
W[3603] = 8'b0000010001;
W[3604] = 8'b1111110010;
W[3605] = 8'b0000110110;
W[3606] = 8'b1111110001;
W[3607] = 8'b0001000101;
W[3608] = 8'b0000011000;
W[3609] = 8'b0001000001;
W[3610] = 8'b1110010101;
W[3611] = 8'b0000000010;
W[3612] = 8'b0001011010;
W[3613] = 8'b0000000000;
W[3614] = 8'b0000110010;
W[3615] = 8'b0000000100;
W[3616] = 8'b1110111001;
W[3617] = 8'b1111000111;
W[3618] = 8'b1110100010;
W[3619] = 8'b0000100010;
W[3620] = 8'b0001110110;
W[3621] = 8'b1111101101;
W[3622] = 8'b1111000011;
W[3623] = 8'b1111011011;
W[3624] = 8'b1111001111;
W[3625] = 8'b1110010011;
W[3626] = 8'b1111010100;
W[3627] = 8'b0000010100;
W[3628] = 8'b1111011110;
W[3629] = 8'b0000000001;
W[3630] = 8'b0000110000;
W[3631] = 8'b0000000110;
W[3632] = 8'b0000100001;
W[3633] = 8'b0000010101;
W[3634] = 8'b1111110011;
W[3635] = 8'b0000001111;
W[3636] = 8'b0001001011;
W[3637] = 8'b0000111100;
W[3638] = 8'b0000101101;
W[3639] = 8'b0000110001;
W[3640] = 8'b0000010001;
W[3641] = 8'b0000110101;
W[3642] = 8'b0010111110;
W[3643] = 8'b1111011000;
W[3644] = 8'b0000111100;
W[3645] = 8'b0000010010;
W[3646] = 8'b1110101101;
W[3647] = 8'b0001100110;
W[3648] = 8'b0000000100;
W[3649] = 8'b1111101001;
W[3650] = 8'b0000110110;
W[3651] = 8'b0001100010;
W[3652] = 8'b0000000100;
W[3653] = 8'b0000110110;
W[3654] = 8'b0000101011;
W[3655] = 8'b1110111011;
W[3656] = 8'b0010000001;
W[3657] = 8'b1111111110;
W[3658] = 8'b1110001011;
W[3659] = 8'b0001111101;
W[3660] = 8'b1111011110;
W[3661] = 8'b1101111010;
W[3662] = 8'b0000111111;
W[3663] = 8'b0000110101;
W[3664] = 8'b0000000101;
W[3665] = 8'b0001001010;
W[3666] = 8'b1111101101;
W[3667] = 8'b1110011111;
W[3668] = 8'b0001111111;
W[3669] = 8'b0000111001;
W[3670] = 8'b0000001011;
W[3671] = 8'b1111010111;
W[3672] = 8'b1111100110;
W[3673] = 8'b0000001110;
W[3674] = 8'b0001010001;
W[3675] = 8'b1110101101;
W[3676] = 8'b1111011000;
W[3677] = 8'b0001110100;
W[3678] = 8'b0000100100;
W[3679] = 8'b1111100011;
W[3680] = 8'b0010110010;
W[3681] = 8'b0000110100;
W[3682] = 8'b1111010110;
W[3683] = 8'b0000000001;
W[3684] = 8'b1111010110;
W[3685] = 8'b1111011100;
W[3686] = 8'b1110100000;
W[3687] = 8'b1111100100;
W[3688] = 8'b1110001010;
W[3689] = 8'b0000111111;
W[3690] = 8'b0001101110;
W[3691] = 8'b0000101100;
W[3692] = 8'b0001000011;
W[3693] = 8'b0001110010;
W[3694] = 8'b1110100101;
W[3695] = 8'b1111000011;
W[3696] = 8'b0000101111;
W[3697] = 8'b0001010100;
W[3698] = 8'b0000010001;
W[3699] = 8'b1110110110;
W[3700] = 8'b1111101111;
W[3701] = 8'b0000000000;
W[3702] = 8'b1110110101;
W[3703] = 8'b0000101100;
W[3704] = 8'b0000101101;
W[3705] = 8'b0000000000;
W[3706] = 8'b1110001100;
W[3707] = 8'b1111001100;
W[3708] = 8'b0001010001;
W[3709] = 8'b0001010010;
W[3710] = 8'b0000110001;
W[3711] = 8'b1111010111;
W[3712] = 8'b0000011101;
W[3713] = 8'b1111100101;
W[3714] = 8'b0000001000;
W[3715] = 8'b1111100100;
W[3716] = 8'b0001101100;
W[3717] = 8'b0000110100;
W[3718] = 8'b1111011111;
W[3719] = 8'b1111110001;
W[3720] = 8'b0001000011;
W[3721] = 8'b0000000000;
W[3722] = 8'b1111111111;
W[3723] = 8'b1110101010;
W[3724] = 8'b1111001011;
W[3725] = 8'b0001000000;
W[3726] = 8'b0001000101;
W[3727] = 8'b1111110010;
W[3728] = 8'b0000011101;
W[3729] = 8'b0000011110;
W[3730] = 8'b1110110010;
W[3731] = 8'b1111101100;
W[3732] = 8'b0000100000;
W[3733] = 8'b0001101001;
W[3734] = 8'b0000110111;
W[3735] = 8'b0000101100;
W[3736] = 8'b1111100110;
W[3737] = 8'b0000000000;
W[3738] = 8'b0000000110;
W[3739] = 8'b0001110000;
W[3740] = 8'b0000110001;
W[3741] = 8'b0001000100;
W[3742] = 8'b1110010001;
W[3743] = 8'b1110111001;
W[3744] = 8'b0000001000;
W[3745] = 8'b0000001010;
W[3746] = 8'b0000001001;
W[3747] = 8'b1111100011;
W[3748] = 8'b1111100100;
W[3749] = 8'b0000010111;
W[3750] = 8'b1111111101;
W[3751] = 8'b0001001011;
W[3752] = 8'b0001001101;
W[3753] = 8'b0001000010;
W[3754] = 8'b0000001000;
W[3755] = 8'b1110011001;
W[3756] = 8'b0000100100;
W[3757] = 8'b0000111110;
W[3758] = 8'b1111101010;
W[3759] = 8'b1110010110;
W[3760] = 8'b0000000000;
W[3761] = 8'b0000010100;
W[3762] = 8'b1111101010;
W[3763] = 8'b0001100101;
W[3764] = 8'b0000111110;
W[3765] = 8'b1111101010;
W[3766] = 8'b1110101011;
W[3767] = 8'b1110100011;
W[3768] = 8'b0001001101;
W[3769] = 8'b0001111101;
W[3770] = 8'b1111111110;
W[3771] = 8'b1111010011;
W[3772] = 8'b1111101000;
W[3773] = 8'b0001100010;
W[3774] = 8'b0010010111;
W[3775] = 8'b0000011011;
W[3776] = 8'b0000110000;
W[3777] = 8'b0010110000;
W[3778] = 8'b1110101111;
W[3779] = 8'b1110100010;
W[3780] = 8'b1111111111;
W[3781] = 8'b0001110110;
W[3782] = 8'b0000010000;
W[3783] = 8'b0000111111;
W[3784] = 8'b1110111101;
W[3785] = 8'b0000100111;
W[3786] = 8'b0000111110;
W[3787] = 8'b0001111100;
W[3788] = 8'b0001101101;
W[3789] = 8'b0001001000;
W[3790] = 8'b1110100110;
W[3791] = 8'b1110100110;
W[3792] = 8'b0001001011;
W[3793] = 8'b0000111100;
W[3794] = 8'b0000011001;
W[3795] = 8'b0001101110;
W[3796] = 8'b1111011001;
W[3797] = 8'b1111100111;
W[3798] = 8'b1111111110;
W[3799] = 8'b0010011100;
W[3800] = 8'b0000011011;
W[3801] = 8'b0001011011;
W[3802] = 8'b1110001110;
W[3803] = 8'b1111011011;
W[3804] = 8'b0010000010;
W[3805] = 8'b0000011100;
W[3806] = 8'b1111111101;
W[3807] = 8'b1110111100;
W[3808] = 8'b1110111100;
W[3809] = 8'b1111011011;
W[3810] = 8'b1111101010;
W[3811] = 8'b0010001011;
W[3812] = 8'b0000111010;
W[3813] = 8'b0001001011;
W[3814] = 8'b1100111010;
W[3815] = 8'b1111111001;
W[3816] = 8'b0000110011;
W[3817] = 8'b0000101111;
W[3818] = 8'b1110110000;
W[3819] = 8'b0000100001;
W[3820] = 8'b1111010100;
W[3821] = 8'b1110111101;
W[3822] = 8'b0001100010;
W[3823] = 8'b1111111101;
W[3824] = 8'b0001110111;
W[3825] = 8'b0011000000;
W[3826] = 8'b1101111001;
W[3827] = 8'b0000100001;
W[3828] = 8'b0001000001;
W[3829] = 8'b1111111001;
W[3830] = 8'b0000111110;
W[3831] = 8'b0010110111;
W[3832] = 8'b1110100011;
W[3833] = 8'b0001101100;
W[3834] = 8'b0000011100;
W[3835] = 8'b1111110100;
W[3836] = 8'b0001111001;
W[3837] = 8'b0011010100;
W[3838] = 8'b1111000101;
W[3839] = 8'b0001001011;
W[3840] = 8'b0000011010;
W[3841] = 8'b1111011110;
W[3842] = 8'b0001110100;
W[3843] = 8'b0000010001;
W[3844] = 8'b1110110000;
W[3845] = 8'b0000001101;
W[3846] = 8'b0000010101;
W[3847] = 8'b0000110100;
W[3848] = 8'b0001101001;
W[3849] = 8'b0011110010;
W[3850] = 8'b1110001100;
W[3851] = 8'b0000100111;
W[3852] = 8'b0000001001;
W[3853] = 8'b1110001000;
W[3854] = 8'b0000110001;
W[3855] = 8'b0000000110;
W[3856] = 8'b1111010011;
W[3857] = 8'b0000011111;
W[3858] = 8'b0000010110;
W[3859] = 8'b1110010110;
W[3860] = 8'b0100101100;
W[3861] = 8'b0000100111;
W[3862] = 8'b1111001101;
W[3863] = 8'b0000000010;
W[3864] = 8'b0000101000;
W[3865] = 8'b1010111001;
W[3866] = 8'b0001010101;
W[3867] = 8'b0001000110;
W[3868] = 8'b1111110001;
W[3869] = 8'b0011000011;
end

integer i, j, m, n;
initial
// Initialize pooling layers P1 and P2
for(i=0; i<=S_P1*S_P1-1; i=i+1)
   for(j=0; j<=N_f1-1; j=j+1)
      P1[i][j]=0;

initial
for(m=0; m<=S_P2*S_P2-1; m=m+1)
   for(n=0; n<=N_f2-1; n=n+1)
      P2[m][n]=0;

// Layer Control Block
always@(posedge clk)
// Reset control signal for convolution layers
if(rst || (C_finish && C_c<2))
   rstc<=1;
else
   rstc<=0;

always@(posedge clk)
// Reset control signal for fully connected layers
if(C_finish && C_c==3)
   rstf<=1; 
else if(FCi==0)
   rstf<=0;

always@(posedge clk)
// Update layer counter
if(rst)
   C_c<=0;
else if(!rstc && C_finish && C_c<=3)
   C_c<=C_c+1;

// Conv3D: Assigning Weights and Inputs & Calling Conv3D Module
// Address Generation Block
always@(posedge clk) 
   Wi <= (C_c >= 1) * N_ch1 * S_f1 * S_f1 * N_f1 +
         (C_c >= 2) * N_ch2 * S_f2 * S_f2 * N_f2 / 2 +
         (C_c >= 3) * N_ch2 * S_f2 * S_f2 * N_f2 / 2;

wire [M-1:0]SP0, SP1, SP2, SP3, SP4;
// Select input data for convolution layers based on pooling layer 1 values
assign SP0 = (P1[Ai0 % (S_in2 * S_in2)][Fi][M-1]) ?
             {10'b1111111111, P1[Ai0 % (S_in2 * S_in2)][Fi][M-1:10]} :
             {10'b0000000000, P1[Ai0 % (S_in2 * S_in2)][Fi][M-1:10]};
assign SP1 = (P1[Ai1 % (S_in2 * S_in2)][Fi][M-1]) ?
             {10'b1111111111, P1[Ai1 % (S_in2 * S_in2)][Fi][M-1:10]} :
             {10'b0000000000, P1[Ai1 % (S_in2 * S_in2)][Fi][M-1:10]};
assign SP2 = (P1[Ai2 % (S_in2 * S_in2)][Fi][M-1]) ?
             {10'b1111111111, P1[Ai2 % (S_in2 * S_in2)][Fi][M-1:10]} :
             {10'b0000000000, P1[Ai2 % (S_in2 * S_in2)][Fi][M-1:10]};
assign SP3 = (P1[Ai3 % (S_in2 * S_in2)][Fi][M-1]) ?
             {10'b1111111111, P1[Ai3 % (S_in2 * S_in2)][Fi][M-1:10]} :
             {10'b0000000000, P1[Ai3 % (S_in2 * S_in2)][Fi][M-1:10]};
assign SP4 = (P1[Ai4 % (S_in2 * S_in2)][Fi][M-1]) ?
             {10'b1111111111, P1[Ai4 % (S_in2 * S_in2)][Fi][M-1:10]} :
             {10'b0000000000, P1[Ai4 % (S_in2 * S_in2)][Fi][M-1:10]};

// Assigning Weights & Inputs
assign I10 = (C_c == 0) ? I[Ai0] : SP0,
       I11 = (C_c == 0) ? I[Ai1] : SP1,
       I12 = (C_c == 0) ? I[Ai2] : SP2,
       I13 = (C_c == 0) ? I[Ai3] : SP3,
       I14 = (C_c == 0) ? I[Ai4] : SP4;

// Assign weights for convolution
assign W10 = W[Aw0 + Wi], W11 = W[Aw1 + Wi], W12 = W[Aw2 + Wi], W13 = W[Aw3 + Wi], W14 = W[Aw4 + Wi],
       W20 = W[Aw5 + Wi], W21 = W[Aw6 + Wi], W22 = W[Aw7 + Wi], W23 = W[Aw8 + Wi], W24 = W[Aw9 + Wi],
       W30 = W[Aw10 + Wi], W31 = W[Aw11 + Wi], W32 = W[Aw12 + Wi], W33 = W[Aw13 + Wi], W34 = W[Aw14 + Wi],
       W40 = W[Aw15 + Wi], W41 = W[Aw16 + Wi], W42 = W[Aw17 + Wi], W43 = W[Aw18 + Wi], W44 = W[Aw19 + Wi],
       W50 = W[Aw20 + Wi], W51 = W[Aw21 + Wi], W52 = W[Aw22 + Wi], W53 = W[Aw23 + Wi], W54 = W[Aw24 + Wi],
       W60 = W[Aw25 + Wi], W61 = W[Aw26 + Wi], W62 = W[Aw27 + Wi], W63 = W[Aw28 + Wi], W64 = W[Aw29 + Wi];

// Update S_in, N_ch, S_P, and S_C based on the control signal C_c
always@(posedge clk) 
   S_in <= (C_c == 0) ? S_in1 : S_in2;
always@(posedge clk) 
   N_ch <= (C_c == 0) ? N_ch1 : N_ch2;
always@(posedge clk) 
   S_P <= (C_c == 0) ? S_P1 : S_P2;
always@(posedge clk) 
   S_C <= (C_c == 0) ? S_C1 : S_C2;

// Instantiate Conv3D module and pass the required inputs and outputs
Conv3D #(M, N, Ma, S_f1, N_f1) conv(
   clk, rstc,
   a, S_in, N_ch,
   I10, I11, I12, I13, I14,
   W10, W11, W12, W13, W14,
   W20, W21, W22, W23, W24,
   W30, W31, W32, W33, W34,
   W40, W41, W42, W43, W44,
   W50, W51, W52, W53, W54,
   W60, W61, W62, W63, W64,
   Ai0, Ai1, Ai2, Ai3, Ai4,
   Aw0, Aw1, Aw2, Aw3, Aw4,
   Aw5, Aw6, Aw7, Aw8, Aw9,
   Aw10, Aw11, Aw12, Aw13,
   Aw14, Aw15, Aw16, Aw17,
   Aw18, Aw19, Aw20, Aw21,
   Aw22, Aw23, Aw24, Aw25,
   Aw26, Aw27, Aw28, Aw29,
   Po1, Po2, Po3, Po4, Po5, Po6,
   A, Fri, Fi, rstp, C_finish
);

// Output Accumulation Block
assign a = (A1 & A2 & A3 & A4 & A5 & A6) == S_P * S_P;

// Update A11 to A15 based on rstp signal
always@(posedge clk)
if(rstp)
begin 
   A11 <= 0;
   A12 <= 0;
   A13 <= 0;
   A14 <= 0;
   A15 <= 0;
end 
else 
begin 
   A11 <= A;
   A12 <= A11;
   A13 <= A12;
   A14 <= A13;
   A15 <= A14; 
end

// Update A1, CA, and ori based on A, A1, and C_c conditions
always@(posedge clk)
if(A > S_in * (S_in * Fi + Fri) + (S_f1 - 1) && A1 < S_P * S_P)
begin 
   CA <= CA + 1;
   if((CA + 1) % (2 * S_C) == 0)
      ori <= ori + 1;
   if(CA % 2 == 0)
      A1 <= A1;
   else if(CA - S_C + 1 == 2 * S_C * ori) 
      A1 <= S_P * ori;
   else 
      A1 <= A1 + 1;
   if(C_c == 0)
      P1[A1][0] <= P1[A1][0] + Po1;
   else if (C_c == 1)
      P2[A1][0] <= P2[A1][0] + Po1;
   else if(C_c == 2)
      P2[A1][6] <= P2[A1][6] + Po1;
end
else if(rstp)
begin 
   ori <= 0;
   CA <= 0;
   A1 <= 0;
end

// Update A2 based on A11, A2, and C_c conditions
always@(posedge clk)
if(A11 > S_in * (S_in * Fi + Fri) + (S_f1 - 1) && A2 < S_P * S_P)
begin 
   A2 <= A1;
   if(C_c == 0)
      P1[A2][1] <= P1[A2][1] + Po2;
   else if (C_c == 1)
      P2[A2][1] <= P2[A2][1] + Po2;
   else if(C_c == 2)
      P2[A2][7] <= P2[A2][7] + Po2;
end 
else if(rstp)
   A2 <= 0;

// Update A3 based on A12, A3, and C_c conditions
always@(posedge clk)
if(A12 > S_in * (S_in * Fi + Fri) + (S_f1 - 1) && A3 < S_P * S_P)
begin 
   A3 <= A2;
   if(C_c == 0)
      P1[A3][2] <= P1[A3][2] + Po3;
   else if (C_c == 1)
      P2[A3][2] <= P2[A3][2] + Po3;
   else if(C_c == 2)
      P2[A3][8] <= P2[A3][8] + Po3;
end 
else if(rstp)
   A3 <= 0;

// Update A4 based on A13, A4, and C_c conditions
always@(posedge clk)
if(A13 > S_in * (S_in * Fi + Fri) + (S_f1 - 1) && A4 < S_P * S_P)
begin 
   A4 <= A3;
   if(C_c == 0)
      P1[A4][3] <= P1[A4][3] + Po4;
   else if (C_c == 1)
      P2[A4][3] <= P2[A4][3] + Po4;
   else if(C_c == 2)
      P2[A4][9] <= P2[A4][9] + Po4;
end
else if(rstp)
   A4 <= 0;

// Update A5 based on A14, A5, and C_c conditions
always@(posedge clk)
if(A14 > S_in * (S_in * Fi + Fri) + (S_f1 - 1) && A5 < S_P * S_P)
begin
   A5 <= A4;
   if(C_c == 0)
      P1[A5][4] <= P1[A5][4] + Po5;
   else if (C_c == 1)
      P2[A5][4] <= P2[A5][4] + Po5;
   else if(C_c == 2)
      P2[A5][10] <= P2[A5][10] + Po5;
end 
else if(rstp)
   A5 <= 0;

// Update A6 based on A15, A6, and C_c conditions
always@(posedge clk)
if(A15 > S_in * (S_in * Fi + Fri) + (S_f1 - 1) && A6 < S_P * S_P)
begin
   A6 <= A5;
   if(C_c == 0)
      P1[A6][5] <= P1[A6][5] + Po6;
   else if (C_c == 1)
      P2[A6][5] <= P2[A6][5] + Po6;
   else if(C_c == 2)
      P2[A6][11] <= P2[A6][11] + Po6;
end 
else if(rstp)
   A6 <= 0;

// Assigning Weights and Inputs & Calling Fully Connected Module
assign Wfi = Poolif * S_P2 + (FCi % S_P2);
always@(posedge clk)
if(rstf)
   Poolif <= 0;
else if(FCi % S_P2 == S_P2 - 1 && FcFi == N_f2 - 1 && Poolif < S_P2 - 1) 
   Poolif <= Poolif + 1;
assign Ii = (P2[Wfi][FcFi][M-1]) ? {10'b1111111111, P2[Wfi][FcFi][M-1:10]} :
                                   {10'b0000000000, P2[Wfi][FcFi][M-1:10]};
assign Wf = FCi * N_f2 + FcFi + Wi;
// Assign weights W0 to W9 based on the weight index calculations
assign W0 = W[0 * S_fc + Wf],
       W1 = W[1 * S_fc + Wf],
       W2 = W[2 * S_fc + Wf],
       W3 = W[3 * S_fc + Wf],
       W4 = W[4 * S_fc + Wf],
       W5 = W[5 * S_fc + Wf],
       W6 = W[6 * S_fc + Wf],
       W7 = W[7 * S_fc + Wf],
       W8 = W[8 * S_fc + Wf],
       W9 = W[9 * S_fc + Wf];

// Instantiate the Fully Connected (FC) module with the assigned weights and inputs
FC#(M, N, Ma, N_f2, C, S_P2) uut(
   clk, rstf,
   W0, W1, W2, W3, W4, W5, W6, W7, W8, W9, // Weight inputs
   Ii, FCi, FcFi, // Input data and control signals
   O0, O1, O2, O3, O4, O5, O6, O7, O8, O9, // Output data
   LeNet_Out, FC_finish // Output control signals
);

endmodule

