#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>

typedef struct {
	unsigned char red, green, blue;
} vga_ball_color_t;

typedef struct {
	unsigned short ball_x;
  unsigned short ball_y;
  unsigned short paddle;
} vga_positions_t;

typedef struct {
	unsigned short lives;
  unsigned short audio;
  unsigned short score;
} vga_gameinfo_t;

typedef uint32_t vga_blocks_t;

typedef struct {
  int lives;
  int score;
  int ball_x;
  int ball_y;
  int ball_v;
  int last_ball_v;
  int paddle_x;
  int paddle_v;
  unsigned char ball_U;
  uint32_t blocks;
} game_info_t;
  

typedef struct {
  vga_ball_color_t background;
  vga_positions_t position;
  vga_blocks_t blocks;
  vga_gameinfo_t gameinfo;
} vga_ball_arg_t;

#define VGA_BALL_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_BALL_WRITE_BACKGROUND   _IOW(VGA_BALL_MAGIC, 1, vga_ball_arg_t *)
#define VGA_BALL_READ_BACKGROUND    _IOR(VGA_BALL_MAGIC, 2, vga_ball_arg_t *)
#define VGA_BALL_WRITE_POSITION     _IOW(VGA_BALL_MAGIC, 3, vga_ball_arg_t *)
#define VGA_BALL_READ_POSITION      _IOR(VGA_BALL_MAGIC, 4, vga_ball_arg_t *)
#define VGA_BLOCKS_WRITE_POSITION   _IOW(VGA_BALL_MAGIC, 5, vga_ball_arg_t *)
#define VGA_BLOCKS_READ_POSITION    _IOR(VGA_BALL_MAGIC, 6, vga_ball_arg_t *)
#define VGA_BALL_WRITE_INFO         _IOW(VGA_BALL_MAGIC, 7, vga_ball_arg_t *)
#define VGA_BALL_READ_INFO          _IOR(VGA_BALL_MAGIC, 8, vga_ball_arg_t *)

#endif
