#ifndef _USBCONTROLLER_H
#define _USBCONTROLLER_H

#include <libusb-1.0/libusb.h>

#define USB_VOLUME_CONTROL_PROTOCOL 0

/* Modifier bits */
#define USB_LEFT 	234
#define USB_RIGHT 	233

struct usb_controller_packet
{
    uint8_t reserved;
    uint8_t direction;
};

/* Find and open the controller.  Argument should point to
   space to store an endpoint address.  Returns NULL if no controller
   device was found. */
extern struct libusb_device_handle *open_controller(uint8_t *);

#endif

