#ifndef VOCODER_H
#define VOCODER_H

#include <stdint.h>
#include "operations.h"

#define FRAME_SIZE 1024
#define HOP_SIZE 32
#define FFT_SIZE_IN_BITS 10
#define PI 3.14159265358979323846

int16_t wrap(int16_t x); 
void encode(complex_fixed *complex_data, int framesize, int hopsize, int samplerate, complex_fixed *encoded_data);
void decode(complex_fixed *data, int framesize, int hopsize, int samplerate, complex_fixed *decoded_data);

#endif