#ifndef STFT_H
#define STFT_H

#include <stdint.h>
#include "operations.h"

#define N_WAVE      1024    /* full length of Sinewave[] */
#define LOG2_N_WAVE 10      /* log2(N_WAVE) */
#define FRAME_SIZE 1024
#define HOP_SIZE 32
#define FFT_SIZE_IN_BITS 10

int16_t** sliding_window(int16_t* x, int num_samples, int framesize, int hopsize);
void apply_hann_window_forward(int16_t *input);
void apply_hann_window_reverse(int16_t *input);
void rfft_fixed(complex_fixed *x, int N, int inverse);

#endif