#ifndef OPERATIONS_H
#define OPERATIONS_H

#include <stdint.h>

#define FRACTION_BITS 16

typedef int16_t fixed_point;
typedef struct {
    fixed_point real;
    fixed_point imag;
} complex_fixed;

// FIXED POINT OPERATIONS
fixed_point float_to_fixed(float x);
float fixed_to_float(fixed_point x);
fixed_point fixed_add(fixed_point x, fixed_point y);
fixed_point fixed_subtract(fixed_point x, fixed_point y);
fixed_point fixed_multiply(fixed_point x, fixed_point y);
fixed_point fixed_divide(fixed_point x, fixed_point y);

//COMPLEX FIXED POINT OPERATIONS
complex_fixed complex_float_to_fixed(float real, float imag);
complex_fixed complex_fixed_add(complex_fixed x, complex_fixed y);
complex_fixed complex_fixed_subtract(complex_fixed x, complex_fixed y);
complex_fixed complex_fixed_multiply(complex_fixed x, complex_fixed y);
complex_fixed complex_fixed_divide(complex_fixed x, complex_fixed y);

#endif