module CLOCK (
    CLOCK,
    CLOCK_500,
    DATA,
    END,
    RESET,
    GO,
    CLOCK_2
);

    input         CLOCK;
    input         END;
    input         RESET;
    
    output        CLOCK_500;
    output  [23:0] DATA;
    output        GO;
    output        CLOCK_2;

    reg   [10:0]  COUNTER_500;
    reg   [15:0]  ROM[7:0];
    reg   [15:0]  DATA_A;
    reg   [5:0]   address;

    wire  CLOCK_500 = COUNTER_500[9];
    wire  CLOCK_2 = COUNTER_500[1];
    wire  [23:0]  DATA = {8'h34, DATA_A};
    wire  GO = ((address <= 8'd8) && (END == 1)) ? COUNTER_500[10] : 1;

    always @(negedge RESET or posedge END) begin
        if (!RESET) begin
            address = 6'd0;
        end else if (address <= 6'd8) begin
            address = address + 1;
        end
    end

    reg [4:0] vol;
    wire [6:0] volume;
    always @(posedge RESET) begin
        vol = vol - 1;
    end
    assign volume = vol + 97;

    always @(posedge END) begin
        ROM[0] = 16'h0c00;                   
        ROM[1] = 16'h0ec2;                   
        ROM[2] = 16'h0838;                   
    
        ROM[3] = 16'h1000;                    
    
        ROM[4] = 16'h0017;                 
        ROM[5] = 16'h0217;                 
        ROM[6] = {8'h04, 1'b0, volume[6:0]}; 
        ROM[7] = {8'h06, 1'b0, volume[6:0]}; 

        ROM[8'd8] = 16'h1201;              
        DATA_A = ROM[address];
    end

    always @(posedge CLOCK) begin
        COUNTER_500 = COUNTER_500 + 1;
    end

endmodule