import System.Exit ( die )
import System.Environment
import Data.List
import Data.Ord (comparing)
import Control.Parallel.Strategies
import Data.Time.Clock
import Control.Parallel
import Control.Exception
import Control.DeepSeq
import System.Random

{-

 Name: Gregory Fu
 Uni: gf2426

 Collaborators:

 References:
 -}

type Board = [[Char]]

data Player = AI | Human
    deriving (Eq)

main :: IO ()
main = do 
   args <- getArgs
   input <- parseInput args
   case input of
      1 -> play initBoard Human 0 [] 0
      2 -> play initBoard Human 1 [] 0
      3 -> play initBoard Human 2 [] 100
      4 -> play initBoard Human 3 [] 100
      _ -> do 
         die $ "Invalid input"

parseInput :: [String] -> IO Int
parseInput args
    | head args == "sequential" = return 1
    | head args == "parallel" = return 2
    | head args == "sequential2" = return 3
    | head args == "parallel2" = return 4
    | otherwise = return 5

initBoard :: Board
initBoard = replicate 6 $ replicate 7 '.'

play :: Board -> Player -> Int -> [NominalDiffTime] -> Int -> IO ()
play board player mode times iters
    | boardStatus > 0 = terminateGame board boardStatus (average times) iters mode
    | boardStatus == -1 = terminateGame board boardStatus (average times) iters mode
    | player == Human = do
        putStrLn "Your turn, input the column number 1 through 7 (inclusive)"
        col <- getMove board mode
        let row = getRowNum ((generateVerticalLists board) !! col) 0
        if row == -1 || row > 5 then do
            putStrLn "Column already full, choose another column"
            play board player mode times iters
        else do
            let next = calculateBoard board row col Human
            play next AI mode times iters
    | otherwise = do
        putStrLn "AI's turn"
        let moves = [0..6] \\ (getValidCols (last board) 0)
        t1 <- getCurrentTime
        col <- calculateMove board mode
        t2 <- getCurrentTime
        let diff = diffUTCTime t2 t1
        let newTimes = times ++ [diff]
        putStrLn $ "Execution Time: " ++ (show diff)
        -- let v = generateVerticalLists board
        -- let d = generateDiagonalLists board
        -- putStrLn $ "v: \n" ++ (show v)
        -- putStrLn $ "d: \n" ++ (show d)
        -- putStrLn ("Par scores: " ++ show pscores)
        let row = getRowNum ((generateVerticalLists board) !! col) 0
        let next = calculateBoard board row col AI
        play next Human mode newTimes iters
    where
        boardStatus = checkBoard board

average :: [NominalDiffTime] -> NominalDiffTime
average xs = sum xs / genericLength xs

terminateGame :: Board -> Int -> NominalDiffTime -> Int -> Int -> IO ()
terminateGame board status avg iters mode = do
    appendFile "out.csv" (show avg ++ ", " ++ show status ++ "\n")
    putStrLn $ showBoard $ (reverseBoard board)
    putStrLn ("Average execution time: " ++ show avg)
    if iters > 0 then do
        play initBoard Human mode [] (iters - 1)
        return ()
    else do
        if status == -1 then do
            putStrLn "The game ended in a tie. No one is happy"
        else do
            if status `mod` 2 == 1 then do
                putStrLn "Congrats! You beat the AI"
            else do
                putStrLn "Awe shucks! You lost to the AI"

calculateMove :: Board -> Int -> IO Int
calculateMove board mode = do
    if mode `mod` 2 == 0 then do
        let (move, val) = minimaxSeq board AI 6
        putStrLn ("AI's move: " ++ show move) 
        return move
     else do
        let (move, val) = minimaxPar board AI 6
        putStrLn ("AI's move: " ++ show move) 
        return move

minimaxSeq :: Board -> Player -> Int -> (Int, Int) --move, score
minimaxSeq board player depth
    | boardStatus /= 0  || depth <= 0 = (-1, computeTerminal boardStatus board)
    | otherwise =
        let moves = [0..6] \\ (getValidCols (last board) 0)
        in case moves of 
            [] -> (computeTerminal boardStatus board, -1)
            _ -> 
                let evals = evaluateImmediate nodes player (-1)
                in case (fst evals < 0) of
                    True -> (findBest (evaluateChildStatesSeq nodes player depth) player)
                    _ -> 
                        (snd evals, computeTerminal nbs node)
                        where
                            node = fst (nodes !! (fst evals))
                            nbs = checkBoard node
                where
                    nodes = generateChildStatesSeq board player moves

    where 
        boardStatus = checkBoard board

evaluateImmediate :: [(Board, Int)] -> Player -> Int -> (Int, Int)
evaluateImmediate [] _ ret = (-1, -1)
evaluateImmediate (x:xs) player ret 
    | player == Human && val <= -999999999 = (ret + 1, snd x)
    | player == AI && val >= 999999999 = (ret + 1, snd x)
    | otherwise = evaluateImmediate xs player (ret + 1)
    where
        val = score (fst x) 

minimaxPar :: Board -> Player -> Int -> (Int, Int) --move, score
minimaxPar board player depth
    | boardStatus /= 0  || depth <= 0 = (-1, computeTerminal boardStatus board)
    | otherwise =
        let moves = [0..6] \\ (getValidCols (last board) 0)
        in case moves of 
            [] -> (computeTerminal boardStatus board, -1)
            _ -> 
                let evals = evaluateImmediate nodes player (-1)
                in case (fst evals < 0) of
                    True -> (findBest (evaluateChildStatesPar nodes player depth) player)
                    _ -> 
                        (snd evals, computeTerminal nbs node)
                        where
                            node = fst (nodes !! (fst evals))
                            nbs = checkBoard node
                where
                    nodes = generateChildStatesPar board player moves
    where 
        boardStatus = checkBoard board

findBest :: [(Int, Int)] -> Player -> (Int, Int)
findBest scores player
    | player == AI = maximumBy (comparing snd) scores
    | otherwise = minimumBy (comparing snd) scores

generateChildStatesSeq :: Board -> Player -> [Int] -> [(Board, Int)] -- Board, move
generateChildStatesSeq _ _ [] = []
generateChildStatesSeq board player (x:xs) = (evalBoard board x player, x) : (generateChildStatesSeq board player xs)

generateChildStatesPar :: Board -> Player -> [Int] -> [(Board, Int)] -- Board, move
generateChildStatesPar _ _ [] = []
generateChildStatesPar board player moves = 
    map (\x -> (evalBoard board x player, x)) moves `using` evalList (rpar . force)

evalBoard :: Board ->  Int -> Player -> Board
evalBoard board col player = 
    take row board ++ --https://stackoverflow.com/questions/20156078/replacing-an-element-in-a-list-of-lists-in-haskell
    [take col (board !! row) ++ [x] ++ drop (col + 1) (board !! row)] ++
    drop (row + 1) board
    where
        x = playerToToken player
        row = getRowNum ((generateVerticalLists board) !! col) 0

evaluateChildStatesSeq :: [(Board, Int)] -> Player -> Int -> [(Int, Int)] -- move, score
evaluateChildStatesSeq [] _ _ = []
evaluateChildStatesSeq (x:xs) player depth = (move, val) : evaluateChildStatesSeq xs player depth
    where
        (board, move) = x
        (_, val) = minimaxSeq board (otherPlayer player) (depth - 1)

evaluateChildStatesPar :: [(Board, Int)] -> Player -> Int -> [(Int, Int)]
evaluateChildStatesPar [] _ _ = []
evaluateChildStatesPar nodes player depth = map (\(x, y) -> (y, snd (minimaxPar x (otherPlayer player) (depth - 1)))) nodes `using` evalList (rpar . force)

-- loopMinimax :: Board -> Player -> Int -> Int -> [Int] -> Int -> Int -> (Int, Int)
-- loopMinimax _ _ bestMove _ [] bestScore _ = (bestMove, bestScore) 
-- loopMinimax _ _ bestMove _ _ bestScore 0 = (bestMove, bestScore)
-- loopMinimax board player bestMove curMove (x:xs) bestScore depth
--     | player == Human && nextScore > bestScore = loopMinimax board other curMove x xs nextScore depth
--     | player == AI && nextScore < bestScore = loopMinimax board other curMove x xs nextScore depth
--     | otherwise = loopMinimax board other bestMove x xs bestScore depth
--     where
--         newBoard = calculateBoard board curMove player
--         other = otherPlayer player
--         (nextScore, _) = minimax newBoard other (depth - 1)

computeTerminal :: Int -> Board -> Int
computeTerminal status board 
    | status == 1 = -999999999
    | status == 2 = 999999999
    | otherwise = computePartialScore board

computePartialScore :: Board -> Int
computePartialScore board = h_score + v_score + d_score + c_score
    where
        h_score = score board
        v_score = score (generateVerticalLists board)
        d_score = score (generateDiagonalLists board)
        c_score = centralScore ((generateVerticalLists board) !! 3)

centralScore :: [Char] -> Int
centralScore col = ((length os - length xs) * 5)
    where 
        (os, _) = span (=='O') col
        (xs, _) = span (=='X') col

score :: [[Char]] -> Int
score [] = 0
score (x:xs)
    | length x  < 4 = score xs --skip 
    | length x == 4 = curScore + score xs
    | otherwise = score windows + score xs
    where
        curScore = scoreWindow x
        windows = genWindows 4 x

genWindows :: Int -> [a] -> [[a]] -- https://stackoverflow.com/questions/12876384/grouping-a-list-into-lists-of-n-elements-in-haskell
genWindows _ [] = []
genWindows n l
  | n > 0 = (take n l) : (genWindows n (drop n l))
  | otherwise = error "Negative or zero n"

scoreWindow :: [Char] -> Int
scoreWindow [] = 0
scoreWindow window 
    | player == 2 && (length xs) == 0 && len > 2 = (len * 10)
    | player == 1 && (length os) == 0 && len > 2 = (len * (-10))
    | otherwise = 0
    where
        (len, player) = maxrun window
        (os, _) = span (=='O') window
        (xs, _) = span (=='X') window

otherPlayer :: Player -> Player
otherPlayer player
    | player == Human = AI
    | otherwise = Human

calculateBoard :: Board -> Int -> Int -> Player -> Board
calculateBoard board row col player = 
    take row board ++ --https://stackoverflow.com/questions/20156078/replacing-an-element-in-a-list-of-lists-in-haskell
    [take col (board !! row) ++ [x] ++ drop (col + 1) (board !! row)] ++
    drop (row + 1) board
    where
        x = playerToToken player

playerToToken :: Player -> Char
playerToToken player
    | player == Human = 'X'
    | otherwise = 'O'

getRowNum :: [Char] -> Int -> Int
getRowNum [] index = index
getRowNum (x:xs) index
    | index > 5 = -1
    | x == '.' = index
    | otherwise = getRowNum xs newIndex
    where 
        newIndex = index + 1


getMove :: Board -> Int -> IO Int
getMove board mode = do
    let validCols = getValidCols (last board) 1
    putStrLn $ showBoard $ (reverseBoard board)
    if mode >= 2 then do --simulate
        number <- randomRIO(0, 6)
        if number `elem` validCols || number > 7 || number < 1 then do
            getMove board mode
        else do
            return number
    else do
        line <- getLine
        let number = (read line:: Int)
        if number `elem` validCols || number > 7 || number < 1 then do
            putStrLn "Invalid column" >> getMove board mode
        else do
            return (number - 1)

reverseBoard :: Board -> Board
reverseBoard [] = []
reverseBoard (x:xs) = reverseBoard xs ++ [x]

getValidCols :: [Char] -> Int -> [Int]
getValidCols [] _ = []
getValidCols (x:xs) index 
    | x /= '.' = index : getValidCols xs newIndex
    | otherwise = getValidCols xs newIndex
    where
        newIndex = index + 1

showBoard :: Board -> [Char] -- https://github.com/marcmonfort/ConnectFour/blob/master/ConnectFour.hs
showBoard [] = []
showBoard (r:rs) = 
    '\n':' ':(showRow(r)) ++
    '\n':' ':box ++
    showBoard rs
    where
        box = if length rs == 0 
            then " ╰─" ++ (concat (take ((length r)-1) (repeat "──┴─"))) ++ "──╯"
            else " ├─" ++ (concat (take ((length r)-1) (repeat "──┼─"))) ++ "──┤"

showRow :: [Char] -> [Char]
showRow [] = ' ':'│':[] 
showRow (x:xs) = " │ " ++ x:showRow xs


checkBoard :: Board -> Int
checkBoard board
    | full = -1
    | vertical /= 0 = vertical
    | horizontal /= 0 = horizontal
    | diagonal /= 0 = diagonal
    | otherwise = 0
    where
        full = checkFull board
        vertical = checkWinner (generateVerticalLists board) 1
        horizontal = checkWinner board 3
        diagonal = checkWinner (generateDiagonalLists board) 5

checkFull :: Board -> Bool
checkFull [] = False
checkFull board = all (/= '.') (last board)


generateVerticalLists :: Board -> [[Char]]
generateVerticalLists ([]:_) = []
generateVerticalLists x = (map head x) : transpose (map tail x) -- https://stackoverflow.com/questions/2578930/understanding-this-matrix-transposition-function-in-haskell

generateDiagonalLists :: Board -> [[Char]]
generateDiagonalLists board = (diagonals board) ++ (diagonals (foldl (\x y -> y:x) [] board))

checkWinner :: [[Char]] -> Int -> Int
checkWinner [] _ = 0
checkWinner (x:xs) code
    | len >= 4 && player == 1 = code
    | len >= 4 && player == 2 = code + 1
    | otherwise = checkWinner xs code
    where
        (len, player) = maxrun x

maxrun :: [Char] -> (Int, Int)
maxrun [] = (0, 0)
maxrun [_] = (1, 0)
maxrun (x:xs) = maxrun' x xs 1 1 0

maxrun' :: Char -> [Char] -> Int -> Int -> Int -> (Int, Int)
maxrun' _ [] cur ret winner = (cur `max` ret, winner)
maxrun' n (y:ys) cur ret winner
        | n == y && n /= '.' = maxrun' y ys (1+cur) ret nextWinner
        | otherwise = maxrun' y ys 1 (cur `max` ret) nextWinner
        where
        nextWinner = getWinner winner n y cur ret

getWinner :: Int -> Char -> Char -> Int -> Int -> Int
getWinner curWinner curValue nextValue curLongest longest
    | curWinner == 0 = next
    | curValue /= '.' && curValue == nextValue && (curLongest + 1) > longest = next
    | curValue /= '.' && curValue /= nextValue && curLongest > longest = next
    | otherwise = curWinner
    where
        next = tokenToInt curValue

tokenToInt :: Char -> Int
tokenToInt c
    | c == 'X' = 1
    | c == 'O' = 2
    | otherwise = 0

diagonals :: [[a]] -> [[a]]
diagonals = tail . go [] where
    -- it is critical for some applications that we start producing answers
    -- before inspecting es_
    go b es_ = [h | h:_ <- b] : case es_ of
        []   -> transpose ts
        e:es -> go (e:ts) es
        where ts = [t | _:t <- b]
