{-
  Module responsible for reading input into a 2-D array.
-}
module GridReader
    ( createGridFromInput
    ) where

import qualified Data.Word8 as W
import Data.Array ( Array, array )
import qualified Data.ByteString as S

{-
  Given a bytestring and size of the grid, create
  a grid of dimensions (size X size)
-}
createGridFromInput :: S.ByteString -> Int -> Array (Int, Int) W.Word8
createGridFromInput contents size = let word_arr = map W.toUpper $ filter W.isAlpha $ S.unpack contents
                                    in array ((0,0), (size-1, size-1))
                                      ([ ((i,j), word_arr !! (size*i + j)) | i <- [0..size-1], j <- [0..size-1]])