# +RTS - runtime options follow that
# -N8 - number of threads (8)
# -l - enable eventlog for threadscope
# -p - enable profiling (Slow!!)

EXECUTABLE=./.stack-work/dist/8a54c84f/build/word-ladder-exe/word-ladder-exe.exe

function run () {
	${EXECUTABLE} $1 words.txt sage fool +RTS -N8 $2
	NAME=$1$2

	[ -f word-ladder-exe.eventlog ] && mv word-ladder-exe.eventlog report/$NAME.eventlog
	[ -f word-ladder-exe.prof ] && mv word-ladder-exe.prof report/$NAME.prof
}

if [ $1 = "full" ]
then
	echo "Running full set of runs"

	echo "Clearing out old results"
	rm -rf report
	mkdir -p report

	echo "Building without profile information for accurate timing"
	(stack build) > build.log 2>&1

	echo "Par timing"
	(time run par "-l") >> report/report.txt 2>&1
	echo "Seq timing"
	(time run seq "-l") >> report/report.txt 2>&1

	echo "Building with profile information"
	stack clean
	(stack build --profile) >> report/build.log 2>&1

	echo "Gathering Par profile"
	run par "-p" > /dev/null
	echo "Gathering Seq profile"
	run seq "-p" > /dev/null
else
	echo "Running run on the current build with mode $1 with flag $2"
	run $1 $2
fi