module RunTests
(
    tests
)
where
    import qualified HeldKarp_List as HKL (minTripFib, makePoint, makeTestSet)
    import qualified HeldKarpSet_Par as HKSP (minTripFib)
    import qualified HeldKarpSet as HKS (minTripFib, makeTestSet)
    import qualified Naive_Par as NP (traverseAll)
    import qualified Naive_Seq as NS (traverseAll)
    import Text.Printf
    import qualified Data.List as List
    import System.CPUTime
    import Control.Concurrent
    import Data.FloatCast

    tests :: IO ()
    tests = do
            putStrLn " "
            putStrLn " "
            putStrLn " "
            putStrLn "Beginning Test Suite!"
            putStrLn "Beginning with a graph of [10] nodes on [Naive Sequential]"
            putStrLn "This can take up to [60] seconds."
            st_time <- getCPUTime
            print . snd . List.minimum $ NP.traverseAll
            ed_time <- getCPUTime
            let diff = (fromIntegral (ed_time - st_time)) / (10^(12 :: Integer))
            printf "Computation time: [%0.3f] secs\n" (diff :: Double)
            threadDelay 3500000
            putStrLn " "
            putStrLn "That's quite slow. Let's use our parallel implementation."
            putStrLn "Running the same graph of [10] nodes on [Naive Parallel]"
            st_time_2 <- getCPUTime
            print . snd . List.minimum $ NS.traverseAll
            ed_time_2 <- getCPUTime
            let diff_2 = (fromIntegral (ed_time_2 - st_time_2)) / (10^(12 :: Integer))
            printf "Computation time: [%0.3f] secs\n" (diff_2 :: Double)
            threadDelay 2500000
            putStrLn " "
            putStrLn "Much better! Let's try with some of the Held-Karp implementations."
            putStrLn "Testing [Held-Karp List Sequential] on a graph of [12] nodes."
            st_time_3 <- getCPUTime
            print . wordToFloat $ (HKL.minTripFib (HKL.makePoint 1 1, HKL.makePoint 1 1, HKL.makeTestSet 12))
            ed_time_3 <- getCPUTime
            let diff_3 = (fromIntegral (ed_time_3 - st_time_3)) / (10^(12 :: Integer))
            printf "Computation time: [%0.3f] secs\n" (diff_3 :: Double)
            putStrLn " "
            putStrLn "Clearly we aren't taking advantage of HK's memoization."
            putStrLn "Let's swap from list to set!"
            threadDelay 1700000
            putStrLn "Testing [Held-Karp-Set Sequential] on a graph of [12] nodes."
            st_time_4 <- getCPUTime
            print . wordToFloat $ (HKS.minTripFib (HKL.makePoint 1 1, HKL.makePoint 1 1, HKS.makeTestSet 12))
            ed_time_4 <- getCPUTime
            let diff_4 = (fromIntegral (ed_time_4 - st_time_4)) / (10^(12 :: Integer))
            printf "Computation time: [%0.3f] secs\n" (diff_4 :: Double)
            putStrLn " "
            putStrLn "Much better! Finally, let's try this in parallel. We'll need to up the graph size."
            threadDelay 2000000
            putStrLn "Testing [Held-Karp-Set Parallel] on a graph of [15] nodes."
            st_time_5 <- getCPUTime
            print . wordToFloat $ (HKSP.minTripFib (HKL.makePoint 1 1, HKL.makePoint 1 1, HKS.makeTestSet 15))
            ed_time_5 <- getCPUTime
            let diff_5 = (fromIntegral (ed_time_5 - st_time_5)) / (10^(12 :: Integer))
            printf "Computation time: [%0.3f] secs\n" (diff_5 :: Double)
            threadDelay 1000000
            putStrLn " "
            putStrLn " "
            putStrLn "FINAL COMPARISON:"
            printf "Naive Sequential [10 Nodes]: [%0.3f] secs\n" (diff :: Double)
            printf "Naive Parallel   [10 Nodes]: [%0.3f] secs\n" (diff_2 :: Double)
            printf "HK-List Seq.     [12 Nodes]: [%0.3f] secs\n" (diff_3 :: Double)
            printf "HK-Set Seq.      [12 Nodes]: [%0.3f] secs\n" (diff_4 :: Double)
            printf "HK-Set Par.      [15 Nodes]: [%0.3f] secs\n" (diff_5 :: Double)
            putStrLn " "
            putStrLn " "




