    module Naive_Par 
    (
      shortest,
      traverseAll
    )
    where
    import qualified Data.List as List
    import Control.Parallel.Strategies 
    
    -- Can change graph easily to a different set of input nodes

    graphMaker :: Int -> [(Float, Float)]
    graphMaker num = [(fromIntegral i, fromIntegral i)| i <- [0..num]]

    graph :: [(Float, Float)]
    graph = graphMaker 10

    -- distance :: (Integral a, Floating b) => (a,a) -> (a,a) -> b
    -- distance p1 p2 = sqrt ((fst (p2) - fst(p1))^^2 + ((snd p2) - (snd p1))^^2)
    
    distance :: Floating a => (a, a) -> (a, a) -> a
    distance (x1 , y1) (x2 , y2) = sqrt (x'*x' + y'*y')
        where
          x' = x1 - x2
          y' = y1 - y2
    
    
    -- Can probably implement this with a fold, not sure how though
    map_traverse :: (Floating b) => [(b,b)] -> b
    map_traverse [p1, p2] = distance p1 p2
    map_traverse (p1:p2:ps) = distance p1 p2 + map_traverse (p2 : ps)
    map_traverse [_] = 0.0
    map_traverse [] = 0.0

    allPerms :: [[(Float, Float)]]
    allPerms = List.permutations (tail graph) --`using` parList rseq
    
    -- Sequential -> rpar (overflowed sparks) -> parListChunk
    traverseAll :: [(Float, [(Float, Float)])]
    traverseAll = map (\x -> (map_traverse (addEnds x (head graph)), x)) allPerms `using` parListChunk 8 rseq
    
    addEnds :: [a] -> a -> [a]
    addEnds xs end = end:xs ++ [end]
    
    shortest :: (Float, [(Float, Float)])
    shortest = List.minimum traverseAll
