{-
$ stack --resolver lts-19.23 ghc -- --make -Wall -O main.hs
$ ./test output.csv tracks.csv
-}
import System.Environment (getArgs)
import System.IO (openFile, IOMode (ReadMode), hGetContents)

nValid :: [String] -> [String] -> Int
nValid _ [] = 0
nValid outputlines (htruthlines:ttruthlines)
    | init htruthlines `elem` outputlines = nValid outputlines ttruthlines + 1
    | otherwise = nValid  outputlines ttruthlines

efficiencyandpurity :: [String] -> [String] -> (Double,Double)
efficiencyandpurity outputlines truthlines
    = (100 * valids / fromIntegral (length truthlines),
        100 * valids/fromIntegral (length outputlines))
    where valids = fromIntegral (nValid outputlines truthlines)


main :: IO ()
main = do
    arguments <- getArgs
    outputfile <- openFile (head arguments) ReadMode
    truthfile <-  openFile (head $ tail arguments) ReadMode
    output <- hGetContents outputfile
    truth <- hGetContents truthfile
    let truthlines = lines truth
    let outputlines = lines output
    let ep = efficiencyandpurity outputlines truthlines
    putStr $ take 4 (show (fst ep))++"% efficiency\n"
    putStr $ take 4 (show (snd ep))++"% purity\n"
