import Control.Exception
import System.Environment
import Data.Maybe
import Data.List (sortBy)
import Data.Ord (comparing)
import Control.Monad.Par
import Data.Char (digitToInt)
import Data.List.Split (splitOn)

type Maze = [[Int]]
type Coord = (Int, Int)
type Route = [Coord]
data Node = Node { pos :: Coord,
                  d :: Int,
                  f :: Int,
                  parent :: Coord
                  } deriving (Eq, Show)

getValidNeighbors :: Coord -> Maze -> [Coord]
getValidNeighbors (x, y) maze = filter (isOpen maze) [(x1, y1) | (x1,y1) <- [(x+1,y),(x-1,y),(x,y+1),(x,y-1)], x1 < (length maze),  x1 >= 0, y1 < (length (maze !! x)), y1 >= 0]

distance :: Coord -> Coord -> Int
distance (x1,y1) (x2,y2) = abs (x1 - x2) + abs(y1 - y2)

isOpen :: Maze -> Coord -> Bool
isOpen maze (x,y) = maze !! x !! y == 1

nodefilter :: Node -> [Node] -> Bool
nodefilter node nodes = any (\x -> pos x == pos node && f x <= f node) nodes

sortByF :: [Node] -> [Node]
sortByF = sortBy (comparing f)

buildRoute :: Node -> Coord -> [Node] -> Route
buildRoute cur start nodes
        | pos cur == start = [start]
        | otherwise =  (pos cur) : buildRoute (findNode (parent cur) nodes) start nodes

findNode :: Coord -> [Node] -> Node
findNode cur (x:xs)
        | cur == pos x = x
        | otherwise = findNode cur xs

start :: Coord
start = (0,0)


solveMaze :: Maze -> Coord -> Coord -> [Node] -> [Node] -> Maybe Route
solveMaze maze cur end openList closedList
        | openList == [] = Nothing
        | cur == end = Just (reverse (buildRoute (head openList) start closedList))
        | otherwise = 
          let 
                curNode = head openList
                neighbors = getValidNeighbors cur maze
                neighborNodes = filter (not . checkClosed) [Node {pos=x,d=(y+1),f=(y+1+(distance x end)),parent=cur} | x <- neighbors, let y = d curNode]
                        where checkClosed n = nodefilter n (closedList ++ openList)
                curOpenList = sortByF (tail openList ++ neighborNodes)

          in solveMaze maze (pos (head curOpenList)) end curOpenList (closedList ++ [(head openList)])

main :: IO()
main = do
    args <- getArgs
    case args of
        [filename] -> do
                contents <- readFile filename
                let mazeLines = lines contents
                let mazeStrings = (map ( map (splitOn ",")) (map (splitOn " ") mazeLines))
                let mazes = map (map (map (\x -> read x :: Int))) mazeStrings

                print (length (filter isJust (map solve mazes)))
                        where solve maze = solveMaze maze start ((length maze)-1,(length (maze !! 0))-1) [Node {pos=start,d=0,f=0,parent=start}] []