module Point
  ( Point(..)
  ) where

import Color

data Point =
  Point
    { color    :: Color
    , position :: (Int, Int)
    }

instance Show Point where
  show (Point color _) = show color

instance Eq Point where
  (Point color1 (x1, y1)) == (Point color2 (x2, y2)) = x1 == x2 && y1 == y2 && color1 == color2

instance Ord Point where
  compare (Point _ (x1,y1)) (Point _ (x2,y2)) = compare (x1*10+y1) (x2*10+y2)