module Main (main) where

import AI
import Board
import Data.Char
import System.IO

gameLoopAI :: Board -> Color -> IO ()
gameLoopAI board color
    | isOver curBoard == True = do
        putStrLn (show color ++ "'s turn.")
        printBoard curBoard
        putStrLn (show color ++ " wins!")
    | otherwise = do
        putStrLn (show color ++ "'s turn.")
        printBoard curBoard
        gameLoopAI curBoard (oppositeColor color)
    where
        curBoard = generateMove board color


playerLoop :: Board -> Color -> IO ()
playerLoop board color
    | color == Black = do 
        x <- prompt "Enter row: "
        y <- prompt "Enter col: "
        let playerBoard = addPointToBoard (Point color (read x :: Int, read y :: Int)) board
        printBoard playerBoard
        if isOver playerBoard then putStrLn (show color ++ " wins!") else playerLoop playerBoard (oppositeColor color)
    | otherwise = do
        putStrLn (show color ++ "'s turn.")
        let curBoard = generateMove board color
        printBoard curBoard
        if isOver curBoard then putStrLn (show color ++ " wins!") else playerLoop curBoard (oppositeColor color)

prompt :: String -> IO String
prompt text = do
    putStr text
    hFlush stdout
    getLine


main :: IO ()
main = gameLoopAI (initBoard 8 8) Black
-- main = do
--     let board = initBoard 10 10
--     printBoard board
--     playerLoop board Black


