import Lib

initialBoard :: Board
initialBoard = initializeBoard (7, 7)

evaluateTest :: String -> Bool -> IO ()
evaluateTest testName test = if test then putStrLn $ "Test {" ++ testName ++ "} passed." else putStrLn $ "Test {" ++ testName ++ "} failed."

testGetChildren :: Bool
testGetChildren = (length $ getChildren initialBoard White) == 8

testOverline :: Bool
testOverline = ((`heuristic` True) $ (move (move (move (move (move initialBoard Black (7, 8)) Black (7, 9)) Black (7, 10)) Black (7, 11)) Black (7, 12))) == 0

testScore2 :: Bool
testScore2 = ((`heuristic` True) $ (move initialBoard Black (7, 8))) == 200

testScore3 :: Bool
testScore3 = ((`heuristic` True) $ (move (move initialBoard Black (7, 8)) Black (7, 9))) == 1000

testScore4 :: Bool
testScore4 = ((`heuristic` True) $ (move (move (move initialBoard Black (7, 8)) Black (7, 9)) Black (7, 10))) == 2000000

testScore5 :: Bool
testScore5 = ((`heuristic` True) $ (move (move (move (move initialBoard Black (7, 8)) Black (7, 9)) Black (7, 10)) Black (7, 11))) == 20000000000

testIsTerminal :: Bool
testIsTerminal = isTerminal $ (move (move (move (move initialBoard Black (7, 8)) Black (7, 9)) Black (7, 10)) Black (7, 11))

testParSerialMatch :: Bool
testParSerialMatch = (map showBoard $ serialSolutions) == (map showBoard $ parallelSolutions)
  where serialSolutions = loopSerial initialBoard White 10 []
        parallelSolutions = loopPar initialBoard White 10 []

main :: IO ()
main = do
    putStrLn "BEGIN TESTING"
    evaluateTest "Get Children of Board" testGetChildren -- initial board should have eight children
    evaluateTest "Overline" testOverline -- lines with length greater than 5 actually have a heuristic of 0
    evaluateTest "Score 2" testScore2
    evaluateTest "Score 3" testScore3
    evaluateTest "Score 4" testScore4
    evaluateTest "Score 5" testScore5
    evaluateTest "Termination" testIsTerminal
    evaluateTest "Parallel = Serial Output" testParSerialMatch