module Main (main) where

import NQueens (nQueensParallel, nQueensSequential)
import System.Environment (getArgs, getProgName)
import System.Exit (die)

main :: IO ()
main = do
    args <- getArgs
    progName <- getProgName

    case args of
        ["par", depth, number] -> putStrLn $ show $ nQueensParallel (read depth) (read number)
        ["seq", number] -> putStrLn $ show $ nQueensSequential (read number)
        _ -> do
            die $ "Invalid arguments. Please use the following format: \n" ++ progName ++ " par <spark depth> <number of queens> \n or \n" ++ progName ++ " seq <number of queens>"
