module Main (main) where

import qualified Data.Text as B (words, lines)
import qualified Data.Text.IO as B (readFile)
import qualified Data.Text.Read as B (double)
import Types (Point(..))
import qualified Lib (convexHull)
import qualified ParLib (convexHull)
import System.Exit (exitFailure)
import System.IO (hPutStrLn, withFile, IOMode(WriteMode))

main :: IO ()
main = do
      contents <- B.readFile "test/hull.in"
      let pts = map (\p -> case p of
                           [xstr, ystr] -> (case (B.double xstr, B.double ystr) of
                                              (Right (x, _), Right (y, _)) -> 
                                                 Point x y
                                              _ -> error "error while parsing input"
                                           )
                           _            -> error "malformed input"
                    ) 
                    (map B.words $ B.lines contents)
      let hull_s = Lib.convexHull pts
      withFile "test/hull_s.out" WriteMode
               (\h -> do mapM_ (\p -> hPutStrLn h $ show p) $ hull_s)
      let hull_p = ParLib.convexHull pts
      withFile "test/hull_p.out" WriteMode
               (\h -> do mapM_ (\p -> hPutStrLn h $ show p) $ hull_p)
      
      p_Contents <- readFile "test/hull_s.out"
      s_Contents <- readFile "test/hull_p.out"
      okContents <- readFile "test/hull.ok"
    
      if p_Contents == s_Contents && p_Contents == okContents
      then return ()
      else exitFailure
