module Types
    ( Point(..)
    , Cap(..)
    , Hull(..)
    ) where

import Control.Parallel.Strategies
import Control.DeepSeq
-- a cap is either the top or the bottom half of a hull
-- consists of its left-right and its right-left traversal
-- a hull is made out of its upper-hull/cap and its lower one
data Cap = Cap [Point] [Point]
data Hull = Hull Cap Cap
instance NFData Hull where
  rnf (Hull (Cap upperLR upperRL) 
            (Cap lowerLR lowerRL)) = (rnf upperLR) `seq`
                                     (rnf upperRL) `seq`
                                     (rnf lowerLR) `seq`
                                     (rnf lowerRL)

data Point = Point Double Double
instance Eq Point where
  (Point ax ay) == (Point bx by) = (ax == ay) && (bx == by)
instance Ord Point where
  (Point ax ay) `compare` (Point bx by) =
    case (ax `compare` bx) of 
      LT -> LT
      GT -> GT
      EQ -> ay `compare` by
instance Show Point where
  show (Point x y) = "(" ++ (show x) ++ ", " ++ (show y) ++ ")"
instance NFData Point where
  rnf (Point x y) = (rnf x) `seq` (rnf y)
