#!/usr/bin/env python3

entries = \
[
    (
        0, #type = 0, color sprite
        0, #sprite number
        17, #width=16
        26, #height=25
        500, #cur_x
        100, #cur_y
        0, #next_x
        100 #next_y
    ),
    (
        0, #type = 0, color sprite
        1, #sprite number
        17, #width = 32
        26, #height = 32
        300, #cur_x
        200, #cur_y
        300, #next_x
        400 #next_y
    ),
    (
        0, #type = 0, color sprite
        2, #sprite number
        17, #width = 32
        26, #height = 32
        400, #cur_x
        100, #cur_y
        200, #next_x
        400 #next_y
    ),
    (
        0, #type = 0, color sprite
        3, #sprite number
        17, #width = 32
        31, #height = 32
        0, #cur_x
        500, #cur_y
        500, #next_x
        0 #next_y
    ),
    (
        0, #type = 0, color sprite
        4, #sprite number
        17, #width = 32
        31, #height = 32
        450, #cur_x
        0, #cur_y
        450, #next_x
        0 #next_y
    ),
    (
        0, #type = 0, color sprite
        5, #sprite number
        17, #width = 32
        31, #height = 32
        425, #cur_x
        0, #cur_y
        425, #next_x
        0 #next_y
    ),
    (
        0, #type = 0, color sprite
        25, #sprite number
        17, #width = 32
        31, #height = 32
        325, #cur_x
        0, #cur_y
        325, #next_x
        0 #next_y
    ),
    (
        1, #type = 1, mono-color
        7, # H
        0xF, #red
        0xF, #green
        0xF, #blue
        100, #cur_x
        450, #cur_y
        100, #next_x
        450 #next_y
    ),
    (
        1, #type = 1, mono-color
        8, # I
        0xF, #red
        0xF, #green
        0xF, #blue
        108, #cur_x
        450, #cur_y
        108, #next_x
        450 #next_y
    ),
    (
        1, #type = 1, mono-color
        86, # ,
        0xF, #red
        0xF, #green
        0xF, #blue
        116, #cur_x
        450, #cur_y
        1116, #next_x
        450 #next_y
    ),
    (
        1, #type = 1, mono-color
        92, # space
        0xF, #red
        0xF, #green
        0xF, #blue
        124, #cur_x
        450, #cur_y
        124, #next_x
        450 #next_y
    ),
    (
        1, #type = 1, mono-color
        45, # t
        0xF, #red
        0xF, #green
        0xF, #blue
        132, #cur_x
        450, #cur_y
        132, #next_x
        450 #next_y
    ),
    (
        1, #type = 1, mono-color
        30, # e
        0xF, #red
        0xF, #green
        0xF, #blue
        140, #cur_x
        450, #cur_y
        140, #next_x
        450 #next_y
    ),
    (
        1, #type = 1, mono-color
        44, # s
        0xF, #red
        0xF, #green
        0xF, #blue
        148, #cur_x
        450, #cur_y
        148, #next_x
        450 #next_y
    ),
    (
        1, #type = 1, mono-color
        45, # t
        0xF, #red
        0xF, #green
        0xF, #blue
        156, #cur_x
        450, #cur_y
        156, #next_x
        450 #next_y
    )
    ]

debug = False

for entry in entries:
    line = "0b"
    line += "{:01b}".format(entry[0]) # type
    if (entry[0] == 0): #color
        line += " {:05b}".format(entry[1]) # sprite num
        line += " 0000" #padding
        line += " {:05b}".format(entry[2]) #width
        line += " {:05b}".format(entry[3]) #height
        line += " {:011b}".format(entry[4]) #cur_x
        line += " {:011b}".format(entry[5]) #cur_y
        line += " {:011b}".format(entry[6]) #new_x
        line += " {:011b}".format(entry[7]) #new_y
    else:
        line += " {:07b}".format(entry[1]) # sprite num
        line += " {:04b}".format(entry[2]) #red
        line += " {:04b}".format(entry[3]) #green
        line += " {:04b}".format(entry[4]) #blue
        line += " {:011b}".format(entry[5]) #cur_x
        line += " {:011b}".format(entry[6]) #cur_y
        line += " {:011b}".format(entry[7]) #new_x
        line += " {:011b}".format(entry[8]) #new_y
    if debug:
        print(line,end = ' - ')
    line = line.replace(" ","")
    hex_val = "{:016x}".format(eval(line))
    print(hex_val)
for index in range(255-len(entries)):
    print("{:016x}".format(0))
    
