#ifndef _VIEWTUBE_KMOD_H
#define _VIEWTUBE_KMOD_H

#include <linux/ioctl.h>


typedef struct {
	unsigned char red, green, blue;
} viewtube_color_t;

typedef struct {
  unsigned short coordinate_x;
  unsigned short coordinate_y;
  unsigned char bounce;
} viewtube_background_window_position_t;

typedef struct {
  unsigned char sprite_num;
  unsigned char width;
  unsigned char height;
} viewtube_4bit_color_sprite_t;

typedef struct {
  unsigned char sprite_num;
  unsigned char red;
  unsigned char green;
  unsigned char blue;

} viewtube_mono_color_sprite_t;

typedef union {
  viewtube_4bit_color_sprite_t color;
  viewtube_mono_color_sprite_t mono;
} viewtube_sprite_obj_t;

typedef struct {
  unsigned char type;
  unsigned char jump;
  unsigned char table_index;
  unsigned short new_x;
  unsigned short new_y;
  viewtube_sprite_obj_t obj;
} viewtube_sprite_t;

typedef union {
  viewtube_sprite_t sprite;
  viewtube_background_window_position_t background_window_position;
} viewtube_arg_t;


#define SPRITE_TYPE_COLOR 0

#define SPRITE_TYPE_MONO 1

#define VIEWTUBE_MAGIC 'q'


/* ioctls and their arguments */
#define VIEWTUBE_SET_BACKGROUND_POS_X     _IOW(VIEWTUBE_MAGIC, 1, viewtube_arg_t *)
#define VIEWTUBE_SET_BACKGROUND_POS_Y     _IOW(VIEWTUBE_MAGIC, 2, viewtube_arg_t *)
#define VIEWTUBE_GET_BACKGROUND_POS       _IOW(VIEWTUBE_MAGIC, 3, viewtube_arg_t *)
#define VIEWTUBE_UPDATE_SPRITE_AT_INDEX   _IOW(VIEWTUBE_MAGIC, 4, viewtube_arg_t *)
#define VIEWTUBE_MOVE_SPRITE_TO_NEW_POS   _IOW(VIEWTUBE_MAGIC, 5, viewtube_arg_t *)




#endif
