#include <iostream>
#include <iomanip>
#include <stdio.h>
#include <fstream>
#include <string> 
#include <string.h> 

using namespace std;

int main(int argc, const char ** argv, const char ** env) {
  int exitcode = 0;
  
  string dir = "sprites/";
  string outfilename = dir + "new_sprites.sv";
  
  ofstream outfile;
  outfile.open (&outfilename[0]);
  
  string infilename;
  ifstream infile;
  
  string line, word;
  char * pch;
   
  outfile << "module sprites(\n";
  outfile << "\tinput logic [5:0]          n_sprite,\n";
  outfile << "\tinput logic [9:0]          line,\n";
	outfile << "\tinput logic                clk,\n";
	outfile << "\toutput logic [29:0][23:0]  pattern);\n\n";
 
	outfile << "\talways_ff @(posedge clk) begin\n";
	outfile << "\t\tcase (n_sprite)\n";
 
  for (int n_sprite = 1; n_sprite < 64; n_sprite++){ 
  
    int num, col, row;
    int ncol = 0, nrow = 0;
    int rgb = 2, color = 0;

    infilename = dir + to_string(n_sprite) + ".ppm";
    infile.open (&infilename[0]);
    
    if (infile.is_open()){
      outfile << dec << "\t\t\t6'd" << n_sprite << " : begin\n\t\t\t\tcase(line)\n";
    
      int i = -1;
      while ( getline (infile, line) )
      {
        if (++i == 0) continue;
        
        pch = strtok (&line[0], " ");
        while (pch != NULL)
        {
          word = pch;
          num = stoi(word);
          if (i == 1) {
            col = num;
            pch = strtok (NULL, " ");
            word = pch;
            num = stoi(word);
            row = num;
          }
          else if(i >= 3){
            //cout << hex << num << " |";
            if ((ncol == 0) && (rgb == 2)){
              //outfile << dec << "\t\t\t\t\t10'd" << nrow << " : pattern[" << col - 1 << ":0] = {";
              outfile << dec << "\t\t\t\t\t10'd" << nrow << " : pattern <= {";
            }
            
            if (rgb > 0){
              color += (num << (8*rgb));
              rgb --;
            }else{
              color += num;
              outfile << "{24'h" << hex << setfill('0') << setw(6) << color << "}";
              color = 0;
              rgb = 2;
              ncol ++;
            }
            
            if (ncol >= col){
              ncol = 0;
              nrow ++;
              outfile << ", {" << dec << 30-col << "{24'h0}}" <<"};\n";
            }
            else if (rgb == 2){
              outfile << ", ";
            }
          
          }
          
          pch = strtok (NULL, " ");
        }
      }
      outfile << dec << "\t\t\t\t\tdefault : pattern <= {30{24'h0}};\n";
      outfile << dec << "\t\t\t\tendcase\n\t\t\tend\n";
      
      infile.close();
    }
  }
  
  outfile << "\t\t\tdefault : begin\n";
  outfile << "\t\t\t\tpattern <= {30{24'h0}};\n";
  outfile << "\t\t\tend\n";
  outfile << "\t\tendcase\n";
  outfile << "\tend\n";
  outfile << "endmodule\n";
  
  
  //outfile << "Writing this to a file.\n";
  outfile.close();
  

  return exitcode;
}

