module axi_interconnect_2x1_wrapper (
	input logic clk,
	input logic rst,
	axi_interface s00,
	axi_interface s01,
	axi_interface m00
);

	axi_interconnect_2x1 inter_connect (
		.clk				(clk),
		.rst				(rst),

		// s00
		.s00_axi_awid		(s00.s_axi_awid),
		.s00_axi_awaddr		(s00.s_axi_awaddr),
		.s00_axi_awlen		(s00.s_axi_awlen),
		.s00_axi_awsize		(s00.s_axi_awsize),
		.s00_axi_awburst	(s00.s_axi_awburst),
		.s00_axi_awlock		(s00.s_axi_awlock),
		.s00_axi_awcache	(s00.s_axi_awcache),
		.s00_axi_awprot		(s00.s_axi_awprot),
		.s00_axi_awqos		(s00.s_axi_awqos),
		.s00_axi_awuser		(s00.s_axi_awuser),
		.s00_axi_awvalid	(s00.s_axi_awvalid),
		.s00_axi_awready	(s00.s_axi_awready),
		.s00_axi_wdata		(s00.s_axi_wdata),
		.s00_axi_wstrb		(s00.s_axi_wstrb),
		.s00_axi_wlast		(s00.s_axi_wlast),
		.s00_axi_wuser		(s00.s_axi_wuser),
		.s00_axi_wvalid		(s00.s_axi_wvalid),
		.s00_axi_wready		(s00.s_axi_wready),
		.s00_axi_bid		(s00.s_axi_bid),
		.s00_axi_bresp		(s00.s_axi_bresp),
		.s00_axi_buser		(s00.s_axi_buser),
		.s00_axi_bvalid		(s00.s_axi_bvalid),
		.s00_axi_bready		(s00.s_axi_bready),
		.s00_axi_arid		(s00.s_axi_arid),
		.s00_axi_araddr		(s00.s_axi_araddr),
		.s00_axi_arlen		(s00.s_axi_arlen),
		.s00_axi_arsize		(s00.s_axi_arsize),
		.s00_axi_arburst	(s00.s_axi_arburst),
		.s00_axi_arlock		(s00.s_axi_arlock),
		.s00_axi_arcache	(s00.s_axi_arcache),
		.s00_axi_arprot		(s00.s_axi_arprot),
		.s00_axi_arqos		(s00.s_axi_arqos),
		.s00_axi_aruser		(s00.s_axi_aruser),
		.s00_axi_arvalid	(s00.s_axi_arvalid),
		.s00_axi_arready	(s00.s_axi_arready),
		.s00_axi_rid		(s00.s_axi_rid),
		.s00_axi_rdata		(s00.s_axi_rdata),
		.s00_axi_rresp		(s00.s_axi_rresp),
		.s00_axi_rlast		(s00.s_axi_rlast),
		.s00_axi_ruser		(s00.s_axi_ruser),
		.s00_axi_rvalid		(s00.s_axi_rvalid),
		.s00_axi_rready		(s00.s_axi_rready),
		
		// s01
		.s01_axi_awid		(s01.s_axi_awid),
		.s01_axi_awaddr		(s01.s_axi_awaddr),
		.s01_axi_awlen		(s01.s_axi_awlen),
		.s01_axi_awsize		(s01.s_axi_awsize),
		.s01_axi_awburst	(s01.s_axi_awburst),
		.s01_axi_awlock		(s01.s_axi_awlock),
		.s01_axi_awcache	(s01.s_axi_awcache),
		.s01_axi_awprot		(s01.s_axi_awprot),
		.s01_axi_awqos		(s01.s_axi_awqos),
		.s01_axi_awuser		(s01.s_axi_awuser),
		.s01_axi_awvalid	(s01.s_axi_awvalid),
		.s01_axi_awready	(s01.s_axi_awready),
		.s01_axi_wdata		(s01.s_axi_wdata),
		.s01_axi_wstrb		(s01.s_axi_wstrb),
		.s01_axi_wlast		(s01.s_axi_wlast),
		.s01_axi_wuser		(s01.s_axi_wuser),
		.s01_axi_wvalid		(s01.s_axi_wvalid),
		.s01_axi_wready		(s01.s_axi_wready),
		.s01_axi_bid		(s01.s_axi_bid),
		.s01_axi_bresp		(s01.s_axi_bresp),
		.s01_axi_buser		(s01.s_axi_buser),
		.s01_axi_bvalid		(s01.s_axi_bvalid),
		.s01_axi_bready		(s01.s_axi_bready),
		.s01_axi_arid		(s01.s_axi_arid),
		.s01_axi_araddr		(s01.s_axi_araddr),
		.s01_axi_arlen		(s01.s_axi_arlen),
		.s01_axi_arsize		(s01.s_axi_arsize),
		.s01_axi_arburst	(s01.s_axi_arburst),
		.s01_axi_arlock		(s01.s_axi_arlock),
		.s01_axi_arcache	(s01.s_axi_arcache),
		.s01_axi_arprot		(s01.s_axi_arprot),
		.s01_axi_arqos		(s01.s_axi_arqos),
		.s01_axi_aruser		(s01.s_axi_aruser),
		.s01_axi_arvalid	(s01.s_axi_arvalid),
		.s01_axi_arready	(s01.s_axi_arready),
		.s01_axi_rid		(s01.s_axi_rid),
		.s01_axi_rdata		(s01.s_axi_rdata),
		.s01_axi_rresp		(s01.s_axi_rresp),
		.s01_axi_rlast		(s01.s_axi_rlast),
		.s01_axi_ruser		(s01.s_axi_ruser),
		.s01_axi_rvalid		(s01.s_axi_rvalid),
		.s01_axi_rready		(s01.s_axi_rready),

	/*
	 * AXI master interface
	 */
		.m00_axi_awid		(m00.m_axi_awid),
		.m00_axi_awaddr		(m00.m_axi_awaddr),
		.m00_axi_awlen		(m00.m_axi_awlen),
		.m00_axi_awsize		(m00.m_axi_awsize),
		.m00_axi_awburst	(m00.m_axi_awburst),
		.m00_axi_awlock		(m00.m_axi_awlock),
		.m00_axi_awcache	(m00.m_axi_awcache),
		.m00_axi_awprot		(m00.m_axi_awprot),
		.m00_axi_awqos		(m00.m_axi_awqos),
		.m00_axi_awregion	(m00.m_axi_awregion),
		.m00_axi_awuser		(m00.m_axi_awuser),
		.m00_axi_awvalid	(m00.m_axi_awvalid),
		.m00_axi_awready	(m00.m_axi_awready),
		.m00_axi_wdata		(m00.m_axi_wdata),
		.m00_axi_wstrb		(m00.m_axi_wstrb),
		.m00_axi_wlast		(m00.m_axi_wlast),
		.m00_axi_wuser		(m00.m_axi_wuser),
		.m00_axi_wvalid		(m00.m_axi_wvalid),
		.m00_axi_wready		(m00.m_axi_wready),
		.m00_axi_bid		(m00.m_axi_bid),
		.m00_axi_bresp		(m00.m_axi_bresp),
		.m00_axi_buser		(m00.m_axi_buser),
		.m00_axi_bvalid		(m00.m_axi_bvalid),
		.m00_axi_bready		(m00.m_axi_bready),
		.m00_axi_arid		(m00.m_axi_arid),
		.m00_axi_araddr		(m00.m_axi_araddr),
		.m00_axi_arlen		(m00.m_axi_arlen),
		.m00_axi_arsize		(m00.m_axi_arsize),
		.m00_axi_arburst	(m00.m_axi_arburst),
		.m00_axi_arlock		(m00.m_axi_arlock),
		.m00_axi_arcache	(m00.m_axi_arcache),
		.m00_axi_arprot		(m00.m_axi_arprot),
		.m00_axi_arqos		(m00.m_axi_arqos),
		.m00_axi_arregion	(m00.m_axi_arregion),
		.m00_axi_aruser		(m00.m_axi_aruser),
		.m00_axi_arvalid	(m00.m_axi_arvalid),
		.m00_axi_arready	(m00.m_axi_arready),
		.m00_axi_rid		(m00.m_axi_rid),
		.m00_axi_rdata		(m00.m_axi_rdata),
		.m00_axi_rresp		(m00.m_axi_rresp),
		.m00_axi_rlast		(m00.m_axi_rlast),
		.m00_axi_ruser		(m00.m_axi_ruser),
		.m00_axi_rvalid		(m00.m_axi_rvalid),
		.m00_axi_rready		(m00.m_axi_rready)
	);

endmodule : axi_interconnect_2x1_wrapper
