
//from Altera University Program Audio IP


/*****************************************************************************
 *                           Constant Declarations                           *
 *****************************************************************************/


/*****************************************************************************
 *                 Internal Wires and Registers Declarations                 *
 *****************************************************************************/

 module i2s_avalon_st #(
parameter DW						= 15, //16 bit audio
parameter BIT_COUNTER_INIT	= 5'd15
)(
  input clk,
  input reset,

  input wire [DW:0] avalon_sink_data,
  input wire avalon_sink_valid,
  output wire avalon_sink_ready,

  output wire [DW:0] avalon_source_data,
  output wire avalon_source_valid,
  input wire avalon_source_ready,
  
input	   wire				AUD_ADCDAT,
input		wire				AUD_ADCLRCK,
input		wire				AUD_BCLK,
input		wire				AUD_DACLRCK,
output		wire				AUD_DACDAT

  );
reg [8:0] validcounter; //128max
always@(posedge clk) begin
	if(reset)
		validcounter<=0;
	else begin
		validcounter=validcounter+1;
	end
end
assign avalon_sink_ready=audio_out_allowed;
assign avalon_source_valid=audio_in_available&&validcounter==7'd0;
// Internal Wires
wire						bclk_rising_edge;
wire						bclk_falling_edge;

wire						adc_lrclk_rising_edge;
wire						adc_lrclk_falling_edge;

wire		signed	[DW: 0]	new_left_channel_audio;
wire		signed	[DW: 0]	new_right_channel_audio;

wire			[ 7: 0]	left_channel_read_available;
wire			[ 7: 0]	right_channel_read_available;
wire						dac_lrclk_rising_edge;
wire						dac_lrclk_falling_edge;

wire			[ 7: 0]	left_channel_write_space;
wire			[ 7: 0]	right_channel_write_space;


// Internal Registers
reg						done_adc_channel_sync;
reg						read_interrupt_en;
reg						clear_read_fifos;
reg						read_interrupt;

reg						done_dac_channel_sync;
reg						write_interrupt_en;
reg						write_interrupt;
reg						audio_in_available;
reg						audio_out_allowed;

// State Machine Registers


/*****************************************************************************
 *                         Finite State Machine(s)                           *
 *****************************************************************************/


/*****************************************************************************
 *                             Sequential Logic                              *
 *****************************************************************************/

always @(posedge clk)
begin
	if (reset == 1'b1)
		done_dac_channel_sync <= 1'b0;
	else if (dac_lrclk_falling_edge == 1'b1)
		done_dac_channel_sync <= 1'b1;
end
always @(posedge clk)
begin
	if (reset == 1'b1)
		done_adc_channel_sync <= 1'b0;
	else if (adc_lrclk_rising_edge == 1'b1)
		done_adc_channel_sync <= 1'b1;
end

always @ (posedge clk)
begin
	if (reset == 1'b1)
		audio_in_available <= 1'b0;
	else if ((left_channel_read_available[7] | left_channel_read_available[6])
			& (right_channel_read_available[7] | right_channel_read_available[6]))
		audio_in_available <= 1'b1;
	else
		audio_in_available <= 1'b0;
end
always @ (posedge clk)
begin
	if (reset == 1'b1)
		audio_out_allowed <= 1'b0;
	else if ((left_channel_write_space[7] | left_channel_write_space[6])
			& (right_channel_write_space[7] | right_channel_write_space[6]))
		audio_out_allowed <= 1'b1;
	else
		audio_out_allowed <= 1'b0;
end
/*****************************************************************************
 *                            Combinational Logic                            *
 *****************************************************************************/


/*****************************************************************************
 *                              Internal Modules                             *
 *****************************************************************************/

altera_up_clock_edge Bit_Clock_Edges (
	// Inputs
	.clk				(clk),
	.reset			(reset),
	
	.test_clk		(AUD_BCLK),
	
	// Bidirectionals

	// Outputs
	.rising_edge	(bclk_rising_edge),
	.falling_edge	(bclk_falling_edge)
);

altera_up_clock_edge ADC_Left_Right_Clock_Edges (
	// Inputs
	.clk				(clk),
	.reset			(reset),
	
	.test_clk		(AUD_ADCLRCK),
	
	// Bidirectionals

	// Outputs
	.rising_edge	(adc_lrclk_rising_edge),
	.falling_edge	(adc_lrclk_falling_edge)
);

altera_up_clock_edge DAC_Left_Right_Clock_Edges (
	// Inputs
	.clk				(clk),
	.reset			(reset),
	
	.test_clk		(AUD_DACLRCK),
	
	// Bidirectionals

	// Outputs
	.rising_edge	(dac_lrclk_rising_edge),
	.falling_edge	(dac_lrclk_falling_edge)
);


altera_up_audio_in_deserializer Audio_In_Deserializer (
	// Inputs
	.clk									(clk),
	.reset								(reset),
	
	.bit_clk_rising_edge				(bclk_rising_edge),
	.bit_clk_falling_edge			(bclk_falling_edge),
	.left_right_clk_rising_edge	(adc_lrclk_rising_edge),
	.left_right_clk_falling_edge	(adc_lrclk_falling_edge),

	.done_channel_sync				(done_adc_channel_sync),

	.serial_audio_in_data			(AUD_ADCDAT),

	.read_left_audio_data_en		(avalon_source_valid&&avalon_source_ready),
	.read_right_audio_data_en		(avalon_source_valid&&avalon_source_ready),

	// Bidirectionals

	// Outputs
	.left_audio_fifo_read_space	(left_channel_read_available),
	.right_audio_fifo_read_space	(right_channel_read_available),

	//.left_channel_data				(new_left_channel_audio),
	.left_channel_data				(avalon_source_data),//only send lch to avalon st


	.right_channel_data				(new_right_channel_audio)
);
defparam
	Audio_In_Deserializer.DW 					= DW,
	Audio_In_Deserializer.BIT_COUNTER_INIT = BIT_COUNTER_INIT;

altera_up_audio_out_serializer Audio_Out_Serializer (
	// Inputs
	.clk										(clk),
	.reset									(reset),
	
	.bit_clk_rising_edge					(bclk_rising_edge),
	.bit_clk_falling_edge				(bclk_falling_edge),
	.left_right_clk_rising_edge		(done_dac_channel_sync & dac_lrclk_rising_edge),
	.left_right_clk_falling_edge		(done_dac_channel_sync & dac_lrclk_falling_edge),
	
	.left_channel_data					(avalon_sink_data),

	.left_channel_data_en				(avalon_sink_valid&&avalon_sink_ready),

	.right_channel_data					(avalon_sink_data),

	.right_channel_data_en				(avalon_sink_valid&&avalon_sink_ready),


	// Outputs
	.left_channel_fifo_write_space	(left_channel_write_space),
	.right_channel_fifo_write_space	(right_channel_write_space),

	.serial_audio_out_data				(AUD_DACDAT)
);
//END of ALTERA IP
endmodule


