module biquad_ast #(
  parameter DW = 16
  /* coefficients */

  
  /*
a low pass filter for testing Q=0.7071, fc=1000Hz  
b0_qq = 15
b1_qq = 31
b2_qq = 15
a1_qq = -31709
a2_qq = 15386


hpf 1000hz 0.7071
b0_qq =15869
b1_qq = -31740
b2_qq = 15869
a1_qq = -31709
a2_qq =  15386
		 */
  )(
  input clk,
  input reset,

  input wire signed [DW-1:0] avalon_sink_data,
  input wire avalon_sink_valid,
  output  reg avalon_sink_ready,

  output wire signed [DW-1:0] avalon_source_data,
  output reg avalon_source_valid,
  input wire avalon_source_ready,
  
  
  input wire signed [15:0]  b0_int,
  input wire signed [15:0]  b1_int,
  input wire signed [15:0]  b2_int,
  input wire signed [15:0]  a1_int,
  input wire signed [15:0]  a2_int,

  input wire bypass
  );

  wire signed [DW-1:0] input_int; 
  assign input_int=avalon_sink_data;

  wire signed [DW-1:0] output_int;

  reg signed [DW-1:0] input_pipe1;
  reg signed [DW-1:0] input_pipe2; 
  reg signed [DW-1:0] output_pipe1; 
  reg signed [DW-1:0] output_pipe2; 

  reg signed [DW + DW-1:0] input_b0; 
  reg signed [DW + DW-1:0] input_b1; 
  reg signed [DW + DW-1:0] input_b2; 
  reg signed [DW + DW-1:0] output_a1;
  reg signed [DW + DW-1:0] output_a2;
  wire signed [DW + DW-1:0] output_2int;


  always @(posedge clk) begin
	    avalon_source_valid <= avalon_sink_valid;
       avalon_sink_ready<=avalon_source_ready;
if (reset) begin
      input_pipe1 <= 0;
      input_pipe2 <= 0;
      output_pipe1 <= 0;
      output_pipe2 <= 0;
    end else
      if (avalon_sink_valid&&avalon_sink_valid) begin
        input_pipe1 <= input_int;
        input_pipe2 <= input_pipe1;
        output_pipe1 <= output_int;
        output_pipe2 <= output_pipe1;
      end
		
end
  always @(posedge clk)begin
      if (reset) begin
      input_b0 <= 0;
      input_b1 <= 0;
      input_b2 <= 0;
      output_a1 <= 0;
      output_a2 <= 0;
		end else begin
      input_b0 <= input_int * b0_int;
      input_b1 <= input_pipe1 * b1_int;
      input_b2 <= input_pipe2 * b2_int;
      output_a1 <= output_pipe1 * a1_int;
      output_a2 <= output_pipe2 * a2_int;    
    end
  end
  assign output_2int = input_b0 + input_b1 + input_b2 - output_a1 - output_a2;
  assign output_int = output_2int[27:12];

  assign avalon_source_data = bypass?avalon_sink_data:output_int;

endmodule


module biquad (
  input clk,
  input reset,

  input wire signed [15:0] avalon_sink_data,
  input wire avalon_sink_valid,
  output wire avalon_sink_ready,

  output wire signed [15:0] avalon_source_data,
  output wire avalon_source_valid,
  input wire avalon_source_ready,
  
    //AVALON MM
  input wire signed [15:0]  writedata,
  input wire 	   write,
  input wire		   chipselect,
  input wire [4:0]  address
  
  );
  	reg signed [15:0] i0_b0_int;
	reg signed [15:0] i0_b1_int;
	reg signed [15:0] i0_b2_int;
	reg signed [15:0] i0_a1_int;
	reg signed [15:0] i0_a2_int;
	
	reg signed [15:0] i1_b0_int;
	reg signed [15:0] i1_b1_int;
	reg signed [15:0] i1_b2_int;
	reg signed [15:0] i1_a1_int;
	reg signed [15:0] i1_a2_int;
	
	reg signed [15:0] i2_b0_int;
	reg signed [15:0] i2_b1_int;
	reg signed [15:0] i2_b2_int;
	reg signed [15:0] i2_a1_int;
	reg signed [15:0] i2_a2_int;
	
	reg signed [15:0] i3_b0_int;
	reg signed [15:0] i3_b1_int;
	reg signed [15:0] i3_b2_int;
	reg signed [15:0] i3_a1_int;
	reg signed [15:0] i3_a2_int;
	wire signed [15:0] i0srcdat;
	wire signed [15:0] i1srcdat;
	wire signed [15:0] i2srcdat;
	
	reg [15:0] bypass;
biquad_ast i0(
  .clk(clk),
  .reset(reset),

  .avalon_sink_data(avalon_sink_data),
  .avalon_sink_valid(avalon_sink_valid),
  .avalon_sink_ready(avalon_sink_ready),

  .avalon_source_data(i0srcdat),
  .avalon_source_valid(i0srcv),
  .avalon_source_ready(i0srcr),
  
  .b0_int(i0_b0_int),
  .b1_int(i0_b1_int),
  .b2_int(i0_b2_int),
  .a1_int(i0_a1_int),
  .a2_int(i0_a2_int),
  .bypass(bypass[0])
);

biquad_ast i1(
  .clk(clk),
  .reset(reset),

  .avalon_sink_data(i0srcdat),
  .avalon_sink_valid(i0srcv),
  .avalon_sink_ready(i0srcr),

  .avalon_source_data(i1srcdat),
  .avalon_source_valid(i1srcv),
  .avalon_source_ready(i1srcr),
  
  .b0_int(i1_b0_int),
  .b1_int(i1_b1_int),
  .b2_int(i1_b2_int),
  .a1_int(i1_a1_int),
  .a2_int(i1_a2_int),
  .bypass(bypass[0])
);

biquad_ast i2(
  .clk(clk),
  .reset(reset),

  .avalon_sink_data(i1srcdat),
  .avalon_sink_valid(i1srcv),
  .avalon_sink_ready(i1srcr),

  .avalon_source_data(i2srcdat),
  .avalon_source_valid(i2srcv),
  .avalon_source_ready(i2srcr),
  
  .b0_int(i2_b0_int),
  .b1_int(i2_b1_int),
  .b2_int(i2_b2_int),
  .a1_int(i2_a1_int),
  .a2_int(i2_a2_int),
  .bypass(bypass[0])
);

biquad_ast i3(
  .clk(clk),
  .reset(reset),

  .avalon_sink_data(i2srcdat),
  .avalon_sink_valid(i2srcv),
  .avalon_sink_ready(i2srcr),

  .avalon_source_data(avalon_source_data),
  .avalon_source_valid(avalon_source_valid),
  .avalon_source_ready(avalon_source_ready),
  
  .b0_int(i3_b0_int),
  .b1_int(i3_b1_int),
  .b2_int(i3_b2_int),
  .a1_int(i3_a1_int),
  .a2_int(i3_a2_int),
  .bypass(bypass[0])
);

//BEGIN AVALON MM
always @(posedge clk) begin
     if (reset) begin //default to bypass
			bypass<=1;

			i0_b0_int<=16'd4096;
			i0_b1_int<= 16'd0;
			i0_b2_int<=16'd0;
			i0_a1_int<= 16'd0;
			i0_a2_int<=16'd0;
			
			i1_b0_int<=16'd4096;
			i1_b1_int<=16'd0;
			i1_b2_int<=16'd0;
			i1_a1_int<=16'd0;
			i1_a2_int<=16'd0;
			
			i2_b0_int<=16'd4096;
			i2_b1_int<=16'd0;
			i2_b2_int<=16'd0;
			i2_a1_int<=16'd0;
			i2_a2_int<=16'd0;
			
		   i3_b0_int<=16'd4096;
			i3_b1_int<=16'd0;
			i3_b2_int<=16'd0;
			i3_a1_int<=16'd0;
			i3_a2_int<=16'd0;
     end else if (chipselect && write)
       case (address)
	 5'h0 : i0_b0_int <= writedata;
	 5'h1 : i0_b1_int <= writedata;
	 5'h2 : i0_b2_int<=writedata;
	 5'h3 : i0_a1_int <= writedata;
	 5'h4 : i0_a2_int<=writedata;

	 5'h5 : i1_b0_int <= writedata;
	 5'h6 : i1_b1_int <= writedata;
	 5'h7 : i1_b2_int<=writedata;
	 5'h8 : i1_a1_int <= writedata;
	 5'h9 : i1_a2_int<=writedata;

	 5'd10 : i2_b0_int <= writedata;
	 5'd11 : i2_b1_int <= writedata;
	 5'd12 : i2_b2_int<=writedata;
	 5'd13 : i2_a1_int <= writedata;
	 5'd14 : i2_a2_int<=writedata;
	 

	 5'd15 : i3_b0_int <= writedata;
	 5'd16 : i3_b1_int <= writedata;
	 5'd17 : i3_b2_int<=writedata;
	 5'd18 : i3_a1_int <= writedata;
	 5'd19 : i3_a2_int<=writedata;

	 5'd20 : bypass<=writedata;
	 endcase
end
//END AVALON MM
endmodule

