/*
 * Academic License - for use in teaching, academic research, and meeting
 * course requirements at degree granting institutions only.  Not for
 * government, commercial, or other organizational use.
 * File: eq_coeff.c
 *
 * MATLAB Coder version            : 5.2
 * C/C++ source code generated on  : 29-Apr-2022 14:21:01
 */

/* Include Files */
#include "eq_coeff.h"
#include "rt_nonfinite.h"
#include "rt_nonfinite.h"
#include <math.h>
#include "biquad.h"
#include <stdio.h>

/* Function Declarations */
static double rt_powd_snf(double u0, double u1);

static double rt_roundd_snf(double u);

/* Function Definitions */
/*
 * Arguments    : double u0
 *                double u1
 * Return Type  : double
 */
static double rt_powd_snf(double u0, double u1)
{
  double d;
  double d1;
  double y;
  if (rtIsNaN(u0) || rtIsNaN(u1)) {
    y = rtNaN;
  } else {
    d = fabs(u0);
    d1 = fabs(u1);
    if (rtIsInf(u1)) {
      if (d == 1.0) {
        y = 1.0;
      } else if (d > 1.0) {
        if (u1 > 0.0) {
          y = rtInf;
        } else {
          y = 0.0;
        }
      } else if (u1 > 0.0) {
        y = 0.0;
      } else {
        y = rtInf;
      }
    } else if (d1 == 0.0) {
      y = 1.0;
    } else if (d1 == 1.0) {
      if (u1 > 0.0) {
        y = u0;
      } else {
        y = 1.0 / u0;
      }
    } else if (u1 == 2.0) {
      y = u0 * u0;
    } else if ((u1 == 0.5) && (u0 >= 0.0)) {
      y = sqrt(u0);
    } else if ((u0 < 0.0) && (u1 > floor(u1))) {
      y = rtNaN;
    } else {
      y = pow(u0, u1);
    }
  }
  return y;
}

/*
 * Arguments    : double u
 * Return Type  : double
 */
static double rt_roundd_snf(double u)
{
  double y;
  if (fabs(u) < 4.503599627370496E+15) {
    if (u >= 0.5) {
      y = floor(u + 0.5);
    } else if (u > -0.5) {
      y = u * 0.0;
    } else {
      y = ceil(u - 0.5);
    }
  } else {
    y = u;
  }
  return y;
}

/*
 * Arguments    : double bass
 *                double mid
 *                double treble
 *                short b[9]
 *                short a[9]
 * Return Type  : void
 */
void eq_coeff(double bass, double mid, double treble, biquad_param_t bi[])
{
  double G;
  double V0;
  double a1;
  double a2;
  double b0;
  double b1;
  double b2;
  double b_a1;
  double b_a2;
  double b_b0;
  double b_b1;
  double b_b2;
  double c_a1;
  double c_a2;
  double c_b0;
  double c_b1;
  double c_b2;
  short i;
  short a[9];
  short b[9];

  /* bass, mid, treble are integer inputs with 146-285 range */
  G = (bass - 215.5) * 2.0 * 12.0 / -139.0;
  b0 = (mid - 215.5) * 2.0 * 12.0 / -139.0;
  /*  */
  /*  Derive coefficients for a shelving filter with a given amplitude and */
  /*  cutoff frequency.  All coefficients are calculated as described in  */
  /*  Zolzer's DAFX book (p. 50 -55).   */
  /*  */
  /*  Usage:     [B,A] = shelving(G, Fc, Fs, Q, type); */
  /*  */
  /*             G is the logrithmic gain (in dB) */
  /*             FC is the center frequency */
  /*             Fs is the sampling rate */
  /*             Q adjusts the slope be replacing the sqrt(2) term */
  /*             type is a character string defining filter type */
  /*                  Choices are: 'Bass_Shelf' or 'Treble_Shelf' */
  /*  */
  /*  Author:    Jeff Tackett 08/22/05 */
  /*  */
  /* Error Check */
  V0 = rt_powd_snf(10.0, G / 20.0);
  /* sqrt(2) */
  /* Invert gain if a cut */
  if (V0 < 1.0) {
    V0 = 1.0 / V0;
  }
  /* %%%%%%%%%%%%%%%%%%% */
  /*     BASS BOOST */
  /* %%%%%%%%%%%%%%%%%%% */
  if (G > 0.0) {
    G = sqrt(V0) * 1.4142135623730949 * 0.009817792466785694;
    b_b0 = ((G + 1.0) + V0 * 9.6389048920873918E-5) / 1.0139808443080136;
    b1 = 2.0 * (V0 * 9.6389048920873918E-5 - 1.0) / 1.0139808443080136;
    b2 = ((1.0 - G) + V0 * 9.6389048920873918E-5) / 1.0139808443080136;
    a1 = -1.9722337291952663;
    a2 = 0.972613969313063;
    /* %%%%%%%%%%%%%%%%%%% */
    /*     BASS CUT */
    /* %%%%%%%%%%%%%%%%%%% */
  } else if (G < 0.0) {
    G = (1.4142135623730949 * sqrt(V0) * 0.009817792466785694 + 1.0) +
        V0 * 9.6389048920873918E-5;
    b_b0 = 1.0139808443080136 / G;
    b1 = -1.9998072219021583 / G;
    b2 = 0.98621193378982808 / G;
    a1 = 2.0 * (V0 * 9.6389048920873918E-5 - 1.0) / G;
    a2 = ((1.0 - 1.4142135623730949 * sqrt(V0) * 0.009817792466785694) +
          V0 * 9.6389048920873918E-5) /
         G;
    /* %%%%%%%%%%%%%%%%%%% */
    /*    TREBLE BOOST */
    /* %%%%%%%%%%%%%%%%%%% */
  } else {
    b_b0 = V0;
    b1 = 0.0;
    b2 = 0.0;
    a1 = 0.0;
    a2 = 0.0;
  }
  /* return values */
  G = (treble - 215.5) * 2.0 * 12.0 / -139.0;
  /*  */
  /*  Derive coefficients for a shelving filter with a given amplitude and */
  /*  cutoff frequency.  All coefficients are calculated as described in  */
  /*  Zolzer's DAFX book (p. 50 -55).   */
  /*  */
  /*  Usage:     [B,A] = shelving(G, Fc, Fs, Q, type); */
  /*  */
  /*             G is the logrithmic gain (in dB) */
  /*             FC is the center frequency */
  /*             Fs is the sampling rate */
  /*             Q adjusts the slope be replacing the sqrt(2) term */
  /*             type is a character string defining filter type */
  /*                  Choices are: 'Bass_Shelf' or 'Treble_Shelf' */
  /*  */
  /*  Author:    Jeff Tackett 08/22/05 */
  /*  */
  /* Error Check */
  V0 = rt_powd_snf(10.0, G / 20.0);
  /* sqrt(2) */
  /* Invert gain if a cut */
  if (V0 < 1.0) {
    V0 = 1.0 / V0;
  }
  /* %%%%%%%%%%%%%%%%%%% */
  /*     BASS BOOST */
  /* %%%%%%%%%%%%%%%%%%% */
  if (G > 0.0) {
    G = 1.4142135623730949 * sqrt(V0) * 0.15838444032453627;
    c_b0 = ((V0 + G) + 0.025085630936916591) / 1.2490750545127478;
    b_b1 = 2.0 * (0.025085630936916591 - V0) / 1.2490750545127478;
    b_b2 = ((V0 - G) + 0.025085630936916591) / 1.2490750545127478;
    b_a1 = -1.5610180758007182;
    b_a2 = 0.64135153805756318;
    /* %%%%%%%%%%%%%%%%%%% */
    /*    TREBLE CUT */
    /* %%%%%%%%%%%%%%%%%%% */
  } else if (G < 0.0) {
    G = (V0 + 1.4142135623730949 * sqrt(V0) * 0.15838444032453627) +
        0.025085630936916591;
    c_b0 = 1.2490750545127478 / G;
    b_b1 = -1.9498287381261667 / G;
    b_b2 = 0.80109620736108533 / G;
    G = 1.4142135623730949 / sqrt(V0) * 0.15838444032453627;
    c_a2 = (G + 1.0) + 0.025085630936916591 / V0;
    b_a1 = 2.0 * (0.025085630936916591 / V0 - 1.0) / c_a2;
    b_a2 = ((1.0 - G) + 0.025085630936916591 / V0) / c_a2;
    /* %%%%%%%%%%%%%%%%%%% */
    /*    All-Pass */
    /* %%%%%%%%%%%%%%%%%%% */
  } else {
    c_b0 = V0;
    b_b1 = 0.0;
    b_b2 = 0.0;
    b_a1 = 0.0;
    b_a2 = 0.0;
  }
  /* return values */
  /*  */
  /*  Derive coefficients for a shelving filter with a given amplitude and */
  /*  cutoff frequency.  All coefficients are calculated as described in  */
  /*  Zolzer's DAFX book (p. 50 -55).   */
  /*  */
  /*  Usage:     [B,A] = shelving(G, Fc, Fs, Q); */
  /*  */
  /*             G is the logrithmic gain (in dB) */
  /*             FC is the center frequency */
  /*             Fs is the sampling rate */
  /*             Q adjusts the slope be replacing the sqrt(2) term */
  /*  */
  /*  Author:    Yuqi Zhu 03/30/22 */
  /*  */
  V0 = rt_powd_snf(10.0, b0 / 20.0);
  /* %%%%%%%%%%%%%%%%%%% */
  /*     BOOST */
  /* %%%%%%%%%%%%%%%%%%% */
  if (b0 > 0.0) {
    G = V0 * 0.03929010700766964 / 0.70710678118654757;
    b0 = ((G + 1.0) + 0.0015437125086741311) / 1.0571083147060107;
    c_b1 = -1.8890330793945247;
    c_b2 = ((1.0 - G) + 0.0015437125086741311) / 1.0571083147060107;
    c_a1 = -1.8890330793945247;
    c_a2 = 0.89487434461663562;
    /* %%%%%%%%%%%%%%%%%%% */
    /*     CUT */
    /* %%%%%%%%%%%%%%%%%%% */
  } else if (b0 < 0.0) {
    G = (0.055564602197336582 / V0 + 1.0) + 0.0015437125086741311;
    b0 = 1.0571083147060107 / G;
    c_b1 = -1.9969125749826517 / G;
    c_b2 = 0.94597911031133752 / G;
    c_a1 = c_b1;
    c_a2 = ((1.0 - 0.03929010700766964 / V0 / 0.70710678118654757) +
            0.0015437125086741311) /
           G;
    /* %%%%%%%%%%%%%%%%%%% */
    /*    All-Pass */
    /* %%%%%%%%%%%%%%%%%%% */
  } else {
    b0 = V0;
    c_b1 = 0.0;
    c_b2 = 0.0;
    c_a1 = 0.0;
    c_a2 = 0.0;
  }
  /* return values */
  a[0] = 4096;
  G = rt_roundd_snf(a1 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  a[1] = i;
  G = rt_roundd_snf(a2 * 4096.0);
  if (G < 32768.0) {
    if (G >= -32768.0) {
      i = (short)G;
    } else {
      i = MIN_int16_T;
    }
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  a[2] = i;
  a[3] = 4096;
  G = rt_roundd_snf(c_a1 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else {
    i = 0;
  }
  a[4] = i;
  G = rt_roundd_snf(c_a2 * 4096.0);
  if (G < 32768.0) {
    if (G >= -32768.0) {
      i = (short)G;
    } else {
      i = MIN_int16_T;
    }
  } else {
    i = 0;
  }
  a[5] = i;
  a[6] = 4096;
  G = rt_roundd_snf(b_a1 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else {
    i = 0;
  }
  a[7] = i;
  G = rt_roundd_snf(b_a2 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else {
    i = 0;
  }
  a[8] = i;
  G = rt_roundd_snf(b_b0 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  b[0] = i;
  G = rt_roundd_snf(b1 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  b[1] = i;
  G = rt_roundd_snf(b2 * 4096.0);
  if (G < 32768.0) {
    if (G >= -32768.0) {
      i = (short)G;
    } else {
      i = MIN_int16_T;
    }
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  b[2] = i;
  G = rt_roundd_snf(b0 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  b[3] = i;
  G = rt_roundd_snf(c_b1 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else {
    i = 0;
  }
  b[4] = i;
  G = rt_roundd_snf(c_b2 * 4096.0);
  if (G < 32768.0) {
    if (G >= -32768.0) {
      i = (short)G;
    } else {
      i = MIN_int16_T;
    }
  } else {
    i = 0;
  }
  b[5] = i;
  G = rt_roundd_snf(c_b0 * 4096.0);
  if (G < 32768.0) {
    i = (short)G;
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  b[6] = i;
  G = rt_roundd_snf(b_b1 * 4096.0);
  if (G < 32768.0) {
    if (G >= -32768.0) {
      i = (short)G;
    } else {
      i = MIN_int16_T;
    }
  } else {
    i = 0;
  }
  b[7] = i;
  G = rt_roundd_snf(b_b2 * 4096.0);
  if (G < 32768.0) {
    if (G >= -32768.0) {
      i = (short)G;
    } else {
      i = MIN_int16_T;
    }
  } else if (G >= 32768.0) {
    i = MAX_int16_T;
  } else {
    i = 0;
  }
  b[8] = i;
  (bi[0].biquadcoeff)[0] = b[0];
  (bi[0].biquadcoeff)[1] = b[1];
  (bi[0].biquadcoeff)[2] = b[2];
  (bi[0].biquadcoeff)[3] = a[1];
  (bi[0].biquadcoeff)[4] = a[2];
  (bi[0].biquadcoeff)[5] = b[3];
  (bi[0].biquadcoeff)[6] = b[4];
  (bi[0].biquadcoeff)[7] = b[5];
  (bi[0].biquadcoeff)[8] = a[4];
  (bi[0].biquadcoeff)[9] = a[5];
  (bi[0].biquadcoeff)[10] = b[6];
  (bi[0].biquadcoeff)[11] = b[7];
  (bi[0].biquadcoeff)[12] = b[8];
  (bi[0].biquadcoeff)[13] = a[7];
  (bi[0].biquadcoeff)[14] = a[8];
  printf("Biquad: ");
  for (int i = 0; i <15; i++) printf("%d ", (bi[0].biquadcoeff)[i]);
  printf("\n");
}

/*
 * File trailer for eq_coeff.c
 *
 * [EOF]
 */
