#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pi_controller.h"










pi_t pi_create(pi_t controller, float Kp, float Ki, float sample_time){
    // printf("Creation of the controller \n");
    // pi_t controller = (pi_t) malloc(sizeof(pi_t));
    // printf("Value of Kp: %f \n", Kp);
    controller->Kp = Kp;
    // printf("Value of the new controller Kp: %f \n", controller->Kp);
    controller->Ki = Ki;
    // printf("Value of the new controller Ki: %f \n", controller->Ki);
    controller->sample_time = sample_time;
    // printf("Value of the new controller sample time: %f \n", controller->sample_time);
    // float* x = (float*) malloc(sizeof(float));
    float* input = (float*) malloc(sizeof(float));
    controller->input = input;
    // printf("Here \n");
    controller->output = malloc(sizeof(float));
    return controller;
}


void pi_compute(pi_t pi){
    // printf("In compute \n");
    // float * out = (float*) malloc(sizeof(float));
    float out;
    if (pi->Ki == 0){
        out = *pi->input * pi->Kp;
    }
    else{
        out = ((*pi->output) 
        + (pi->Kp) 
        * (*pi->input) 
        + (
            (pi->Ki) 
            * (pi->sample_time) 
            - (pi->Kp)
            ) 
        * (pi->last_input)
        );    
    }
    pi->last_input = *pi->input;
    *pi->output = out;
}



float* current_controller(float input, pi_t p_controller, pi_t pi, pi_t pi_wup){
    // Initialization
    float* res = (float*) malloc(sizeof(float*));
    float va, ev;
    va = 0;
    ev = 0;
    *pi->input = input;
    // p_controller->input = omega_motor_speed;
    // printf("\n Input command: %f \n", u[i]);
    // printf("Input of the PI controller: %f \n", *pi->input);
    // printf("Input of the I controller: %f \n", *pi_wup->input);
    pi_compute(p_controller);
    pi_compute(pi);
    pi_compute(pi_wup);
    // printf("Output of the PI controller: %f \n", *pi->output);
    // printf("Output of the I controller: %f \n", *pi_wup->output);
    va = *pi->output - *pi_wup->output + *p_controller->output; // V
    if (va < -12){
        *res = -12;
    } 
    else if (va > 12) {
        *res = 12;
    }
    else{
        *res = va;
    }
    ev = va - *res;  // [V]
    // printf("Value of saturation error: %f \n", ev);
    pi_wup->input = &ev;
    return res;
    // printf("Input of the I controller: %f \n", *pi_wup->input);
}


float* speed_controller(float input, float k, pi_t pi, pi_t pi_wup){
    // Initialization
    float* torque_ref = (float*) malloc(sizeof(float*));
    float* current_ref = (float*) malloc(sizeof(float*));
    float torque_e, torque_diff;
    *pi->input = input;
    // p_controller->input = omega_motor_speed;
    // printf("\n Input command: %f \n", input);
    // printf("Input of the PI controller: %f \n", *pi->input);
    // printf("Input of the I controller: %f \n", *pi_wup->input);
    pi_compute(pi);
    pi_compute(pi_wup);
    // printf("Output of the PI controller: %f \n", *pi->output);
    // printf("Output of the I controller: %f \n", *pi_wup->output);
    torque_e = *pi->output - *pi_wup->output; // V
    // printf("Value of torque ref: %f \n", torque_e);
    if (torque_e < -0.247){
        *torque_ref = -0.247;
    } 
    else if (torque_e > 0.247) {
        *torque_ref = 0.247;
    }
    else{
        *torque_ref = torque_e;
    }
    torque_diff = torque_e - *torque_ref;  // [V]
    // printf("Value of saturation error: %f \n", torque_diff);
    *pi_wup->input = torque_diff;
    *current_ref = *torque_ref / k; // Divided by the machine constant
    
    free(torque_ref);
    if (*current_ref > 1){
        *current_ref = 1; 
    } 
    else if (*current_ref < -1){
        *current_ref = -1; 
    }
    // printf("Current referece sent: %f \n", *current_ref);
    return current_ref;
    // printf("Input of the I controller: %f \n", *pi_wup->input);
}
