// CSEE 4840 Lab 1: Run and Display Collatz Conjecture Iteration Counts
//
// Spring 2022
//
// By: <your name here>
// Uni: <your uni here>

module pwm(
   input logic clk,  // 50 MHz Clock input
   input logic reset,
	input logic [9:0] SW, // Switches; SW[0] is rightmost
   inout [35:0] GPIO_0,
   input chipselect,
   input logic [1:0] address,
   input logic [15:0] writedata,
   output logic [15:0] readdata,
   input logic write,
   input logic read,
   // output logic irq,
	// 7-segment LED displays; HEX0 is rightmost
   output logic [6:0] HEX0, HEX1, HEX2, HEX3, HEX4, HEX5,
	output logic [9:0] LEDR // LEDs above the switches; LED[0] on right
	     );

   logic led_info1 = 0;
   logic [7:0] led_byte_info2 = 0;
   logic in1 = 0;
   logic in2 = 0;
   logic ena = 0;
   logic drive_mode = 0;
   logic rotation_mode = 0;
   logic rotation_direction = 1;
   logic buffer_rotation_direction = 0;
   logic pwm_high = 0;
   logic [10:0] lower_period_counter = 0;  // 0 to 2,047
   logic [10:0] duty_cycle_command = 500;  // 0 to 2,047
   logic [10:0] buffer_duty_cycle_command = 500;  // 0 to 2,047
   logic [31:0] led_counter = 0;

   assign GPIO_0[0] = ena;
   // assign GPIO_0[1] = rotation_mode;
   assign GPIO_0[8] = in1;
   assign GPIO_0[9] = in2;
   assign LEDR[9] = SW[9];
   assign LEDR[0] = led_info1;
   assign LEDR[8:2] = led_byte_info2;
   // Modes
   // assign rotation_direction = SW[2];  // high when motor accelerates (convention)
   assign rotation_mode = SW[0];
   assign drive_mode = SW[1];

   // GPIO assignments
   assign ena = SW[9];

   always_comb
      if (drive_mode) begin  // Manual mode for the rotation
         if (rotation_mode)  begin  // Right
            in1 = (!rotation_direction & pwm_high & ena);
            in2 = (rotation_direction & pwm_high & ena);
         end
         else begin  // Left
            in1 = (rotation_direction & pwm_high & ena);
            in2 = (!rotation_direction & pwm_high & ena);
         end
      end
      else begin  // Left by default
         in1 = (rotation_direction & pwm_high & ena);
         in2 = (!rotation_direction & pwm_high & ena);
      end

   
   assign GPIO_0[7:2] = 6'b0;  // Disabling the output
   assign GPIO_0[35:10] = 26'b0;  // Disabling the output

   // Hex display
   assign HEX3 = 7'h7F;
   always_comb // Left rotation or right rotation 
      case(SW[0])
         1'b0:    HEX5 = 7'h47;  // L
         1'b1:    HEX5 = 7'h4C;  // R
      default: HEX5 = 7'h47;  // L
   endcase

   always_comb // Manual or Automatic mode 
      case(SW[1])
         1'b0:    HEX4 = 7'h08;  // A
         1'b1:    HEX4 = 7'h48;  // M
      default: HEX4 = 7'h77;  // A
   endcase

   always_comb
      case(SW[9]) // Connected to ENA port to enable the rotation of the motor
         1'b0:    begin HEX2 = 7'h40; HEX1 = 7'h0E; HEX0 = 7'h0E; end  // OFF
         1'b1:    begin HEX2 = 7'h7F; HEX1 = 7'h40; HEX0 = 7'h48; end  // ON
      default: begin HEX2 = 7'h40; HEX1 = 7'h0E; HEX0 = 7'h0E; end  // OFF
   endcase

   

   // PWM
   assign pwm_high = (lower_period_counter <= duty_cycle_command);


   always_ff @(posedge clk)   
      if (chipselect & write) begin // Command from the controller
         case (address)
            2'h0 : buffer_rotation_direction <= writedata[0];
            2'h1 : buffer_duty_cycle_command <= writedata[10:0];
         endcase
      end

   
   always_ff @(posedge clk)
      if (lower_period_counter > 1999) begin 
         lower_period_counter <= 0;
         rotation_direction <= buffer_rotation_direction;
         duty_cycle_command <= buffer_duty_cycle_command;
         // led_byte_info2 <= duty_cycle_command[7:0];
         led_byte_info2 <= buffer_duty_cycle_command[7:1];
      end
      else lower_period_counter <= lower_period_counter + 1;

   // Encoder input
   logic [31:0] encoder_counter = 0;
   logic [31:0] clock_cycles_counter = 0;
   logic [15:0] last_encoder_count = 0;  
   
   logic flag_gpio = 0;
   always_ff @(posedge clk)
      if (clock_cycles_counter > 499999) begin  // Sampling at 100 kHz
        last_encoder_count <= encoder_counter;
        clock_cycles_counter <= 0;
        encoder_counter <= 0;
      end
      else begin 
        clock_cycles_counter <= clock_cycles_counter + 1;
        if (GPIO_0[1] & !flag_gpio) begin 
            encoder_counter <= encoder_counter + 1;
            flag_gpio <= 1;
        end
        else if (!GPIO_0[1]) flag_gpio <= 0;  
    end

  
    always_ff @(posedge clk)   
          if (chipselect & read) begin // Command from the controller
             led_info1 <= 1;
             case (address)
                2'h2 : readdata[15:0] <= last_encoder_count;
             endcase
          end
          else if (led_counter > 10000000) begin 
            led_counter <= 0;
            led_info1 <= 0;
          end
         else led_counter <= led_counter + 1;

endmodule
